/*    ADSLIB.H
      (C) Copyright 1988-1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and
      intended  to  work  solely  with  Autodesk, Inc. products, and
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
      1988-1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

      ADS definitions and system dependent controls.

      This also contains a substitute for stdlib.h on some systems.
      If we know the system has stdlib.h, just include it.

*/

#ifndef _adslib_h
#define _adslib_h

#ifdef _MAXSTRING
#undef    _MAXSTRING
#define   _MAXSTRING  (~0)
#endif

  
/* Note: As of this writing, Sun ANSI C defines __STDC__, but
   sets it to a non-numeric value.  This is contrary to the
   ANSI standard, but we'll live with it for now.  Hence the
   unusual handling of __STDC__. */

#ifdef __STDC__
#define STDC_DEFINED 1
#else
#define STDC_DEFINED 0
#endif

#ifdef _WINDOWS
#define WIN 1
#endif

#ifdef WINVER
#define WIN 1
#endif

#ifdef _MSC_VER
#define MICROSOFT 1
#endif

#ifdef __TURBOC__
#define TURBOC 1
#endif

#ifdef OS2
#define PROTOTYPES 1
#endif

#ifdef WIN
#define main(a,b) ads_main(a,b)
#define PROTOTYPES 1
#endif  /* WIN */

#ifndef PROTOTYPES
#if STDC_DEFINED || __cplusplus           /* "Standard C" or C++ */
#define PROTOTYPES 1
#endif  /* STDC_DEFINED || __cplusplus */
#endif  /* !PROTOTYPES */


/* useful definitions */
#define TRUE    1
#define FALSE   0
#define EOS     '\0'

/*  Tricky macro for declaration of function types with optional
    prototype (i.e., declaration of argument types).  The way the
    macro "_()" is defined, the following declaration:

       int fcn _((int i, char c));

    will expand into either

       int fcn (int i, char c);
       or
       int fcn ();

    depending on whether the symbol PROTOTYPES is defined.  Thanks to
    Bob Elman for this idea.  */

#ifdef PROTOTYPES
#define   _(x)  x
#else
#define   _(x)  ()
#endif /* PROTOTYPES */



/* Substitute for STDLIB.H on systems that do NOT have it.
   Also enable use of const in adsxxx.h declarations.  */

#if       STDC_DEFINED || __cplusplus || WIN
#include  <stdlib.h>
#else

/* Declaration for ?alloc() was set to char * because that caused us fewer
   compiler warnings in some substandard systems.  Now we declare it as ANSI
   standard by default.  The Sparc compiler works fine with this, though the
   obsolete lint on Unix screams its ancient head off.  (Serious programmers
   use Gimpel's PC-Lint.)

   Any exceptions to the proper ANSI-style declaration must be explicitly
   machine by machine. */

void *malloc _((size_t size));
void *calloc _((unsigned int nelem, size_t elsize));
void free _((void *ptr));
#ifndef TURBOC
#ifndef RMADS /* RMADS */
double atof _((char *nptr));
#else
double atof _((const char *nptr));
#endif        /* RMADS */
#endif
int atoi _((char *nptr));
void exit _((int status));
double fmod _((double x, double y));

/* Enable the use of const on machines that support it (by making it disappear
   on these non-standard machines). */
#ifndef const
#define const                         /* Make const invisible for adsxxx.h */
#define _adslib_h_const               /* Flag for later */
#endif  /* !const */
#endif  /*STDC_DEFINED || __cplusplus || WIN */

#include "ads.h"
#include "adscodes.h"

#ifdef _adslib_h_const                /* Clean up after yourself */
#undef const
#undef _adslib_h_const
#endif  /* !_adslib_h_const */


#endif  /* !_adslib_h */
