/*
   ADSDLG.H  -  Definitions for ADS Programmable Dialogue Boxes

      (C) Copyright 1988-1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and
      intended  to  work  solely  with  Autodesk, Inc. products, and
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
      1988-1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.
*/


/* Defined only for OS/2 DLL Version */
#define CALLB

typedef void *ads_hdlg;
typedef void *ads_htile;

typedef struct {
    ads_hdlg  dialog;
    ads_htile tile;
    char*     value;
    void*     client_data;
    int       reason;
    long      x, y;
} ads_callback_packet;

/* The following are used in tile callback packets. Their meaning
   for each kind of tile can be found in the Programmable Dialogue
   Boxes documentation.
*/
#define CBR_SELECT       1
#define CBR_LOST_FOCUS   2
#define CBR_DRAG         3
#define CBR_DOUBLE_CLICK 4

/* ADS user's function, passed to AutoCAD to be called later */
typedef void (*CLIENTFUNC) _((ads_callback_packet *cpkt));
#define NULLCB ((CLIENTFUNC)0)

#define BAD_DIALOG NULL

/* Return by reference integers for ads_start_dialog */
#define DLGCANCEL     0               /* User pressed Cancel or equivalent */
#define DLGOK         1               /* User pressed Ok */
#define DLGALLDONE   -1               /* All dialogs terminated with
                                         term_dialog */
#define DLGSTATUS     2               /* start of user return codes */


/* List argument type for ads_start_list(); */
#define LIST_CHANGE   ((short) 1)     /* Change selected listbox contents */
#define LIST_APPEND   ((short) 2)     /* Append new listbox entry */
#define LIST_NEW      ((short) 3)     /* Delete old list and create new list */

/* Mode argument type for ads_mode_tile(); */
#define MODE_ENABLE   ((short) 0)     /* Enable tile */
#define MODE_DISABLE  ((short) 1)     /* Disable tile */
#define MODE_SETFOCUS ((short) 2)     /* Set focus to tile */
#define MODE_SETSEL   ((short) 3)     /* Set editbox selection--allows 
                                         auto-clearing of old string */
#define MODE_FLIP     ((short) 4)     /* Invert current state */


/* For buffers that receive values for tiles.  The number is
   arbitrary--it's just here to allow changing them all from
   one place. */
#define MAX_TILE_STR  40
#define TILE_STR_LIMIT 255            /* real limit of dialog strings */

/* Dialog Functions */

ads_load_dialog _((char *dclfile, int *dcl_id));
ads_unload_dialog _((int dcl_id));
ads_new_dialog _((char *dlgname, int dcl_id, CLIENTFUNC def_callback,
        ads_hdlg *hdlg));
ads_new_positioned_dialog _((char *dlgname, int dcl_id, CLIENTFUNC def_callback,
        int x, int y, ads_hdlg *hdlg));
ads_start_dialog _((ads_hdlg hdlg, int *status));
ads_term_dialog _((void));
ads_action_tile _((ads_hdlg hdlg, char *key, CLIENTFUNC tilefunc));
ads_done_dialog _((ads_hdlg hdlg, int status));
ads_done_positioned_dialog _((ads_hdlg hdlg, int status, int *x_result, int *y_result));
ads_set_tile _((ads_hdlg hdlg, char *key, char *value));
ads_client_data_tile _((ads_hdlg hdlg, char *key, void *clientdata));
ads_get_tile _((ads_hdlg hdlg, char *key, char *value, int
        maxlen));
ads_get_attr _((ads_hdlg hdlg, char *key, char *attr, char
        *value, int len));
ads_get_attr_string _((ads_htile tile, char *attr,
        char *value, int len));
ads_start_list _((ads_hdlg hdlg, char *key, short operation,
        short index));
ads_add_list _((char *item));
ads_end_list _((void));
ads_mode_tile _((ads_hdlg hdlg, char *key, short mode));
ads_dimensions_tile _((ads_hdlg hdlg, char *key, short *cx, short
        *cy));
ads_start_image _((ads_hdlg hdlg, char *key));
ads_vector_image _((short x1, short y1, short x2, short
        y2, short color));
ads_fill_image _((short x1, short y1, short x2, short y2,
        short color));
ads_slide_image _((short x1, short y1, short x2, short y2,
        char *slnam));
ads_end_image _((void));
