/* 
   ADS.H   -    Definitions of the AutoCAD functions for Applications 
                This takes the place of xlacad.h (from LISP) and contains
                the changes to the function definitions to make them
                compatible with the application interface.

      (C) Copyright 1988-1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and
      intended  to  work  solely  with  Autodesk, Inc. products, and
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright
      1988-1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.


*/

#ifndef _ads_h
#define _ads_h

/* There is a clash between the alignment required within structures for
   ADS and that required for members within Zortech structs and classes.
   ADS requires byte alignment (-a1) while 32-bit Zortech requires 4-byte
   alignment (-a4).  To work around this clash the alignment is set to one
   at the top of this header file and restored to four at the bottom so
   that ADS structures are byte-aligned. */
#ifdef __ZTC__
#pragma ZTC align 1
#endif

/* Ensure that C++ modules use the right linking conventions when calling
   functions contained in C. */
#ifdef __cplusplus
    extern /*MSG0*/"C" {
#endif


/* A real to AutoCAD is a double precision float, and must be
   used for all floating point numbers in AutoCAD. */
typedef double ads_real;

/* The following types are used in functions that accept points or entity/ss
   names, and return one of these as well. */

typedef ads_real ads_point[3];
typedef long ads_name[2];

/* The following type is used by functions that accept a 3D matrix */

typedef ads_real ads_matrix[4][4];

/* The coordinates of a point */
#define X  0
#define Y  1
#define Z  2

/* The translation vector of a 3D matrix */
#define T  3

/* The PAUSE token for ads_command and ads_cmd */
#define PAUSE "\\"

/* The ADS_INITGET control bits */

#define RSG_NONULL 0x01               /* Disallow null input */
#define RSG_NOZERO 0x02               /* Disallow zero input */
#define RSG_NONEG  0x04               /* Disallow negative input */
#define RSG_NOLIM  0x08               /* Do not check limits */
#define RSG_GETZ   0x10               /* Get Z coordinate */
#define RSG_DASH   0x20               /* Draw dashed rubber band/box (not a
                                         GEDIT control bit) */
#define RSG_2D     0x40               /* Restrict (getdist) to 2D (causes the
                                         UD_GETZ control bit to be cleared) */
#define RSG_OTHER  0x80               /* Return input string if unknown */

/* Binary data stream structure */

struct ads_binary {                   /* Binary data chunk structure */
    short clen;                       /* length of chunk in bytes */
    char *buf;                        /* binary data */
};

/*  Union for storing different ADS data types. */
 
union ads_u_val {
   ads_real rreal;
   ads_real rpoint[3];
   short rint;
   char *rstring;
   long rlname[2];
   long rlong;   
   struct ads_binary rbinary;
}; 
 
/* The following is the structure definition of the general result buffer.
   This is used for both passing back results from functions, as well
   as exotic applications like entity lists, and command function lists.
   It is as close as we come to the AutoLISP node structure.  */

struct resbuf {                                                  
        struct resbuf *rbnext;        /* Allows them to be "linked" */
        short restype;
        union ads_u_val resval;
};

/* External function definitions accessible from applications */

/* Application initialization  function */
void           ads_init _((int argc, char *argv[]));

/* General failure (prints message) mechanism */
void           ads_fail _((const char *str));

/* General abort mechanism.  Return RSABORT to Lisp. */
void           ads_abort _((const char *str));

/* ADS exit() function used for transparent exit of programs */
void           ads_exit _((int status));

/* Register an ADS function handler */
int            ads_regfunc _((int (*fhdl) (void), int fcode));

/* Link back to host with request code */
int            ads_link _((int cbc));

/* Get a new result buffer */
struct resbuf *ads_newrb _((int v));

/* Release a result buffer as well as those linked to it */
int            ads_relrb _((struct resbuf *rb));

/* Check for a console break */
int            ads_usrbrk _((void));


/* Define an external subroutine in AutoLISP */
int            ads_defun _((const char *sname, short funcno));

/* Undefine an external subroutine in AutoLISP */
int            ads_undef _((const char *sname, short funcno));

/* Unitilies for external subroutine interface */
int            ads_getfuncode _((void));
struct resbuf *ads_getargs _((void));

/* Return the specified type as a result of external subroutine */
int            ads_retlist _((const struct resbuf *rbuf));
int            ads_retval _((const struct resbuf *rbuf));
int            ads_retpoint _((const ads_point pt));
int            ads_retstr _((const char *s));
int            ads_retname _((const ads_name aname, int type));
int            ads_retint _((int ival));
int            ads_retreal _((ads_real rval));
int            ads_rett _((void));
int            ads_retnil _((void));
int            ads_retvoid _((void));


/* AutoCAD Entity access routines */

int            ads_entdel _((const ads_name ent));
struct resbuf *ads_entgetx _((const ads_name ent, const struct resbuf *args));
struct resbuf *ads_entget _((const ads_name ent));
int            ads_entlast _((ads_name result));
int            ads_entnext _((const ads_name ent, ads_name result));
int            ads_entupd _((const ads_name ent));
int            ads_entmod _((const struct resbuf *ent));
int            ads_entmake _((const struct resbuf *ent));
int            ads_entsel _((const char *str, ads_name entres,
                             ads_point ptres));
int            ads_nentsel _((const char *str, ads_name entres,
                              ads_point ptres, ads_point xformres[4],
                              struct resbuf **refstkres));
int            ads_nentselp _((const char *str, ads_name entres,
                              ads_point ptres, int pickflag,
                              ads_matrix xformres,
                              struct resbuf **refstkres));
int            ads_ssget _((const char *str, const void *pt1,
                            const ads_point pt2, const struct resbuf *filter,
                            ads_name ss));
int            ads_ssfree _((const ads_name sname));
int            ads_sslength _((const ads_name sname, long *len));
int            ads_ssadd _((const ads_name ename, const ads_name sname,
                            ads_name result));
int            ads_ssdel _((const ads_name ename, const ads_name ss));
int            ads_ssmemb _((const ads_name ename, const ads_name ss));
int            ads_ssname _((const ads_name ss, long i, ads_name entres));

/* Extended Entity data utilities */
int            ads_xdroom _((const ads_name ent, long *result));
int            ads_xdsize _((const struct resbuf *rb, long *result));

/* AutoCAD table access routines */
struct resbuf *ads_tblnext _((const char *tblname, int rewind));
struct resbuf *ads_tblsearch _((const char *tblname, const char *sym,
                                int setnext));

/* Drawing database utilities */
int            ads_handent _((const char *handle, ads_name entres));
int            ads_trans _((const ads_point pt, const struct resbuf *from,
                            const struct resbuf *to, int disp,
                            ads_point result));

/* General AutoCAD utility routines */
int            ads_angtos _((ads_real v, int unit, int prec, char *str));
int            ads_cvunit _((ads_real value, const char *oldunit,
                             const char *newunit, ads_real *result));
int            ads_wcmatch _((const char *string, const char *pattern));
int            ads_rtos _((ads_real val, int unit, int prec, char *str));
int            ads_angtof _((const char *str, int unit, ads_real *v));
int            ads_distof _((const char *str, int unit, ads_real *v));
int            ads_setvar _((const char *sym, const struct resbuf *val));
int            ads_initget _((int val, const char *kwl));

int            ads_getsym _((const char *sname, struct resbuf **value));
int            ads_putsym _((const char *sname, struct resbuf *value));
struct resbuf  *ads_loaded _(());
int            ads_xload _((const char *app));
int            ads_xunload _((const char *app));
#if    UNIX && !OS2
int            ads_command ();
struct resbuf *ads_buildlist ();
int            ads_printf ();
#else
int            ads_command _((int rtype, ...));
struct resbuf *ads_buildlist _((int rtype, ...));
int            ads_printf _((const char *format, ...));
#endif
int            ads_cmd _((const struct resbuf *rbp));
int            ads_invoke _((const struct resbuf *args,
                             struct resbuf **result));
int            ads_inters _((const ads_point from1, const ads_point to1,
                             const ads_point from2, const ads_point to2,
                             int teston, ads_point result));

/* Functions that get system variables */
int            ads_getvar _((const char *sym, struct resbuf *result));
int            ads_findfile _((const char *fname, char *result));

/* Function that gets a string */
int            ads_getstring _((int cronly, const char *prompt, char *result));

/* Functions that pass AutoCAD a single string  */
int            ads_menucmd _((const char *str));
int            ads_prompt _((const char *str));
int            ads_alert _((const char *str));

/* Function to register an application with AutoCAD */
int            ads_regapp _((const char *appname));

/* Functions used to get user input  */
int            ads_getangle _((const ads_point pt, const char *prompt,
                               ads_real *result));
int            ads_getcorner _((const ads_point pt, const char *prompt,
                                ads_point result));
int            ads_getdist _((const ads_point pt, const char *prompt,
                              ads_real *result));
int            ads_getorient _((const ads_point pt, const char *prompt,
                                ads_real *result));
int            ads_getpoint _((const ads_point pt, const char *prompt,
                               ads_point result));
int            ads_getint _((const char *prompt, int *result));
int            ads_getkword _((const char *prompt, char *result));
int            ads_getreal _((const char *prompt, ads_real *result));
int            ads_getinput _((char *str));
int            ads_vports _((struct resbuf **vlist));

/* Functions for screen flipping */
int            ads_textscr _((void));
int            ads_graphscr _((void));
int            ads_textpage _((void));

/* Graphics related functions */
int            ads_grclear _((void));
int            ads_redraw _((const ads_name ent, int mode));
int            ads_osnap _((const ads_point pt, const char *mode,
                            ads_point result));
int            ads_grread _((int track, int *type, struct resbuf *result));
int            ads_grtext _((int box, const char *text, int hl));
int            ads_grdraw _((const ads_point from, const ads_point to,
                             int color, int hl));
int            ads_grvecs _((const struct resbuf *vlist, ads_matrix mat));
int            ads_xformss _((const ads_name ssname,
                              ads_matrix genmat));
int            ads_draggen _((const ads_name ss, const char *pmt, int cursor,
                              int (*scnf) _((ads_point pt, ads_matrix mt)),
                              ads_point p));

/* Geometry utilities */
ads_real       ads_angle _((const ads_point pt1, const ads_point pt2));
ads_real       ads_distance _((const ads_point pt1, const ads_point pt2));
void           ads_polar _((const ads_point pt, ads_real angle,
                            ads_real dist, ads_point ptres));

/* Functions that put up standard dialogs for user input */
int            ads_getfiled _((const char *title, const char *defawlt,
                               const char *ext, int flags,
                               struct resbuf *result));

int            ads_textbox _((const struct resbuf *args,
                              ads_point pt1, ads_point pt2));

/*  Function to retrieve or establish AutoCAD's tablet transformation: */
int            ads_tablet  _((const struct resbuf *args,
                              struct resbuf **result));

/* Functions to support ADS / ADI communications */
int            ads_recfgport _((int *idvc, int iotype, int baudrate,
                                int parity, int databits, int stopbits,
                                int hhflag, char *devname));
void           ads_adiinfo   _((void *dsinfoptr));
void           ads_dscfg     _((void *dspktptr));
void           ads_dsxqt     _((void *dspktptr));
void           ads_dispt     _((void *dspktptr));
void           ads_adistart  _((void *dsactptr));
void           ads_adiend    _((void *dsactptr));

#ifdef WIN
/* Call before termination to clean up Windows, DDE, memory, etc */
void           adsi_machexit(int exitval);
#endif

/* Functions for character handling */
int            ads_isalpha _((int c));
int            ads_isupper _((int c));
int            ads_islower _((int c));
int            ads_isdigit _((int c));
int            ads_isxdigit _((int c));
int            ads_isspace _((int c));
int            ads_ispunct _((int c));
int            ads_isalnum _((int c));
int            ads_isprint _((int c));
int            ads_isgraph _((int c));
int            ads_iscntrl _((int c));
int            ads_toupper _((int c));
int            ads_tolower _((int c));

/* When you want something that's explicitly a pointer type and not an array
   type, use ads_pointp and ads_namep.  Remember that if your function takes an
   *array* of points, it still declares ads_point[] foo; */
typedef ads_real *ads_pointp;
typedef long     *ads_namep;

/* Define macros to copy them.  NOTE that the result is the SECOND argument,
   consistent with ADS usage.  The standard C ones require <string.h> */
#ifdef __STDC__
#define ads_name_set(from, to)  (memcpy(to, from, sizeof(ads_name)))
#define ads_point_set(from,to)  (memcpy(to, from, sizeof(ads_point)))
#else
#define ads_name_set(from, to)  (*(to)= *(from), (to)[1]=(from)[1])
#define ads_point_set(from, to) (*(to)= *(from), (to)[1]=(from)[1], (to)[2]=(from)[2])
#endif  /* !__STDC__ */

/* Define null value for ads_names.  These values are NOT guaranteed valid;
   that is, there is no actual guarantee (such as C gives with NULL) that the
   system will never under any circumstances generate the values as valid data.
   The correct values will be created as part of the Lisp reinitialization
   project, if we go through with that one, and will then be inserted here.
   */
#define ads_name_clear(name)    name[0] = name[1] = 0
#define ads_name_nil(name)      (name[0] == 0 && name[1] == 0)
#define ads_name_equal(name1, name2)  (name1[0]==name2[0] \
                                       && name1[1]==name2[1])

#ifdef __cplusplus
    }
#endif

/* Restore the 32-bit Zortech C++ alignment to a 4-byte boundary (except
   when building the Zortech ADS library, which requires 1-byte alignment:
   P386 is defined when building the library). */
#ifndef P386
#ifdef __ZTC__
#pragma ZTC align 4
#endif
#endif

#endif  /* !_ads_h */
