/* PLDOS32.H - Protected mode DOS interface routines in DOS32.LIB */
/* $Id: pldos32.h 2.7 93/08/24 14:57:44 rwm Exp $ */

/************************************************************************/
/*	Copyright (C) 1986-1993 Phar Lap Software, Inc.			*/
/*	Unpublished - rights reserved under the Copyright Laws of the	*/
/*	United States.  Use, duplication, or disclosure by the 		*/
/*	Government is subject to restrictions as set forth in 		*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
/*	Computer Software clause at 252.227-7013.			*/
/*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
/************************************************************************/

/*	

	FILE DESCRIPTION

This include file contains definitions for the MS-DOS system
call library DOS32.LIB

*/

#ifndef PLTYPES
#include <pltypes.h>
#endif

#ifndef PLDOS32DEFS
#define PLDOS32DEFS

#pragma pack(1)

// 
// Only define data structs and prototypes for the 32-bit versions of the 
// _dos_, _bios_, _intdosx, and _int86 calls supported by 16-bit Microsoft C 
// if they are not already supported by the C run-time library for 
// this compiler.
//
#if !(__CMPLR_FEATURES__ & __FEATURE_DOSCALL__)

/* dword registers */
struct _DWORDREGS {
	UINT eax;
	UINT ebx;
	UINT ecx;
	UINT edx;
	UINT esi;
	UINT edi;
	UINT cflag;
};

/* DWORD regs with WORD names, for compatibility with old 16-bit code;  */
/* using old code (e.g., regs.x.dx) will get you a 32-bit register, which */
/* is USUALLY what you want in 32-bit protected mode */
struct _WORDREGS {
	UINT ax;
	UINT bx;
	UINT cx;
	UINT dx;
	UINT si;
	UINT di;
	UINT cflag;
};

#define __WORD_FILL unsigned short :16;

/* the REAL word registers, in case you REALLY want a 16-bit register */
struct _REALWORDREGS {
	USHORT ax;  __WORD_FILL
	USHORT bx;  __WORD_FILL
	USHORT cx;  __WORD_FILL
	USHORT dx;  __WORD_FILL
	USHORT si;  __WORD_FILL
	USHORT di;  __WORD_FILL
	USHORT cflag; __WORD_FILL
};

/* byte registers */
struct _BYTEREGS {
	UCHAR al, ah;  __WORD_FILL
	UCHAR bl, bh;  __WORD_FILL
	UCHAR cl, ch;  __WORD_FILL
	UCHAR dl, dh;  __WORD_FILL
};

/* general purpose registers union - overlays the corresponding dword,
 * word, and byte registers.
 */

union _REGS {
	struct _DWORDREGS d;
	struct _WORDREGS  x;	/* As noted above, this has same names as */
				/* 16-bit _WORDREGS for compatibility when */
				/* porting existing 16-bit code, but really */
				/* gets you 32-bit DWORD regs */
	struct _REALWORDREGS w;	/* if you REALLY want 16-bit regs, use this */
	struct _BYTEREGS  h;
};

/* segment registers */
struct _SREGS {
	USHORT es;
	USHORT cs;
	USHORT ss;
	USHORT ds;
};

/* _dos_getdate/_dossetdate and _dos_gettime/_dos_settime structures */
struct _dosdate_t {
	unsigned char day;		/* 1-31 */
	unsigned char month;		/* 1-12 */
	unsigned short year;		/* 1980-2099 */
	unsigned char dayofweek;	/* 0-6, 0=Sunday */
	};

struct _dostime_t {
	unsigned char hour;		/* 0-23 */
	unsigned char minute;		/* 0-59 */
	unsigned char second;		/* 0-59 */
	unsigned char hsecond;		/* 0-99 */
	};

/* _dos_findfirst structure */
struct _find_t {
	char reserved[21];
	char attrib;
	USHORT wr_time;
	USHORT wr_date;
	UINT size;
	char name[13];
	};

/* dosexterror structure */
struct _DOSERROR {
	int exterror;
#if ((!defined(__STDC__)) && (!defined(__cplusplus)))
/* Non-ANSI name for compatibility */
	char class;
#else
	char errclass;
#endif
	char action;
	char locus;
	};

#ifndef _DISKFREE_T_DEFINED
/* _dos_getdiskfree structure */
struct _diskfree_t {
	unsigned total_clusters;
	unsigned avail_clusters;
	unsigned sectors_per_cluster;
	unsigned bytes_per_sector;
	};
#define _DISKFREE_T_DEFINED
#endif

/* manifest constants for BIOS disk support */

/* disk services */
#define _DISK_RESET	0	/* reset disk controller */
#define _DISK_STATUS	1	/* get disk status */
#define _DISK_READ	2	/* read disk sectors */
#define _DISK_WRITE	3	/* write disk sectors */
#define _DISK_VERIFY	4	/* verify disk sectors */
#define _DISK_FORMAT	5	/* format disk track */

/* manifest constants for BIOS serial communications (RS-232) support */

/* serial port services */
#define _COM_INIT	0	/* init serial port */
#define _COM_SEND	1	/* send character */
#define _COM_RECEIVE	2	/* receive character */
#define _COM_STATUS	3	/* get serial port status */

/* serial port initializers.  One and only one constant from each of the
 * following four groups - character size, stop bit, parity, and baud rate -
 * must be specified in the initialization byte.
 */

/* character size initializers */
#define _COM_CHR7	2	/* 7 bits characters */
#define _COM_CHR8	3	/* 8 bits characters */

/* stop bit values - on or off */
#define _COM_STOP1	0	/* 1 stop bit */
#define _COM_STOP2	4	/* 2 stop bits */

/*  parity initializers */
#define _COM_NOPARITY	0	/* no parity */
#define _COM_ODDPARITY	8	/* odd parity */
#define _COM_EVENPARITY 24	/* even parity */

/*  baud rate initializers */
#define _COM_110	0	/* 110 baud */
#define _COM_150	32	/* 150 baud */
#define _COM_300	64	/* 300 baud */
#define _COM_600	96	/* 600 baud */
#define _COM_1200	128	/* 1200 baud */
#define _COM_2400	160	/* 2400 baud */
#define _COM_4800	192	/* 4800 baud */
#define _COM_9600	224	/* 9600 baud */

/* manifest constants for BIOS keyboard support */

/* keyboard services */
#define _KEYBRD_READ		0	/* read next character from keyboard */
#define _KEYBRD_READY		1	/* check for keystroke */
#define _KEYBRD_SHIFTSTATUS	2	/* get current shift key status */

/* services for enhanced keyboards */
#define _NKEYBRD_READ		0x10	/* read next character from keyboard */
#define _NKEYBRD_READY		0x11	/* check for keystroke */
#define _NKEYBRD_SHIFTSTATUS	0x12	/* get current shift key status */


/* manifest constants for BIOS printer support */

/* printer services */
#define _PRINTER_WRITE	0	/* write character to printer */
#define _PRINTER_INIT	1	/* intialize printer */
#define _PRINTER_STATUS 2	/* get printer status */


/* manifest constants for BIOS time of day support */

/* time of day services */
#define _TIME_GETCLOCK	0	/* get current clock count */
#define _TIME_SETCLOCK	1	/* set current clock count */

/*
 * For prototypes for functions in the Phar Lap libraries, force
 * stack-based C calling conventions.
 */
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Function prototypes for C-callable routines in DOS32.LIB.
 *
 * Prototypes for functions supported in the 16-bit Microsoft C library,
 * but not in the 32-bit Microsoft C library.  However, they are supported
 * in the MetaWare High C/C++ and Watcom C/386 C libraries.
 */

/* Execute an 80x86 interupt without segment registers specified */
int __STKCALL _int86(int intnum, union _REGS *inregs, union _REGS *outregs);
/* Execute an 80x86 interupt with segment registers specified */
int __STKCALL _int86x(int intnum, union _REGS *inregs, union _REGS *outregs,
			struct _SREGS *segregs);
/* Execute an INT 21 interupt without segment registers specified */
int __STKCALL _intdos(union _REGS *inregs, union _REGS *outregs);
/* Execute an INT 21 interupt with segment registers specified */
int __STKCALL _intdosx(union _REGS *inregs, union _REGS *outregs,
			struct _SREGS *segregs);
/* Invoke DOS INT 21h system call */
int __STKCALL _bdos(int dosfunc, UINT dosdx, UINT dosal);
/* INT 11h - Get equipment configuration */
UINT __STKCALL _bios_equiplist(void);
/*
 * The _bios_disk() call, INT 13h, is not supported
 */
/* INT 12h - Get conventional memory size */
UINT __STKCALL _bios_memsize(void);
/* INT 14h - Call bios communication services */
UINT __STKCALL _bios_serialcom(UINT services, UINT serial_port,UINT data);
/* INT 16h - Call bios keyboard services */
UINT __STKCALL _bios_keybrd(UINT service);
/* INT 17h - Call bios printer services */
UINT __STKCALL _bios_printer(UINT service, UINT printer, UINT data);
/* INT 1Ah - Call time and date services */
UINT __STKCALL _bios_timeofday(UINT service, ULONG *timeval);
/* INT 21h AH=0Eh - Set current disk drive */
void __STKCALL _dos_setdrive(UINT drive, UINT *numdrives);
/* INT 21h AH=19h - Get current disk drive */
void __STKCALL _dos_getdrive(UINT *drive);
/*
 * _dos_setvect(), AH=25h, is not supported -- use _dx_pmiv_set or _dx_rmiv_set
 */
/* INT 21h AH=2Ah - Get system date */
void __STKCALL _dos_getdate(struct _dosdate_t *date);
/* INT 21h AH=2Bh - Set system date */
UINT __STKCALL _dos_setdate(struct _dosdate_t *date);
/* INT 21h AH=2Ch - Get system time */
void __STKCALL _dos_gettime(struct _dostime_t *time);
/* INT 21h AH=2Dh - Set system time */
UINT __STKCALL _dos_settime(struct _dostime_t *time);
/* INT 21h AH=31h - Terminate and stay resident */
void __STKCALL _dos_keep(UINT retcode, UINT memsize);
/*
 * _dos_getvect(), AH=35h, is not supported -- use _dx_pmiv_get or _dx_rmiv_get
 */
/* INT 21h AH=36h - Get disk information */
UINT __STKCALL _dos_getdiskfree(UINT drive, struct _diskfree_t *diskspace);
/* INT 21h AH=3Ch - Create file */
UINT __STKCALL _dos_creat(UCHAR *fnamep, UINT attr, int *handlep);
/* INT 21h AH=3Dh - Open file */
UINT __STKCALL _dos_open(UCHAR *fnamep, UINT attr, int *handlep);
/* INT 21h AH=3Eh - Close file */
UINT __STKCALL _dos_close(int handle);
/* INT 21h AH=3Fh - Read file or device */
UINT __STKCALL _dos_read(int handle, void *bufp, UINT nbytes, UINT *nreadp);
/* INT 21h AH=40h - Write file or device */
UINT __STKCALL _dos_write(int handle, void *bufp, UINT nbytes, UINT *nwritep);
/* INT 21h AH=43h - Get/set file attributes */
UINT __STKCALL _dos_getfileattr(char *pathname, UINT *attrib);
UINT __STKCALL _dos_setfileattr(char *pathname, UINT attrib);
/* INT 21h AH=48h - Allocate segment in paragraphs */
UINT __STKCALL _dos_allocmem(UINT npar, USHORT *selectorp);
/* INT 21h AH=49h - Free segment */
UINT __STKCALL _dos_freemem(USHORT selector);
/* INT 21h AH=4Ah - Resize segment in paragraphs */
UINT __STKCALL _dos_setblock(UINT npar, USHORT selector, UINT *maxparp);
/* INT 21h AH=4Eh - Find file with specified attributes */
UINT __STKCALL _dos_findfirst(char *filename, UINT attrib, 
						struct _find_t *fileinfo);
/* INT 21h AH=4Fh - Find next file with specified attributes */
UINT __STKCALL _dos_findnext(struct _find_t *fileinfo);
/* INT 21h AH=57h - Get/set file time and date */
UINT __STKCALL _dos_getftime(int handle, UINT *date, UINT *time);
UINT __STKCALL _dos_setftime(int handle, UINT date, UINT time);
/* INT 21h AH=59h - Get extended error information */
int __STKCALL _dosexterr(struct _DOSERROR *errorinfo);
/* INT 21h AH=5Bh - Create file */
UINT __STKCALL _dos_creatnew(char *fnamep, UINT attr, int *handlep);
/* INT 21h AH=68h - Flush file to disk */
UINT __STKCALL _dos_commit(int handle);

/*
 * End of function prototypes -- restore calling conventions to whatever
 * they were originally
 */
#ifdef __cplusplus
}
#endif

#endif		// of 32-bit version of _dos_, _bios_, _intdosx, _int86x 
		// functions supported by 16-bit Microsoft C

/*
 * For prototypes for functions in the Phar Lap libraries, force
 * stack-based C calling conventions.
 */
#ifdef __cplusplus
extern "C" {
#endif

/*	
 * Function prototypes for C-callable routines in DOS32.LIB.
 *
 * These are Phar Lap-specific prototypes, for routines that are not in
 * the standard 16-bit Microsoft C run-time library.
 */
/* INT 21h AH=01h - Character input with echo */
void __STKCALL _dos_char_ine(UCHAR *chp);
/* INT 21h AH=02h - Character output */
void __STKCALL _dos_char_out(UCHAR ch);
/* INT 21h AH=09h - Output character string */
void __STKCALL _dos_str_out(UCHAR *strp);
/* INT 21h AH=0Ah - Buffered input */
void __STKCALL _dos_buff_in(void *bufp);
/* INT 21h AH=30h - Get MS-DOS and 386|DOS-X version number */
void __STKCALL _dos_ver(ULONG dxinfo, ULONG *verp,ULONG *dxverp,ULONG *dxenvp);
/* INT 21h AH=41h - Delete file */
UINT __STKCALL _dos_delete(UCHAR *fnamep);
/* INT 21h AH=42h - Seek in file */
UINT __STKCALL _dos_seek(int handle,int origin,LONG offset,ULONG *new_filep);
/* INT 21h AH=46h - Force duplicate of handle */
UINT __STKCALL _dos_force_hnd(int hnd, int newhnd);
/* INT 21h AH=48h - Allocate segment in pages */
UINT __STKCALL _dos_seg_alloc(ULONG npages, USHORT *selectorp, ULONG *maxpgsp);
/* INT 21h AH=49h - Free segment */
/* Note this call is identical to _dos_freemem() */
UINT __STKCALL _dos_seg_free(USHORT selector);
/* INT 21h AH=4Ah - Resize segment in pages */
UINT __STKCALL _dos_seg_resize(ULONG npages, USHORT selector, ULONG *maxpgsp);
/* INT 21h AH=50h - Set PSP */
void __STKCALL _dos_setpsp(USHORT real_psp_seg);
/* INT 21h AX=51h - Get PSP */
void __STKCALL _dos_getpsp(USHORT *real_psp_seg);
/* INT 21h AX=5801h - Set conventional memory allocation strategy */
UINT __STKCALL _dos_alloc_sset(UINT strategy);
/* INT 21h AX=5800h - Get conventional memory allocation strategy */
UINT __STKCALL _dos_alloc_sget(UINT *stratp);
/* INT 21h AH=67h - Set handle count */
UINT __STKCALL _dos_sethandcnt(UINT handle_cnt);

/*
 * End of function prototypes -- restore calling conventions to whatever
 * they were originally
 */
#ifdef __cplusplus
}
#endif

#pragma pack()

#endif
