@echo off
: DBGADS.BAT -- Debug an AutoCAD R12 ADS application built with Microsoft 
:		Visual C++, 32-bit Edition.  Note the AutoCAD directory
:		(with ACAD.EXE) must be on the executable PATH.
:
: 	dbgads ads_filename [additional SB386 switches]
: 	
if x%1 == x goto usage
:
: We use the ADSDEBUG.EXE debugger, which is an ADS-specific version of
: SB386.  Set the MSVCADSDEBUG environment variable to enable the INT 3 
: inside the initializer for an ADS app built with Visual C++.  This
: INT 3 allows us to get control in the debugger after the CS and DS
: registers are loaded with the segment selectors for the ADS program.
:
: The following SB386 switches are used:
:	-STARTFILE ADS		the ADS.CMD startup file has commands to
:				step past the initial INT 3 and set the
:				correct ADS segments in the symbol table
:	-SWAPMON		You should always use a 2-monitor setup
:				when debugging AutoCAD or ADS apps.
:	-SYMFILE %1		Loads the symbol table from the ADS app
:
: You may also want to use other SB386 switches, in particular -SOURCPATH.
: For example:
:	dbgads \acad\ads\tower -sourcepath \acad\ads
:
: The full pathname to the AutoCAD executable directory should be specified
: both the line below and on the line whihc invokes ADSDEBUG.  This will 
: ensure correct ACAD.EXE gets loaded by ADSDEBUG.
:
set dosx=-dbgfname c:\acad\acad.exe 
set msvcadsdebug=1
adsdebug -startf ads -swap -sf %1.exp %2 %3 %4 %5 %6 %7 %8 %9 c:\acad\acad.exe
set mvscadsdebug=
goto exit

:usage
	echo Usage:  dbgads ads_filename [add'l SB386 switches]
	goto exit

:exit
