/*
 * hpcmd.c  perform an MPE command on the HP3000 and redirect the output
 *	    back to the PC.  If the HP does not prompt with :<d1>,
 *	    keep prompting the user and sending response back to the hp.
 *	    Terminate when you get the final ":".
 *
 *	    Return an errorlevel if you see a CIERR or CIWARN
 *
 * Revision history - shipped with version 3.40 (plus only)
 *
 *	    1.00     6/27/89  DI
 */

#include <stdlib.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include "api.h"

#define YES 1
#define NO  0
#define DC1 17
#define LF 10

void error(char *s);
void apiexit(void);
void printvar(int i);
int getv(char *s, int i);
void fixarg0(char s[]);
void showout(void);
int colonprompt(void);
void usage(void);


char var1buf[81];
int hperror = NO;	    /* YES if received CIERR or CIWARN */
int eat_linefeed = YES;
char global_buf[81];


void main(int argc, char *argv[])
   {
   int	   i,j,k;
   int	   length;
   char    var[81];
   char    var2buf[81];
   char    inbuffer[81];

   fixarg0(argv[0]);

   if (!strcmp(argv[0], "HPCMD" ) || !strcmp(argv[1], "/?"))
      usage();

   if (api_rcheck() != NoError)
      error("Reflection not present in background.");

   if (api_instchk(var1buf) != NoError)
      error("Please start Reflection with /W switch for API support");

   if (api_startcommands() != NoError)
      error("Reflection busy or not in terminal mode.");

   api_docommand("set literal-escape '~~'");

   /*
   /* Form a single command line out of argv[i]'s and store it in v0
   */

   var[0] = '\0';
   for (i = 0; i < argc; i++)
      {
      strcat(var, argv[i]);
      strcat(var, " ");
      }
   strcat(var, "^m");

   api_setvar(var, 0, strlen(var));

   /*
   /* Transmit v0 and wait 5 sec for host echo, capturing it in v2
   */

   api_docommand("transmit '$0'");
   api_docommand("readhost 0:0:5 v2");

   if (!api_found())
      error("No response received from HP3000");

   /*
   /*keep displaying lines till ^q
   */

   showout();
   }

void error(char *s)
   {
   printf("%s\n",s);
   api_endcommands();
   exit(1);
   }

void apiexit(void)
   {
   api_endcommands();
   exit(1);
   }

/* print reflection variable v2 which has received line */

void printvar(int i)
   {
   char    vbuf[81];
   int	   j,k;

   api_getvar(vbuf, i, &j);
   vbuf[j]= '\0';

   if (strstr(vbuf,"(CIERR" )!=NULL||strstr(vbuf,"(CIWARN" )!=NULL )
      hperror = YES;

   if (eat_linefeed == YES )
      {
      eat_linefeed = NO;
      if (vbuf[0] == LF)
	 {
	 i = 0;
	 while ((vbuf[i] = vbuf[i+1]) != 0 )
	    i++;
	 }
      }

   printf("%s", vbuf);
   }

int getv(char *varString, int varNumber)
   {
   int varLength;

   api_getvar(varString, varNumber, &varLength);
   varString[varLength]='\0';
   return varString[0] & 0xFF;
   }

void fixarg0(char s[])
   {
   char    t[80];
   char    *k;
   char    *ptr;
   char    *sptr;
   int	   i,j;

   j = strlen(s);

   for ( i = 0 ; i < j ; i++ )
      t[i] = s[i];

   ptr = t;
   i = 0;

   while ((k = strstr(ptr,"\\")) != 0)
      ptr = k+1;

   sptr = ptr;

   if ((k = strstr(ptr,".")) != 0)
      {
      ptr = k;
      *ptr = '\0';
      }

   i = 0;
   while ((s[i] = *sptr) != 0)
      {
      i++;
      sptr++;
      }
   }


void showout(void)
   {
   char    var[81];
   int	   k;

   api_docommand("let v7=''");

   while (1)
      {
      /*
      /* Transmit chars that user types at the DOS prompt while host is
      /* dumping data.
      */
      if (kbhit())
	 {
	 k = getch();
	 var1buf[0] = k;
	 api_setvar(var1buf, 3, 1);
	 api_docommand("transmit '$3'");
	 }

      api_docommand("readhost 0:0:10 v2 until '^m^q' terminator v7");
      if (!api_found())
	 error("No response from host");

      if (colonprompt())
	 apiexit();

      printvar(2);
      }
   }

/* recognize the string [LF]...[LF][:][DC1] */

int colonprompt(void)
   {
   char var[81];
   char t[81];
   int i, terminator;

   api_getvar(t, 2, &i);
   t[i] = '\0';

   terminator = getv(var, 7);
   for (i = 0; i < strlen(t); i++)
      {
      if (t[i] != LF)
	 if (t[i] == ':' && terminator == DC1)
	    return 1;
	 else
	    return 0;
      }
   return 0;
   }

void usage(void)
{
   printf
      (
      "\n"
      "API Demonstration Program - Run HP3000 commands from the DOS Prompt!\n"
      "To use this utility, copy this file to the name of an HP3000 command\n"
      "such as FILE, LISTF, SHOWTIME, or SHOWME. The HP command must not use\n"
      "any screen formatting functions or do any keyboard input.\n"
      "\n"
      "Example: make your own DOS LISTF command.\n"
      "\n"
      "    step 1:   Create the LISTF command:\n"
      "\n"
      "                   COPY HPCMD.EXE LISTF.EXE\n"
      "\n"
      "    step 2:   Load Reflection with API support\n"
      "\n"
      "                   R1 /W\n"
      "\n"
      "    step 3:   Establish a connection to the HP3000 host and hotkey\n"
      "              back to DOS. At the DOS prompt, type the LISTF command\n"
      "              just as you would on the HP3000, e.g:\n"
      "\n"
      "                   C>LISTF  A@.DOC,2\n"
      );

   exit(1);
   }


