/* @(#)mmshdpnt.sl	1.2 (Pixar - RenderMan Division) 5/14/90 */

/*-______________________________________________________________________
** 
** Copyright (c) 1988 PIXAR.  All rights reserved.  This program or
** documentation contains proprietary confidential information and trade
** secrets of PIXAR.  Reverse engineering of object code is prohibited.
** Use of copyright notice is precautionary and does not imply
** publication.
** 
**                      RESTRICTED RIGHTS NOTICE
** 
** Use, duplication, or disclosure by the Government is subject to
** restrictions as set forth in subdivision (b)(3)(ii) of the Rights in
** Technical Data and Computer Software clause at 252.227-7013.
** 
** Pixar
** 3240 Kerner Blvd.
** San Rafael, CA  94901
** 
** ______________________________________________________________________
*/

light
mmshdpnt( 
    float intensity = 1;
    color lightcolor = 1;
    point from = point "shader" (0,0,0);	/* light position */
    string    sfpx    = "";
    string    sfnx    = "";
    string    sfpy    = "";
    string    sfny    = "";
    string    sfpz    = "";
    string    sfnz    = "";
    uniform float width      = 1.0;
    uniform float samples    = 16.0;
)
{
    float    attenuation = 0.0;
    float    Lx, Ly, Lz, AbsLx, AbsLy, AbsLz;
    point    Lrel;

    illuminate( from ) {

        Lrel = transform("world", L + point "world" (0,0,0));

        Lx = xcomp(Lrel);
        AbsLx = abs(Lx);
        Ly = ycomp(Lrel);
        AbsLy = abs(Ly);
        Lz = zcomp(Lrel);
        AbsLz = abs(Lz);

        if((AbsLx > AbsLy) && (AbsLx > AbsLz)) {
            if((Lx > 0.0)&&(sfpx != ""))
		attenuation = shadow( sfpx, Ps, "samples", samples,
                                       "twidth", width, "swidth", width );
            else if (sfnx != "")
		attenuation = shadow( sfnx, Ps, "samples", samples,
                                      "twidth", width, "swidth", width );
	}
        else if((AbsLy > AbsLx) && (AbsLy > AbsLz)) {
            if((Ly > 0.0)&&(sfpy != ""))
		attenuation = shadow( sfpy, Ps, "samples", samples,
                                      "twidth", width, "swidth", width );
            else if (sfny != "")
		attenuation = shadow( sfny, Ps, "samples", samples,
                                      "twidth", width, "swidth", width );
	}
        else if((AbsLz > AbsLy) && (AbsLz > AbsLx)) {
            if((Lz > 0.0)&&(sfpz != ""))
		attenuation = shadow( sfpz, Ps, "samples", samples,
                                      "twidth", width, "swidth", width );
            else if (sfnz != "")
		attenuation = shadow( sfnz, Ps, "samples", samples,
                                      "twidth", width, "swidth", width );
	}

        /* calculate light contribution  with shadow attenuation */
        Cl = (1.0 - attenuation) * intensity * lightcolor;
    }
}
