 /********************************************************************
 * PC installer (aldsetup) control file for PageMaker 5.0a  1.44mb Disks
 * NETWORK INSTALLER control file.
 * Copyright (C) 1992 - 1993 Aldus Corporation.  All rights reserved.
 * Control file administrator: Dave Perkins
 ********************************************************************/

PRODUCT "PageMaker 5.0a"

VERSIONREQ "2.3"

ALDUSDIRECTORY "Aldus" "AdminLogDirectory" "C:\NetLog"


/********   DBUILD SECTION  ***********/



DISK "(1)"
   {
   (C)ALDUS.'93         62,
   ALDSETUP.EXE     284720  CHECKDATE,
   FDA_12M.CTL       11758,
   READFDA.WRI       35712,
   WP5IMP.FL~        40960  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TWAINIMP.FL~      39984  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   RTFIMP.FL~        35358  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WP6IMP.FL~        51328  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   CGMIMP.FL~        52528  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   EXCELIMP.FL~      62544  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   GIFIMP.FL~        13824  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TEIMP.FL~         68016  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   PPD.EX~           88832  "ALDUS\USENGLSH\UTILITY"  CHECKDATE,
   DEAPP.EX~        381632  "ALDUS\USENGLSH\UTILITY"  CHECKDATE,
   PATCH.EX~         45928  "PM5"  CHECKDATE,
   TEAPP.EX~        272496  "PM5"  CHECKDATE,
   TEREAD.WR~         3840  "PM5"  CHECKDATE,
   PATCH.RT~         34585  "PM5"  CHECKDATE,
   NETINST.EX~        8832  "NET"  CHECKDATE,
   UPDATNET.CTL      13760  "NET"  CHECKDATE,
   USIMAGE.SR~       68582  "NET"  CHECKDATE,
   USMAX.SR~         10963  "NET"  CHECKDATE,
   USMIN.SR~         55533  "NET"  CHECKDATE,
   IEIMAGE.SR~       82381  "NET"  CHECKDATE,
   IEMAX.SR~         12909  "NET"  CHECKDATE,
   IEMIN.SR~         70707  "NET"  CHECKDATE,
   CEIMAGE.SR~       80312  "NET"  CHECKDATE,
   CEMAX.SR~         11639  "NET"  CHECKDATE,
   CEMIN.SR~         68916  "NET"  CHECKDATE,
   NETWORK.WRI       25344  "NET"  CHECKDATE
   }


DISK "(2)"
   {
   ALAFTER.PS~        1246  "ALDUS\USENGLSH",
   ACQUIRE.AD~       57344  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   LIBRARY.PA~      126976  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   PANTONEC.BC~      51980  "ALDUS\USENGLSH\COLOR"  CHECKDATE,
   PANTONEU.BC~      51980  "ALDUS\USENGLSH\COLOR"  CHECKDATE,
   PCSGE.BC~        162950  "ALDUS\USENGLSH\COLOR"  CHECKDATE
   }


/*********** DBUILD END ******************/

/*****   DIALOG & VARIABLE INITIALIZATION  *****/

INITIAL NetAldusDir "F:\NetAldus"
	{
	"Type the network drive letter and subdirectory"
	"where you have already installed the Network Aldus"
	"subdirectory.  This subdirectory is created when you"
	"installed the original PageMaker 5.0 network install"
	"files."
	}

DIALOG BuffersWarning "&Continue" "&Exit"
{
	CAPTION "Low BUFFERS setting"
	TEXT
	{
	"Aldus Setup has detected that the BUFFERS setting in your "
	"CONFIG.SYS file is below 20.  You can successfully install "
	"with the current settings, but the installation process may"
	"be slowed considerably.  Increasing the value of this setting"
	"and rebooting your computer will speed up the installation time."
	}
}

DIALOG PPDwarning "&OK"
{
	CAPTION "Selecting PPDs (PostScript ONLY)"
	TEXT
	{
	"If you will be using a PostScript printer, you will need to"
	"install a PostScript Printer Description (PPD) file for each"
	"printer.  Select only the printers you need.  Installing more"
	"PPDs than you need (ten or more) may slow the performance of"
	"PageMaker's ""Print"" dialog."
	}
}
INITIAL DiskImageDir "F:\PM5Image"
	{
	"Type the name of the drive and directory where"
	"you already installed the images of the PageMaker"
	"disks so that the 5.0a files can be updated."
	""
	"If this is the directory you want, click OK."
	}
DIALOG LogFileLocation "OK" "Cancel" 
{
	CAPTION "Installation Logfile Creation"
	TEXT
	{
	"Type the drive letter and subdirectory where"
	"you want the installer to create the installation"
	"logfile."
	}
}
DIALOG WhichLangDir "US" "INT." 
{
	CAPTION "Choose Language"
	TEXT
	{
	"Are you installing the update for the US English version or an"
	"International language version?  Click the appropriate button."
	}
}
DIALOG WhichUKLangDir "UK" "CAN." 
{
	CAPTION "Choose Language"
	TEXT
	{
	"Are you installing the UK English version or the Canadian English"
	"version?  Click the appropriate button."
	" "
	"(Note: This update works for the Canadian English version only."
	"       See your distributer for the French Canadian version.)"
	}
}
DIALOG LicWarn "&OK"
{
	CAPTION "Network License Agreement"
	TEXT
	{
	"The license agreement included with this software package"
	"entitles one person to access this copy of PageMaker."
	"If you have not updated that license agreement for"
	"concurrent use by more than one person, you will be in"
	"violation of your license if you distribute copies of this"
	"program or set it up for network access by multiple users."
	""
	"This software includes the capability to detect if the"
	"number of legal users has been exceeded. Illegal sessions"
	"will not be allowed to launch."
	""
	"For more information on network licensing options, contact"
	"Aldus Customer Relations at (206) 628-2320"
	}
}
DIALOG RightsWarn "&OK"
{
	CAPTION "Access Rights"
	TEXT
	{
	"This installation procedure requires that you have"
	"supervisor-level rights to the network. Unless the"
	"server has been specially enabled by the System"
	"Administrator for this network, shared installations"
	"of PageMaker will not launch successfully."
	""
	"See NETWORK.WRI for more details."
	""
	}
}

DIALOG SucRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been successfully installed."
	" "
	"IMPORTANT NOTE:  The file PATCH.EXE has been installed into"
	"the PageMaker subdirectory and will need to be run in order to"
	"finish the update.  This file must be run from the DOS prompt by"
	"the system administrator.  Please exit windows now and run"
	"the patch file to update PageMaker 5.0 to 5.0a"
	}
}

DIALOG BumpEnable "&OK"
{
	CAPTION "Preparing PM5 & Server"
	TEXT
	{
	"If WINBUMPS.EXE and ENABLSRV.EXE were Windows Apps"
	"they would be run at this point."
	"See NETWORK.WRI for more details."
	}
}

/*********** INITIALIZATION END *************/


/*****   PACKAGE DEFINITION SECTION *********/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{
/***** Global Variable Declarations & System Min. Config Checks *****/
GETALDDIR AldDir LogFileLocation
GETBOOTDRIVE BootDrive
SET serialize "FALSE"

CONCAT BootDrive "CONFIG.SYS" ConfigFullName

FILEEXIST ConfigFullName ConfigYesorNo

IF ConfigYesorNo EQS "SUCCESS"
	{
	GETSYSVARVALUE ConfigFullName "BUFFERS" BufferAmount
	IF BufferAmount LT 20 
		{
		DISPLAY BuffersWarning BufferResponse
		IF  BufferResponse EQS "&Exit" 
			{
			EXIT
			}
		} 
	}

DISPLAY LicWarn
DISPLAY RightsWarn

}   /** End PROLOGUE **/

PACKAGE MaxNetAll "Update for network server" SELECTED
	{
	CONFIRMDIR NetAldusDir MUSTEXIST
	DISPLAY WhichLangDir USorInt
	IF USorInt EQS "US"
		{
		CONCAT NetAldusDir "USENGLSH" LangDir
		CONCAT LangDir "COLOR" AColorDir
		CONCAT LangDir "PM5USER" UserDir
		FILES UserDir
			{
			"USMAX.SR~\NETPM5.SRC"
			NETINST.EX~
			}
		}
	IF USorInt EQS "INT."
		{
		DISPLAY WhichUKLangDir UKorCan
		IF UKorCan EQS "UK"
			{
			CONCAT NetAldusDir "UKENGLSH" LangDir
			CONCAT LangDir "COLOUR" AColorDir
			CONCAT LangDir "PM5USER" UserDir
			FILES UserDir
				{
				"IEMAX.SR~\NETPM5.SRC"
				NETINST.EX~
				}
			}
		IF UKorCan EQS "CAN."
			{
			CONCAT NetAldusDir "UKENGLSH" LangDir
			CONCAT LangDir "COLOUR" AColorDir
			CONCAT LangDir "PM5USER" UserDir
			FILES UserDir
				{
				"CEMAX.SR~\NETPM5.SRC"
				NETINST.EX~
				}
			}
		}

	SET serialize "FALSE"
	
	CONCAT LangDir "FILTERS" AFiltDir
	CONCAT AFiltDir "AFILTERS" AddFiltDir
	CONCAT LangDir "ADDITION" AADDitionDir
	CONCAT UserDir "DRIVERS" UserDriversDir


	CONCAT AADDitionDir "TEMPLATE" TemplateDir
	CONCAT TemplateDir "CALDATES" CalDir
	CONCAT CalDir "DAYS" DayDir
	CONCAT LangDir "PPD4" APPD4Dir
	CONCAT LangDir "UTILITY" AUtilDir
	CONCAT AUtilDir "PS_TOOLS" PSTDir

	CONCAT NetAldusDir "PM5" PM5Dir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "tutorial" TutRootDir
	CONCAT PM5Dir "SCRIPTS" ScriptDir
	CONCAT TutRootDir "explore" TutExpDir
	CONCAT TutRootDir "LESSON1" TutLess1Dir
	CONCAT TutRootDir "LESSON2" TutLess2Dir

	/**** File Subdirectory Assignments *****/

		


	FILES LangDir
		{
		ALAFTER.PS~
		}


	FILES AUtilDir
		{
		PPD.EX~
		DEAPP.EX~        
		}

	FILES PM5Dir
		{
		NETWORK.WRI
		TEAPP.EX~        
		TEREAD.WR~         
		PATCH.RT~
		PATCH.EX~
		}

	FILES AColorDir
		{
		PANTONEC.BC~      
		PANTONEU.BC~      
		PCSGE.BC~        
		}

	FILES AADDitionDir
		{
		ACQUIRE.AD~       
		LIBRARY.PA~      
		}

	FILES AfiltDir
		{
		WP5IMP.FL~        
		TWAINIMP.FL~      
		RTFIMP.FL~        
		WP6IMP.FL~        
		CGMIMP.FL~        
		EXCELIMP.FL~      
		GIFIMP.FL~        
		TEIMP.FL~         
		}

	/**** Oninstall Commands ******/


	}  /***** END Server MAX Install *****/

PACKAGE BlankLine "----------------------------------------------------" UNSELECTED
{
SET Fred "Barney"
}

PACKAGE MinNet "Update for server & hard disk" UNSELECTED
{
	CONFIRMDIR NetAldusDir MUSTEXIST
	DISPLAY WhichLangDir USorInt
	IF USorInt EQS "US"
		{
		CONCAT NetAldusDir "USENGLSH" LangDir
		CONCAT LangDir "COLOR" AColorDir
		CONCAT LangDir "PM5USER" UserDir
		FILES UserDir
			{
			"USMIN.SR~\NETPM5.SRC"
			NETINST.EX~
			}
		}
	IF USorInt EQS "INT."
		{
		DISPLAY WhichUKLangDir UKorCan
		IF UKorCan EQS "UK"
			{
			CONCAT NetAldusDir "UKENGLSH" LangDir
			CONCAT LangDir "COLOUR" AColorDir
			CONCAT LangDir "PM5USER" UserDir
			FILES UserDir
				{
				"IEMIN.SR~\NETPM5.SRC"
				NETINST.EX~
				}
			}
		IF UKorCan EQS "CAN."
			{
			CONCAT NetAldusDir "UKENGLSH" LangDir
			CONCAT LangDir "COLOUR" AColorDir
			CONCAT LangDir "PM5USER" UserDir
			FILES UserDir
				{
				"CEMIN.SR~\NETPM5.SRC"
				NETINST.EX~
				}
			}
		}
	
	CONCAT LangDir "UTILITY" AUtilDir
	CONCAT NetAldusDir "PM5" PM5Dir
	CONCAT UserDir "DRIVERS" UserDriversDir
	CONCAT UserDir "FILTERS" UserFilterDir
	CONCAT UserFilterDir "AFILTERS" UserAddFilterDir
	CONCAT UserDir	"ADDITION" UserAddDir
	CONCAT UserAddDir "TEMPLATE" UserTemDir
	CONCAT UserTemDir "CALDATES" UserCalDir
	CONCAT UserCalDir "DAYS" UserDayDir
	CONCAT UserDir "PPD4" UserPPD4Dir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "tutorial" TutRootDir
	CONCAT PM5Dir "SCRIPTS" ScriptDir
	CONCAT TutRootDir "explore" TutExpDir
	CONCAT TutRootDir "LESSON1" TutLess1Dir
	CONCAT TutRootDir "LESSON2" TutLess2Dir

	/**** File Subdirectory Assignments *****/

	FILES UserAddDir NODECOMPRESS
		{
		ACQUIRE.AD~       
		LIBRARY.PA~      
		}

	FILES UserFilterDir NODECOMPRESS
		{
		WP5IMP.FL~        
		TWAINIMP.FL~      
		RTFIMP.FL~        
		WP6IMP.FL~        
		CGMIMP.FL~        
		EXCELIMP.FL~      
		GIFIMP.FL~        
		TEIMP.FL~         
		}


	FILES LangDir
		{
		ALAFTER.PS~
		}

	FILES AColorDir
		{
		PANTONEC.BC~      
		PANTONEU.BC~      
		PCSGE.BC~        
		}

	FILES AUtilDir
		{
		PPD.EX~
		DEAPP.EX~
		}

	FILES PM5Dir
		{
		NETWORK.WRI
		TEAPP.EX~        
		TEREAD.WR~         
		PATCH.RT~
		PATCH.EX~
		}


/**** Oninstall Commands ******/


	}  /***** END Server MIN Install *****/

PACKAGE BlankLine "----------------------------------------------------" UNSELECTED
{
SET Fred "Barney"
}

PACKAGE ImageNet "Install disks on server" UNSELECTED
{
	CONFIRMDIR DiskImageDir MUSTEXIST

	CONCAT DiskImageDir "Disk1" Disk1Dir
	CONCAT DiskImageDir "Disk2" Disk2Dir
	CONCAT DiskImageDir "Disk3" Disk3Dir
	CONCAT DiskImageDir "Disk4" Disk4Dir
	CONCAT DiskImageDir "Disk5" Disk5Dir
	CONCAT DiskImageDir "Disk6" Disk6Dir
	CONCAT DiskImageDir "Disk7" Disk7Dir

	DISPLAY WhichLangDir USorInt
	IF USorInt EQS "US"
		{
		FILES DiskImageDir
		   {
		   "USIMAGE.SR~\PM5_NET.CTL"
		   }
		FILES Disk5Dir NODECOMPRESS
		   {
		   ALAFTER.PS~  
		   ACQUIRE.AD~ 
		   LIBRARY.PA~ 
		   }	
		}
	IF USorInt EQS "INT."
		{
		DISPLAY WhichUKLangDir UKorCan
		IF UKorCan EQS "UK"
			{
			FILES DiskImageDir
			   {
			   "IEIMAGE.SR~\PM5_NET.CTL"
			   }
			FILES Disk6Dir NODECOMPRESS
			   {
			   ALAFTER.PS~  
			   ACQUIRE.AD~ 
			   LIBRARY.PA~ 
			   }	
			}
		IF UKorCan EQS "CAN."
			{
			FILES DiskImageDir
			   {
			   "CEIMAGE.SR~\PM5_NET.CTL"
			   }
			FILES Disk6Dir NODECOMPRESS
			   {
			   ALAFTER.PS~  
			   ACQUIRE.AD~ 
			   LIBRARY.PA~ 
			   }	
			}
		}
	SET serialize "FALSE"




	/**** File Subdirectory Assignments *****/


FILES Disk1Dir NODECOMPRESS
   {
   READFDA.WRI
   NETWORK.WRI 
   }

FILES Disk2Dir 
   {
   PATCH.RT~
   PATCH.EX~
   }

FILES Disk3Dir NODECOMPRESS  
   {
   PCSGE.BC~   
   PANTONEC.BC~
   PANTONEU.BC~
   }

FILES Disk4Dir NODECOMPRESS
   {
   TEAPP.EX~        
   TEREAD.WR~         
   WP5IMP.FL~        
   TWAINIMP.FL~      
   RTFIMP.FL~        
   WP6IMP.FL~        
   CGMIMP.FL~        
   EXCELIMP.FL~      
   GIFIMP.FL~        
   TEIMP.FL~         
   PPD.EX~      
   DEAPP.EX~   
   }


	
}  /***** END Server MIN Install *****/


PACKAGE LastOninstalls "" SELECTED INVISIBLE
{
	/***  Stuff to be done after all other ONINSTALL's are completed ***/
	
	ONINSTALL
		{
		DISPLAY SucRead
		}
}
/*****
	Use EPILOGUE only for options which should be run when the
	user clicks the EXIT button from ALDSETUP

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
	 {
SET Fred "Barney" 
	}
*****/

/********* PACKAGE END ************/
