/********************************************************************
 * PC installer (aldsetup) control file for PageMaker 5.0  1.44mb Disks
 * Copyright (C) 1992 - 1993 Aldus Corporation.  All rights reserved.
 * Control file administrator: Dave Perkins
 ********************************************************************/

PRODUCT "PageMaker 5.0a"

VERSIONREQ "2.3"

ALDUSDIRECTORY "Aldus" "AldusDirectory" "C:\ALDUS"


/********   DBUILD SECTION  ***********/



DISK "(1)"
   {
   (C)ALDUS.'93         62,
   ALDSETUP.EXE     284720  CHECKDATE,
   FDA_12M.CTL       11758,
   READFDA.WRI       35712,
   WP5IMP.FL~        40960  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TWAINIMP.FL~      39984  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   RTFIMP.FL~        35358  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   WP6IMP.FL~        51328  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   CGMIMP.FL~        52528  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   EXCELIMP.FL~      62544  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   GIFIMP.FL~        13824  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   TEIMP.FL~         68016  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   PPD.EX~           88832  "ALDUS\USENGLSH\UTILITY"  CHECKDATE,
   DEAPP.EX~        381632  "ALDUS\USENGLSH\UTILITY"  CHECKDATE,
   PATCH.EX~         45928  "PM5"  CHECKDATE,
   TEAPP.EX~        272496  "PM5"  CHECKDATE,
   TEREAD.WR~         3840  "PM5"  CHECKDATE,
   PATCH.RT~         34585  "PM5"  CHECKDATE,
   NETINST.EX~        8832  "NET"  CHECKDATE,
   UPDATNET.CTL      13760  "NET"  CHECKDATE,
   USIMAGE.SR~       68582  "NET"  CHECKDATE,
   USMAX.SR~         10963  "NET"  CHECKDATE,
   USMIN.SR~         55533  "NET"  CHECKDATE,
   IEIMAGE.SR~       82381  "NET"  CHECKDATE,
   IEMAX.SR~         12909  "NET"  CHECKDATE,
   IEMIN.SR~         70707  "NET"  CHECKDATE,
   CEIMAGE.SR~       80312  "NET"  CHECKDATE,
   CEMAX.SR~         11639  "NET"  CHECKDATE,
   CEMIN.SR~         68916  "NET"  CHECKDATE,
   NETWORK.WRI       25344  "NET"  CHECKDATE
   }


DISK "(2)"
   {
   ALAFTER.PS~        1246  "ALDUS\USENGLSH",
   ACQUIRE.AD~       57344  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   LIBRARY.PA~      126976  "ALDUS\USENGLSH\ADDITION"  CHECKDATE,
   PANTONEC.BC~      51980  "ALDUS\USENGLSH\COLOR"  CHECKDATE,
   PANTONEU.BC~      51980  "ALDUS\USENGLSH\COLOR"  CHECKDATE,
   PCSGE.BC~        162950  "ALDUS\USENGLSH\COLOR"  CHECKDATE
   }


/*********** DBUILD END ******************/


/*****   DIALOG & VARIABLE INITIALIZATION  *****/

INITIAL PM5Dir "C:\PM5"
	{
	"Type the name of the drive and directory where"
	"you have already installed your Aldus PageMaker 5.0"
	"files."
	" "
	"If this is the directory you want, click OK."
	}


DIALOG PMNotInstalled "&Exit"
  {
	CAPTION "PageMaker 5.0 is not installed"
	TEXT
	{
	"In order to update Aldus PagerMaker 5.0 to 5.0a"
	"you must have already installed PageMaker 5.0."
	"The settings in the WIN.INI indicate that this program"
	"is not installed."
	" "
	"Please quit this installation, install Aldus PageMaker 5.0"
	"then continue with this update."
	}
  }

DIALOG AldusLocation "OK" "Cancel" 
{
	CAPTION "Aldus Directory Creation"
	TEXT
	{
	"Type the drive letter and subdirectory where"
	"you want to install the Aldus files.  This"
	"directory will be used by all Aldus products"
	"to store files such as dictionaries and filters."
	}
}

DIALOG BuffersWarning "&Continue" "&Exit"
{
	CAPTION "Low BUFFERS setting"
	TEXT
	{
	"Aldus Setup has detected that the BUFFERS setting in your "
	"CONFIG.SYS file is below 20.  You can successfully install "
	"with the current settings, but the installation process may"
	"be slowed considerably.  Increasing the value of this setting"
	"and rebooting your computer will speed up the installation time."
	}
}

DIALOG AcquireQuest "&Yes" "&No"
{
	CAPTION "Acquire image..."
	TEXT
	{
	"Would you like to install the ""Acquire image..."" addition"
	"and the associated ""Twain Image Acquisition Import"" filter"
	"to your hard disk?"
	}
}


DIALOG SucRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been successfully installed."
	" "
	"IMPORTANT NOTE:  The file PATCH.EXE has been installed into"
	"the PageMaker subdirectory and will need to be run in order to"
	"finish the update.  This file must be run from the DOS prompt."
	"Double-click on the readme file for more detailed information."
	}
}

DIALOG NetAldusInstalled "E&xit"
{
	CAPTION "Network Version found"
	TEXT
	{
	"The installer found a NetAldusDirectory setting in"
	"the WIN.INI file which implies that a Network version"
	"of an Aldus product is installed.  This installation"
	"is setup to install only local hard disk versions. "
	"Please refer to your network installation guide for"
	"information about how to update the network."
	""	
	}
}

DIALOG SucNoRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to examine the"
	"information provided from the Diagnostics or View menu"
	"in Aldus Setup."
	}
}

/*********** INITIALIZATION END *************/


/*****   PACKAGE DEFINITION SECTION *********/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{
/***** Global Variable Declarations & System Min. Config Checks *****/

/*  We are checking here to find out if PM5 is installed and
    what language is installed.  IF PM isn't installed, we should
    quit the install, if it is, copy the filters into the appropriate
    dir. 
*/
GETWININIENTRY "ALDUS" "PM5AppDir" PM5Dir
GETWININIENTRY "ALDUS" "AldusDirectory" AldDir
GETWININIENTRY "ALDUS" "PM5LangDir" PM5LangDir
GETWININIENTRY "Aldus" "NetAldusDirectory" NetDirVar

IF NetDirVar NES "NOT_SET"
	{
	IF NetDirVar NES "NONE"
		{
		DISPLAY NetAldusInstalled
		EXIT
		}
	}


IF PM5Dir EQS "NOT_SET"
   {
   DISPLAY PMNotInstalled 
   EXIT
   }

IF PM5Dir NES "NOT_SET"
	{
        CONCAT PM5Dir "PM5.exe" FullPMName
	FILEEXIST FullPMName IsPmThere
	IF IsPmThere NES "SUCCESS"
		{
		DISPLAY PMNotInstalled 
		EXIT
		}
	}

IF AldDir EQS "NOT_SET"
   {
   DISPLAY PMNotInstalled 
   EXIT
   }

IF PM5LangDir EQS "NOT_SET"
   {
   DISPLAY PMNotInstalled 
   EXIT
   }

GETBOOTDRIVE BootDrive
GETWINDIR WinDir
GETWINSYSDIR WinSysDir
SET EverythingInstalled "FALSE"

CONCAT BootDrive "CONFIG.SYS" ConfigFullName

FILEEXIST ConfigFullName ConfigYesorNo

IF ConfigYesorNo EQS "SUCCESS"
	{
	GETSYSVARVALUE ConfigFullName "BUFFERS" BufferAmount
	IF BufferAmount LT 20 
		{
		DISPLAY BuffersWarning BufferResponse
		IF  BufferResponse EQS "&Exit" 
			{
			EXIT
			}
		} 
	}

}   /** End PROLOGUE **/

PACKAGE InstallEverything "Install Everything" SELECTED
	{
	/**** Package Initializations *****/

	CONCAT AldDir PM5LangDir LangDir
	CONCAT LangDir "FILTERS" FiltDir
	CONCAT LangDir "SETUP" SetupDir
	CONCAT LangDir "FILTERS" FiltDir
	CONCAT LangDir "ADDITION" AADDitionDir
	CONCAT LangDir "UTILITY" AUtilDir
 
	IF PM5LangDir EQS "USENGLSH"
		{
		CONCAT LangDir "COLOR" AColorDir
		}

	IF PM5LangDir EQS "UKENGLSH"
		{
		CONCAT LangDir "COLOUR" AColorDir
		}

	/**** File Subdirectory Assignments *****/

	FILES FiltDir
		{
		WP5IMP.FL~        
		TWAINIMP.FL~      
		RTFIMP.FL~        
		WP6IMP.FL~        
		CGMIMP.FL~        
		EXCELIMP.FL~      
		GIFIMP.FL~        
		TEIMP.FL~         
		}

	FILES AColorDir
		{
		PANTONEC.BC~      
		PANTONEU.BC~      
		PCSGE.BC~        
		}

	FILES AADDitionDir
		{
		ACQUIRE.AD~       
		LIBRARY.PA~      
		}

	FILES LangDir
		{
		ALAFTER.PS~         
		}

	FILES AUtilDir
		{
		PPD.EX~           
		DEAPP.EX~        
		}

	FILES PM5Dir
		{
		READFDA.WRI
		PATCH.EX~         
		TEAPP.EX~        
		TEREAD.WR~         
		PATCH.RT~         
		}

	/**** end File Subdirectory Assignments ****/



	/**** INI Initializations ****/

	SET EverythingInstalled "TRUE"

	/**** INI Settings ****/

	/*** Oninstall initializations ***/

	CONCAT PM5Dir "READFDA.WRI" ReadMeName		    
	CONCAT WinDir "WRITE.EXE" WriteName

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		DELETEPROGRAMITEM "Aldus" "Filter/Driver Pack Plus Readme"
  

		ADDPROGRAMITEM "Aldus" ReadMeName "Filter/Driver Pack Plus Readme" WriteName 0	

		}	/** End Oninstall **/

	}	/***** END PageMaker Easy Install *****/


PACKAGE BlankLine "----------------------------------------------------" UNSELECTED
{
SET Fred "Barney"
}

PACKAGE PageMaker "PageMaker 5.0a update" UNSELECTED
	{
	/**** Package Initializations *****/

	CONCAT AldDir PM5LangDir LangDir
	CONCAT LangDir "FILTERS" FiltDir
	CONCAT LangDir "SETUP" SetupDir
	CONCAT LangDir "FILTERS" FiltDir
	CONCAT LangDir "ADDITION" AADDitionDir
	CONCAT LangDir "UTILITY" AUtilDir

	IF PM5LangDir EQS "USENGLSH"
		{
		CONCAT LangDir "COLOR" AColorDir
		}

	IF PM5LangDir EQS "UKENGLSH"
		{
		CONCAT LangDir "COLOUR" AColorDir
		}

	/**** File Subdirectory Assignments *****/

	FILES AColorDir
		{
		PANTONEC.BC~      
		PANTONEU.BC~      
		PCSGE.BC~        
		}

	FILES AUtilDir
		{
		PPD.EX~           
		DEAPP.EX~        
		}

	FILES LangDir
		{
		ALAFTER.PS~         
		}

	FILES PM5Dir
		{
		READFDA.WRI
		PATCH.EX~         
		TEAPP.EX~        
		TEREAD.WR~         
		PATCH.RT~         
		}


	/**** end File Subdirectory Assignments ****/





	/*** Oninstall initializations ***/

	CONCAT PM5Dir "READFDA.WRI" ReadMeName		    
	CONCAT WinDir "WRITE.EXE" WriteName

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		IF EverythingInstalled EQS "FALSE"
			{
			DELETEPROGRAMITEM "Aldus" "Filter/Driver Pack Plus Readme"
  

			ADDPROGRAMITEM "Aldus" ReadMeName "Filter/Driver Pack Plus Readme" WriteName 0	
			SET EverythingInstalled "TRUE"
			}
		}	/** End Oninstall **/

	}	/***** END PageMaker *****/


PACKAGE AddsFilts "Additions/Filters update" UNSELECTED
	{
	/**** Package Initializations *****/

	CONCAT AldDir PM5LangDir LangDir
	CONCAT LangDir "FILTERS" FiltDir
	CONCAT LangDir "SETUP" SetupDir
	CONCAT LangDir "FILTERS" FiltDir
	CONCAT LangDir "ADDITION" AADDitionDir
	CONCAT LangDir "UTILITY" AUtilDir

	IF PM5LangDir EQS "USENGLSH"
		{
		CONCAT LangDir "COLOR" AColorDir
		}

	IF PM5LangDir EQS "UKENGLSH"
		{
		CONCAT LangDir "COLOUR" AColorDir
		}

	/**** File Subdirectory Assignments *****/

	DISPLAY AcquireQuest AcquireResponse
	IF AcquireResponse EQS "&Yes"
		{
		FILES FiltDir
			{
			TWAINIMP.FL~      
			}

		FILES AADDitionDir
			{
			ACQUIRE.AD~       
			LIBRARY.PA~      
			}
		}
		
	SELECT1 "Select filters" FiltDir
		{
		TEXT
			{
			"Select the filters you want to install:"
			}
		ITEMS
			{
			CGMIMP.FL~ "CGM Graphics Import",	  
			EXCELIMP.FL~ "Excel Spreadsheet Import",	   
			GIFIMP.FL~ "GIF Graphics Import",	   
			RTFIMP.FL~ "Rich Text Format (RTF) Import",
			TEIMP.FL~ "Table Editor Import",
			WP5IMP.FL~ "WordPerfect 5.X Import",
			WP6IMP.FL~ "WordPerfect 6.0 Import"
			}
		HELP
			{
			"PageMaker uses filters to export and"
			"import files to and from other applications."
			" "
			"Select multiple filters by holding the"
			"Ctrl key down as you click on the filter"
			"name.  You can install additional filters"
			"at any time."
			}

		}  /*** End Select Filters ****/


	}   /*** END AddsFilts Package ***/


PACKAGE LastOninstalls "" SELECTED INVISIBLE
	{

	ONINSTALL
		{
		IF EverythingInstalled EQS "TRUE"
			{
			DISPLAY SucRead 
			}
		IF EverythingInstalled EQS "FALSE"
			{
			DISPLAY SucNoRead 
			}
			
		}  /**** End Oninstall ****/

	}  /***** End LastOninstalls ****/




/****
	Use EPILOGUE only for options which should be run when the
	user clicks the EXIT button from ALDSETUP

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
    {
        DISPLAY RebootReminder

    }
****/

