#include <stdio.h>
#include <dos.h>

/* 4 megabits */
#define SIZE    524288

#define MAXBUF  4096
#define NUMSEGS 8

/* use CP=37A for lpt2: */
#define CP      0x3be

/* use DP=378 for lpt2: */
#define DP      0x3bc

/* use IP=379 for lpt2: */
#define IP      0x3bd

#define LA      0xe1
#define MA      0xe2
#define HA      0xe3
#define NOPA    0xe0
#define HI_NYB  0xe0
#define LO_NYB  0xe8
#define DELAY   10

void loop();

void main(argc, argv)
int argc;
char *argv[];
{

unsigned char buffer[256], tmp, testhi, testlo, lo_nyb, hi_nyb;
long int segment, page, byte, total=0;
FILE *fp;

if (argc > 3) {
	printf("usage: readcart [filename] [4|8|12 megabits]\n");
	exit(1);
}

if (argc == 2) {
	if ((fp = fopen(argv[1], "wb")) == NULL) {
		printf("Error opening file.\n");
		exit(1);
	}
}
else {
	if ((fp = fopen("game.dat", "wb")) == NULL) {
		printf("Error opening file.\n");
		exit(1);
	}
}



printf("\n\t\tGAME MEDIC\n");
printf("\t\t\tby The Silicon Valley Swappe Shoppe \n\n");

/* start code */
for (segment=0; segment < NUMSEGS; segment++) {
  outportb (DP, segment);
  loop(DELAY);
  outportb (CP, HA);
  loop(DELAY);
  outportb (CP, NOPA);
  loop(DELAY);

  for (page=0; page <= 255 ; page++) {
    outportb (DP, page);
    loop(DELAY);
    outportb (CP, MA);
    loop(DELAY);
    outportb(CP, NOPA);
    loop(DELAY);

    for (byte=0; byte <= 255 ; byte++) {
      outportb(DP, byte);
      loop(DELAY);
      outportb(CP, LA);
      loop(DELAY);
      outportb(CP, NOPA);
      loop(DELAY);

      tmp = inportb(IP);
      hi_nyb = (tmp ^ 0x80) & 0xf0;

      outportb(CP, LO_NYB);
      loop(DELAY);

      tmp= inport(IP);
      lo_nyb = (tmp ^ 0x80) & 0xf0;
      lo_nyb = lo_nyb >> 4;
      tmp=lo_nyb | hi_nyb;

      buffer[byte]=tmp;
      
      testhi = (total & 0x1ff00) >> 9;
      testlo = (total & 0x1ff) >> 1;
      if ((byte % 2) ==0) { /* upper byte */
	if (tmp !=testhi) 
	  printf("\007UPPER BYTE ERROR: Address %8x; got %2x, expected %2x\n", 
		  (unsigned long int) total, tmp, testhi);
	}
       else
	if (tmp !=testlo)
	  printf ("\007LOWER BYTE ERROR: Address %8x; got %2x, expected %2x\n",
		  (unsigned long int) total, tmp, testlo);

      total++;
      /*
      printf("%2x ", tmp);
      */
      }
    fwrite(buffer, sizeof(unsigned char), 256, fp);
    printf("Written %8ld bytes\r", total);
    /*
    printf("writing\n");
    */
    }
  }

fclose(fp);
}

void
loop(x)
int x;
{
int i;

for (i=0; i< x; i++);
}
