/* extra bytes constants */

#define P3_ExtBytesPtr             0   /* pointer to user data                           */
#define P3_ExtBytesOldEditProc     4   /* pointer to wnd proc for edit sub-classing      */
#define P3_ExtBytesOldButtonProc   8   /* pointer to wnd proc for button sub-classing    */
#define P3_ExtBytesOldListProc     12  /* pointer to wnd proc for list box sub-classing  */
#define P3_ExtBytesOldComboProc    16  /* pointer to wnd proc for combo box sub-classing */
#define P3_Phase3Reserved          20  /* used internally by Phase3                      */
#define P3_TotalExtBytes           22  /* total number of extra bytes                    */

/* Prototypes for all Window processes */

BOOL DriverTrips (HWND hOwner);
BOOL DriverList (HWND hOwner);
BOOL AddDriver (HWND hOwner);
BOOL MainWindow (HWND hOwner);

/************************************
Prototypes for all Dialog processes */


/************************************
Prototypes for all Report processes */


/* Prototypes for all Stub processes */



void Initialise (void);

void CleanUp (void);
#define idDriverTrips  1
#define idDriverTrips_TripsBox  2

/* Global window handles for "DriverTrips" */

HWND hWndDriverTrips,
     hWndDriverTrips_TripsBox;

/* Extra bytes structure for "DriverTrips" */

typedef struct tagDriverTripsStruct
   {
   HBRUSH P3_hBrushCtlColor;
   HWND hWndDriverTrips_TripsBox;
   HFONT hFontDriverTrips_TripsBox;
   } DriverTripsStruct;
typedef DriverTripsStruct FAR* LPDriverTripsStruct;

#define idDriverList  3
#define idDriverList_DriverBox  4
#define idDriverList_TEXT1  5
#define idDriverList_TEXT2  6
#define idDriverList_TEXT3  7
#define idDriverList_TEXT4  8
#define idDriverList_TEXT5  9
#define idDriverList_TEXT6  10
#define idDriverList_TEXT7  11
#define idDriverList_TEXT8  12

/* Global window handles for "DriverList" */

HWND hWndDriverList,
     hWndDriverList_DriverBox,
     hWndDriverList_TEXT1,
     hWndDriverList_TEXT2,
     hWndDriverList_TEXT3,
     hWndDriverList_TEXT4,
     hWndDriverList_TEXT5,
     hWndDriverList_TEXT6,
     hWndDriverList_TEXT7,
     hWndDriverList_TEXT8;

/* Extra bytes structure for "DriverList" */

typedef struct tagDriverListStruct
   {
   HBRUSH P3_hBrushCtlColor;
   HWND hWndDriverList_DriverBox;
   HWND hWndDriverList_TEXT1;
   HWND hWndDriverList_TEXT2;
   HWND hWndDriverList_TEXT3;
   HWND hWndDriverList_TEXT4;
   HWND hWndDriverList_TEXT5;
   HWND hWndDriverList_TEXT6;
   HWND hWndDriverList_TEXT7;
   HWND hWndDriverList_TEXT8;
   HFONT hFontDriverList_DriverBox;
   HFONT hFontDriverList_TEXT1;
   HFONT hFontDriverList_TEXT2;
   HFONT hFontDriverList_TEXT3;
   HFONT hFontDriverList_TEXT4;
   HFONT hFontDriverList_TEXT5;
   HFONT hFontDriverList_TEXT6;
   HFONT hFontDriverList_TEXT7;
   HFONT hFontDriverList_TEXT8;
HTABLE hTable;
   } DriverListStruct;
typedef DriverListStruct FAR* LPDriverListStruct;

#define idAddDriver  13
#define idAddDriver_TEXT1  14
#define idAddDriver_DEDriverld  15
#define idAddDriver_TEXT2  16
#define idAddDriver_DESurname  17
#define idAddDriver_TEXT3  18
#define idAddDriver_DESalary  19
#define idAddDriver_TEXT4  20
#define idAddDriver_DEBirth  21
#define idAddDriver_AddButton  22
#define idAddDriver_CloseButton  23

/* Global window handles for "AddDriver" */

HWND hWndAddDriver,
     hWndAddDriver_TEXT1,
     hWndAddDriver_DEDriverld,
     hWndAddDriver_TEXT2,
     hWndAddDriver_DESurname,
     hWndAddDriver_TEXT3,
     hWndAddDriver_DESalary,
     hWndAddDriver_TEXT4,
     hWndAddDriver_DEBirth,
     hWndAddDriver_AddButton,
     hWndAddDriver_CloseButton;

/* Extra bytes structure for "AddDriver" */

typedef struct tagAddDriverStruct
   {
   HBRUSH P3_hBrushCtlColor;
   HWND hWndAddDriver_TEXT1;
   HWND hWndAddDriver_DEDriverld;
   HWND hWndAddDriver_TEXT2;
   HWND hWndAddDriver_DESurname;
   HWND hWndAddDriver_TEXT3;
   HWND hWndAddDriver_DESalary;
   HWND hWndAddDriver_TEXT4;
   HWND hWndAddDriver_DEBirth;
   HWND hWndAddDriver_AddButton;
   HWND hWndAddDriver_CloseButton;
   HFONT hFontAddDriver_TEXT1;
   HFONT hFontAddDriver_DEDriverld;
   HFONT hFontAddDriver_TEXT2;
   HFONT hFontAddDriver_DESurname;
   HFONT hFontAddDriver_TEXT3;
   HFONT hFontAddDriver_DESalary;
   HFONT hFontAddDriver_TEXT4;
   HFONT hFontAddDriver_DEBirth;
   HFONT hFontAddDriver_AddButton;
   HFONT hFontAddDriver_CloseButton;
HTABLE hTable;
   } AddDriverStruct;
typedef AddDriverStruct FAR* LPAddDriverStruct;

#define idMainWindow  24

/* Global window handles for "MainWindow" */

HWND hWndMainWindow;

/* Extra bytes structure for "MainWindow" */

typedef struct tagMainWindowStruct
   {
   HBRUSH P3_hBrushCtlColor;
   } MainWindowStruct;
typedef MainWindowStruct FAR* LPMainWindowStruct;


int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpCmdLine,
                    int    nCmdShow);
/* User-created global declarations */

#include "DTV.dcl"
