#include <windows.h>     /* required for all Windows applications */
#include "DBProcs.h"     /* Phase3 database */
#include "RPProcs.h"     /* Phase3 reports */
#include "DTV.h"    /* required for this application */
#include "string.h"      /* Compiler include file */

HANDLE hInst;            /* current instance of this application */
int    nShowMain;        /* SW constant for showing main window */
LPSTR  lpCommandLine;    /* command-line parameters */


/*========================================================================
 *
 *  Program generated by Phase3 :- 
 *
 *      Date : Tuesday, November 16, 1993
 *
 *      Time : 10:02pm
 *
 *======================================================================*/


#include "P3Procs.h"   /* Phase3 "P3_" DLL routines */
#include "P3User.h"    /* Phase3 routines as source in P3User.C */

BOOL P3_RegisterWindows (void);  

/*=-----------------------------do-not-remove-this-line-=*/
void Initialise (void)
/*=-----------------------------do-not-remove-this-line-=*/

/* 
   Perform any initialisation your application may require.
*/
   {
    hSession = DB_Init ("Test", P3SESSION_SINGLEUSER ) ;
   if (!hSession)
   {
   PostQuitMessage(0);  /* terminate the application */
   return;
   };
   
    DB_SetDefaultDateFormat (hSession, "dd Mmm YYYY" ) ;
   if (!DB_LoadCatalog (hSession, "DTV", "d:\\Phase3\\DTV.SC"))
        return;
   
   if (!DB_OpenCatalog (hSession, "DTV"))
       return;
   }



/*=-----------------------------do-not-remove-this-line-=*/
void CleanUp (void)
/*=-----------------------------do-not-remove-this-line-=*/

/*
   Perform any finalisation your application may require. 
*/
   {
    DB_Exit (hSession ) ;
   }



/*=-----------------------------------------------------=*/
BOOL CreateObjects_DriverTrips (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
   Create all objects on this window.
*/
   {
   HGLOBAL P3_hMem;
   int     P3_nWidth,
           P3_nHeight,
           P3_nRetCode;
   LPDriverTripsStruct EBPtr;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPDriverTripsStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("DriverTrips", "Invalid extra bytes pointer.");
      return FALSE;
      }  

   EBPtr->hWndDriverTrips_TripsBox = CreateWindow (
                          "LISTBOX",
                          "",
                          WS_CHILD | LBS_NOTIFY | LBS_SORT | 
                                   LBS_USETABSTOPS | LBS_NOINTEGRALHEIGHT | 
                                   WS_VSCROLL | WS_VISIBLE,
                          0, 0, 400, 200,
                          hWindow,
                          idDriverTrips_TripsBox,
                          hInst,
                          NULL);
   if (!EBPtr->hWndDriverTrips_TripsBox)
      {
      LongWarning ("DriverTrips_TripsBox", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontDriverTrips_TripsBox = P3_GetFont (16, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "System");
   if (!EBPtr->hFontDriverTrips_TripsBox)
      {
      LongWarning ("DriverTrips_TripsBox", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndDriverTrips_TripsBox, WM_SETFONT,
                EBPtr->hFontDriverTrips_TripsBox, 0);

   GlobalUnlock (P3_hMem);
   return TRUE;
   }


/*=-----------------------------------------------------=*/
void UpdateHandles_DriverTrips (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
 *  Store all object handles for this window in global variables.
 */
   {
   HGLOBAL P3_hMem;
   LPDriverTripsStruct EBPtr;

   hWndDriverTrips = hWindow;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPDriverTripsStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("DriverTrips", "Invalid extra bytes pointer.");
      return;
      }  

   hWndDriverTrips_TripsBox = EBPtr->hWndDriverTrips_TripsBox;

   GlobalUnlock (P3_hMem);
   }

     
/*=-----------------------------------------------------=*/
long WINAPI WndProc_DriverTrips
   (HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
/*=-----------------------------------------------------=*/
/*
 *  Processes messages for the window.
 */
   {
      /* Phase3-generated declarations */
   HDC         dc;
   PAINTSTRUCT ps;
   HBRUSH      P3_hBrush;
   LPDriverTripsStruct EBPtr;
   HGLOBAL     P3_hMem;
   HFONT       P3_hFont;
   HPEN        P3_hPen;
   RECT        P3_rtText;  
   LONG        P3_lHandle;

      /* Your declarations */   
char	szQuery[100];
char	szDriverId[100];
HANDLE	hTable;


   switch (message)
      {
      case WM_CREATE :
         P3_CreateAutoTabs (hWindow, P3_Phase3Reserved);

         if ((P3_hMem = GlobalAlloc (GHND, sizeof (DriverTripsStruct))) == NULL)
            {
            LongWarning ("DriverTrips", "Out of memory.");
            return 0;
            }
         SetWindowWord (hWindow, P3_ExtBytesPtr, P3_hMem);  

         if ((EBPtr = (LPDriverTripsStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("DriverTrips", "Global lock error.");
            return 0;
            }

            /* Initialise brush handle for controls */
         EBPtr->P3_hBrushCtlColor = 0;

         if (!CreateObjects_DriverTrips(hWindow))
            {
            LongWarning ("DriverTrips", "Out of memory.");
            return 0;
            }
         UpdateHandles_DriverTrips (hWindow);  


/****** Begin user-created code ******/

if(! DB_GetLBItem (hWndDriverList_DriverBox,
         P3_CURRENTROW, 0, szDriverId ) )
   return 0;
   
strcpy(szQuery, "Driver NJOIN Trip RESTRICT (DriverId = ^");
strcat(szQuery, szDriverId);
strcat(szQuery, "^) PROJECT (Destination, TripDate)");

if(! DB_CreateDerivedTable (hSession, "DTV",
         "DriverTrips", szQuery ) )
    return 0; 
   
 hTable = DB_OpenTable (hSession, "DriverTrips" ) ;

if(hTable)
 DB_TableToListBox (hSession, hTable,
       hWndDriverTrips_TripsBox, "", TRUE ) ;
       
 DB_DropTable (hSession, "Driver Trips" ) ;
            

/******* End user-created code *******/

         GlobalUnlock (P3_hMem);  

         return 0;

      case WM_SETFOCUS :
         UpdateHandles_DriverTrips (hWindow);  
         return 0;  

      case WM_CTLCOLOR :
            /* Paint background of buttons with screen color */
         if (HIWORD (lParam) == CTLCOLOR_BTN)
            {
            P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
            if ((EBPtr = (LPDriverTripsStruct) GlobalLock (P3_hMem)) == NULL)
               {
               LongWarning ("DriverTrips", "Global lock error.");
               return 0;
               }
            if (EBPtr->P3_hBrushCtlColor)
               {
               SetBkMode ((HDC) wParam, TRANSPARENT);
               SetTextColor ((HDC) wParam, GetSysColor (COLOR_WINDOWTEXT));
               GlobalUnlock (P3_hMem);
               return (LONG) EBPtr->P3_hBrushCtlColor;
               }
            GlobalUnlock (P3_hMem);
            }
         break;

      case WM_PAINT :  /* window being painted */
         P3_hFont = 0;

         /* Get a pointer to the extra-bytes */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPDriverTripsStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("DriverTrips", "Global lock error.");
            return 0;
            }

         dc = BeginPaint (hWindow, &ps);
         if (!dc)
            {
            LongWarning ("DriverTrips", "Cannot get a device context.");
            return 0;
            }

         if (P3_hFont != 0)
            DeleteObject (P3_hFont);

         GlobalUnlock (P3_hMem);
         EndPaint (hWindow, &ps);
         return 0;

      case WM_COMMAND :

         break;  

      
      case WM_DESTROY:            /* message: window being destroyed */
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPDriverTripsStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("DriverTrips", "Global lock error.");
            return 0;
            }   

            /* Delete brush for painting background for controls */
         if (EBPtr->P3_hBrushCtlColor)
            DeleteObject (EBPtr->P3_hBrushCtlColor);
         DeleteObject (EBPtr->hFontDriverTrips_TripsBox);
         GlobalUnlock (P3_hMem);
         GlobalFree (P3_hMem);
         P3_DestroyAutoTabs (hWindow);
         return 0;
      }
   return (DefWindowProc(hWindow, message, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL DriverTrips (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
 *  Creates and displays the window.
 */
   {
   HWND hWnd;   

   hWnd = CreateWindow(
      "DriverTrips Class",
      "Driver Trips",   
      WS_OVERLAPPEDWINDOW | WS_VISIBLE,
      CW_USEDEFAULT,     
      CW_USEDEFAULT,
      400,  
      200,  
      hOwner,                        
      NULL,   
      hInst,  
      NULL    
      );

   /* If window could not be created, return "failure" */

   if (!hWnd)
      {
      LongWarning ("DriverTrips", "Could not create window.");
      return (FALSE);
      }

   /* Make the window visible; update its client area; and return "success" */

   UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
   return (TRUE);               /* Returns the value from PostQuitMessage */

   }   

/*=-----------------------------------------------------=*/
BOOL CreateObjects_DriverList (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
   Create all objects on this window.
*/
   {
   HGLOBAL P3_hMem;
   int     P3_nWidth,
           P3_nHeight,
           P3_nRetCode;
   LPDriverListStruct EBPtr;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPDriverListStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("DriverList", "Invalid extra bytes pointer.");
      return FALSE;
      }  

   EBPtr->hWndDriverList_DriverBox = CreateWindow (
                          "LISTBOX",
                          "",
                          WS_CHILD | LBS_NOTIFY | LBS_SORT | 
                                   LBS_USETABSTOPS | LBS_NOINTEGRALHEIGHT | 
                                   WS_VSCROLL | WS_VISIBLE,
                          0, 0, 517, 224,
                          hWindow,
                          idDriverList_DriverBox,
                          hInst,
                          NULL);
   if (!EBPtr->hWndDriverList_DriverBox)
      {
      LongWarning ("DriverList_DriverBox", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontDriverList_DriverBox = P3_GetFont (-16, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "System");
   if (!EBPtr->hFontDriverList_DriverBox)
      {
      LongWarning ("DriverList_DriverBox", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndDriverList_DriverBox, WM_SETFONT,
                EBPtr->hFontDriverList_DriverBox, 0);

   GlobalUnlock (P3_hMem);
   return TRUE;
   }


/*=-----------------------------------------------------=*/
void UpdateHandles_DriverList (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
 *  Store all object handles for this window in global variables.
 */
   {
   HGLOBAL P3_hMem;
   LPDriverListStruct EBPtr;

   hWndDriverList = hWindow;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPDriverListStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("DriverList", "Invalid extra bytes pointer.");
      return;
      }  

   hWndDriverList_DriverBox = EBPtr->hWndDriverList_DriverBox;

   GlobalUnlock (P3_hMem);
   }

     
/*=-----------------------------------------------------=*/
long WINAPI WndProc_DriverList
   (HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
/*=-----------------------------------------------------=*/
/*
 *  Processes messages for the window.
 */
   {
      /* Phase3-generated declarations */
   HDC         dc;
   PAINTSTRUCT ps;
   HBRUSH      P3_hBrush;
   LPDriverListStruct EBPtr;
   HGLOBAL     P3_hMem;
   HFONT       P3_hFont;
   HPEN        P3_hPen;
   RECT        P3_rtText;  
   LONG        P3_lHandle;

      /* Your declarations */   
RECT rect;


   switch (message)
      {
      case WM_CREATE :
         P3_CreateAutoTabs (hWindow, P3_Phase3Reserved);

         if ((P3_hMem = GlobalAlloc (GHND, sizeof (DriverListStruct))) == NULL)
            {
            LongWarning ("DriverList", "Out of memory.");
            return 0;
            }
         SetWindowWord (hWindow, P3_ExtBytesPtr, P3_hMem);  

         if ((EBPtr = (LPDriverListStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("DriverList", "Global lock error.");
            return 0;
            }

            /* Initialise brush handle for controls */
         EBPtr->P3_hBrushCtlColor = 0;

         if (!CreateObjects_DriverList(hWindow))
            {
            LongWarning ("DriverList", "Out of memory.");
            return 0;
            }
         UpdateHandles_DriverList (hWindow);  


/****** Begin user-created code ******/

 EBPtr->hTable = DB_OpenTable (hSession, "Driver" ) ;
if(!EBPtr->hTable)
    return 0;
     DB_TableToListBox (hSession, EBPtr->hTable, hWndDriverList_DriverBox, "", TRUE ) ;
     DB_CloseTable (hSession, EBPtr->hTable ) ;

/******* End user-created code *******/

         GlobalUnlock (P3_hMem);  

         return 0;

      case WM_SETFOCUS :
         UpdateHandles_DriverList (hWindow);  
         return 0;  

      case WM_CTLCOLOR :
            /* Paint background of buttons with screen color */
         if (HIWORD (lParam) == CTLCOLOR_BTN)
            {
            P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
            if ((EBPtr = (LPDriverListStruct) GlobalLock (P3_hMem)) == NULL)
               {
               LongWarning ("DriverList", "Global lock error.");
               return 0;
               }
            if (EBPtr->P3_hBrushCtlColor)
               {
               SetBkMode ((HDC) wParam, TRANSPARENT);
               SetTextColor ((HDC) wParam, GetSysColor (COLOR_WINDOWTEXT));
               GlobalUnlock (P3_hMem);
               return (LONG) EBPtr->P3_hBrushCtlColor;
               }
            GlobalUnlock (P3_hMem);
            }
         break;

      case WM_PAINT :  /* window being painted */
         P3_hFont = 0;

         /* Get a pointer to the extra-bytes */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPDriverListStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("DriverList", "Global lock error.");
            return 0;
            }

         dc = BeginPaint (hWindow, &ps);
         if (!dc)
            {
            LongWarning ("DriverList", "Cannot get a device context.");
            return 0;
            }

            /* Paint static text on the screen */
         if (P3_hFont != 0)
            DeleteObject (P3_hFont);
         P3_hFont = P3_GetFont (16, 700, 0, 0, 0, 0, 1, 2, 
                                FF_SWISS + VARIABLE_PITCH, "System");
         SelectObject (dc, P3_hFont);
         SetTextColor (dc, RGB (170, 130, 125));
         SetBkColor (dc, RGB (215, 225, 251));
         SetBkMode (dc, OPAQUE);
         SetRect (&P3_rtText, 0, 0, 19, 27);
         DrawText (dc, "Id", 2,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 70, 0, 137, 29);
         DrawText (dc, "Surname:", 8,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 290, 0, 388, 34);
         DrawText (dc, "Salary:", 7,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 420, 0, 501, 34);
         DrawText (dc, "Birth:", 6,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (54, 89, 125));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 0, 0, 15, 18);
         DrawText (dc, "Id", 2,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (54, 89, 125));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 70, 0, 137, 20);
         DrawText (dc, "Surname:", 8,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (54, 89, 125));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 290, 0, 340, 19);
         DrawText (dc, "Salary:", 7,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (54, 89, 125));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 420, 0, 459, 18);
         DrawText (dc, "Birth:", 6,
                   &P3_rtText, 16);

         if (P3_hFont != 0)
            DeleteObject (P3_hFont);

         GlobalUnlock (P3_hMem);
         EndPaint (hWindow, &ps);
         return 0;

      case WM_SIZE :
         /* There is some user code, so get the extra-bytes pointer */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPDriverListStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("DriverList", "Global lock error.");
            return 0;
            }

/****** Begin user-created code ******/

 GetClientRect (hWndDriverList, &rect ) ;
 MoveWindow (hWndDriverList_DriverBox, rect.left, rect.top + 20, rect.right, rect.bottom - 20, TRUE ) ;

/******* End user-created code *******/

         GlobalUnlock (P3_hMem);
         return 0;

      case WM_COMMAND :
         switch (wParam)
            {
            case idDriverList_DriverBox :
               switch (HIWORD(lParam))
                  {
                  case LBN_DBLCLK :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPDriverListStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("DriverList", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
DriverTrips (0) ;
/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
               break; 

            } /* wParam */


         break;  

      
      case WM_DESTROY:            /* message: window being destroyed */
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPDriverListStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("DriverList", "Global lock error.");
            return 0;
            }   

            /* Delete brush for painting background for controls */
         if (EBPtr->P3_hBrushCtlColor)
            DeleteObject (EBPtr->P3_hBrushCtlColor);
         DeleteObject (EBPtr->hFontDriverList_DriverBox);
         GlobalUnlock (P3_hMem);
         GlobalFree (P3_hMem);
         P3_DestroyAutoTabs (hWindow);
         return 0;
      }
   return (DefWindowProc(hWindow, message, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL DriverList (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
 *  Creates and displays the window.
 */
   {
   HWND hWnd;   

   hWnd = CreateWindow(
      "DriverList Class",
      "Driver List",   
      WS_OVERLAPPEDWINDOW | WS_VISIBLE,
      CW_USEDEFAULT,     
      CW_USEDEFAULT,
      CW_USEDEFAULT,  
      CW_USEDEFAULT,  
      hOwner,                        
      NULL,   
      hInst,  
      NULL    
      );

   /* If window could not be created, return "failure" */

   if (!hWnd)
      {
      LongWarning ("DriverList", "Could not create window.");
      return (FALSE);
      }

   /* Make the window visible; update its client area; and return "success" */

   UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
   return (TRUE);               /* Returns the value from PostQuitMessage */

   }   

/*=-----------------------------------------------------=*/
BOOL CreateObjects_AddDriver (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
   Create all objects on this window.
*/
   {
   HGLOBAL P3_hMem;
   int     P3_nWidth,
           P3_nHeight,
           P3_nRetCode;
   LPAddDriverStruct EBPtr;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPAddDriverStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("AddDriver", "Invalid extra bytes pointer.");
      return FALSE;
      }  

   EBPtr->hWndAddDriver_DEDriverld = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | WS_BORDER | ES_LEFT | WS_VISIBLE,
                          72, 3, 91, 23,
                          hWindow,
                          idAddDriver_DEDriverld,
                          hInst,
                          NULL);
   if (!EBPtr->hWndAddDriver_DEDriverld)
      {
      LongWarning ("AddDriver_DEDriverld", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontAddDriver_DEDriverld = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "MS Sans Serif");
   if (!EBPtr->hFontAddDriver_DEDriverld)
      {
      LongWarning ("AddDriver_DEDriverld", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndAddDriver_DEDriverld, WM_SETFONT,
                EBPtr->hFontAddDriver_DEDriverld, 0);

   EBPtr->hWndAddDriver_DESurname = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | WS_BORDER | ES_AUTOHSCROLL | 
                                   WS_VISIBLE,
                          72, 33, 166, 23,
                          hWindow,
                          idAddDriver_DESurname,
                          hInst,
                          NULL);
   if (!EBPtr->hWndAddDriver_DESurname)
      {
      LongWarning ("AddDriver_DESurname", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontAddDriver_DESurname = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "MS Sans Serif");
   if (!EBPtr->hFontAddDriver_DESurname)
      {
      LongWarning ("AddDriver_DESurname", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndAddDriver_DESurname, WM_SETFONT,
                EBPtr->hFontAddDriver_DESurname, 0);

   EBPtr->hWndAddDriver_DESalary = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | WS_BORDER | ES_LEFT | WS_VISIBLE,
                          72, 63, 166, 23,
                          hWindow,
                          idAddDriver_DESalary,
                          hInst,
                          NULL);
   if (!EBPtr->hWndAddDriver_DESalary)
      {
      LongWarning ("AddDriver_DESalary", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontAddDriver_DESalary = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "MS Sans Serif");
   if (!EBPtr->hFontAddDriver_DESalary)
      {
      LongWarning ("AddDriver_DESalary", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndAddDriver_DESalary, WM_SETFONT,
                EBPtr->hFontAddDriver_DESalary, 0);

   EBPtr->hWndAddDriver_DEBirth = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | WS_BORDER | ES_LEFT | WS_VISIBLE,
                          72, 93, 136, 23,
                          hWindow,
                          idAddDriver_DEBirth,
                          hInst,
                          NULL);
   if (!EBPtr->hWndAddDriver_DEBirth)
      {
      LongWarning ("AddDriver_DEBirth", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontAddDriver_DEBirth = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "MS Sans Serif");
   if (!EBPtr->hFontAddDriver_DEBirth)
      {
      LongWarning ("AddDriver_DEBirth", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndAddDriver_DEBirth, WM_SETFONT,
                EBPtr->hFontAddDriver_DEBirth, 0);

   EBPtr->hWndAddDriver_AddButton = CreateWindow (
                          "BUTTON",
                          "Add",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          265, 4, 86, 26,
                          hWindow,
                          idAddDriver_AddButton,
                          hInst,
                          NULL);
   if (!EBPtr->hWndAddDriver_AddButton)
      {
      LongWarning ("AddDriver_AddButton", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontAddDriver_AddButton = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "MS Sans Serif");
   if (!EBPtr->hFontAddDriver_AddButton)
      {
      LongWarning ("AddDriver_AddButton", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndAddDriver_AddButton, WM_SETFONT,
                EBPtr->hFontAddDriver_AddButton, 0);

   EBPtr->hWndAddDriver_CloseButton = CreateWindow (
                          "BUTTON",
                          "Close",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          265, 43, 86, 26,
                          hWindow,
                          idAddDriver_CloseButton,
                          hInst,
                          NULL);
   if (!EBPtr->hWndAddDriver_CloseButton)
      {
      LongWarning ("AddDriver_CloseButton", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontAddDriver_CloseButton = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "MS Sans Serif");
   if (!EBPtr->hFontAddDriver_CloseButton)
      {
      LongWarning ("AddDriver_CloseButton", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndAddDriver_CloseButton, WM_SETFONT,
                EBPtr->hFontAddDriver_CloseButton, 0);

   GlobalUnlock (P3_hMem);
   return TRUE;
   }


/*=-----------------------------------------------------=*/
void UpdateHandles_AddDriver (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
 *  Store all object handles for this window in global variables.
 */
   {
   HGLOBAL P3_hMem;
   LPAddDriverStruct EBPtr;

   hWndAddDriver = hWindow;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPAddDriverStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("AddDriver", "Invalid extra bytes pointer.");
      return;
      }  

   hWndAddDriver_DEDriverld = EBPtr->hWndAddDriver_DEDriverld;
   hWndAddDriver_DESurname = EBPtr->hWndAddDriver_DESurname;
   hWndAddDriver_DESalary = EBPtr->hWndAddDriver_DESalary;
   hWndAddDriver_DEBirth = EBPtr->hWndAddDriver_DEBirth;
   hWndAddDriver_AddButton = EBPtr->hWndAddDriver_AddButton;
   hWndAddDriver_CloseButton = EBPtr->hWndAddDriver_CloseButton;

   GlobalUnlock (P3_hMem);
   }

     
/*=-----------------------------------------------------=*/
long WINAPI WndProc_AddDriver
   (HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
/*=-----------------------------------------------------=*/
/*
 *  Processes messages for the window.
 */
   {
      /* Phase3-generated declarations */
   HDC         dc;
   PAINTSTRUCT ps;
   HBRUSH      P3_hBrush;
   LPAddDriverStruct EBPtr;
   HGLOBAL     P3_hMem;
   HFONT       P3_hFont;
   HPEN        P3_hPen;
   RECT        P3_rtText;  
   LONG        P3_lHandle;


   switch (message)
      {
      case WM_CREATE :
         P3_CreateAutoTabs (hWindow, P3_Phase3Reserved);

         if ((P3_hMem = GlobalAlloc (GHND, sizeof (AddDriverStruct))) == NULL)
            {
            LongWarning ("AddDriver", "Out of memory.");
            return 0;
            }
         SetWindowWord (hWindow, P3_ExtBytesPtr, P3_hMem);  

         if ((EBPtr = (LPAddDriverStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("AddDriver", "Global lock error.");
            return 0;
            }

            /* Initialise brush handle for controls */
         EBPtr->P3_hBrushCtlColor = 0;

         if (!CreateObjects_AddDriver(hWindow))
            {
            LongWarning ("AddDriver", "Out of memory.");
            return 0;
            }
         UpdateHandles_AddDriver (hWindow);  


/****** Begin user-created code ******/

EBPtr->hTable = DB_OpenTable (hSession, "Driver" );
if(!EBPtr->hTable)
    {
    P3_WinClose(hWndAddDriver);
    return 0;
    };
    
if(!DB_EditAttach(hSession, EBPtr->hTable, "DriverId",
    hWndAddDriver_DEDriverld))
    return 0;
 
if(!DB_EditAttach(hSession, EBPtr->hTable, "Surname",
    hWndAddDriver_DESurname))
    return 0;
  
if(!DB_EditAttach(hSession, EBPtr->hTable, "Salary",
    hWndAddDriver_DESalary))
    return 0;
    
if(!DB_EditAttach(hSession, EBPtr->hTable, "Birth",
    hWndAddDriver_DEBirth))
    return 0;
    


/******* End user-created code *******/

         GlobalUnlock (P3_hMem);  

         return 0;

      case WM_SETFOCUS :
         UpdateHandles_AddDriver (hWindow);  
         return 0;  

      case WM_CTLCOLOR :
            /* Paint background of buttons with screen color */
         if (HIWORD (lParam) == CTLCOLOR_BTN)
            {
            P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
            if ((EBPtr = (LPAddDriverStruct) GlobalLock (P3_hMem)) == NULL)
               {
               LongWarning ("AddDriver", "Global lock error.");
               return 0;
               }
            if (EBPtr->P3_hBrushCtlColor)
               {
               SetBkMode ((HDC) wParam, TRANSPARENT);
               SetTextColor ((HDC) wParam, GetSysColor (COLOR_WINDOWTEXT));
               GlobalUnlock (P3_hMem);
               return (LONG) EBPtr->P3_hBrushCtlColor;
               }
            GlobalUnlock (P3_hMem);
            }
         break;

      case WM_PAINT :  /* window being painted */
         P3_hFont = 0;

         /* Get a pointer to the extra-bytes */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPAddDriverStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("AddDriver", "Global lock error.");
            return 0;
            }

         dc = BeginPaint (hWindow, &ps);
         if (!dc)
            {
            LongWarning ("AddDriver", "Cannot get a device context.");
            return 0;
            }

            /* Paint static text on the screen */
         if (P3_hFont != 0)
            DeleteObject (P3_hFont);
         P3_hFont = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                FF_SWISS + VARIABLE_PITCH, "MS Sans Serif");
         SelectObject (dc, P3_hFont);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 5, 7, 68, 27);
         DrawText (dc, "Driverld", 8,
                   &P3_rtText, 32);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 5, 37, 68, 57);
         DrawText (dc, "Surname", 7,
                   &P3_rtText, 32);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 5, 67, 68, 87);
         DrawText (dc, "Salary", 6,
                   &P3_rtText, 32);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 5, 97, 68, 117);
         DrawText (dc, "Birth", 5,
                   &P3_rtText, 32);

         if (P3_hFont != 0)
            DeleteObject (P3_hFont);

         GlobalUnlock (P3_hMem);
         EndPaint (hWindow, &ps);
         return 0;

      case WM_COMMAND :
         switch (wParam)
            {
            case idAddDriver_AddButton :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPAddDriverStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("AddDriver", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
 DB_EditsAddToTable (hSession, EBPtr->hTable ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idAddDriver_CloseButton :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPAddDriverStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("AddDriver", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
 P3_WinClose (hWndAddDriver ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
               break; 

            } /* wParam */


         break;  

      
      case WM_DESTROY:            /* message: window being destroyed */
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPAddDriverStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("AddDriver", "Global lock error.");
            return 0;
            }   

/****** Begin user-created code ******/
 DB_CloseTable (hSession, EBPtr->hTable ) ;

/******* End user-created code *******/


            /* Delete brush for painting background for controls */
         if (EBPtr->P3_hBrushCtlColor)
            DeleteObject (EBPtr->P3_hBrushCtlColor);
         DeleteObject (EBPtr->hFontAddDriver_DEDriverld);
         DeleteObject (EBPtr->hFontAddDriver_DESurname);
         DeleteObject (EBPtr->hFontAddDriver_DESalary);
         DeleteObject (EBPtr->hFontAddDriver_DEBirth);
         DeleteObject (EBPtr->hFontAddDriver_AddButton);
         DeleteObject (EBPtr->hFontAddDriver_CloseButton);
         GlobalUnlock (P3_hMem);
         GlobalFree (P3_hMem);
         P3_DestroyAutoTabs (hWindow);
         return 0;
      }
   return (DefWindowProc(hWindow, message, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL AddDriver (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
 *  Creates and displays the window.
 */
   {
   HWND hWnd;   

   hWnd = CreateWindow(
      "AddDriver Class",
      "Add Driver",   
      WS_OVERLAPPEDWINDOW | WS_VISIBLE,
      CW_USEDEFAULT,     
      CW_USEDEFAULT,
      CW_USEDEFAULT,  
      CW_USEDEFAULT,  
      hOwner,                        
      NULL,   
      hInst,  
      NULL    
      );

   /* If window could not be created, return "failure" */

   if (!hWnd)
      {
      LongWarning ("AddDriver", "Could not create window.");
      return (FALSE);
      }

   /* Make the window visible; update its client area; and return "success" */

   UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
   return (TRUE);               /* Returns the value from PostQuitMessage */

   }   

/*=-----------------------------------------------------=*/
BOOL CreateObjects_MainWindow (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
   Create all objects on this window.
*/
   {
   HGLOBAL P3_hMem;
   int     P3_nWidth,
           P3_nHeight,
           P3_nRetCode;
   LPMainWindowStruct EBPtr;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("MainWindow", "Invalid extra bytes pointer.");
      return FALSE;
      }  

   GlobalUnlock (P3_hMem);
   return TRUE;
   }


/*=-----------------------------------------------------=*/
void UpdateHandles_MainWindow (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
 *  Store all object handles for this window in global variables.
 */
   {
   HGLOBAL P3_hMem;
   LPMainWindowStruct EBPtr;

   hWndMainWindow = hWindow;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("MainWindow", "Invalid extra bytes pointer.");
      return;
      }  


   GlobalUnlock (P3_hMem);
   }

     
/*=-----------------------------------------------------=*/
long WINAPI WndProc_MainWindow
   (HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
/*=-----------------------------------------------------=*/
/*
 *  Processes messages for the window.
 */
   {
      /* Phase3-generated declarations */
   HDC         dc;
   PAINTSTRUCT ps;
   HBRUSH      P3_hBrush;
   LPMainWindowStruct EBPtr;
   HGLOBAL     P3_hMem;
   HFONT       P3_hFont;
   HPEN        P3_hPen;
   RECT        P3_rtText;  
   LONG        P3_lHandle;


   switch (message)
      {
      case WM_CREATE :
         P3_CreateAutoTabs (hWindow, P3_Phase3Reserved);

         if ((P3_hMem = GlobalAlloc (GHND, sizeof (MainWindowStruct))) == NULL)
            {
            LongWarning ("MainWindow", "Out of memory.");
            return 0;
            }
         SetWindowWord (hWindow, P3_ExtBytesPtr, P3_hMem);  

         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

            /* Initialise brush handle for controls */
         EBPtr->P3_hBrushCtlColor = 0;

            /* Set window background color */
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                           CreateSolidBrush (RGB (206, 246, 228)));  

            /* Create brush for painting background for controls */
         EBPtr->P3_hBrushCtlColor = CreateSolidBrush (RGB (206, 246, 228));

         if (!CreateObjects_MainWindow(hWindow))
            {
            LongWarning ("MainWindow", "Out of memory.");
            return 0;
            }
         UpdateHandles_MainWindow (hWindow);  

         return 0;

      case WM_SETFOCUS :
         UpdateHandles_MainWindow (hWindow);  
         return 0;  

      case WM_CTLCOLOR :
            /* Paint background of buttons with screen color */
         if (HIWORD (lParam) == CTLCOLOR_BTN)
            {
            P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
            if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
               {
               LongWarning ("MainWindow", "Global lock error.");
               return 0;
               }
            if (EBPtr->P3_hBrushCtlColor)
               {
               SetBkMode ((HDC) wParam, TRANSPARENT);
               SetTextColor ((HDC) wParam, GetSysColor (COLOR_WINDOWTEXT));
               GlobalUnlock (P3_hMem);
               return (LONG) EBPtr->P3_hBrushCtlColor;
               }
            GlobalUnlock (P3_hMem);
            }
         break;

      case WM_PAINT :  /* window being painted */
         P3_hFont = 0;

         /* Get a pointer to the extra-bytes */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

         dc = BeginPaint (hWindow, &ps);
         if (!dc)
            {
            LongWarning ("MainWindow", "Cannot get a device context.");
            return 0;
            }

         if (P3_hFont != 0)
            DeleteObject (P3_hFont);

         GlobalUnlock (P3_hMem);
         EndPaint (hWindow, &ps);
         return 0;

      case WM_COMMAND :
         switch (wParam)
            {
            case 101 /* Driver &List*/ :
               P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
               if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                  {
                  LongWarning ("MainWindow", "Global lock error.");
                  return 0;
                  }
/****** Begin user-created code ******/
DriverList (0) ;
/******* End user-created code *******/

               GlobalUnlock (P3_hMem);
               return 0;  

            case 103 /* &Add Driver*/ :
               P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
               if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                  {
                  LongWarning ("", "Global lock error.");
                  return 0;
                  }
/****** Begin user-created code ******/
AddDriver (0) ;
/******* End user-created code *******/

               GlobalUnlock (P3_hMem);
               return 0;  

            case 106 /* E&xit*/ :
               P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
               if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                  {
                  LongWarning ("", "Global lock error.");
                  return 0;
                  }
/****** Begin user-created code ******/
 P3_WinClose (hWndMainWindow ) ;
/******* End user-created code *******/

               GlobalUnlock (P3_hMem);
               return 0;  

            } /* wParam */ 


         break;  

      case WM_CLOSE:            /* message: window being closed */ 
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

/****** Begin user-created code ******/
CleanUp () ;

/******* End user-created code *******/

         GlobalUnlock (P3_hMem);
         break;  
      
      case WM_DESTROY:            /* message: window being destroyed */
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }   

/****** Begin user-created code ******/
PostQuitMessage(0);

/******* End user-created code *******/


            /* Delete brush for painting background for controls */
         if (EBPtr->P3_hBrushCtlColor)
            DeleteObject (EBPtr->P3_hBrushCtlColor);
         GlobalUnlock (P3_hMem);
         GlobalFree (P3_hMem);
         P3_DestroyAutoTabs (hWindow);
         return 0;
      }
   return (DefWindowProc(hWindow, message, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL MainWindow (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
 *  Creates and displays the window.
 */
   {
   HWND hWnd;   

   hWnd = CreateWindow(
      "MainWindow Class",
      "DTV System",   
      WS_OVERLAPPEDWINDOW | WS_VISIBLE,
      CW_USEDEFAULT,     
      CW_USEDEFAULT,
      CW_USEDEFAULT,  
      CW_USEDEFAULT,  
      hOwner,                        
      NULL,   
      hInst,  
      NULL    
      );

   /* If window could not be created, return "failure" */

   if (!hWnd)
      {
      LongWarning ("MainWindow", "Could not create window.");
      return (FALSE);
      }

   /* Make the window visible; update its client area; and return "success" */

   UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
   return (TRUE);               /* Returns the value from PostQuitMessage */

   }   

/*=-----------------------------do-not-remove-this-line-=*/
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpCmdLine,
                    int    nCmdShow)
/*=-----------------------------do-not-remove-this-line-=*/

/*
   WinMain Procedure
   =================
 
   This procedure is the main windows procedure and is used to register,
   create and show the window, and wait for windows messages.
*/
 
   {
   MSG msg;  /* message */

   hInst = hInstance;
   nShowMain = nCmdShow;
   lpCommandLine = lpCmdLine;

   if (!hPrevInstance) /* Other instances of app running? */
      {
      if (!P3_RegisterWindows ())
         return (FALSE);            
      if (!P3_RegisterReportWindow ())
         return (FALSE);            
      };         

   Initialise() ;
   
   if (!MainWindow(0))
      return (FALSE);
   
   while (GetMessage (&msg, NULL, NULL, NULL))
      {
      TranslateMessage(&msg);  /* Translates virtual key codes	     */
      DispatchMessage(&msg);   /* Dispatches message to window	     */
      }
      
   return (msg.wParam);        /* Return the value from PostQuitMessage */
   }



/*=-----------------------------------------------------=*/
BOOL P3_RegisterWindows (void)
/*=-----------------------------------------------------=*/
/*
   Initializes window data and registers window class.
 */
   {
   WNDCLASS  wc;  

   /* Window class structure for DriverTrips */

   wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
   wc.lpfnWndProc   = WndProc_DriverTrips;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = P3_TotalExtBytes;
   wc.hInstance     = hInst;
   wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;  /* Use Windows color */
   wc.lpszMenuName  = "";
   wc.lpszClassName = "DriverTrips Class";

   /* Register the window class and return success/failure code. */

   if (!RegisterClass(&wc))
      {
      LongWarning ("DriverTrips", "Could not register window.");
      return (FALSE);
      }        

   /* Window class structure for DriverList */

   wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
   wc.lpfnWndProc   = WndProc_DriverList;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = P3_TotalExtBytes;
   wc.hInstance     = hInst;
   wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;  /* Use Windows color */
   wc.lpszMenuName  = "";
   wc.lpszClassName = "DriverList Class";

   /* Register the window class and return success/failure code. */

   if (!RegisterClass(&wc))
      {
      LongWarning ("DriverList", "Could not register window.");
      return (FALSE);
      }        

   /* Window class structure for AddDriver */

   wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
   wc.lpfnWndProc   = WndProc_AddDriver;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = P3_TotalExtBytes;
   wc.hInstance     = hInst;
   wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;  /* Use Windows color */
   wc.lpszMenuName  = "";
   wc.lpszClassName = "AddDriver Class";

   /* Register the window class and return success/failure code. */

   if (!RegisterClass(&wc))
      {
      LongWarning ("AddDriver", "Could not register window.");
      return (FALSE);
      }        

   /* Window class structure for MainWindow */

   wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
   wc.lpfnWndProc   = WndProc_MainWindow;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = P3_TotalExtBytes;
   wc.hInstance     = hInst;
   wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;  /* Use Windows color */
   wc.lpszMenuName  = "MainWindow_Menu";
   wc.lpszClassName = "MainWindow Class";

   /* Register the window class and return success/failure code. */

   if (!RegisterClass(&wc))
      {
      LongWarning ("MainWindow", "Could not register window.");
      return (FALSE);
      }        

   return (TRUE);
   }   

