PROGRAM FLIGHT;

{*========================================================================
 *
 *  Program generated by Phase3 :- 
 *
 *      Date : Friday, May 21, 1993
 *
 *      Time : 01:43pm
 *
 *=======================================================================}


   {* Include USES clause, stack details etc. *}
{$I FLIGHT.INC}


   {* Forward Declarations For Window Procs *}
FUNCTION ListWeather (hOwner : HWnd) : HWnd; FORWARD;
FUNCTION ListComment (hOwner : HWnd) : HWnd; FORWARD;
FUNCTION ListFlight (hOwner : HWnd) : HWnd; FORWARD;
FUNCTION AddFlight (hOwner : HWnd) : HWnd; FORWARD;
FUNCTION ListSite (hOwner : HWnd) : HWnd; FORWARD;
FUNCTION AddSite (hOwner : HWnd) : HWnd; FORWARD;
FUNCTION ListGliders (hOwner : HWnd) : HWnd; FORWARD;
FUNCTION MainWindow (hOwner : HWnd) : HWnd; FORWARD;

   {* Forward Declarations For User Code *}
PROCEDURE Initialise; FORWARD;

PROCEDURE CleanUp; FORWARD;

PROCEDURE NextPage (hTable : THandle); FORWARD;

PROCEDURE MoveWindows; FORWARD;

PROCEDURE SelectFirstLine; FORWARD;

PROCEDURE PrevPage (hTable : THandle); FORWARD;

PROCEDURE WinMain; FORWARD;



{=-------------------------------do-not-remove-this-line-=}
PROCEDURE Initialise; 
{=-------------------------------do-not-remove-this-line-=}

(* 
 * This routine will be called before the main window of 
 * the application appears. It should be used for any
 * initialisation code the application may require.
 *)
 
VAR
   szCurDir,
   szFile    : Array [0..100] of Char;
 
BEGIN
      {* Get current directory *}
   WinDos.GetCurDir (szCurDir, 0);

      {* Build Catalog name and full path using current directory *}
   StrCopy (szFile, szCurDir);
   StrCat (szFile, '\');
   StrCat (szFile, 'FLIGHT.SC');

      {* open the database session *}
   hSession := DB_Init ('Flight', P3SESSION_SINGLEUSER );
   IF hSession = 0 THEN
      P3_WinClose (hWndMainWindow);

   IF NOT DB_SetDefaultDateFormat (hSession, 'ddMmmyy' ) THEN
      BEGIN  
      P3_WinClose (hWndMainWindow);
      Exit;
      END;
      
   IF NOT DB_LoadCatalog (hSession, 'Flight', szFile ) THEN
      BEGIN  
      P3_WinClose (hWndMainWindow);
      Exit;
      END;
      
   IF NOT DB_OpenCatalog (hSession, 'Flight' ) THEN      
      BEGIN  
      P3_WinClose (hWndMainWindow);
      Exit;
      END;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE CleanUp;
{=-------------------------------do-not-remove-this-line-=}

(* 
 * Carry out any final processing you require before your 
 * application closes.
 *)
 
BEGIN
   IF hWndListFlight <> 0 THEN
      P3_WinClose (hWndListFlight);
      
   IF hSession <> 0 THEN
       DB_Exit (hSession ) ;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE NextPage (hTable : THandle);
{=-------------------------------do-not-remove-this-line-=}
{*
 *  Displays the next page of the table with handle "hTable"
 *  in the list box on the DriverList window.
 *}
CONST
   NumPerPage = 10;
    
VAR
   szLine,
   szItem   : PChar;
   found    : Boolean;
    
BEGIN
   FlightsOnPage := 0;
   
    P3_LBResetContent (hWndListFlight_FlightListBox ) ;
   
   found := TRUE;
   WHILE found AND (FlightsOnPage < FlightsPerPage) DO
      BEGIN
      Inc (FlightsOnPage);
   
      GetMem (szLine, 2000);
      GetMem (szItem, 2000);
   
       DB_GetText (hSession, hTable, 'FlightNo', szLine) ;
   
      StrCat (szLine, Chr(9));
       DB_GetText (hSession, hTable, 'GliderName', szItem ) ;
      StrCat (szLine, szItem);
   
      StrCat (szLine, Chr(9));
       DB_GetText (hSession, hTable, 'SiteName', szItem ) ;
      StrCat (szLine, szItem);
   
      StrCat (szLine, Chr(9));
       DB_GetText (hSession, hTable, 'WeekDay', szItem ) ;
      StrCat (szLine, szItem);
   
      StrCat (szLine, Chr(9));
       DB_GetFormattedDate (hSession, hTable, 'Date', 'Mmmm d~, yyyy', szItem ) ;
      StrCat (szLine, szItem);
    
      StrCat (szLine, Chr(9));
       DB_GetText (hSession, hTable, 'Description', szItem) ;
      StrCat (szLine, szItem);
   
      StrCat (szLine, Chr(9));
       DB_GetText (hSession, hTable, 'Text', szItem) ;
      StrCat (szLine, szItem);
   
       P3_LBAddText (hWndListFlight_FlightListBox, szLine ) ;
   
      FreeMem (szLine, 2000);
      FreeMem (szItem, 2000);
   
      IF NOT DB_GetNextRow (hSession, hTable, found ) THEN
         BEGIN
         P3_WinClose (hWndListFlight);
         Exit;
         END;
      END;  {while}
      
    EnableWindow (hWndListFlight_NextBtn, found) ;  
    EnableWindow (hWndListFlight_PrevBtn, NOT BOF) ;  
   
   BOF := NOT found;
   EOF := NOT found;
      
   SelectFirstLine ;          

END;


{=================================================================}
PROCEDURE CreateObjects_ListWeather (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^ListWeatherRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   EBPtr^.hWndListWeather_WeatherEdit := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or ES_MULTILINE or ES_READONLY or 
                                   WS_VISIBLE, 
                                   24, 16, 299, 117, 
                                   hWindow, idListWeather_WeatherEdit, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndListWeather_WeatherEdit = 0 THEN
      P3User.SystemError ('Error creating window "ListWeather_WeatherEdit"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontListWeather_WeatherEdit := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndListWeather_WeatherEdit, WM_SETFONT,
                       EBPtr^.hFontListWeather_WeatherEdit, 0);

END;


{=================================================================}
PROCEDURE UpdateHandles_ListWeather (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^ListWeatherRec;

BEGIN
   P3Decs.hWndListWeather := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   P3Decs.hWndListWeather_WeatherEdit := EBPtr^.hWndListWeather_WeatherEdit;
END;


{=================================================================}
FUNCTION WinProc_ListWeather
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "ListWeather" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^ListWeatherRec;

rect : TRect;
BEGIN
   WinProc_ListWeather := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

            {* Set window background colour *}
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                         CreateSolidBrush (RGB (255, 255, 255)));

            {* Create brush for painting background for controls *}
         EBPtr^.P3_hBrushCtlColor := CreateSolidBrush (RGB (255, 255, 255));

         CreateObjects_ListWeather (hWindow);
         UpdateHandles_ListWeather (hWindow);
         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_ListWeather (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_ListWeather := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_SIZE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******} 

GetClientRect (hWndListWeather, rect);

WITH rect DO
   MoveWindow (hWndListWeather_WeatherEdit, 
   	       left, top, right, bottom, FALSE);

{******* End user-created code *******}

         Exit;
         END;

      WM_COMMAND :
         BEGIN
         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);
         DeleteObject (EBPtr^.hFontListWeather_WeatherEdit);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_ListWeather := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION ListWeather (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('ListWeather Class', 
                         'Weather', 
                         WS_OVERLAPPED or WS_CAPTION or WS_THICKFRAME or 
                   WS_MINIMIZEBOX or WS_MAXIMIZEBOX or WS_VISIBLE,
                         10, 300, 
                         200, 170, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "ListWeather"'); 

   UpdateWindow (hWin);

   ListWeather := hWin;
END;


{=================================================================}
PROCEDURE CreateObjects_ListComment (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^ListCommentRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   EBPtr^.hWndListComment_CommentEdit := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or ES_MULTILINE or ES_READONLY or 
                                   WS_VISIBLE, 
                                   27, 16, 252, 125, 
                                   hWindow, idListComment_CommentEdit, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndListComment_CommentEdit = 0 THEN
      P3User.SystemError ('Error creating window "ListComment_CommentEdit"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontListComment_CommentEdit := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndListComment_CommentEdit, WM_SETFONT,
                       EBPtr^.hFontListComment_CommentEdit, 0);

END;


{=================================================================}
PROCEDURE UpdateHandles_ListComment (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^ListCommentRec;

BEGIN
   P3Decs.hWndListComment := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   P3Decs.hWndListComment_CommentEdit := EBPtr^.hWndListComment_CommentEdit;
END;


{=================================================================}
FUNCTION WinProc_ListComment
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "ListComment" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^ListCommentRec;

rect : TRect;
BEGIN
   WinProc_ListComment := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

            {* Set window background colour *}
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                         CreateSolidBrush (RGB (255, 255, 255)));

            {* Create brush for painting background for controls *}
         EBPtr^.P3_hBrushCtlColor := CreateSolidBrush (RGB (255, 255, 255));

         CreateObjects_ListComment (hWindow);
         UpdateHandles_ListComment (hWindow);
         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_ListComment (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_ListComment := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_SIZE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******} 

GetClientRect (hWndListComment, rect);

WITH rect DO
   MoveWindow (hWndListComment_CommentEdit, 
               left, top, right, bottom, FALSE);

{******* End user-created code *******}

         Exit;
         END;

      WM_COMMAND :
         BEGIN
         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);
         DeleteObject (EBPtr^.hFontListComment_CommentEdit);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_ListComment := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION ListComment (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('ListComment Class', 
                         'Comments', 
                         WS_OVERLAPPED or WS_CAPTION or WS_THICKFRAME or 
                   WS_MINIMIZEBOX or WS_MAXIMIZEBOX or WS_VISIBLE,
                         220, 300, 
                         400, 170, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "ListComment"'); 

   UpdateWindow (hWin);

   ListComment := hWin;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE MoveWindows;
{=-------------------------------do-not-remove-this-line-=}
{*
 *  Move the three display windows for the flight list, 
 *  weather and comments to their correct locations.
 *
 *  This procedure is also called by the Flights / Resize
 *  menu option. 
 *}
BEGIN
   ShowWindow (hWndListFlight, SW_NORMAL);  {in case minimized}
   MoveWindow (hWndListFlight,  10,  50,600,240, TRUE);
   
   ShowWindow (hWndListWeather, SW_NORMAL);  {in case minimized}
   MoveWindow (hWndListWeather, 10, 300,200,170, TRUE);
   
   ShowWindow (hWndListComment, SW_NORMAL);  {in case minimized}
   MoveWindow (hWndListComment, 220,300,400,170, TRUE);
   
   SetFocus (hWndListFlight);
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE SelectFirstLine;
{=-------------------------------do-not-remove-this-line-=}
{*
 *  Select the first line of the flights list box & refresh
 *  the Weather and Comments windows.
 *}
BEGIN
    P3_LBSetSelection (hWndListFlight_FlightListBox, 0 ) ;   
    P3_SendNotifyMessage (hWndListFlight_FlightListBox, LBN_SELCHANGE) ;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE PrevPage (hTable : THandle);
{=-------------------------------do-not-remove-this-line-=}
{*
 *  Displays the previous page of the table with handle "hTable"
 *  in the list box on the DriverList window.
 *}
VAR
   count    : Word;
   szLine,
   szItem   : PChar;
   i,
   num      : Word;
   found    : Boolean;
    
BEGIN
   count := 0;
   
   IF EOF THEN
      num := FlightsPerPage + FlightsOnPage - 1
   ELSE   
      num := FlightsPerPage + FlightsOnPage;
      
   FOR i := 1 TO num DO
      IF NOT DB_GetPrevRow (hSession, hTable, found ) THEN
         BEGIN
         P3_WinClose (hWndListFlight);
         Exit;
         END;

   BOF := NOT found;
   EOF := FALSE;
   
   NextPage (hTable);
END;


{==========================================================================}
FUNCTION ListSubClass_ListFlight
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   ListSubClass_ListFlight := 0;

   CASE wMessage OF
      WM_CHAR :
         BEGIN
{****** Begin user-created code ******}
IF wParam = VK_ESCAPE THEN
   BEGIN
   P3_WinClose (hWndListFlight);
   Exit;
   END;
{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldListProc));

   ListSubClass_ListFlight := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
PROCEDURE CreateObjects_ListFlight (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^ListFlightRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   EBPtr^.hWndListFlight_NextBtn := CreateWindow ('BUTTON', 
                                   '&Next', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   15, 112, 74, 25, 
                                   hWindow, idListFlight_NextBtn, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndListFlight_NextBtn = 0 THEN
      P3User.SystemError ('Error creating window "ListFlight_NextBtn"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontListFlight_NextBtn := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndListFlight_NextBtn, WM_SETFONT,
                       EBPtr^.hFontListFlight_NextBtn, 0);

   EBPtr^.hWndListFlight_PrevBtn := CreateWindow ('BUTTON', 
                                   '&Prev', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   100, 112, 74, 25, 
                                   hWindow, idListFlight_PrevBtn, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndListFlight_PrevBtn = 0 THEN
      P3User.SystemError ('Error creating window "ListFlight_PrevBtn"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontListFlight_PrevBtn := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndListFlight_PrevBtn, WM_SETFONT,
                       EBPtr^.hFontListFlight_PrevBtn, 0);

   EBPtr^.hWndListFlight_FlightListBox := CreateWindow ('LISTBOX', 
                                   '', 
                                   WS_CHILD or LBS_NOTIFY or LBS_SORT or 
                                   LBS_USETABSTOPS or WS_VSCROLL or WS_VISIBLE, 
                                   25, 22, 284, 84, 
                                   hWindow, idListFlight_FlightListBox, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndListFlight_FlightListBox = 0 THEN
      P3User.SystemError ('Error creating window "ListFlight_FlightListBox"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontListFlight_FlightListBox := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndListFlight_FlightListBox, WM_SETFONT,
                       EBPtr^.hFontListFlight_FlightListBox, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndListFlight_FlightListBox,
                      @ListSubClass_ListFlight,
                      P3Decs.P3_ExtBytesOldListProc);

END;


{=================================================================}
PROCEDURE UpdateHandles_ListFlight (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^ListFlightRec;

BEGIN
   P3Decs.hWndListFlight := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   P3Decs.hWndListFlight_FlightListBox := EBPtr^.hWndListFlight_FlightListBox;
   P3Decs.hWndListFlight_NextBtn := EBPtr^.hWndListFlight_NextBtn;
   P3Decs.hWndListFlight_PrevBtn := EBPtr^.hWndListFlight_PrevBtn;
END;


{=================================================================}
FUNCTION WinProc_ListFlight
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "ListFlight" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^ListFlightRec;

szTab  : Array [0..2] OF Char;
index  : Integer;
szText : PChar;
wSize  : Word;
tabs   : Array [1..20] OF Integer;
rect   : TRect;
szDate : Array [0..50] OF Char;
found  : Boolean;
BEGIN
   WinProc_ListFlight := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

         CreateObjects_ListFlight (hWindow);
         UpdateHandles_ListFlight (hWindow);

{****** Begin user-created code for "WM_CREATE" ******}

EBPtr^.hMnu := GetMenu (hWndMainWindow);
EnableMenuItem (EBPtr^.hMnu, 101, MF_DISABLED or MF_GRAYED);
EnableMenuItem (EBPtr^.hMnu, 105, MF_ENABLED);

tabs[1] := 20;
tabs[2] := 100;
tabs[3] := 180;
tabs[4] := 203;
tabs[5] := 400;  {off screen}
tabs[6] := 400;  {off screen}

SendMessage (hWndListFlight_FlightListBox, LB_SETTABSTOPS, 6, LongInt (@tabs));

 P3_SetHourGlass ;

StrCopy (szTab, Chr(9));

IF NOT DB_CreateDerivedTable (hSession, 'Flight', 'Flights', 
                              'Flight LOJOIN Weather LOJOIN Comment') THEN
   BEGIN
   P3_WinClose (hWndListFlight);
   Exit;
   END;
   
EBPtr^.hTable := DB_OpenTable (hSession, 'Flights' );   
IF EBPtr^.hTable = 0 THEN
   BEGIN
   P3_WinClose (hWndListFlight);
   Exit;
   END;

IF NOT DB_GetFirstRow (hSession, EBPtr^.hTable, found ) THEN
   BEGIN
   P3_WinClose (hWndListFlight);
   Exit;
   END;

BOF := TRUE;
EOF := NOT found;

NextPage (EBPtr^.hTable) ;
   
ListWeather (hWndMainWindow) ;
ListComment (hWndMainWindow) ;

MoveWindows ;

SelectFirstLine ;
   
 P3_RemoveHourGlass ;   



{******* End user-created code for "WM_CREATE" *******}

         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_ListFlight (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_ListFlight := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_SIZE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******} 

GetClientRect (hWndListFlight, rect);

WITH rect DO
   BEGIN
   MoveWindow (hWndListFlight_FlightListBox, 
               left, top, right, bottom - 50, TRUE); 
               
   MoveWindow (hWndListFlight_NextBtn, 
               left + 10, bottom - 35, 74, 25, TRUE); 
               
   MoveWindow (hWndListFlight_PrevBtn, 
               left + 94, bottom - 35, 74, 25, TRUE); 
   END;               

{******* End user-created code *******}

         Exit;
         END;

      WM_COMMAND :
         BEGIN
         CASE wParam OF
            idListFlight_FlightListBox :
               BEGIN
               CASE HiWord (lParam) OF
                  LBN_SELCHANGE :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

GetMem (szText, 1100);

StrCopy (szText, 'Weather - ');
DB_GetLBItem (hWndListFlight_FlightListBox, P3_CurrentRow, 4, szDate);
StrCat (szText, szDate);
SetWindowText (hWndListWeather, szText);

IF DB_GetLBItem (hWndListFlight_FlightListBox, P3_CurrentRow, 5, szText) THEN
   SetWindowText (hWndListWeather_WeatherEdit, szText);
   
IF DB_GetLBItem (hWndListFlight_FlightListBox, P3_CurrentRow, 6, szText) THEN
   SetWindowText (hWndListComment_CommentEdit, szText);
   
FreeMem (szText, wSize);



{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idListFlight_NextBtn :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

P3_SetHourGlass;

NextPage (EBPtr^.hTable) ;

P3_RemoveHourGlass;

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idListFlight_PrevBtn :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

P3_SetHourGlass;

PrevPage (EBPtr^.hTable) ;

P3_RemoveHourGlass;

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            END;  {case wParam}

         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);

{****** Begin user-created code for "WM_DESTROY" ******}

IF EBPtr^.hTable <> 0 THEN
   BEGIN
   DB_CloseTable (hSession, EBPtr^.hTable);
   DB_DropTable (hSession, 'Flights');
   END;
   
P3_WinClose (hWndListWeather);   
P3_WinClose (hWndListComment);   

BringWindowToTop (hWndMainWindow);

EnableMenuItem (EBPtr^.hMnu, 101, MF_ENABLED);
EnableMenuItem (EBPtr^.hMnu, 105, MF_DISABLED or MF_GRAYED);


{******* End user-created code for "WM_DESTROY" *******}

         DeleteObject (EBPtr^.hFontListFlight_FlightListBox);
         DeleteObject (EBPtr^.hFontListFlight_NextBtn);
         DeleteObject (EBPtr^.hFontListFlight_PrevBtn);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_ListFlight := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION ListFlight (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('ListFlight Class', 
                         'List Flights', 
                         WS_OVERLAPPEDWINDOW or WS_VISIBLE,
                         10, 50, 
                         600, 240, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "ListFlight"'); 

   UpdateWindow (hWin);

   ListFlight := hWin;
END;


{==========================================================================}
FUNCTION EditSubClass_AddFlight
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   EditSubClass_AddFlight := 0;

   CASE wMessage OF
      WM_CHAR :
         BEGIN
{****** Begin user-created code ******}
IF wParam = VK_RETURN THEN
   BEGIN
   P3_SendNotifyMessage (hWndAddFlight_AddBtn, BN_CLICKED);
   Exit;
   END;
 
{******* End user-created code *******}
         END;

      WM_SYSCHAR :
         BEGIN
{****** Begin user-created code ******}
CASE UpCase (Chr (wParam)) OF
   'S' : P3_SendNotifyMessage (hWndAddFlight_SiteBtn, BN_CLICKED);
   'G' : P3_SendNotifyMessage (hWndAddFlight_GliderBtn, BN_CLICKED);
   'A' : P3_SendNotifyMessage (hWndAddFlight_AddBtn, BN_CLICKED);
   'C' : P3_SendNotifyMessage (hWndAddFlight_CancelBtn, BN_CLICKED);
   ELSE
      MessageBeep(0);
   END;  {case}      
   
Exit;

{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldEditProc));

   EditSubClass_AddFlight := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{==========================================================================}
FUNCTION ButtonSubClass_AddFlight
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   ButtonSubClass_AddFlight := 0;

   CASE wMessage OF
      WM_CHAR :
         BEGIN
{****** Begin user-created code ******}
IF wParam = VK_RETURN THEN
   BEGIN
   P3_SendNotifyMessage (GetFocus, BN_CLICKED );
   Exit;
   END;
{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldButtonProc));

   ButtonSubClass_AddFlight := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
PROCEDURE CreateObjects_AddFlight (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^AddFlightRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   EBPtr^.hWndAddFlight_DEDate := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_AUTOHSCROLL or 
                                   WS_VISIBLE, 
                                   92, 142, 109, 20, 
                                   hWindow, idAddFlight_DEDate, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_DEDate = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_DEDate"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_DEDate := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_DEDate, WM_SETFONT,
                       EBPtr^.hFontAddFlight_DEDate, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_DEDate,
                      @EditSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddFlight_DEDate, 2); 

   EBPtr^.hWndAddFlight_DEGliderName := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_AUTOHSCROLL or 
                                   WS_VISIBLE, 
                                   92, 21, 133, 20, 
                                   hWindow, idAddFlight_DEGliderName, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_DEGliderName = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_DEGliderName"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_DEGliderName := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_DEGliderName, WM_SETFONT,
                       EBPtr^.hFontAddFlight_DEGliderName, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_DEGliderName,
                      @EditSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldEditProc);

   EBPtr^.hWndAddFlight_DEFlightNo := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_WANTRETURN or 
                                   WS_VISIBLE, 
                                   92, 110, 61, 20, 
                                   hWindow, idAddFlight_DEFlightNo, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_DEFlightNo = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_DEFlightNo"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_DEFlightNo := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_DEFlightNo, WM_SETFONT,
                       EBPtr^.hFontAddFlight_DEFlightNo, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_DEFlightNo,
                      @EditSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddFlight_DEFlightNo, 1); 

   EBPtr^.hWndAddFlight_DEWeekDay := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_LEFT or 
                                   WS_VISIBLE, 
                                   92, 174, 49, 20, 
                                   hWindow, idAddFlight_DEWeekDay, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_DEWeekDay = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_DEWeekDay"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_DEWeekDay := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_DEWeekDay, WM_SETFONT,
                       EBPtr^.hFontAddFlight_DEWeekDay, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_DEWeekDay,
                      @EditSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddFlight_DEWeekDay, 3); 

   EBPtr^.hWndAddFlight_CancelBtn := CreateWindow ('BUTTON', 
                                   '&Cancel', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   459, 140, 74, 25, 
                                   hWindow, idAddFlight_CancelBtn, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_CancelBtn = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_CancelBtn"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_CancelBtn := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_CancelBtn, WM_SETFONT,
                       EBPtr^.hFontAddFlight_CancelBtn, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_CancelBtn,
                      @ButtonSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddFlight_CancelBtn, 8); 

   EBPtr^.hWndAddFlight_DEDuration := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_LEFT or 
                                   WS_VISIBLE, 
                                   92, 206, 73, 20, 
                                   hWindow, idAddFlight_DEDuration, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_DEDuration = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_DEDuration"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_DEDuration := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_DEDuration, WM_SETFONT,
                       EBPtr^.hFontAddFlight_DEDuration, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_DEDuration,
                      @EditSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddFlight_DEDuration, 4); 

   EBPtr^.hWndAddFlight_Weather := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_MULTILINE or 
                                   WS_VISIBLE, 
                                   209, 104, 242, 60, 
                                   hWindow, idAddFlight_Weather, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_Weather = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_Weather"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_Weather := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_Weather, WM_SETFONT,
                       EBPtr^.hFontAddFlight_Weather, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_Weather,
                      @EditSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddFlight_Weather, 5); 

   EBPtr^.hWndAddFlight_Comments := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_MULTILINE or 
                                   ES_AUTOVSCROLL or ES_WANTRETURN or WS_VISIBLE, 
                                   210, 172, 324, 115, 
                                   hWindow, idAddFlight_Comments, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_Comments = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_Comments"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_Comments := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_Comments, WM_SETFONT,
                       EBPtr^.hFontAddFlight_Comments, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_Comments,
                      @EditSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddFlight_Comments, 6); 

   EBPtr^.hWndAddFlight_DESiteName := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_AUTOHSCROLL or 
                                   WS_VISIBLE, 
                                   92, 53, 133, 20, 
                                   hWindow, idAddFlight_DESiteName, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_DESiteName = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_DESiteName"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_DESiteName := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_DESiteName, WM_SETFONT,
                       EBPtr^.hFontAddFlight_DESiteName, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_DESiteName,
                      @EditSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldEditProc);

   EBPtr^.hWndAddFlight_GliderBtn := CreateWindow ('BUTTON', 
                                   '&Glider', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   235, 19, 74, 25, 
                                   hWindow, idAddFlight_GliderBtn, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_GliderBtn = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_GliderBtn"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_GliderBtn := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_GliderBtn, WM_SETFONT,
                       EBPtr^.hFontAddFlight_GliderBtn, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_GliderBtn,
                      @ButtonSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldButtonProc);

   EBPtr^.hWndAddFlight_SiteBtn := CreateWindow ('BUTTON', 
                                   '&Site', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   235, 50, 74, 25, 
                                   hWindow, idAddFlight_SiteBtn, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_SiteBtn = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_SiteBtn"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_SiteBtn := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_SiteBtn, WM_SETFONT,
                       EBPtr^.hFontAddFlight_SiteBtn, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_SiteBtn,
                      @ButtonSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldButtonProc);

   EBPtr^.hWndAddFlight_AddBtn := CreateWindow ('BUTTON', 
                                   '&Add', 
                                   WS_CHILD or BS_DEFPUSHBUTTON or WS_VISIBLE, 
                                   459, 107, 74, 25, 
                                   hWindow, idAddFlight_AddBtn, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_AddBtn = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_AddBtn"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_AddBtn := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_AddBtn, WM_SETFONT,
                       EBPtr^.hFontAddFlight_AddBtn, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_AddBtn,
                      @ButtonSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddFlight_AddBtn, 7); 

   EBPtr^.hWndAddFlight_DECommentNo := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_LEFT or 
                                   WS_VISIBLE, 
                                   91, 266, 49, 20, 
                                   hWindow, idAddFlight_DECommentNo, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddFlight_DECommentNo = 0 THEN
      P3User.SystemError ('Error creating window "AddFlight_DECommentNo"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddFlight_DECommentNo := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddFlight_DECommentNo, WM_SETFONT,
                       EBPtr^.hFontAddFlight_DECommentNo, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddFlight_DECommentNo,
                      @EditSubClass_AddFlight,
                      P3Decs.P3_ExtBytesOldEditProc);

END;


{=================================================================}
PROCEDURE UpdateHandles_AddFlight (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^AddFlightRec;

BEGIN
   P3Decs.hWndAddFlight := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   P3Decs.hWndAddFlight_DEFlightNo := EBPtr^.hWndAddFlight_DEFlightNo;
   P3Decs.hWndAddFlight_DEDate := EBPtr^.hWndAddFlight_DEDate;
   P3Decs.hWndAddFlight_DEWeekDay := EBPtr^.hWndAddFlight_DEWeekDay;
   P3Decs.hWndAddFlight_DEDuration := EBPtr^.hWndAddFlight_DEDuration;
   P3Decs.hWndAddFlight_DEGliderName := EBPtr^.hWndAddFlight_DEGliderName;
   P3Decs.hWndAddFlight_DECommentNo := EBPtr^.hWndAddFlight_DECommentNo;
   P3Decs.hWndAddFlight_DESiteName := EBPtr^.hWndAddFlight_DESiteName;
   P3Decs.hWndAddFlight_SiteBtn := EBPtr^.hWndAddFlight_SiteBtn;
   P3Decs.hWndAddFlight_GliderBtn := EBPtr^.hWndAddFlight_GliderBtn;
   P3Decs.hWndAddFlight_AddBtn := EBPtr^.hWndAddFlight_AddBtn;
   P3Decs.hWndAddFlight_CancelBtn := EBPtr^.hWndAddFlight_CancelBtn;
   P3Decs.hWndAddFlight_Weather := EBPtr^.hWndAddFlight_Weather;
   P3Decs.hWndAddFlight_Comments := EBPtr^.hWndAddFlight_Comments;
END;


{=================================================================}
FUNCTION WinProc_AddFlight
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "AddFlight" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^AddFlightRec;

found  : Boolean;
szNum,
szDate : Array [0..20] OF Char;
num,
err    : Integer;

BEGIN
   WinProc_AddFlight := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

            {* Set window background colour *}
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                         CreateSolidBrush (RGB (192, 192, 192)));

            {* Create brush for painting background for controls *}
         EBPtr^.P3_hBrushCtlColor := CreateSolidBrush (RGB (192, 192, 192));

         CreateObjects_AddFlight (hWindow);
         UpdateHandles_AddFlight (hWindow);

{****** Begin user-created code for "WM_CREATE" ******}

{*
 *  This window provides a data-entry screen to add a single flight to the
 *  database. A data row will be added to the Flight, Weather and Comment
 *  tables.  
 *
 *  Related Messages
 *  ----------------
 *
 *  	WM_DESTROY
 *   	BN_CLICKED (CancelBtn)
 *	BN_CLICKED (AddBtn)
 *	BN_CLICKED (GliderBtn)
 *	BN_CLICKED (SiteBtn)
 *}

   {* The CommentNo edit box is a "linking" field between the Flight and 
    * Comment tables, therefore hide it so it is not visible *}
 ShowWindow (hWndAddFlight_DECommentNo, SW_HIDE ) ;

EBPtr^.sameComment := TRUE;
EBPtr^.sameDate := FALSE;
StrCopy (EBPtr^.szPrevDate, '');

SetWindowText (hWndAddFlight_DECommentNo, '0');  {default CommentNo}

EnableWindow (hWndAddFlight_DESiteName, FALSE);
EnableWindow (hWndAddFlight_DEGliderName, FALSE);

   {* open all required tables *}
 EBPtr^.hTblFlight := DB_OpenTable (hSession, 'Flight' ) ;
IF EBPtr^.hTblFlight = 0 THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
 EBPtr^.hTblComment := DB_OpenTable (hSession, 'Comment' ) ;
IF EBPtr^.hTblComment = 0 THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
 EBPtr^.hTblWeather := DB_OpenTable (hSession, 'Weather' ) ;
IF EBPtr^.hTblWeather = 0 THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
   {* Attach all edit boxes to relevant tables - note that CommentNo is 
    * attached to both the Flight and Comment tables. *}
IF NOT DB_EditAttach (hSession, EBPtr^.hTblFlight, 'FlightNo', hWndAddFlight_DEFlightNo ) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblFlight, 'GliderName', hWndAddFlight_DEGliderName) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblFlight, 'SiteName', hWndAddFlight_DESiteName) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblFlight, 'Date', hWndAddFlight_DEDate ) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblFlight, 'WeekDay', hWndAddFlight_DEWeekDay) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblFlight, 'Duration', hWndAddFlight_DEDuration) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblFlight, 'CommentNo', hWndAddFlight_DECommentNo) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblComment, 'CommentNo', hWndAddFlight_DECommentNo) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblComment, 'Text', hWndAddFlight_Comments) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblWeather, 'Date', hWndAddFlight_DEDate ) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTblWeather, 'Description', hWndAddFlight_Weather) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;
   
   {* Prepare screen for data-entry *}
SetFocus (hWndAddFlight_DEFlightNo);
{******* End user-created code for "WM_CREATE" *******}

         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_AddFlight (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_AddFlight := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

            {* Paint static text on the screen *}
         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         P3_hFontWork := P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                       FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif');
         SelectObject (dc, P3_hFontWork);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 19, 25, 88, 42);
         DrawText (dc, 'GliderName', 10,
                   P3_rtText, 32);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 19, 57, 88, 74);
         DrawText (dc, 'SiteName', 8,
                   P3_rtText, 32);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 19, 146, 88, 163);
         DrawText (dc, 'Date', 4,
                   P3_rtText, 32);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 19, 178, 88, 195);
         DrawText (dc, 'WeekDay', 7,
                   P3_rtText, 32);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 19, 210, 88, 227);
         DrawText (dc, 'Duration', 8,
                   P3_rtText, 32);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 19, 114, 88, 131);
         DrawText (dc, 'FlightNo', 8,
                   P3_rtText, 32);

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 10, 97, 545, 296, 1, 
                                    RGB (0, 0, 0), RGB (255, 255, 255));

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 10, 9, 322, 87, 1, 
                                    RGB (0, 0, 0), RGB (255, 255, 255));

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_COMMAND :
         BEGIN
         CASE wParam OF
            idAddFlight_DEFlightNo :
               BEGIN
               CASE HiWord (lParam) OF
                  EN_SETFOCUS :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

Hold_hFocus := hWndAddFlight_DEFlightNo;

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idAddFlight_DEDate :
               BEGIN
               CASE HiWord (lParam) OF
                  EN_SETFOCUS :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

Hold_hFocus := hWndAddFlight_DEDate;

{******* End user-created code *******}

                     Exit;
                     END;

                  EN_CHANGE :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

EnableWindow (hWndAddFlight_Weather, TRUE);

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idAddFlight_DEWeekDay :
               BEGIN
               CASE HiWord (lParam) OF
                  EN_SETFOCUS :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

Hold_hFocus := hWndAddFlight_DEWeekDay;

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idAddFlight_DEDuration :
               BEGIN
               CASE HiWord (lParam) OF
                  EN_SETFOCUS :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

Hold_hFocus := hWndAddFlight_DEDuration;

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idAddFlight_SiteBtn :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  Allows user to select a site from the Site table. The ListSites
 *  routine requires that the handle of the destination edit box be stored
 *  in the global variable Hold_hWindow. The selected site name will then
 *  be inserted into that particular edit box.
 *}
 
Hold_hWindow := hWndAddFlight_DESiteName;

ListSite (hWndAddFlight) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idAddFlight_GliderBtn :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  Allows user to select a glider from the Glider table. The ListGliders
 *  routine requires that the handle of the destination edit box be stored
 *  in the global variable Hold_hWindow. The selected glider name will then
 *  be inserted into that particular edit box.
 *}

Hold_hWindow := hWndAddFlight_DEGliderName;

ListGliders (hWndAddFlight) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idAddFlight_AddBtn :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  Add data in edit boxes to Flight, Weather and Comment tables.
 *}
 
 
   {* Check text exists in date field *}
IF GetWindowTextLength (hWndAddFlight_DEDate) = 0 THEN
   BEGIN
   MessageBeep(0);
   DB_AddWarning (hSession, 'Date must be entered.');
   DB_Warning (hSession);
   SetFocus (hWndAddFlight_DEDate);
   Exit;
   END;

   {* Check site has been selected *}
IF GetWindowTextLength (hWndAddFlight_DESiteName) = 0 THEN
   BEGIN
   MessageBeep(0);
   DB_AddWarning (hSession, 'Site must be entered.');
   DB_Warning (hSession);
   SetFocus (hWndAddFlight_SiteBtn);
   Exit;
   END;

   {* Check glider has been selected *}
IF GetWindowTextLength (hWndAddFlight_DEGliderName) = 0 THEN
   BEGIN
   MessageBeep(0);
   DB_AddWarning (hSession, 'Site must be entered.');
   DB_Warning (hSession);
   SetFocus (hWndAddFlight_GliderBtn);
   Exit;
   END;

IF EBPtr^.sameComment THEN
   BEGIN 
   {* Do not add the comment text to the Comment Table *} 
   END
ELSE IF GetWindowTextLength (hWndAddFlight_Comments ) = 0 THEN
   SetWindowText (hWndAddFlight_DECommentNo, '0')  {default for no comment}
ELSE   
   BEGIN
   SetWindowText (hWndAddFlight_DECommentNo, '');  {auto key must be blank}
   
   IF NOT DB_EditsAddToTable (hSession, EBPtr^.hTblComment) THEN
      BEGIN
      P3_WinClose (hWndAddFlight);
      Exit;
      END;
   
      {* get the row just added *}
   IF NOT DB_GetLastRow (hSession, EBPtr^.hTblComment, found) THEN
      BEGIN
      P3_WinClose (hWndAddFlight);
      Exit;
      END;

   IF NOT found THEN   
      BEGIN
      MessageBox (0, 'Row not found', '', MB_TASKMODAL);
      P3_WinClose (hWndAddFlight);
      Exit;
      END;

   IF NOT DB_EditsFromRow (hSession, EBPtr^.hTblComment ) THEN       
      BEGIN
      P3_WinClose (hWndAddFlight);
      Exit;
      END;
   END;   

IF GetWindowTextLength (hWndAddFlight_Weather) <> 0 THEN
   BEGIN
      {* only save weather if it is a new date *}
   GetWindowText (hWndAddFlight_DEDate, @szDate, 20);
   IF StrIComp (szDate, EBPtr^.szPrevDate) <> 0 THEN
      IF NOT DB_EditsAddToTable (hSession, EBPtr^.hTblWeather) THEN
         BEGIN
         P3_WinClose (hWndAddFlight);
         Exit;
         END;
   StrCopy (EBPtr^.szPrevDate, szDate);      
   END;      
   
IF NOT DB_EditsAddToTable (hSession, EBPtr^.hTblFlight ) THEN
   BEGIN
   P3_WinClose (hWndAddFlight);
   Exit;
   END;

GetWindowText (hWndAddFlight_DEFlightNo, szNum, 10);
Val (szNum, num, err);
IF err = 0 THEN
   BEGIN
   Inc (num);
   Str (num:0, szNum);
   SetWindowText (hWndAddFlight_DEFlightNo, @szNum);
   END;
   
SetWindowText (hWndAddFlight_DEDuration, '');
EnableWindow (hWndAddFlight_Weather, FALSE);

   {* Prepare for adding next record - move cursor to date field with
    * entire contents of edit box highlighted *}
SetFocus (hWndAddFlight_DEDate);
 P3_EditSetSel (hWndAddFlight_DEDate, 0, 99 ) ;

EBPtr^.sameComment := TRUE;
EBPtr^.sameDate := TRUE;

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idAddFlight_CancelBtn :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

P3_WinClose (hWndAddFlight);

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idAddFlight_Comments :
               BEGIN
               CASE HiWord (lParam) OF
                  EN_CHANGE :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

EBPtr^.sameComment := FALSE;

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            END;  {case wParam}

         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);

{****** Begin user-created code for "WM_DESTROY" ******}

DB_CloseTable (hSession, EBPtr^.hTblFlight);
DB_CloseTable (hSession, EBPtr^.hTblComment);
DB_CloseTable (hSession, EBPtr^.hTblWeather);

BringWindowToTop (hWndMainWindow);
{******* End user-created code for "WM_DESTROY" *******}

         DeleteObject (EBPtr^.hFontAddFlight_DEFlightNo);
         DeleteObject (EBPtr^.hFontAddFlight_DEDate);
         DeleteObject (EBPtr^.hFontAddFlight_DEWeekDay);
         DeleteObject (EBPtr^.hFontAddFlight_DEDuration);
         DeleteObject (EBPtr^.hFontAddFlight_DEGliderName);
         DeleteObject (EBPtr^.hFontAddFlight_DECommentNo);
         DeleteObject (EBPtr^.hFontAddFlight_DESiteName);
         DeleteObject (EBPtr^.hFontAddFlight_SiteBtn);
         DeleteObject (EBPtr^.hFontAddFlight_GliderBtn);
         DeleteObject (EBPtr^.hFontAddFlight_AddBtn);
         DeleteObject (EBPtr^.hFontAddFlight_CancelBtn);
         DeleteObject (EBPtr^.hFontAddFlight_Weather);
         DeleteObject (EBPtr^.hFontAddFlight_Comments);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_AddFlight := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION AddFlight (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('AddFlight Class', 
                         'Add Flight', 
                         WS_OVERLAPPEDWINDOW or WS_VISIBLE,
                         CW_USEDEFAULT, CW_USEDEFAULT, 
                         565, 335, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "AddFlight"'); 

   UpdateWindow (hWin);

   AddFlight := hWin;
END;


{==========================================================================}
FUNCTION ListSubClass_ListSite
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   ListSubClass_ListSite := 0;

   CASE wMessage OF
      WM_CHAR :
         BEGIN
{****** Begin user-created code ******}
CASE wPAram OF
   VK_RETURN : 
      SendMessage (hWndListSite, WM_COMMAND, 
   	   idListSite_SiteListBox,
   	   MakeLong (hWndListSite_SiteListBox, LBN_DBLCLK));
   
   VK_ESCAPE :        
        BEGIN
        P3_WinClose (hWndListSite);
        SetFocus (Hold_hFocus);
        END;

   END;  {case}   
{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldListProc));

   ListSubClass_ListSite := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
PROCEDURE CreateObjects_ListSite (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^ListSiteRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   EBPtr^.hWndListSite_SiteListBox := CreateWindow ('LISTBOX', 
                                   '', 
                                   WS_CHILD or LBS_NOTIFY or LBS_SORT or 
                                   LBS_USETABSTOPS or WS_VSCROLL or WS_VISIBLE, 
                                   32, 29, 270, 127, 
                                   hWindow, idListSite_SiteListBox, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndListSite_SiteListBox = 0 THEN
      P3User.SystemError ('Error creating window "ListSite_SiteListBox"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontListSite_SiteListBox := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndListSite_SiteListBox, WM_SETFONT,
                       EBPtr^.hFontListSite_SiteListBox, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndListSite_SiteListBox,
                      @ListSubClass_ListSite,
                      P3Decs.P3_ExtBytesOldListProc);

END;


{=================================================================}
PROCEDURE UpdateHandles_ListSite (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^ListSiteRec;

BEGIN
   P3Decs.hWndListSite := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   P3Decs.hWndListSite_SiteListBox := EBPtr^.hWndListSite_SiteListBox;
END;


{=================================================================}
FUNCTION WinProc_ListSite
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "ListSite" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^ListSiteRec;

hTable : THandle;
rect   : TRect;
szItem : Array [0..200] OF Char;
BEGIN
   WinProc_ListSite := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

         CreateObjects_ListSite (hWindow);
         UpdateHandles_ListSite (hWindow);

{****** Begin user-created code for "WM_CREATE" ******}

{*
 *  This window provides a display list of the Site table by loading the 
 *  entire table into a list box. The user can select a site by 
 *  double-clicking on an entry in the list box. 
 *
 *  The selected site name will be inserted into the window whose handle has
 *  been stored in the global variable "Hold_hWindow" by the calling routine.
 *
 *  Related Messages
 *  ----------------
 *
 *	WM_SIZE
 *  	LBN_DBLCLK of "SiteListBox"
 *
 *  The list box has been sub-classed to implement the RETURN key & ESCAPE
 *  key (see Sub-class code messages for list boxes).
 *}
 
 hTable := DB_OpenTable (hSession, 'Site' ) ;
IF hTable = 0 THEN
   BEGIN
   P3_WinClose (hWndListSite);
   Exit;
   END;
   
IF NOT DB_TableToListBox (hSession, hTable, hWndListSite_SiteListBox, '', TRUE ) THEN
   BEGIN
   P3_WinClose (hWndListSite);
   Exit;
   END;

DB_CloseTable (hSession, hTable );   

   {* highlight the first line in the list box *}
SetFocus (hWndListSite_SiteListBox);
SendMessage (hWndListSite_SiteListBox, LB_SETCURSEL, 0,0);
{******* End user-created code for "WM_CREATE" *******}

         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_ListSite (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_ListSite := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_SIZE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******} 

{* Re-size the list box to always fill the entire window area whenever
 * the window is re-sized.
 *}
 
 GetClientRect (hWndListSite, rect ) ;
 MoveWindow (hWndListSite_SiteListBox, rect.Left, rect.Top, rect.Right, rect.Bottom, TRUE ) ;

{******* End user-created code *******}

         Exit;
         END;

      WM_COMMAND :
         BEGIN
         CASE wParam OF
            idListSite_SiteListBox :
               BEGIN
               CASE HiWord (lParam) OF
                  LBN_DBLCLK :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  Extract the name of the site from the selected line of the list box
 *  and store it in the window handle set up by the calling routine.
 *}
 
IF Hold_hWindow <> 0 THEN
   BEGIN
   DB_GetLBItem (hWndListSite_SiteListBox, P3_CurrentRow, 0, szItem );
   SetWindowText (Hold_hWindow, szItem );
   P3_WinClose (hWndListSite);
   SetFocus (Hold_hFocus);
   END;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            END;  {case wParam}

         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);
         DeleteObject (EBPtr^.hFontListSite_SiteListBox);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_ListSite := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION ListSite (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('ListSite Class', 
                         'Sites', 
                         WS_OVERLAPPED or WS_CAPTION or WS_SYSMENU or WS_THICKFRAME
                    or WS_VISIBLE,
                         100, 100, 
                         170, 220, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "ListSite"'); 

   UpdateWindow (hWin);

   ListSite := hWin;
END;


{==========================================================================}
FUNCTION EditSubClass_AddSite
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   EditSubClass_AddSite := 0;

   CASE wMessage OF
      WM_CHAR :
         BEGIN
{****** Begin user-created code ******}
{*
 *  Set up the ENTER key to complete the data-entry process and add the
 *  data to the Site table. This is done by sending a notify message to
 *  the Add button to execute the code attached to that button.
 *
 *  Related Messages
 *  ----------------
 *
 *  	BN_CLICKED for "AddBtn"
 *}

IF wParam = VK_RETURN THEN
   BEGIN
   P3_SendNotifyMessage (hWndAddSite_AddBtn, BN_CLICKED);      
   Exit;
   END;
  
{******* End user-created code *******}
         END;

      WM_SYSCHAR :
         BEGIN
{****** Begin user-created code ******}
{*
 *  Set up the Alt-key values to execute the Add and Cancel buttons by
 *  sending notify messages to the appropriate buttons to execute the code
 *  that is attached to them.
 *
 *  Related Messages
 *  ----------------
 *
 *	BN_CLICKED for "AddBtn"
 *	BN_CLICKED for "CancelBtn"
 *}
 
CASE wParam OF
   Ord('A'), Ord('a') :
      P3_SendNotifyMessage (hWndAddSite_AddBtn, BN_CLICKED);      
   Ord('C'), Ord('c') :
      P3_SendNotifyMessage (hWndAddSite_CancelBtn, BN_CLICKED);      
   ELSE
      MessageBeep(0);   
   END;  {case}
   
Exit;   
{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldEditProc));

   EditSubClass_AddSite := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{==========================================================================}
FUNCTION ButtonSubClass_AddSite
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   ButtonSubClass_AddSite := 0;

   CASE wMessage OF
      WM_CHAR :
         BEGIN
{****** Begin user-created code ******}
{*
 *  Set the ENTER key to press the button that currently has the input
 *  focus (i.e. the "AddBtn" or the "CancelBtn").
 *}
IF wParam = VK_RETURN THEN
   BEGIN
   P3_SendNotifyMessage (GetFocus, BN_CLICKED );
   Exit;
   END;
{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldButtonProc));

   ButtonSubClass_AddSite := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
PROCEDURE CreateObjects_AddSite (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^AddSiteRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   EBPtr^.hWndAddSite_DESiteName := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_AUTOHSCROLL or 
                                   WS_VISIBLE, 
                                   70, 8, 133, 20, 
                                   hWindow, idAddSite_DESiteName, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddSite_DESiteName = 0 THEN
      P3User.SystemError ('Error creating window "AddSite_DESiteName"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddSite_DESiteName := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddSite_DESiteName, WM_SETFONT,
                       EBPtr^.hFontAddSite_DESiteName, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddSite_DESiteName,
                      @EditSubClass_AddSite,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddSite_DESiteName, 1); 

   EBPtr^.hWndAddSite_DEVertical := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_LEFT or 
                                   WS_VISIBLE, 
                                   70, 62, 61, 20, 
                                   hWindow, idAddSite_DEVertical, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddSite_DEVertical = 0 THEN
      P3User.SystemError ('Error creating window "AddSite_DEVertical"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddSite_DEVertical := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddSite_DEVertical, WM_SETFONT,
                       EBPtr^.hFontAddSite_DEVertical, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddSite_DEVertical,
                      @EditSubClass_AddSite,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddSite_DEVertical, 3); 

   EBPtr^.hWndAddSite_DEWinds := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_AUTOHSCROLL or 
                                   WS_VISIBLE, 
                                   70, 35, 133, 20, 
                                   hWindow, idAddSite_DEWinds, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddSite_DEWinds = 0 THEN
      P3User.SystemError ('Error creating window "AddSite_DEWinds"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddSite_DEWinds := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddSite_DEWinds, WM_SETFONT,
                       EBPtr^.hFontAddSite_DEWinds, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddSite_DEWinds,
                      @EditSubClass_AddSite,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddSite_DEWinds, 2); 

   EBPtr^.hWndAddSite_DEState := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_LEFT or 
                                   WS_VISIBLE, 
                                   70, 89, 49, 20, 
                                   hWindow, idAddSite_DEState, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddSite_DEState = 0 THEN
      P3User.SystemError ('Error creating window "AddSite_DEState"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddSite_DEState := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddSite_DEState, WM_SETFONT,
                       EBPtr^.hFontAddSite_DEState, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddSite_DEState,
                      @EditSubClass_AddSite,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddSite_DEState, 4); 

   EBPtr^.hWndAddSite_AddBtn := CreateWindow ('BUTTON', 
                                   '&Add', 
                                   WS_CHILD or BS_DEFPUSHBUTTON or WS_VISIBLE, 
                                   8, 122, 75, 24, 
                                   hWindow, idAddSite_AddBtn, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddSite_AddBtn = 0 THEN
      P3User.SystemError ('Error creating window "AddSite_AddBtn"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddSite_AddBtn := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddSite_AddBtn, WM_SETFONT,
                       EBPtr^.hFontAddSite_AddBtn, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddSite_AddBtn,
                      @ButtonSubClass_AddSite,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddSite_AddBtn, 5); 

   EBPtr^.hWndAddSite_CancelBtn := CreateWindow ('BUTTON', 
                                   '&Cancel', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   95, 122, 75, 24, 
                                   hWindow, idAddSite_CancelBtn, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndAddSite_CancelBtn = 0 THEN
      P3User.SystemError ('Error creating window "AddSite_CancelBtn"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontAddSite_CancelBtn := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndAddSite_CancelBtn, WM_SETFONT,
                       EBPtr^.hFontAddSite_CancelBtn, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndAddSite_CancelBtn,
                      @ButtonSubClass_AddSite,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndAddSite_CancelBtn, 6); 

END;


{=================================================================}
PROCEDURE UpdateHandles_AddSite (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^AddSiteRec;

BEGIN
   P3Decs.hWndAddSite := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   P3Decs.hWndAddSite_DESiteName := EBPtr^.hWndAddSite_DESiteName;
   P3Decs.hWndAddSite_DEWinds := EBPtr^.hWndAddSite_DEWinds;
   P3Decs.hWndAddSite_DEVertical := EBPtr^.hWndAddSite_DEVertical;
   P3Decs.hWndAddSite_DEState := EBPtr^.hWndAddSite_DEState;
   P3Decs.hWndAddSite_AddBtn := EBPtr^.hWndAddSite_AddBtn;
   P3Decs.hWndAddSite_CancelBtn := EBPtr^.hWndAddSite_CancelBtn;
END;


{=================================================================}
FUNCTION WinProc_AddSite
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "AddSite" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^AddSiteRec;

BEGIN
   WinProc_AddSite := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

            {* Set window background colour *}
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                         CreateSolidBrush (RGB (192, 192, 192)));

            {* Create brush for painting background for controls *}
         EBPtr^.P3_hBrushCtlColor := CreateSolidBrush (RGB (192, 192, 192));

         CreateObjects_AddSite (hWindow);
         UpdateHandles_AddSite (hWindow);

{****** Begin user-created code for "WM_CREATE" ******}

{*
 *  This window provides a data-entry screen to add a single row to the 
 *  "Site" table.
 *
 *  The Site table is opened and each edit box on the window is "attached" 
 *  to the relevant table column. If any error occurs with the code for this
 *  message, close down this window.
 *
 *  Related messages
 *  ----------------
 *
 *	BN_CLICKED for "AddBtn"
 *      WM_DESTROY 	
 *
 *  Code for keyboard control of this window is contained in the SubClass 
 *  code for Edit Boxes and Buttons.
 *}

SetFocus (hWndAddSite_DESiteName);  {ready for user to enter data}

   {* open the table - if error occurs, close window & exit *}
 EBPtr^.hTable := DB_OpenTable (hSession, 'Site' ) ;
IF EBPtr^.hTable = 0 THEN
   BEGIN
   P3_WinClose (hWndAddSite);
   Exit;
   END;
   
   {* attach all edit boxes to relevant table columns *}
IF NOT DB_EditAttach (hSession, EBPtr^.hTable, 'SiteName', hWndAddSite_DESiteName ) THEN
   BEGIN
   P3_WinClose (hWndAddSite);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTable, 'Winds', hWndAddSite_DEWinds) THEN
   BEGIN
   P3_WinClose (hWndAddSite);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTable, 'Vertical', hWndAddSite_DEVertical) THEN
   BEGIN
   P3_WinClose (hWndAddSite);
   Exit;
   END;
   
IF NOT DB_EditAttach (hSession, EBPtr^.hTable, 'State', hWndAddSite_DEState) THEN
   BEGIN
   P3_WinClose (hWndAddSite);
   Exit;
   END;
   
   

{******* End user-created code for "WM_CREATE" *******}

         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_AddSite (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_AddSite := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

            {* Paint static text on the screen *}
         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         P3_hFontWork := P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                       FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif');
         SelectObject (dc, P3_hFontWork);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 10, 12, 66, 29);
         DrawText (dc, 'SiteName', 8,
                   P3_rtText, 32);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 10, 39, 66, 56);
         DrawText (dc, 'Winds', 5,
                   P3_rtText, 32);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 10, 66, 66, 83);
         DrawText (dc, 'Vertical', 8,
                   P3_rtText, 32);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 10, 93, 66, 110);
         DrawText (dc, 'State', 5,
                   P3_rtText, 32);

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_COMMAND :
         BEGIN
         CASE wParam OF
            idAddSite_AddBtn :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  Add the contents of all the edit boxes on the window to the "Site"
 *  table as a single table row. If successful, clear the contents of the
 *  edit boxes and prepare the window for the user to enter the data for
 *  the next row.
 *
 *  Related Messages
 *  ----------------
 *
 *  	WM_CREATE
 *	WM_DESTROY 	 
 *}
 
IF NOT DB_EditsAddToTable (hSession, EBPtr^.hTable ) THEN
   Exit;
   
DB_EditsClear (hSession, EBPtr^.hTable );   
SetFocus (hWndAddSite_DESiteName);

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idAddSite_CancelBtn :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

P3_WinClose (hWndAddSite);

{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            END;  {case wParam}

         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);

{****** Begin user-created code for "WM_DESTROY" ******}

{*
 *  Close the "Site" table.
 *
 *  Related messages
 *  ----------------
 *
 *	WM_CREATE 
 *}
 
 DB_CloseTable (hSession, EBPtr^.hTable ) ;
{******* End user-created code for "WM_DESTROY" *******}

         DeleteObject (EBPtr^.hFontAddSite_DESiteName);
         DeleteObject (EBPtr^.hFontAddSite_DEWinds);
         DeleteObject (EBPtr^.hFontAddSite_DEVertical);
         DeleteObject (EBPtr^.hFontAddSite_DEState);
         DeleteObject (EBPtr^.hFontAddSite_AddBtn);
         DeleteObject (EBPtr^.hFontAddSite_CancelBtn);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_AddSite := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION AddSite (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('AddSite Class', 
                         'Add Site', 
                         WS_OVERLAPPEDWINDOW or WS_VISIBLE,
                         CW_USEDEFAULT, CW_USEDEFAULT, 
                         250, 180, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "AddSite"'); 

   UpdateWindow (hWin);

   AddSite := hWin;
END;


{==========================================================================}
FUNCTION ListSubClass_ListGliders
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   ListSubClass_ListGliders := 0;

   CASE wMessage OF
      WM_CHAR :
         BEGIN
{****** Begin user-created code ******}
CASE wParam OF
   13 : SendMessage (hWndListGliders, WM_COMMAND, 
   	   idListGliders_LISTBOX1,
   	   MakeLong (hWndListGliders_LISTBOX1, LBN_DBLCLK));
   
   27 : BEGIN
        P3_WinClose (hWndListGliders);
        SetFocus (Hold_hFocus);
        END;

   END;  {case}   
{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldListProc));

   ListSubClass_ListGliders := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
PROCEDURE CreateObjects_ListGliders (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^ListGlidersRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   EBPtr^.hWndListGliders_LISTBOX1 := CreateWindow ('LISTBOX', 
                                   '', 
                                   WS_CHILD or LBS_NOTIFY or LBS_USETABSTOPS
                                    or WS_VSCROLL or WS_VISIBLE, 
                                   51, 26, 114, 107, 
                                   hWindow, idListGliders_LISTBOX1, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndListGliders_LISTBOX1 = 0 THEN
      P3User.SystemError ('Error creating window "ListGliders_LISTBOX1"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontListGliders_LISTBOX1 := 
               P3Procs.P3_GetFont (-11, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'MS Sans Serif'); 
   SendMessage (EBPtr^.hWndListGliders_LISTBOX1, WM_SETFONT,
                       EBPtr^.hFontListGliders_LISTBOX1, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndListGliders_LISTBOX1,
                      @ListSubClass_ListGliders,
                      P3Decs.P3_ExtBytesOldListProc);

END;


{=================================================================}
PROCEDURE UpdateHandles_ListGliders (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^ListGlidersRec;

BEGIN
   P3Decs.hWndListGliders := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   P3Decs.hWndListGliders_LISTBOX1 := EBPtr^.hWndListGliders_LISTBOX1;
END;


{=================================================================}
FUNCTION WinProc_ListGliders
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "ListGliders" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^ListGlidersRec;

hTable : THandle;
rect   : TRect;
szItem : Array [0..200] OF Char;
BEGIN
   WinProc_ListGliders := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

         CreateObjects_ListGliders (hWindow);
         UpdateHandles_ListGliders (hWindow);

{****** Begin user-created code for "WM_CREATE" ******}

 hTable := DB_OpenTable (hSession, 'Glider' ) ;
IF hTable = 0 THEN
   BEGIN
   P3_WinClose (hWndListGliders);
   Exit;
   END;
   
IF NOT DB_TableToListBox (hSession, hTable, hWndListGliders_LISTBOX1, '', TRUE ) THEN
   BEGIN
   P3_WinClose (hWndListGliders);
   Exit;
   END;

DB_CloseTable (hSession, hTable );   

SetFocus (hWndListGliders_LISTBOX1);
SendMessage (hWndListGliders_LISTBOX1, LB_SETCURSEL, 0,0);
{******* End user-created code for "WM_CREATE" *******}

         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_ListGliders (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_ListGliders := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_SIZE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******} 

 GetClientRect (hWndListGliders, rect ) ;
 MoveWindow (hWndListGliders_LISTBOX1, rect.Left, rect.Top, rect.Right, rect.Bottom, TRUE ) ;

{******* End user-created code *******}

         Exit;
         END;

      WM_COMMAND :
         BEGIN
         CASE wParam OF
            idListGliders_LISTBOX1 :
               BEGIN
               CASE HiWord (lParam) OF
                  LBN_DBLCLK :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

IF Hold_hWindow <> 0 THEN
   BEGIN
   DB_GetLBItem (hWndListGliders_LISTBOX1, P3_CurrentRow, 0, szItem );
   SetWindowText (Hold_hWindow, szItem );
   P3_WinClose (hWndListGliders);
   SetFocus (Hold_hFocus);
   END;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            END;  {case wParam}

         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);
         DeleteObject (EBPtr^.hFontListGliders_LISTBOX1);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_ListGliders := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION ListGliders (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('ListGliders Class', 
                         'Gliders', 
                         WS_OVERLAPPED or WS_CAPTION or WS_SYSMENU or WS_THICKFRAME
                    or WS_VISIBLE,
                         100, 100, 
                         170, 220, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "ListGliders"'); 

   UpdateWindow (hWin);

   ListGliders := hWin;
END;


{=================================================================}
PROCEDURE CreateObjects_MainWindow (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^MainWindowRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

END;


{=================================================================}
PROCEDURE UpdateHandles_MainWindow (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^MainWindowRec;

BEGIN
   P3Decs.hWndMainWindow := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

END;


{=================================================================}
FUNCTION WinProc_MainWindow
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "MainWindow" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^MainWindowRec;

BEGIN
   WinProc_MainWindow := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

            {* Set window background colour *}
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                         CreateSolidBrush (RGB (255, 255, 188)));

            {* Create brush for painting background for controls *}
         EBPtr^.P3_hBrushCtlColor := CreateSolidBrush (RGB (255, 255, 188));

         CreateObjects_MainWindow (hWindow);
         UpdateHandles_MainWindow (hWindow);
         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_MainWindow (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_MainWindow := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_COMMAND :
         BEGIN
         CASE wParam OF
            101 {&List Flights} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

ListFlight (hWndMainWindow) ;

{******* End user-created code *******}

               Exit;               END;

            102 {&Add Flight} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

AddFlight (hWndMainWindow) ;

{******* End user-created code *******}

               Exit;               END;

            103 {&Modify Flight} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

MessageBox (hWndMainWindow, 
            'Not yet implemented', 'Modify Flight', 
            MB_TASKMODAL or MB_ICONINFORMATION);


{******* End user-created code *******}

               Exit;               END;

            104 {&Delete Flight} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

MessageBox (hWndMainWindow, 
            'Not yet implemented', 'Delete Flight', 
            MB_TASKMODAL or MB_ICONINFORMATION);


{******* End user-created code *******}

               Exit;               END;

            105 {&Resize Windows} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

MoveWindows ;

{******* End user-created code *******}

               Exit;               END;

            106 {E&xit} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

p3_WinClose (hWndMainWindow);

{******* End user-created code *******}

               Exit;               END;

            111 {&List Sites} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

Hold_hWindow := 0;

ListSite (hWndMainWindow) ;

{******* End user-created code *******}

               Exit;               END;

            112 {&Add Site} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

AddSite (hWndMainWindow) ;

{******* End user-created code *******}

               Exit;               END;

            113 {&Modify Site} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

MessageBox (hWndMainWindow, 
            'Not yet implemented', 'Modify Site', 
            MB_TASKMODAL or MB_ICONINFORMATION);


{******* End user-created code *******}

               Exit;               END;

            114 {&Delete Site} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

MessageBox (hWndMainWindow, 
            'Not yet implemented', 'Delete Site', 
            MB_TASKMODAL or MB_ICONINFORMATION);


{******* End user-created code *******}

               Exit;               END;

            121 {&List Gliders} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

ListGliders (hWndMainWindow) ;

{******* End user-created code *******}

               Exit;               END;

            122 {&Add Glider} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

MessageBox (hWndMainWindow, 
            'Not yet implemented', 'Add Glider', 
            MB_TASKMODAL or MB_ICONINFORMATION);
 

{******* End user-created code *******}

               Exit;               END;

            123 {&Modify Glider} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

MessageBox (hWndMainWindow, 
            'Not yet implemented', 'Modify Glider', 
            MB_TASKMODAL or MB_ICONINFORMATION);


{******* End user-created code *******}

               Exit;               END;

            124 {&Delete Glider} :
               BEGIN
               LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
{****** Begin user-created code ******}

MessageBox (hWndMainWindow, 
            'Not yet implemented', 'Delete Glider', 
            MB_TASKMODAL or MB_ICONINFORMATION);


{******* End user-created code *******}

               Exit;               END;

            END;  {case wParam} 

         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code for "WM_CLOSE" ******}

CleanUp ;

{******* End user-created code for "WM_CLOSE" *******}

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);

{****** Begin user-created code for "WM_DESTROY" ******}

PostQuitMessage(0);

{******* End user-created code for "WM_DESTROY" *******}


         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_MainWindow := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION MainWindow (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('MainWindow Class', 
                         'Hang Gliding Log', 
                         WS_OVERLAPPEDWINDOW or WS_MAXIMIZE or WS_VISIBLE,
                         0, 0, 
                         800, 600, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "MainWindow"'); 

   UpdateWindow (hWin);

   MainWindow := hWin;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE WinMain; 
{=-------------------------------do-not-remove-this-line-=}

(*  
 *  WinMain Procedure
 *  =================
 *
 *  This procedure is the main windows procedure and is used to register,
 *  create and show the window, and wait for windows messages.
 *)
 
VAR
   message : TMsg;

BEGIN

   Initialise ;

   MainWindow(0);
   
      {*
       * Windows main message loop - make sure your program issues a
       * call to the Windows API routine "PostQuitMessage" to terminate
       * the program.
       *}
   WHILE GetMessage (message, 0, 0, 0) DO
      BEGIN
      TranslateMessage (message);
      DispatchMessage (message);
      END;

   Halt (message.wParam);      

END;


{=================================================================}
PROCEDURE RegisterWindowClasses;

{*
 *  This procedure registers the window classes which will be used
 *  throughout the program.
 *}

VAR
   WinClass : TWndClass;               {Window class for any window       }

BEGIN
   IF hPrevInst = 0 THEN
      BEGIN
         {* Register class for window "ListWeather" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_ListWeather;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'ListWeather Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 

         {* Register class for window "ListComment" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_ListComment;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'ListComment Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 

         {* Register class for window "ListFlight" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_ListFlight;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'ListFlight Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 

         {* Register class for window "AddFlight" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_AddFlight;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'AddFlight Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 

         {* Register class for window "ListSite" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_ListSite;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'ListSite Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 

         {* Register class for window "AddSite" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_AddSite;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'AddSite Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 

         {* Register class for window "ListGliders" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_ListGliders;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'ListGliders Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 

         {* Register class for window "MainWindow" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_MainWindow;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'MainWindow Class';
      WinClass.lpszMenuName  := 'MainWindow_Menu';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 
      END;
END;


   {================}
   {  Main Control  }
   {================}

BEGIN
   RegisterWindowClasses;
   WinMain;
END.