PROGRAM BOOKLIB;

{*========================================================================
 *
 *  Program generated by Phase3 :- 
 *
 *      Date : Wednesday, July 14, 1993
 *
 *      Time : 03:07pm
 *
 *=======================================================================}


   {* Include USES clause, stack details etc. *}
{$I BOOKLIB.INC}


   {* Forward Declarations For Window Procs *}
FUNCTION MainWindow (hOwner : HWnd) : HWnd; FORWARD;

   {* Forward Declarations For Dialog Procs *}
FUNCTION ReportsDialog (hWindow : HWnd) : Integer; FORWARD;

   {* Forward Declarations For Report Procs *}
PROCEDURE PrintBooks (hOwner : HWnd); FORWARD;
PROCEDURE PrintAuthors (hOwner : HWnd); FORWARD;

   {* Forward Declarations For User Code *}
PROCEDURE Initialise; FORWARD;

PROCEDURE CleanUp; FORWARD;

PROCEDURE ProcessHotKeys (cKey : Char); FORWARD;

FUNCTION ValidateDataEntryFields (bDelete : Boolean) : BOOLEAN; FORWARD;

PROCEDURE BuildFindString (hWin : HWnd; szField : PChar); FORWARD;

PROCEDURE WinMain; FORWARD;



{=-------------------------------do-not-remove-this-line-=}
PROCEDURE Initialise; 
{=-------------------------------do-not-remove-this-line-=}

(* 
 * This routine will be called before the main window of 
 * the application appears. It should be used for any
 * initialisation code the application may require.
 *)
 
VAR
   szCurDir,
   szFile    : Array [0..100] of Char;
 
BEGIN
      {* Get current directory *}
   WinDos.GetCurDir (szCurDir, 0);

      {* Build Catalog name and full path using current directory *}
   StrCopy (szFile, szCurDir);
   StrCat (szFile, '\');
   StrCat (szFile, 'BOOKLIB.SC');
            
      {* obtain a database session *}
    hUser := DB_Init ('Books', P3SESSION_SINGLEUSER ) ;   
   IF hUser = 0 THEN
      Halt;  

      {* load catalog "Book" into memory *}
   IF NOT  DB_LoadCatalog (hUser, 'BookLib', szFile )  THEN
      BEGIN
       DB_Exit (hUser ) ;
      Halt; 	 	
      END;
 	 	
      {* open the catalog for use *}
   IF NOT  DB_OpenCatalog (hUser, 'BookLib' )  THEN
      BEGIN
       DB_Exit (hUser ) ;
      Halt; 	 	
      END;
 	 	
      {* open the table for use *}
    hTable := DB_OpenTable (hUser, 'Book' ) ;
   IF hTable = 0 THEN
      BEGIN
       DB_Exit (hUser ) ;
      Halt; 	 	
      END;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE CleanUp;
{=-------------------------------do-not-remove-this-line-=}

(* 
 * Carry out any final processing you require before your 
 * application closes.
 *)
 
BEGIN
      (* close down the database session *)
    DB_Exit (hUser ) ;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE ProcessHotKeys (cKey : Char);
{=-------------------------------do-not-remove-this-line-=}

BEGIN
      {* Perform required action depending upon which ALT key combination was pressed *}
   CASE UpCase (cKey) OF
      'A' :  P3_SendNotifyMessage (hWndMainWindow_BtnAdd, BN_CLICKED ) ;
      'B' :  SetFocus (hWndMainWindow_ListBoxBooks ) ;
      'D' :  P3_SendNotifyMessage (hWndMainWindow_BtnDelete, BN_CLICKED ) ;
      'F' :  P3_SendNotifyMessage (hWndMainWindow_BtnFind, BN_CLICKED ) ;
      'M' :  P3_SendNotifyMessage (hWndMainWindow_BtnModify, BN_CLICKED ) ;
      'N' :  P3_SendNotifyMessage (hWndMainWindow_BtnNext, BN_CLICKED ) ;
      'R' :  P3_SendNotifyMessage (hWndMainWindow_BtnReports, BN_CLICKED ) ;
      'X' :  P3_SendNotifyMessage (hWndMainWindow_BtnExit, BN_CLICKED ) ;
      ELSE
          MessageBeep (MB_ICONASTERISK ) ;
      END;
END;


{=-------------------------------do-not-remove-this-line-=}
FUNCTION ValidateDataEntryFields (bDelete : Boolean) : BOOLEAN;
{=-------------------------------do-not-remove-this-line-=}

VAR
   nLen : Integer;
   
BEGIN
   ValidateDataEntryFields := FALSE;
   
    nLen := GetWindowTextLength (hWndMainWindow_DEISBN ) ;
   IF nLen = 0 THEN
      BEGIN
       MessageBeep (MB_ICONASTERISK ) ;
      MessageBox (hWndMainWindow, 'ISBN field is required', NIL, MB_OK);
       SetFocus (hWndMainWindow_DEISBN ) ;
      Exit;
      END;

   IF not bDelete THEN
      BEGIN   
       nLen := GetWindowTextLength (hWndMainWindow_DETitle ) ;
      IF nLen = 0 THEN
         BEGIN
          MessageBeep (MB_ICONASTERISK ) ;
         MessageBox (hWndMainWindow, 'Title field is required', NIL, MB_OK);
          SetFocus (hWndMainWindow_DETitle ) ;
         Exit;
         END;
      END;

   ValidateDataEntryFields := TRUE;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE BuildFindString (hWin : HWnd; szField : PChar);
{=-------------------------------do-not-remove-this-line-=}

VAR
   nLen   : Integer;
   wSize  : Word;
   szWork : Array [0..100] of Char;

BEGIN
    nLen := GetWindowTextLength (hWin ) ;
   IF nLen = 0 THEN
      Exit;

    GetWindowText (hWin, szWork, 100 ) ;
   IF not bFirst THEN
      StrCat (szFind, ' .AND. ');
   StrCat (szFind, szField);
   StrCat (szFind, ' ~ ^');
   StrCat (szFind, szWork);
   StrCat (szFind, '*');
   StrCat (szFind, '^');

   bFirst := FALSE;
END;



{=================================================================}
PROCEDURE PrintBooks (hOwner : HWnd);

{*
 *  Build report and output to specified destination (ie. Screen or Printer).
 *}

VAR
   hUser,
   hReport,
   hQuery      : THandle;
   hReportWnd,
   hDisplayWnd : hWnd;
   font        : TLogFont;
   ok          : Boolean;  
   wGrpBook_Category : Word;

BEGIN  
   P3User.CreateDisplayWindow (hOwner, hReportWnd, 'PrintBooks');

   hReport := RP_Init (MakeProcInstance (@P3User.SystemError, hInstance),
                       hReportWnd);
   IF hReport = 0 THEN
      Exit;

   IF not RP_SwitchToScreen (hReport, hDisplayWnd) THEN
      Exit;

   IF not RP_SetPageSize (hReport, 640, 1050) THEN
      Exit;  
      {* Create all required sort groups *}
   wGrpBook_Category := RP_CreateGroup (hReport, 'Book.Category', RPG_Header);


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_ReportHeader, 0) THEN 
      Exit;


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_PageHeader, 75) THEN 
      Exit;

      {* Select the appropriate font a Text field *}
   P3Procs.P3_GetLogFont (-27, 0, 0, 0, 700, 0, 1, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, 'Times New Roman', @font);  

   IF not RP_AddText (hReport, RPS_PageHeader, 
                      'List of Books by Category', 
                      0, 45, 641, 16, 30, font) THEN 
      Exit;  

      {* Select the appropriate font a Text field *}
   P3Procs.P3_GetLogFont (16, 7, 0, 0, 700, 0, 0, 0, 0, 1, 2, 2, 
                  FF_SWISS + VARIABLE_PITCH, 'System', @font);  

   IF not RP_AddText (hReport, RPS_PageHeader, 
                      'Page', 
                      576, 0, RP_CalculateExtent, 16, 26, font) THEN 
      Exit;  

    IF not RP_AddPageNum (hReport, RPS_PageHeader, 
                         '0 (General)', 
                         616, 0, 25, 16, 24, font) THEN 
      Exit;  


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_Body, 15) THEN 
      Exit;

      {* Select the appropriate font for a Database field *}
   P3Procs.P3_GetLogFont (-13, 0, 0, 0, 700, 0, 0, 0, 0, 3, 2, 1, 
                  FF_SWISS + VARIABLE_PITCH, 'Arial', @font);  

   IF not RP_AddDBCol (hReport, RPS_Body, 
                       'Book.Title', 'Asis', 
                       40, 0, 641, 16, 24, font) THEN 
      Exit;


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_PageFooter, 15) THEN 
      Exit;


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_ReportFooter, 0) THEN 
      Exit;


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, wGrpBook_Category, 60) THEN 
      Exit;

      {* Select the appropriate font a Text field *}
   P3Procs.P3_GetLogFont (-21, 0, 0, 0, 400, 0, 0, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, 'Times New Roman', @font);  

   IF not RP_AddText (hReport, wGrpBook_Category, 
                      'Category:', 
                      8, 30, RP_CalculateExtent, 16, 24, font) THEN 
      Exit;  

      {* Select the appropriate font for a Database field *}
   P3Procs.P3_GetLogFont (-21, 0, 0, 0, 700, 0, 0, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, 'Times New Roman', @font);  

   IF not RP_AddDBCol (hReport, wGrpBook_Category, 
                       'Book.Category', 'Asis', 
                       96, 30, 241, 16, 24, font) THEN 
      Exit;

 
   hUser := DB_Init ('BOOKLIB', P3SESSION_SINGLEUSER);
   IF hUser = 0 THEN
      Exit;

   P3_hUser := hUser;

   IF NOT DB_LoadCatalog (P3_hUser, 'BOOKLIB', 'f:\p3-1.1a3\other\disk3\psamples\BOOKLIB.SC') THEN
      BEGIN
      DB_Exit (P3_hUser);
      Exit;
      END;  

{****** Begin user-created code ******}
{ This report will default to the screen. To send }
{ it to the printer, include the following line:  }

IF bPrinter THEN
   RP_SwitchToPrinter (hReport); 
{******* End user-created code *******}
 
   IF NOT DB_CreateDerivedTable (P3_hUser, 'BOOKLIB', 'ReptTabl',
      'BOOK') THEN
      BEGIN
      DB_Exit (P3_hUser);
      Exit;
      END; 

   IF NOT RP_OpenCatalog (hReport, P3_hUser, 'BOOKLIB', 'ReptTabl') THEN
      BEGIN
      DB_Exit (P3_hUser);
      Exit;
      END;  

   IF NOT RP_SetOrder (hReport, 'CATEGORY + TITLE') THEN
      Exit;  

   P3User.RunReport (hReport, hReportWnd, hDisplayWnd);
END;



{=================================================================}
PROCEDURE PrintAuthors (hOwner : HWnd);

{*
 *  Build report and output to specified destination (ie. Screen or Printer).
 *}

VAR
   hUser,
   hReport,
   hQuery      : THandle;
   hReportWnd,
   hDisplayWnd : hWnd;
   font        : TLogFont;
   ok          : Boolean;  
   wGrpBook_AuthorLastName : Word;

BEGIN  
   P3User.CreateDisplayWindow (hOwner, hReportWnd, 'PrintAuthors');

   hReport := RP_Init (MakeProcInstance (@P3User.SystemError, hInstance),
                       hReportWnd);
   IF hReport = 0 THEN
      Exit;

   IF not RP_SwitchToScreen (hReport, hDisplayWnd) THEN
      Exit;

   IF not RP_SetPageSize (hReport, 640, 1050) THEN
      Exit;  
      {* Create all required sort groups *}
   wGrpBook_AuthorLastName := RP_CreateGroup (hReport, 'Book.AuthorLastName', RPG_Header);


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_ReportHeader, 0) THEN 
      Exit;


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_PageHeader, 75) THEN 
      Exit;

      {* Select the appropriate font a Text field *}
   P3Procs.P3_GetLogFont (-32, 0, 0, 0, 700, 0, 1, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, 'Times New Roman', @font);  

   IF not RP_AddText (hReport, RPS_PageHeader, 
                      'List of Books by Author', 
                      0, 45, 641, 16, 30, font) THEN 
      Exit;  

      {* Select the appropriate font a Text field *}
   P3Procs.P3_GetLogFont (16, 7, 0, 0, 700, 0, 0, 0, 0, 1, 2, 2, 
                  FF_SWISS + VARIABLE_PITCH, 'System', @font);  

   IF not RP_AddText (hReport, RPS_PageHeader, 
                      'Page', 
                      576, 0, RP_CalculateExtent, 16, 26, font) THEN 
      Exit;  

    IF not RP_AddPageNum (hReport, RPS_PageHeader, 
                         '0 (General)', 
                         616, 0, 25, 16, 24, font) THEN 
      Exit;  


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_Body, 15) THEN 
      Exit;

      {* Select the appropriate font for a Database field *}
   P3Procs.P3_GetLogFont (16, 7, 0, 0, 700, 0, 0, 0, 0, 1, 2, 2, 
                  FF_SWISS + VARIABLE_PITCH, 'System', @font);  

   IF not RP_AddDBCol (hReport, RPS_Body, 
                       'Book.Title', 'Asis', 
                       40, 0, 641, 16, 24, font) THEN 
      Exit;


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_PageFooter, 0) THEN 
      Exit;


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, RPS_ReportFooter, 0) THEN 
      Exit;


      {* Define a report section *}
   IF not RP_SetSectionDepth (hReport, wGrpBook_AuthorLastName, 60) THEN 
      Exit;

      {* Select the appropriate font a Text field *}
   P3Procs.P3_GetLogFont (-21, 0, 0, 0, 400, 0, 0, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, 'Times New Roman', @font);  

   IF not RP_AddText (hReport, wGrpBook_AuthorLastName, 
                      'Author:', 
                      8, 30, RP_CalculateExtent, 16, 24, font) THEN 
      Exit;  

      {* Select the appropriate font for a Database field *}
   P3Procs.P3_GetLogFont (-21, 0, 0, 0, 700, 0, 0, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, 'Times New Roman', @font);  

   IF not RP_AddDBCol (hReport, wGrpBook_AuthorLastName, 
                       'Book.AuthorLastName', 'Asis', 
                       80, 30, 241, 16, 24, font) THEN 
      Exit;

 
   hUser := DB_Init ('BOOKLIB', P3SESSION_SINGLEUSER);
   IF hUser = 0 THEN
      Exit;

   P3_hUser := hUser;

   IF NOT DB_LoadCatalog (P3_hUser, 'BOOKLIB', 'f:\p3-1.1a3\other\disk3\psamples\BOOKLIB.SC') THEN
      BEGIN
      DB_Exit (P3_hUser);
      Exit;
      END;  

{****** Begin user-created code ******}
{ This report will default to the screen. To send }
{ it to the printer, include the following line:  }

{ RP_SwitchToPrinter (hReport); }
{******* End user-created code *******}
 
   IF NOT DB_CreateDerivedTable (P3_hUser, 'BOOKLIB', 'ReptTabl',
      'BOOK') THEN
      BEGIN
      DB_Exit (P3_hUser);
      Exit;
      END; 

   IF NOT RP_OpenCatalog (hReport, P3_hUser, 'BOOKLIB', 'ReptTabl') THEN
      BEGIN
      DB_Exit (P3_hUser);
      Exit;
      END;  

   IF NOT RP_SetOrder (hReport, 'AUTHORLASTNAME + TITLE') THEN
      Exit;  

   P3User.RunReport (hReport, hReportWnd, hDisplayWnd);
END;


{=================================================================}
FUNCTION DlgProc_ReportsDialog
                    (hDlg      : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : BOOL; EXPORT;

VAR
   dc : HDC;
VAR
   wCheck : Word;
   
BEGIN
   DlgProc_ReportsDialog := TRUE;

   CASE wMessage OF
      WM_INITDIALOG :
         BEGIN
         P3Decs.hWndReportsDialog := hDlg;
         P3Decs.hWndReportsDialog_Btn101_LISTOFBOOKSBYCATEGORY := GetDlgItem (hDlg, 101);
         P3Decs.hWndReportsDialog_Btn102_LISTOFBOOKSBYAUTHOR := GetDlgItem (hDlg, 102);
         P3Decs.hWndReportsDialog_Btn103_PRINTER := GetDlgItem (hDlg, 103);
         P3Decs.hWndReportsDialog_Btn104_SCREEN := GetDlgItem (hDlg, 104);
         P3Decs.hWndReportsDialog_Btn1_PRINT := GetDlgItem (hDlg, 1);
         P3Decs.hWndReportsDialog_Btn2_CANCEL := GetDlgItem (hDlg, 2);


{****** Begin user-created code for "WM_INITDIALOG" ******}

{*
 *  Perform required initialisation for reports dialog.
 *}
 
   {* Select Books by Category report initially *} 
 CheckRadioButton (hWndReportsDialog, 101, 102, 101 ) ;
                    
   {* Select destination as Screen initially *}                  
 CheckRadioButton (hWndReportsDialog, 103, 104, 104 ) ;
                    
 SetFocus (hWndReportsDialog_Btn101_LISTOFBOOKSBYCATEGORY ) ;
{******* End user-created code for "WM_INITDIALOG" *******}

         Exit;
         END;

      WM_PAINT :
         BEGIN
         dc := GetDC (hDlg);
         ReleaseDC (hDlg, dc);

         { fall through to default WM_PAINT processing }
         END;

      WM_SETFOCUS :
         BEGIN
         END;

      WM_COMMAND :
         BEGIN
         CASE wParam OF
            1 : 
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
{****** Begin user-created code ******}

{*
 *  Reports Dialog : PRINT button pressed - Determine type of report selected
 *        and destination and call appropriate report routine.
 *}

bPrinter :=  IsDlgButtonChecked (hWndReportsDialog, 103 ) <> 0 ;
   
 wCheck := IsDlgButtonChecked (hWndReportsDialog, 101 ) ;
IF wCheck <> 0 THEN
   PrintBooks (hWndReportsDialog) 
ELSE
   PrintAuthors (hWndReportsDialog) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            2 : 
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
{****** Begin user-created code ******}

EndDialog (hWndReportsDialog, 0);


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            END;  {case wParam}


         END;

      WM_CLOSE :
         BEGIN
         EndDialog (hDlg, 0);
         Exit;
         END;

      WM_DESTROY :
         BEGIN
         Exit;
         END;
      END;  {case}

   DlgProc_ReportsDialog := FALSE;
END;


{=================================================================}
FUNCTION ReportsDialog (hWindow : HWnd) : Integer;
VAR
   lpfnDlgProc : TFarProc;
   nResult     : Integer;

BEGIN
   lpfnDlgProc := MakeProcInstance (@DlgProc_ReportsDialog, hInstance);
   nResult := DialogBox (hInstance, 'ReportsDialog', hWindow, lpfnDlgProc);
   IF nResult = -1 THEN
      BEGIN
      P3User.SystemError ('Could not create dialog box.');
      Exit;
      END;

   FreeProcInstance (lpfnDlgProc);
   ReportsDialog := nResult;
END;


{==========================================================================}
FUNCTION EditSubClass_MainWindow
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   EditSubClass_MainWindow := 0;

   CASE wMessage OF
      WM_SYSCHAR :
         BEGIN
{****** Begin user-created code ******}
ProcessHotKeys (Chr (wParam)) ;
Exit;

{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldEditProc));

   EditSubClass_MainWindow := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{==========================================================================}
FUNCTION ButtonSubClass_MainWindow
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   ButtonSubClass_MainWindow := 0;

   CASE wMessage OF
      WM_SYSCHAR :
         BEGIN
{****** Begin user-created code ******}
ProcessHotKeys (Chr (wParam)) ;
Exit;

{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldButtonProc));

   ButtonSubClass_MainWindow := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{==========================================================================}
FUNCTION ListSubClass_MainWindow
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   ListSubClass_MainWindow := 0;

   CASE wMessage OF
      WM_SYSCHAR :
         BEGIN
{****** Begin user-created code ******}
ProcessHotKeys (Chr (wParam)) ;
Exit;

{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldListProc));

   ListSubClass_MainWindow := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
PROCEDURE CreateObjects_MainWindow (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^MainWindowRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   EBPtr^.hWndMainWindow_DEAuthorFirstName := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or ES_AUTOHSCROLL or WS_VISIBLE, 
                                   116, 242, 155, 19, 
                                   hWindow, idMainWindow_DEAuthorFirstName, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_DEAuthorFirstName = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_DEAuthorFirstName"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_DEAuthorFirstName := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_DEAuthorFirstName, WM_SETFONT,
                       EBPtr^.hFontMainWindow_DEAuthorFirstName, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_DEAuthorFirstName,
                      @EditSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_DEAuthorFirstName, 6); 

   EBPtr^.hWndMainWindow_DEISBN := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or ES_AUTOHSCROLL or WS_VISIBLE, 
                                   116, 60, 155, 19, 
                                   hWindow, idMainWindow_DEISBN, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_DEISBN = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_DEISBN"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_DEISBN := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_DEISBN, WM_SETFONT,
                       EBPtr^.hFontMainWindow_DEISBN, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_DEISBN,
                      @EditSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_DEISBN, 1); 

   EBPtr^.hWndMainWindow_DETitle := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or ES_AUTOHSCROLL or WS_VISIBLE, 
                                   116, 90, 200, 19, 
                                   hWindow, idMainWindow_DETitle, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_DETitle = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_DETitle"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_DETitle := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_DETitle, WM_SETFONT,
                       EBPtr^.hFontMainWindow_DETitle, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_DETitle,
                      @EditSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_DETitle, 2); 

   EBPtr^.hWndMainWindow_BtnAdd := CreateWindow ('BUTTON', 
                                   '&Add', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   38, 339, 84, 24, 
                                   hWindow, idMainWindow_BtnAdd, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnAdd = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnAdd"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnAdd := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'System'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnAdd, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnAdd, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnAdd,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnAdd, 8); 

   EBPtr^.hWndMainWindow_BtnDelete := CreateWindow ('BUTTON', 
                                   '&Delete', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   238, 339, 84, 24, 
                                   hWindow, idMainWindow_BtnDelete, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnDelete = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnDelete"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnDelete := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'System'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnDelete, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnDelete, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnDelete,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnDelete, 10); 

   EBPtr^.hWndMainWindow_BtnModify := CreateWindow ('BUTTON', 
                                   '&Modify', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   138, 339, 84, 24, 
                                   hWindow, idMainWindow_BtnModify, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnModify = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnModify"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnModify := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'System'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnModify, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnModify, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnModify,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnModify, 9); 

   EBPtr^.hWndMainWindow_DEPublisher := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or ES_AUTOHSCROLL or WS_VISIBLE, 
                                   116, 150, 155, 19, 
                                   hWindow, idMainWindow_DEPublisher, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_DEPublisher = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_DEPublisher"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_DEPublisher := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_DEPublisher, WM_SETFONT,
                       EBPtr^.hFontMainWindow_DEPublisher, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_DEPublisher,
                      @EditSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_DEPublisher, 4); 

   EBPtr^.hWndMainWindow_DESubTitle := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or ES_AUTOHSCROLL or WS_VISIBLE, 
                                   116, 120, 200, 19, 
                                   hWindow, idMainWindow_DESubTitle, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_DESubTitle = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_DESubTitle"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_DESubTitle := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_DESubTitle, WM_SETFONT,
                       EBPtr^.hFontMainWindow_DESubTitle, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_DESubTitle,
                      @EditSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_DESubTitle, 3); 

   EBPtr^.hWndMainWindow_BtnFind := CreateWindow ('BUTTON', 
                                   '&Find', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   397, 102, 84, 24, 
                                   hWindow, idMainWindow_BtnFind, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnFind = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnFind"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnFind := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'System'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnFind, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnFind, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnFind,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnFind, 11); 

   EBPtr^.hWndMainWindow_BtnNext := CreateWindow ('BUTTON', 
                                   '&Next', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   497, 102, 84, 24, 
                                   hWindow, idMainWindow_BtnNext, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnNext = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnNext"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnNext := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'System'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnNext, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnNext, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnNext,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnNext, 12); 

   EBPtr^.hWndMainWindow_DECategory := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or ES_AUTOHSCROLL or WS_VISIBLE, 
                                   116, 180, 155, 19, 
                                   hWindow, idMainWindow_DECategory, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_DECategory = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_DECategory"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_DECategory := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_DECategory, WM_SETFONT,
                       EBPtr^.hFontMainWindow_DECategory, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_DECategory,
                      @EditSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_DECategory, 5); 

   EBPtr^.hWndMainWindow_DEAuthorLastName := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or ES_AUTOHSCROLL or WS_VISIBLE, 
                                   116, 272, 155, 19, 
                                   hWindow, idMainWindow_DEAuthorLastName, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_DEAuthorLastName = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_DEAuthorLastName"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_DEAuthorLastName := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_DEAuthorLastName, WM_SETFONT,
                       EBPtr^.hFontMainWindow_DEAuthorLastName, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_DEAuthorLastName,
                      @EditSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_DEAuthorLastName, 7); 

   EBPtr^.hWndMainWindow_ListBoxBooks := CreateWindow ('LISTBOX', 
                                   '', 
                                   WS_CHILD or LBS_NOTIFY or LBS_SORT or 
                                   LBS_USETABSTOPS or LBS_NOINTEGRALHEIGHT or 
                                   LBS_DISABLENOSCROLL or WS_VSCROLL or 
                                   WS_VISIBLE, 
                                   380, 167, 216, 140, 
                                   hWindow, idMainWindow_ListBoxBooks, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_ListBoxBooks = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_ListBoxBooks"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_ListBoxBooks := 
               P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_ListBoxBooks, WM_SETFONT,
                       EBPtr^.hFontMainWindow_ListBoxBooks, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_ListBoxBooks,
                      @ListSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldListProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_ListBoxBooks, 13); 

   EBPtr^.hWndMainWindow_BtnExit := CreateWindow ('BUTTON', 
                                   'E&xit', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   497, 340, 84, 24, 
                                   hWindow, idMainWindow_BtnExit, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnExit = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnExit"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnExit := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'System'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnExit, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnExit, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnExit,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnExit, 15); 

   EBPtr^.hWndMainWindow_BtnReports := CreateWindow ('BUTTON', 
                                   '&Reports', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   397, 340, 84, 24, 
                                   hWindow, idMainWindow_BtnReports, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnReports = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnReports"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnReports := 
               P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'System'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnReports, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnReports, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnReports,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnReports, 14); 

END;


{=================================================================}
PROCEDURE UpdateHandles_MainWindow (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^MainWindowRec;

BEGIN
   P3Decs.hWndMainWindow := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   P3Decs.hWndMainWindow_DEISBN := EBPtr^.hWndMainWindow_DEISBN;
   P3Decs.hWndMainWindow_DETitle := EBPtr^.hWndMainWindow_DETitle;
   P3Decs.hWndMainWindow_DESubTitle := EBPtr^.hWndMainWindow_DESubTitle;
   P3Decs.hWndMainWindow_DEPublisher := EBPtr^.hWndMainWindow_DEPublisher;
   P3Decs.hWndMainWindow_DEAuthorFirstName := EBPtr^.hWndMainWindow_DEAuthorFirstName;
   P3Decs.hWndMainWindow_DEAuthorLastName := EBPtr^.hWndMainWindow_DEAuthorLastName;
   P3Decs.hWndMainWindow_BtnAdd := EBPtr^.hWndMainWindow_BtnAdd;
   P3Decs.hWndMainWindow_BtnDelete := EBPtr^.hWndMainWindow_BtnDelete;
   P3Decs.hWndMainWindow_BtnModify := EBPtr^.hWndMainWindow_BtnModify;
   P3Decs.hWndMainWindow_BtnFind := EBPtr^.hWndMainWindow_BtnFind;
   P3Decs.hWndMainWindow_BtnNext := EBPtr^.hWndMainWindow_BtnNext;
   P3Decs.hWndMainWindow_DECategory := EBPtr^.hWndMainWindow_DECategory;
   P3Decs.hWndMainWindow_ListBoxBooks := EBPtr^.hWndMainWindow_ListBoxBooks;
   P3Decs.hWndMainWindow_BtnExit := EBPtr^.hWndMainWindow_BtnExit;
   P3Decs.hWndMainWindow_BtnReports := EBPtr^.hWndMainWindow_BtnReports;
END;


{=================================================================}
FUNCTION WinProc_MainWindow
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "MainWindow" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^MainWindowRec;

VAR
   bOK        : Boolean;
   szTitle    : Array [0..100] of Char;
   szISBN     : Array [0..30] of Char;
   nSel,
   nTabStop   : Integer;
   lSel       : LongInt;
   pTabStop   : Pointer;
   szWork,
   szWork2    : PChar;
   hTableList : THandle;
   
   
BEGIN
   WinProc_MainWindow := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

            {* Set window background colour *}
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                         CreateSolidBrush (RGB (192, 192, 192)));

            {* Create brush for painting background for controls *}
         EBPtr^.P3_hBrushCtlColor := CreateSolidBrush (RGB (192, 192, 192));

         CreateObjects_MainWindow (hWindow);
         UpdateHandles_MainWindow (hWindow);

{****** Begin user-created code for "WM_CREATE" ******}

{*
 *  The following code is executed when the window is first created. The functions
 *  performed by this code are :-
 *     1) Attach the edit boxes to the appropriate database columns allowing 
 *             fields to be extracted and loaded to and from the database.
 *     2) Add the list of book titles from the database to the list box.
 *     3) Set the focus to the first data entry field.
 *}

   {* Attach edit boxes to data entry fields *}
 DB_EditAttach (hUser, hTable, 'ISBN', hWndMainWindow_DEISBN ) ;
 DB_EditAttach (hUser, hTable, 'Title', hWndMainWindow_DETITLE ) ;
 DB_EditAttach (hUser, hTable, 'SubTitle', hWndMainWindow_DESUBTITLE ) ;
 DB_EditAttach (hUser, hTable, 'Publisher', hWndMainWindow_DEPUBLISHER ) ;
 DB_EditAttach (hUser, hTable, 'Category', hWndMainWindow_DECATEGORY ) ;
 DB_EditAttach (hUser, hTable, 'AuthorFirstName', hWndMainWindow_DEAUTHORFIRSTNAME ) ;
 DB_EditAttach (hUser, hTable, 'AuthorLastName', hWndMainWindow_DEAUTHORLASTNAME ) ;

   {* Set tab stop in list box to outside right hand edge *}
pTabStop := @nTabStop;
nTabStop := 220;
 SendMessage (hWndMainWindow_ListBoxBooks, LB_SETTABSTOPS, 1, LongInt (pTabStop) ) ;   

   {* Get all entries from database and add to listbox *}
 SendMessage (hWndMainWindow_ListBoxBooks, LB_RESETCONTENT, 0, 0 ) ;   
 SendMessage (hWndMainWindow_ListBoxBooks, WM_SETREDRAW, 0, 0 ) ;   
GetMem (szWork, 100);
 DB_GetFirstRow (hUser, hTable, bOK ) ;
WHILE bOK DO
   BEGIN
    DB_GetText (hUser, hTable, 'Title', szWork ) ;
   StrCopy (szTitle, szWork);
   StrCat (szTitle, Chr (9));       {Insert tab character}
    DB_GetText (hUser, hTable, 'ISBN', szWork ) ;
   StrCat (szTitle, szWork);
    P3_LBAddText (hWndMainWindow_ListBoxBooks, szTitle ) ;
    DB_GetNextRow (hUser, hTable, bOK ) ;
   END;
FreeMem (szWork, 100);
 SendMessage (hWndMainWindow_ListBoxBooks, WM_SETREDRAW, 1, 0 ) ;   

   {* Set the focus to the ISBN data entry field *}
 SetFocus (hWndMainWindow_DEISBN ) ;

   {* Disable the NEXT button *}
 EnableWindow (hWndMainWindow_BtnNext, FALSE ) ;
bFind := FALSE;

{******* End user-created code for "WM_CREATE" *******}

         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_MainWindow (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_MainWindow := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

            {* Paint static text on the screen *}
         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         P3_hFontWork := P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                       FF_SWISS + VARIABLE_PITCH, 'Arial');
         SelectObject (dc, P3_hFontWork);
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 1, 59, 108, 79);
         DrawText (dc, 'ISBN', 4,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 1, 89, 108, 109);
         DrawText (dc, 'Title', 5,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 1, 119, 108, 139);
         DrawText (dc, 'SubTitle', 8,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 1, 149, 108, 169);
         DrawText (dc, 'Publisher', 9,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 22, 241, 108, 261);
         DrawText (dc, 'First Name', 10,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 22, 271, 108, 291);
         DrawText (dc, 'Last Name', 9,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 2, 90, 109, 110);
         DrawText (dc, 'Title', 5,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 2, 120, 109, 140);
         DrawText (dc, 'SubTitle', 8,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 2, 150, 109, 170);
         DrawText (dc, 'Publisher', 9,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 23, 242, 109, 262);
         DrawText (dc, 'First Name', 10,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 23, 272, 109, 292);
         DrawText (dc, 'Last Name', 9,
                   P3_rtText, 34);

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 113, 86, 319, 112, 2, 
                                    RGB (128, 128, 128), RGB (255, 255, 255));

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 113, 268, 274, 294, 2, 
                                    RGB (128, 128, 128), RGB (255, 255, 255));

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 113, 238, 274, 264, 2, 
                                    RGB (128, 128, 128), RGB (255, 255, 255));

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 113, 176, 274, 202, 2, 
                                    RGB (128, 128, 128), RGB (255, 255, 255));

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 113, 116, 319, 142, 2, 
                                    RGB (128, 128, 128), RGB (255, 255, 255));

            {* Paint static text on the screen *}
         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         P3_hFontWork := P3Procs.P3_GetFont (-21, 700, 0, 0, 0, 0, 3, 2, 
                                       FF_ROMAN + VARIABLE_PITCH, 'Times New Roman');
         SelectObject (dc, P3_hFontWork);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 22, 210, 98, 236);
         DrawText (dc, 'Author', 6,
                   P3_rtText, 16);

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 9, 318, 351, 384, 3, 
                                    RGB (255, 255, 255), RGB (128, 128, 128));

            {* Draw a rectangle on the screen *}
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPenWork := SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (128, 128, 128)));
         Rectangle (dc, 25, 328, 334, 373);
         DeleteObject (SelectObject (dc, P3_hPenWork));

            {* Draw a rectangle on the screen *}
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPenWork := SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (255, 255, 255)));
         Rectangle (dc, 26, 329, 335, 374);
         DeleteObject (SelectObject (dc, P3_hPenWork));

            {* Paint static text on the screen *}
         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         P3_hFontWork := P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                       FF_SWISS + VARIABLE_PITCH, 'Arial');
         SelectObject (dc, P3_hFontWork);
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 1, 179, 108, 199);
         DrawText (dc, 'Category', 8,
                   P3_rtText, 34);

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 113, 146, 274, 172, 2, 
                                    RGB (128, 128, 128), RGB (255, 255, 255));

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 2, 180, 109, 200);
         DrawText (dc, 'Category', 8,
                   P3_rtText, 34);

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 361, 11, 618, 70, 3, 
                                    RGB (255, 255, 255), RGB (128, 128, 128));

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 375, 162, 601, 312, 3, 
                                    RGB (128, 128, 128), RGB (255, 255, 255));

            {* Draw a rectangle on the screen *}
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPenWork := SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (255, 255, 255)));
         Rectangle (dc, 376, 331, 600, 373);
         DeleteObject (SelectObject (dc, P3_hPenWork));

            {* Draw a rectangle on the screen *}
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPenWork := SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (255, 255, 255)));
         Rectangle (dc, 377, 93, 601, 135);
         DeleteObject (SelectObject (dc, P3_hPenWork));

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 361, 80, 618, 384, 3, 
                                    RGB (255, 255, 255), RGB (128, 128, 128));

            {* Draw a rectangle on the screen *}
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPenWork := SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (128, 128, 128)));
         Rectangle (dc, 375, 330, 599, 372);
         DeleteObject (SelectObject (dc, P3_hPenWork));

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 2, 60, 109, 80);
         DrawText (dc, 'ISBN', 4,
                   P3_rtText, 34);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 375, 144, 435, 162);
         DrawText (dc, 'Books', 5,
                   P3_rtText, 16);

            {* Paint static text on the screen *}
         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         P3_hFontWork := P3Procs.P3_GetFont (-21, 700, 0, 0, 0, 0, 3, 2, 
                                       FF_ROMAN + VARIABLE_PITCH, 'Times New Roman');
         SelectObject (dc, P3_hFontWork);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 22, 26, 78, 50);
         DrawText (dc, 'Book', 4,
                   P3_rtText, 16);

            {* Paint static text on the screen *}
         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         P3_hFontWork := P3Procs.P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                       FF_SWISS + VARIABLE_PITCH, 'Arial');
         SelectObject (dc, P3_hFontWork);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 376, 145, 436, 163);
         DrawText (dc, '&Books', 6,
                   P3_rtText, 16);

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 113, 56, 274, 82, 2, 
                                    RGB (128, 128, 128), RGB (255, 255, 255));

            {* Draw a rectangle on the screen *}
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPenWork := SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (128, 128, 128)));
         Rectangle (dc, 376, 92, 600, 134);
         DeleteObject (SelectObject (dc, P3_hPenWork));

            {* Paint static text on the screen *}
         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         P3_hFontWork := P3Procs.P3_GetFont (-37, 700, 0, 0, 0, 0, 3, 2, 
                                       FF_ROMAN + VARIABLE_PITCH, 'Times New Roman');
         SelectObject (dc, P3_hFontWork);
         SetTextColor (dc, RGB (0, 0, 128));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 380, 17, 598, 64);
         DrawText (dc, 'Book Library', 12,
                   P3_rtText, 53);

            {* Draw a relief rectangle on the screen *}
         P3Procs.P3_DrawReliefRect (dc, 9, 11, 351, 308, 3, 
                                    RGB (255, 255, 255), RGB (128, 128, 128));

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_SYSCHAR :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******} 

ProcessHotKeys (Chr (wParam)) ;
Exit;

{******* End user-created code *******}

         Exit;
         END;

      WM_COMMAND :
         BEGIN
         CASE wParam OF
            idMainWindow_BtnAdd :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  ADD Button pressed : Make sure required data entry fields have been entered
 *      and add to database. If entry already exists for given ISBN value then
 *      display an error. If add successful then add book title to listbox.
 *}

IF not ValidateDataEntryFields (FALSE)  THEN
   Exit;
   
   {* Add entry to database *}
 bOK := DB_EditsAddToTable (hUser, hTable ) ;
IF not bOK THEN
   BEGIN
   MessageBeep (0);
   Exit;
   END;
   
   {* Add entry to listbox *}
GetMem (szWork, 120);   
GetMem (szWork2, 100);   
 GetWindowText (hWndMainWindow_DETitle, szWork2, 100 ) ;
StrCopy (szWork, szWork2);
StrCat (szWork, Chr (9));
 GetWindowText (hWndMainWindow_DEISBN, szWork2, 100 ) ;
StrCat (szWork, szWork2);
FreeMem (szWork2, 100);
 lSel := SendMessage (hWndMainWindow_ListBoxBooks, LB_ADDSTRING, 0, LongInt (szWork) ) ;   
FreeMem (szWork, 120);
 SendMessage (hWndMainWindow_ListBoxBooks, LB_SETCURSEL, Word (lSel), 0 ) ;   

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, Word (-1) ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnDelete :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  DELETE Button pressed : Make sure required data entry fields have been entered
 *      and delete from database. 
 *}

IF not ValidateDataEntryFields (TRUE)  THEN
   Exit;
   
IF  MessageBox (hWndMainWindow, 'Do you want to delete this database entry ?', 
                 'Confirm Delete', MB_YESNO or MB_DEFBUTTON2 or MB_ICONQUESTION )  = IDNO THEN
   Exit;
   
   {* Get existing entry from database *}
 GetWindowText (hWndMainWindow_DEISBN, szISBN, 30 ) ;   
GetMem (szWork, 120);
StrCopy (szWork, 'ISBN = ^');
StrCat (szWork, szISBN);
StrCat (szWork, '^');
 DB_GetFirstRowWhere (hUser, hTable, szWork, bOK ) ;   
IF not bOK THEN
   BEGIN
   FreeMem (szWork, 120);
   Exit;
   END;

   {* Build list box entry for deleting entry from list box *}
GetMem (szWork2, 100);
 DB_GetText (hUser, hTable, 'Title', szWork2 ) ;
StrCopy (szWork, szWork2);
StrCat (szWork, Chr (9));     
 DB_GetText (hUser, hTable, 'ISBN', szWork2 ) ;
StrCat (szWork, szWork2);
FreeMem (szWork2, 100);

   {* Delete database entry *}
 DB_DeleteRow (hUser, hTable, bOK ) ;   

   {* Delete the entry from the list box *}
 lSel := SendMessage (hWndMainWindow_ListBoxBooks, LB_FINDSTRINGEXACT, Word (-1), LongInt (szWork) ) ;
IF lSel <> LB_ERR THEN
    P3_LBDeleteLine (hWndMainWindow_ListBoxBooks, Integer (lSel) ) ;

FreeMem (szWork, 120);

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, Word (-1) ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnModify :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  MODIFY Button pressed : Make sure required data entry fields have been entered
 *      and modify entry in database. 
 *}

IF not ValidateDataEntryFields (FALSE)  THEN
   Exit;
   
   {* Get existing entry from database *}
 GetWindowText (hWndMainWindow_DEISBN, szISBN, 30 ) ;
GetMem (szWork, 120);
StrCopy (szWork, 'ISBN = ^');
StrCat (szWork, szISBN);
StrCat (szWork, '^');
 DB_GetFirstRowWhere (hUser, hTable, szWork, bOK ) ;   
IF not bOK THEN
   BEGIN
   FreeMem (szWork, 120);
   Exit;
   END;

   {* Build list box entry for existing entry for search later *}
GetMem (szWork2, 100);
 DB_GetText (hUser, hTable, 'Title', szWork2 ) ;
StrCopy (szWork, szWork2);
StrCat (szWork, Chr (9));     
 DB_GetText (hUser, hTable, 'ISBN', szWork2 ) ;
StrCat (szWork, szWork2);
FreeMem (szWork2, 100);

   {* Update row in database *}
 bOK := DB_EditsUpdateRow (hUser, hTable ) ;   
IF not bOK THEN
   BEGIN
   FreeMem (szWork, 120);
   MessageBeep (0);
   Exit;
   END;

   {* Find the matching entry in the list box *}
 lSel := SendMessage (hWndMainWindow_ListBoxBooks, LB_FINDSTRINGEXACT, Word (-1), LongInt (szWork) ) ;
IF lSel <> LB_ERR THEN
    P3_LBDeleteLine (hWndMainWindow_ListBoxBooks, Integer (lSel) ) ;

   {* Build list box entry for updated entry *}
GetMem (szWork2, 100);
 DB_GetText (hUser, hTable, 'Title', szWork2 ) ;
StrCopy (szWork, szWork2);
StrCat (szWork, Chr (9));     
 DB_GetText (hUser, hTable, 'ISBN', szWork2 ) ;
StrCat (szWork, szWork2);
FreeMem (szWork2, 100);
   
   {* Update entry in listbox *}
IF lSel <> LB_ERR THEN
    P3_LBInsertText (hWndMainWindow_ListBoxBooks, Integer (lSel), szWork ) 
ELSE
    P3_LBAddText (hWndMainWindow_ListBoxBooks, szWork ) ;

FreeMem (szWork, 120);

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, Word (-1) ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnFind :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  FIND Button pressed : Find the first entry that matches the criteria in the edit boxes.
 *}
   
   {* Build search criteria *}
bFirst := TRUE;
GetMem (szFind, 500);
bFind := TRUE;
StrCopy (szFind, '');
BuildFindString (hWndMainWindow_DEISBN, 'ISBN') ;
BuildFindString (hWndMainWindow_DETitle, 'Title') ;
BuildFindString (hWndMainWindow_DESubTitle, 'SubTitle') ;
BuildFindString (hWndMainWindow_DEPublisher, 'Publisher') ;
BuildFindString (hWndMainWindow_DECategory, 'Category') ;
BuildFindString (hWndMainWindow_DEAuthorFirstName, 'AuthorFirstName') ;
BuildFindString (hWndMainWindow_DEAuthorLastName, 'AuthorLastName') ;

IF bFirst THEN
   BEGIN
    MessageBox (hWndMainWindow, 'Enter search criteria in appropriate data entry field(s)', 
                 'No Search Criteria', MB_OK or MB_ICONEXCLAMATION ) ;
    SetFocus (hWndMainWindow_DEISBN ) ;
    P3_EditSetSel (hWndMainWindow_DEISBN, 0, Word (-1) ) ;
   FreeMem (szFind, 500);
   Exit;
   END;
   
 DB_GetFirstRowWhere (hUser, hTable, szFind, bOK ) ;   
FreeMem (szFind, 500);
IF not bOK THEN
   BEGIN
    MessageBox (hWndMainWindow, 'No entry found matching search criteria', 
                 'Search', MB_OK or MB_ICONINFORMATION ) ;
    EnableWindow (hWndMainWindow_BtnNext, FALSE ) ;
   bFind := FALSE;
   END
ELSE
   BEGIN
      {* Fill data entry boxes with matching row from database *}
    bOK := DB_EditsFromRow (hUser, hTable ) ;
    EnableWindow (hWndMainWindow_BtnNext, TRUE ) ;
      {* Select matching entry in listbox *}
   GetMem (szWork, 120);
    DB_GetText (hUser, hTable, 'Title', szWork ) ;
   StrCopy (szTitle, szWork);
   StrCat (szTitle, Chr (9));
    DB_GetText (hUser, hTable, 'ISBN', szWork ) ;
   StrCat (szTitle, szWork);
    P3_LBSelectString (hWndMainWindow_ListBoxBooks, szTitle ) ;
   FreeMem (szWork, 120);
   END;

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, Word (-1) ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnNext :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Don't do anything if FIND has not yet been done *}
IF not bFind THEN
   BEGIN
   Exit;
   END;

   {* Find next row in database that matches search criteria *}
 DB_GetNextRowWhere (hUser, hTable, bOK ) ;   
IF not bOK THEN
   BEGIN
    MessageBox (hWndMainWindow, 'No more entries matching search criteria', 'Search', MB_OK or MB_ICONINFORMATION ) ;
    EnableWindow (hWndMainWindow_BtnNext, FALSE ) ;
   END
ELSE
   BEGIN
      {* Fill data entry boxes with matching row from database *}
    bOK := DB_EditsFromRow (hUser, hTable ) ;
      {* Select matching entry in listbox *}
   GetMem (szWork, 120);
    DB_GetText (hUser, hTable, 'Title', szWork ) ;
   StrCopy (szTitle, szWork);
   StrCat (szTitle, Chr (9));
    DB_GetText (hUser, hTable, 'ISBN', szWork ) ;
   StrCat (szTitle, szWork);
    P3_LBSelectString (hWndMainWindow_ListBoxBooks, szTitle ) ;
   FreeMem (szWork, 120);
   END;

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, Word (-1) ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_ListBoxBooks :
               BEGIN
               CASE HiWord (lParam) OF
                  LBN_SELCHANGE :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  The following code is executed whenever a item is selected in the listbox. The data is
 *  retrieved from the listbox and, using the ISBN value extracted from the listbox row, the 
 *  appropriate database row is then displayed in the edit boxes.
 *}

   {* Get the ISBN from the currently selected entry from the list box *}
 P3_LBGetSelection (hWndMainWindow_ListBoxBooks, nSel ) ;
IF ( P3_LBGetTabText (hWndMainWindow_ListBoxBooks, nSel, 2, szISBN, 30 )  <= 0) THEN
   BEGIN
   MessageBeep (0);
   Exit;
   END;

   {* Extract the row for the given ISBN value from the database *}
GetMem (szWork, 120);
StrCopy (szWork, 'ISBN = ^');
StrCat (szWork, szISBN);
StrCat (szWork, '^');
 DB_GetFirstRowWhere (hUser, hTable, szWork, bOK ) ;   
IF bOK THEN
    bOK := DB_EditsFromRow (hUser, hTable ) 
ELSE
   MessageBeep (0);
FreeMem (szWork, 120);


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnExit :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

 P3_WinClose (hWndMainWindow ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnReports :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

{*
 *  REPORTS button pressed : Call reports dialog box to select type of report
 *         to print and destination.
 *}

ReportsDialog (hWndMainWindow) ;
 SetFocus (hWndMainWindow_BtnReports ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            END;  {case wParam}

         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code for "WM_CLOSE" ******}

CleanUp ;

{******* End user-created code for "WM_CLOSE" *******}

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);

{****** Begin user-created code for "WM_DESTROY" ******}

PostQuitMessage(0);

{******* End user-created code for "WM_DESTROY" *******}

         DeleteObject (EBPtr^.hFontMainWindow_DEISBN);
         DeleteObject (EBPtr^.hFontMainWindow_DETitle);
         DeleteObject (EBPtr^.hFontMainWindow_DESubTitle);
         DeleteObject (EBPtr^.hFontMainWindow_DEPublisher);
         DeleteObject (EBPtr^.hFontMainWindow_DEAuthorFirstName);
         DeleteObject (EBPtr^.hFontMainWindow_DEAuthorLastName);
         DeleteObject (EBPtr^.hFontMainWindow_BtnAdd);
         DeleteObject (EBPtr^.hFontMainWindow_BtnDelete);
         DeleteObject (EBPtr^.hFontMainWindow_BtnModify);
         DeleteObject (EBPtr^.hFontMainWindow_BtnFind);
         DeleteObject (EBPtr^.hFontMainWindow_BtnNext);
         DeleteObject (EBPtr^.hFontMainWindow_DECategory);
         DeleteObject (EBPtr^.hFontMainWindow_ListBoxBooks);
         DeleteObject (EBPtr^.hFontMainWindow_BtnExit);
         DeleteObject (EBPtr^.hFontMainWindow_BtnReports);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_MainWindow := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION MainWindow (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('MainWindow Class', 
                         'Phase3 Sample - Book Library', 
                         WS_OVERLAPPED or WS_CAPTION or WS_SYSMENU or WS_THICKFRAME
                    or WS_MINIMIZEBOX or WS_VISIBLE,
                         CW_USEDEFAULT, CW_USEDEFAULT, 
                         635, 420, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "MainWindow"'); 

   UpdateWindow (hWin);

   MainWindow := hWin;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE WinMain; 
{=-------------------------------do-not-remove-this-line-=}

(*  
 *  WinMain Procedure
 *  =================
 *
 *  This procedure is the main windows procedure and is used to register,
 *  create and show the window, and wait for windows messages.
 *)
 
VAR
   message : TMsg;

BEGIN

   Initialise ;

   MainWindow(0);
   
      {*
       * Windows main message loop - make sure your program issues a
       * call to the Windows API routine "PostQuitMessage" to terminate
       * the program.
       *}
   WHILE GetMessage (message, 0, 0, 0) DO
      BEGIN
      TranslateMessage (message);
      DispatchMessage (message);
      END;

   Halt (message.wParam);      

END;


{=================================================================}
PROCEDURE RegisterWindowClasses;

{*
 *  This procedure registers the window classes which will be used
 *  throughout the program.
 *}

VAR
   WinClass : TWndClass;               {Window class for any window       }

BEGIN
   IF hPrevInst = 0 THEN
      BEGIN
         {* Register class for window "MainWindow" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_MainWindow;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'MainWindow Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 
      END;
END;


   {================}
   {  Main Control  }
   {================}

BEGIN
   RegisterWindowClasses;
   WinMain;
END.