PROGRAM BMPVWR;

{*========================================================================
 *
 *  Program generated by Phase3 :- 
 *
 *      Date : Tuesday, May 25, 1993
 *
 *      Time : 04:36pm
 *
 *=======================================================================}


   {* Include USES clause, stack details etc. *}
{$I BMPVWR.INC}


   {* Forward Declarations For Window Procs *}
FUNCTION BitmapWindow (hOwner : HWnd) : HWnd; FORWARD;
FUNCTION MainWindow (hOwner : HWnd) : HWnd; FORWARD;

   {* Forward Declarations For User Code *}
FUNCTION UpdateListBoxes (bDefault : Boolean) : BOOLEAN; FORWARD;

PROCEDURE ProcessHotKeys (cKey : Char); FORWARD;

FUNCTION GetFileName (szFileIn : PChar) : PCHAR; FORWARD;

PROCEDURE WinMain; FORWARD;

{=================================================================}
PROCEDURE CreateObjects_BitmapWindow (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^BitmapWindowRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

END;


{=================================================================}
PROCEDURE UpdateHandles_BitmapWindow (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^BitmapWindowRec;

BEGIN
   P3Decs.hWndBitmapWindow := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

END;


{=================================================================}
FUNCTION WinProc_BitmapWindow
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "BitmapWindow" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^BitmapWindowRec;

BEGIN
   WinProc_BitmapWindow := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

         CreateObjects_BitmapWindow (hWindow);
         UpdateHandles_BitmapWindow (hWindow);
         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_BitmapWindow (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_BitmapWindow := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

{****** Begin user-created code for "WM_PAINT" ******}

   {* Display the selected bitmap using the selected style *}
IF hBMP <> 0 THEN
   CASE wDisplayStyle OF

      idMainWindow_BtnAsis :            {Display the bitmap ASIS                   }
          P3_BitmapPaintWindow (hWndBitmapWindow, hBMP, P3BP_IGNORE, SRCCOPY ) ;

      idMainWindow_BtnStretch :         {Stretch/Shrink bitmap to fit window coords}
          P3_BitmapPaintWindow (hWndBitmapWindow, hBMP, P3BP_STRETCH, SRCCOPY ) ;

      idMainWindow_BtnTile :            {Tile the bitmap as many times as will fit }
          P3_BitmapPaintWindow (hWndBitmapWindow, hBMP, P3BP_TILE, SRCCOPY ) ;

      END;
   
{******* End user-created code for "WM_PAINT" *******}

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_COMMAND :
         BEGIN
         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_BitmapWindow := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION BitmapWindow (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('BitmapWindow Class', 
                         '', 
                         WS_CHILD or WS_VISIBLE,
                         275, 8, 
                         311, 306, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "BitmapWindow"'); 

   UpdateWindow (hWin);

   BitmapWindow := hWin;
END;




{=-------------------------------do-not-remove-this-line-=}
FUNCTION UpdateListBoxes (bDefault : Boolean) : BOOLEAN;
{=-------------------------------do-not-remove-this-line-=}

{*
 *  Display a list of bitmap files (those with BMP extension) in the current directory,
 *  and display a list of subdirectories and drives.
 *}

VAR
   szPtr : PChar;

BEGIN
   UpdateListBoxes := FALSE;
   
   szPtr := szBMPExt;
    SendMessage (hWndMainWindow_ListFiles, LB_RESETCONTENT, 0, 0 ) ;
    SendMessage (hWndMainWindow_ListFiles, LB_DIR, DDL_READWRITE, LongInt (szPtr) ) ;

   szPtr := szDefExt;
    SendMessage (hWndMainWindow_ListDirs, LB_RESETCONTENT, 0, 0 ) ;
   IF  SendMessage (hWndMainWindow_ListDirs, LB_DIR, 
                     DDL_EXCLUSIVE or DDL_DRIVES or DDL_DIRECTORY, 
                     LongInt (szPtr) )  = LB_ERR THEN
      Exit;

      {* Display '*.BMP' in the edit box *}
   IF bDefault THEN   
       SetWindowText (hWndMainWindow_EditBitmap, szBMPExt ) ;

      {* Display the current directory *}   
   GetCurDir (szDirectory, 0);
    InvalidateRect (hWndMainWindow, @rectDir, TRUE ) ;
   
   UpdateListBoxes := TRUE;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE ProcessHotKeys (cKey : Char);
{=-------------------------------do-not-remove-this-line-=}

BEGIN
      {* Perform required action depending upon which ALT key combination was pressed *}
   CASE UpCase (cKey) OF
      'A' :  P3_SendNotifyMessage (hWndMainWindow_BtnAsis, BN_CLICKED ) ;
      'B' :  SetFocus (hWndMainWindow_EditBitmap ) ;
      'D' :  P3_SendNotifyMessage (hWndMainWindow_BtnDisplay, BN_CLICKED ) ;
      'F' :  SetFocus (hWndMainWindow_ListFiles ) ;
      'R' :  SetFocus (hWndMainWindow_ListDirs ) ;
      'S' :  P3_SendNotifyMessage (hWndMainWindow_BtnStretch, BN_CLICKED ) ;
      'T' :  P3_SendNotifyMessage (hWndMainWindow_BtnTile, BN_CLICKED ) ;
      'X' :  P3_SendNotifyMessage (hWndMainWindow_BtnExit, BN_CLICKED ) ;
      ELSE
          MessageBeep (MB_ICONASTERISK ) ;
      END;
END;


{=-------------------------------do-not-remove-this-line-=}
FUNCTION GetFileName (szFileIn : PChar) : PCHAR;
{=-------------------------------do-not-remove-this-line-=}

{*
 *  Get a pointer to the file name part of a fully qualified path and file name string.
 *}

VAR
   szFP : PChar;

BEGIN
   szFP := StrRScan (szFileIn, '\');
   IF szFP = NIL THEN
      szFP := StrRScan (szFileIn, ':');
   IF szFP = NIL THEN
      GetFileName := szFileIn
   ELSE
      GetFileName := szFP + 1;
END;


{==========================================================================}
FUNCTION EditSubClass_MainWindow
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   EditSubClass_MainWindow := 0;

   CASE wMessage OF
      WM_CHAR :
         BEGIN
{****** Begin user-created code ******}
   {* If ENTER key pressed then simulate DISPLAY button being clicked *}
IF wParam = VK_RETURN THEN
   BEGIN
    P3_SendNotifyMessage (hWndMainWindow_BtnDisplay, BN_CLICKED ) ;
   Exit;
   END;
{******* End user-created code *******}
         END;

      WM_SYSCHAR :
         BEGIN
{****** Begin user-created code ******}
ProcessHotKeys (Chr (wParam)) ;
Exit;

{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldEditProc));

   EditSubClass_MainWindow := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{==========================================================================}
FUNCTION ButtonSubClass_MainWindow
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   ButtonSubClass_MainWindow := 0;

   CASE wMessage OF
      WM_SYSCHAR :
         BEGIN
{****** Begin user-created code ******}
ProcessHotKeys (Chr (wParam)) ;
Exit;

{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldButtonProc));

   ButtonSubClass_MainWindow := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{==========================================================================}
FUNCTION ListSubClass_MainWindow
            (hWindow  : HWnd;
             wMessage,
             wParam    : Word;
             lParam    : Longint) : LONGINT; EXPORT;

VAR
   hFocus,
   hParent : HWnd;
   oldProc : TFarProc;

BEGIN
   ListSubClass_MainWindow := 0;

   CASE wMessage OF
      WM_CHAR :
         BEGIN
{****** Begin user-created code ******}
IF wParam = VK_RETURN THEN
    P3_SendNotifyMessage (hWindow, LBN_DBLCLK ) ;
  
{******* End user-created code *******}
         END;

      WM_SYSCHAR :
         BEGIN
{****** Begin user-created code ******}
ProcessHotKeys (Chr (wParam)) ;
Exit;

{******* End user-created code *******}
         END;

      END; { Case wMessage Of  }

   hParent := GetParent (hWindow);
   oldProc := TFarProc (GetWindowLong (hParent, P3_ExtBytesOldListProc));

   ListSubClass_MainWindow := CallWindowProc(
      oldProc, hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
PROCEDURE CreateObjects_MainWindow (hWindow : HWnd);

{*
 *  Create the various child windows (objects and fields) associated with
 *  this screen.
 *}
 
VAR
   EBPtr       : ^MainWindowRec;
   P3_nWidth,
   P3_nHeight,
   P3_nRetCode : Integer;

BEGIN             
   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   EBPtr^.hWndMainWindow_BtnAsis := CreateWindow ('BUTTON', 
                                   '&Asis', 
                                   WS_CHILD or BS_RADIOBUTTON or WS_VISIBLE, 
                                   19, 270, 57, 20, 
                                   hWindow, idMainWindow_BtnAsis, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnAsis = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnAsis"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnAsis := 
               P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnAsis, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnAsis, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnAsis,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnAsis, 4); 

   EBPtr^.hWndMainWindow_BtnTile := CreateWindow ('BUTTON', 
                                   '&Tile', 
                                   WS_CHILD or BS_RADIOBUTTON or WS_VISIBLE, 
                                   19, 310, 60, 18, 
                                   hWindow, idMainWindow_BtnTile, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnTile = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnTile"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnTile := 
               P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnTile, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnTile, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnTile,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnTile, 6); 

   EBPtr^.hWndMainWindow_BtnStretch := CreateWindow ('BUTTON', 
                                   '&Stretch/Shrink', 
                                   WS_CHILD or BS_RADIOBUTTON or WS_VISIBLE, 
                                   19, 290, 127, 20, 
                                   hWindow, idMainWindow_BtnStretch, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnStretch = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnStretch"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnStretch := 
               P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnStretch, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnStretch, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnStretch,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnStretch, 5); 

   EBPtr^.hWndMainWindow_BtnDisplay := CreateWindow ('BUTTON', 
                                   '&Display', 
                                   WS_CHILD or BS_DEFPUSHBUTTON or WS_VISIBLE, 
                                   177, 256, 80, 26, 
                                   hWindow, idMainWindow_BtnDisplay, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnDisplay = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnDisplay"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnDisplay := 
               P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnDisplay, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnDisplay, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnDisplay,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnDisplay, 7); 

   EBPtr^.hWndMainWindow_ListFiles := CreateWindow ('LISTBOX', 
                                   '', 
                                   WS_CHILD or LBS_STANDARD or 
                                   LBS_DISABLENOSCROLL or WS_VISIBLE, 
                                   9, 93, 120, 145, 
                                   hWindow, idMainWindow_ListFiles, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_ListFiles = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_ListFiles"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_ListFiles := 
               P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_ListFiles, WM_SETFONT,
                       EBPtr^.hFontMainWindow_ListFiles, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_ListFiles,
                      @ListSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldListProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_ListFiles, 2); 

   EBPtr^.hWndMainWindow_ListDirs := CreateWindow ('LISTBOX', 
                                   '', 
                                   WS_CHILD or LBS_STANDARD or 
                                   LBS_DISABLENOSCROLL or WS_VISIBLE, 
                                   142, 93, 120, 145, 
                                   hWindow, idMainWindow_ListDirs, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_ListDirs = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_ListDirs"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_ListDirs := 
               P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_ListDirs, WM_SETFONT,
                       EBPtr^.hFontMainWindow_ListDirs, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_ListDirs,
                      @ListSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldListProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_ListDirs, 3); 

   EBPtr^.hWndMainWindow_BtnExit := CreateWindow ('BUTTON', 
                                   'E&xit', 
                                   WS_CHILD or BS_PUSHBUTTON or WS_VISIBLE, 
                                   177, 294, 80, 26, 
                                   hWindow, idMainWindow_BtnExit, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_BtnExit = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_BtnExit"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_BtnExit := 
               P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_BtnExit, WM_SETFONT,
                       EBPtr^.hFontMainWindow_BtnExit, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_BtnExit,
                      @ButtonSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldButtonProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_BtnExit, 8); 

   EBPtr^.hWndMainWindow_EditBitmap := CreateWindow ('EDIT', 
                                   '', 
                                   WS_CHILD or WS_BORDER or ES_AUTOHSCROLL or 
                                   WS_VISIBLE, 
                                   54, 15, 208, 21, 
                                   hWindow, idMainWindow_EditBitmap, hInstance, NIL);
      {* Make sure child window (field) was created *}
   IF EBPtr^.hWndMainWindow_EditBitmap = 0 THEN
      P3User.SystemError ('Error creating window "MainWindow_EditBitmap"');

      {* Set the appropriate font for this child window *}
   EBPtr^.hFontMainWindow_EditBitmap := 
               P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                   FF_SWISS + VARIABLE_PITCH, 'Arial'); 
   SendMessage (EBPtr^.hWndMainWindow_EditBitmap, WM_SETFONT,
                       EBPtr^.hFontMainWindow_EditBitmap, 0);

      {* Set address of sub-class procedure for this child window *}
   P3Procs.P3_SetSubClass (hWindow, EBPtr^.hWndMainWindow_EditBitmap,
                      @EditSubClass_MainWindow,
                      P3Decs.P3_ExtBytesOldEditProc);

      {* Add this child window to auto tab list *}
   P3Procs.P3_AddAutoTab (EBPtr^.hWndMainWindow_EditBitmap, 1); 

END;


{=================================================================}
PROCEDURE UpdateHandles_MainWindow (hWindow : HWnd);

{*
 *  Store handles of child windows in global variables.
 *}

VAR
   EBPtr   : ^MainWindowRec;

BEGIN
   P3Decs.hWndMainWindow := hWindow;

   LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

   P3Decs.hWndMainWindow_ListFiles := EBPtr^.hWndMainWindow_ListFiles;
   P3Decs.hWndMainWindow_ListDirs := EBPtr^.hWndMainWindow_ListDirs;
   P3Decs.hWndMainWindow_EditBitmap := EBPtr^.hWndMainWindow_EditBitmap;
   P3Decs.hWndMainWindow_BtnAsis := EBPtr^.hWndMainWindow_BtnAsis;
   P3Decs.hWndMainWindow_BtnStretch := EBPtr^.hWndMainWindow_BtnStretch;
   P3Decs.hWndMainWindow_BtnTile := EBPtr^.hWndMainWindow_BtnTile;
   P3Decs.hWndMainWindow_BtnDisplay := EBPtr^.hWndMainWindow_BtnDisplay;
   P3Decs.hWndMainWindow_BtnExit := EBPtr^.hWndMainWindow_BtnExit;
END;


{=================================================================}
FUNCTION WinProc_MainWindow
                    (hWindow   : HWnd;
                     wMessage,
                     wParam    : Word;
                     lParam    : LongInt) : LONGINT; EXPORT;

{*
 *  Message processing for "MainWindow" window.
 *}

VAR
   dc    : HDC;
   ps    : TPaintStruct;
   EBPtr : ^MainWindowRec;

VAR
   nRC         : Integer;
   lSel        : LongInt;
   wPathLen    : Word;
   bDiffDir    : Boolean;
   szFileName,
   szPtr,
   szBuffer    : PChar;
   szNum       : Array [0..10] of Char;
   szDirsEntry : Array [0..20] of Char;     {Text of most recent directory entry selected   }
   szCaption,
   szPathName  : Array [0..96] of Char;
   
BEGIN
   WinProc_MainWindow := 0;

   CASE wMessage OF
      WM_CREATE :
         BEGIN
            {* set up pointer to the process's "extra bytes" variables *}
         NEW (EBPtr);
         SetWindowLong (hWindow, P3_ExtBytesPtr, LongInt (EBPtr)); 

            {* Initialise structure to allow tabbing between fields *}
         P3_CreateAutoTabs (hWindow, P3Decs.P3_Phase3Reserved); 

            {* Initialise brush handle for controls *}
         EBPtr^.P3_hBrushCtlColor := 0;

            {* Set window background colour *}
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                         CreateSolidBrush (RGB (192, 255, 192)));

            {* Create brush for painting background for controls *}
         EBPtr^.P3_hBrushCtlColor := CreateSolidBrush (RGB (192, 255, 192));

         CreateObjects_MainWindow (hWindow);
         UpdateHandles_MainWindow (hWindow);

{****** Begin user-created code for "WM_CREATE" ******}

   {* Create child window that will display the bitmap *}
BitmapWindow (hWndMainWindow) ;

   {* Initialise Display style to ASIS *}
 P3_ButtonSetCheck (hWndMainWindow_BtnAsis, 1 ) ;

   {* Miscellaneous initialisations *}
hBMP := 0;
SetRect (rectDir, 47, 49, 262, 70);
SetRect (EBPtr^.rectWidth, 418, 326, 460, 341);
SetRect (EBPtr^.rectHeight, 510, 326, 565, 341);
 SendMessage (hWndMainWindow_EditBitmap, EM_LIMITTEXT, 96, 0 ) ;

   {* Display drives, subdirectories and bitmap files *}
UpdateListBoxes (TRUE) ;

 SetFocus (hWndMainWindow_EditBitmap ) ;

{******* End user-created code for "WM_CREATE" *******}

         Exit;
         END;

      WM_SETFOCUS :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         UpdateHandles_MainWindow (hWindow);
         Exit;
         END;

      WM_CTLCOLOR :
         BEGIN
            {* Paint background of buttons with screen color *}
         IF HiWord (lParam) = CTLCOLOR_BTN THEN
            BEGIN
            LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
            IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
               BEGIN
               SetBkMode (HDC (wParam), TRANSPARENT);
               SetTextColor (HDC (wParam), GetSysColor (COLOR_WINDOWTEXT));
               P3Procs.P3_ResetBrushOrigin (hWindow, HDC (wParam),
                                            EBPtr^.P3_hBrushCtlColor);
               WinProc_MainWindow := EBPtr^.P3_hBrushCtlColor;
               Exit;
               END;
            END;
         END;

      WM_PAINT :
         BEGIN
         P3_hFontWork := 0;
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);
         dc := BeginPaint (hWindow, ps);

            {* Paint static text on the screen *}
         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         P3_hFontWork := P3Procs.P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                       FF_SWISS + VARIABLE_PITCH, 'Arial');
         SelectObject (dc, P3_hFontWork);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 10, 76, 129, 93);
         DrawText (dc, '&Files', 6,
                   P3_rtText, 16);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 10, 49, 40, 65);
         DrawText (dc, 'Path:', 5,
                   P3_rtText, 16);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 10, 246, 61, 265);
         DrawText (dc, 'Display', 7,
                   P3_rtText, 16);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 10, 18, 54, 35);
         DrawText (dc, '&Bitmap', 7,
                   P3_rtText, 16);

            {* Draw a rectangle on the screen *}
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPenWork := SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (0, 0, 0)));
         Rectangle (dc, 10, 264, 159, 333);
         DeleteObject (SelectObject (dc, P3_hPenWork));

            {* Draw a rectangle on the screen *}
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPenWork := SelectObject (dc, CreatePen (PS_SOLID, 3, RGB (128, 128, 0)));
         Rectangle (dc, 273, 6, 588, 316);
         DeleteObject (SelectObject (dc, P3_hPenWork));

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 293, 326, 362, 342);
         DrawText (dc, 'Bitmap Info', 11,
                   P3_rtText, 16);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 375, 326, 415, 341);
         DrawText (dc, 'Width:', 6,
                   P3_rtText, 16);

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 464, 326, 547, 341);
         DrawText (dc, 'Height:', 7,
                   P3_rtText, 16);

            {* Draw a rectangle on the screen *}
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPenWork := SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (0, 0, 0)));
         Rectangle (dc, 369, 324, 569, 343);
         DeleteObject (SelectObject (dc, P3_hPenWork));

            {* Paint static text on the screen *}
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (P3_rtText, 142, 76, 261, 93);
         DrawText (dc, 'Di&rectories', 12,
                   P3_rtText, 16);

{****** Begin user-created code for "WM_PAINT" ******}

   {* Display current directory path *}
DrawText (dc, StrLower (szDirectory), StrLen (szDirectory), rectDir, DT_SINGLELINE);

   {* If valid bitmap - display height and width *}
IF hBMP <> 0 THEN
   BEGIN
   Str (EBPtr^.nWidth, szNum);
   DrawText (dc, szNum, StrLen (szNum), EBPtr^.rectWidth, DT_SINGLELINE);
   Str (EBPtr^.nHeight, szNum);
   DrawText (dc, szNum, StrLen (szNum), EBPtr^.rectHeight, DT_SINGLELINE);
   END;          

{******* End user-created code for "WM_PAINT" *******}

         IF P3_hFontWork <> 0 THEN
            DeleteObject (P3_hFontWork);
         EndPaint (hWindow, ps);
         Exit;
         END;

      WM_SYSCHAR :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******} 

   {* Process ALT-key combinations *}
ProcessHotKeys (Chr (wParam)) ;
Exit;


{******* End user-created code *******}

         Exit;
         END;

      WM_COMMAND :
         BEGIN
         CASE wParam OF
            idMainWindow_ListFiles :
               BEGIN
               CASE HiWord (lParam) OF
                  LBN_SELCHANGE :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Get index to currently selected list box entry *}
 lSel := SendMessage (hWndMainWindow_ListFiles, LB_GETCURSEL, 0, 0 ) ;
IF lSel = LB_ERR THEN
   BEGIN
   MessageBeep (0);
   Exit;
   END;

   {* Get text of currently selected entry and display in edit box *}   
GetMem (szBuffer, 20);
 SendMessage (hWndMainWindow_ListFiles, LB_GETTEXT, Word (lSel), LongInt (szBuffer) ) ;
 SetWindowText (hWndMainWindow_EditBitmap, szBuffer ) ;
FreeMem (szBuffer, 20);


{******* End user-created code *******}

                     Exit;
                     END;

                  LBN_DBLCLK :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Simulate the DISPLAY button being clicked *}
 P3_SendNotifyMessage (hWndMainWindow_BtnDisplay, BN_CLICKED ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  LBN_KILLFOCUS :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Deselect entry from Files list box *}
 SendMessage (hWndMainWindow_ListFiles, LB_SETCURSEL, Word (-1), 0 ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_ListDirs :
               BEGIN
               CASE HiWord (lParam) OF
                  LBN_SELCHANGE :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Get index to currently selected list box entry *}
 lSel := SendMessage (hWndMainWindow_ListDirs, LB_GETCURSEL, 0, 0 ) ;
IF lSel = LB_ERR THEN
   BEGIN
   MessageBeep (0);
   Exit;
   END;

   {* Get text of selected entry from directories list box *}   
szPtr := szDirsEntry;   
 SendMessage (hWndMainWindow_ListDirs, LB_GETTEXT, Word (lSel), LongInt (szPtr) ) ;

   {* Is entry = [..] ? - then display '..\*.BMP' in edit box *}
IF szDirsEntry[1] = '.' THEN
   BEGIN
   StrCopy (szPathName, '..\');
   StrCat (szPathName, szBMPExt);
    SetWindowText (hWndMainWindow_EditBitmap, szPathName ) ;
   Exit;
   END;

   {* Is entry = [-a-] ? - then display 'a:*.BMP' in edit box *}
IF szDirsEntry[1] = '-' THEN
   BEGIN
   StrLCopy (szPathName, szDirsEntry + 2, 1);
   StrCat (szPathName, ':');
   StrCat (szPathName, szBMPExt);
    SetWindowText (hWndMainWindow_EditBitmap, szPathName ) ;
   Exit;
   END;

   {* Entry must be a subdirectory *}
StrLCopy (szPathName, szDirsEntry + 1, StrLen (szDirsEntry) - 2);
StrCat (szPathName, '\');
StrCat (szPathName, szBMPExt);
 SetWindowText (hWndMainWindow_EditBitmap, szPathName ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  LBN_DBLCLK :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Get index of currently selected entry in list box *}
 lSel := SendMessage (hWndMainWindow_ListDirs, LB_GETCURSEL, 0, 0 ) ;
IF lSel = LB_ERR THEN
   BEGIN
   MessageBeep (0);
   Exit;
   END;

   {* Get text of selected entry from directories list box *}   
szPtr := szDirsEntry;   
 SendMessage (hWndMainWindow_ListDirs, LB_GETTEXT, Word (lSel), LongInt (szPtr) ) ;

   {* Is entry = [..] ? *}
IF szDirsEntry[1] = '.' THEN
   ChDir ('..')
ELSE
      {* Is entry = [-a-] ? *}
   IF szDirsEntry[1] = '-' THEN
      BEGIN
      StrLCopy (szPathName, szDirsEntry + 2, 1);
      StrCat (szPathName, ':');
      SetCurDir (szPathName);
      END
   ELSE
         {* Entry must be a subdirectory *}
      BEGIN
      StrLCopy (szPathName, szDirsEntry + 1, StrLen (szDirsEntry) - 2);
      ChDir (StrPas (szPathName));
      END;

UpdateListBoxes (TRUE) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  LBN_KILLFOCUS :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Deselect entry from Directories list box *}
 SendMessage (hWndMainWindow_ListDirs, LB_SETCURSEL, Word (-1), 0 ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnAsis :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Check the appropriate button *}
 P3_ButtonSetCheck (hWndMainWindow_BtnAsis, 1 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnStretch, 0 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnTile, 0 ) ;

wDisplayStyle := idMainWindow_BtnAsis;

   {* If bitmap already loaded then force a paint immediately *}
IF hBMP <> 0 THEN   
    InvalidateRect (hWndBitmapWindow, NIL, TRUE ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnStretch :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Check the appropriate button *}
 P3_ButtonSetCheck (hWndMainWindow_BtnAsis, 0 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnStretch, 1 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnTile, 0 ) ;

wDisplayStyle := idMainWindow_BtnStretch;

   {* If bitmap already loaded then force a paint immediately *}
IF hBMP <> 0 THEN   
    InvalidateRect (hWndBitmapWindow, NIL, TRUE ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnTile :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Check the appropriate button *}
 P3_ButtonSetCheck (hWndMainWindow_BtnAsis, 0 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnStretch, 0 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnTile, 1 ) ;

wDisplayStyle := idMainWindow_BtnTile;

   {* If bitmap already loaded then force a paint immediately *}
IF hBMP <> 0 THEN   
    InvalidateRect (hWndBitmapWindow, NIL, TRUE ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnDisplay :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

   {* Determine style to display bitmap *}
IF  P3_ButtonGetCheck (hWndMainWindow_BtnAsis )  <> 0 THEN
   wDisplayStyle := idMainWindow_BtnAsis
ELSE
   IF  P3_ButtonGetCheck (hWndMainWindow_BtnStretch )  <> 0 THEN
      wDisplayStyle := idMainWindow_BtnStretch
   ELSE
      wDisplayStyle := idMainWindow_BtnTile;


   {* Get file name of bitmap *}
 GetWindowText (hWndMainWindow_EditBitmap, szPathName, 96 ) ;


   {* Convert file name to a fully qualified path and file *}
FileExpand (szPathName, szPathName);


   {* Get pointer to just the file name *}
szFileName := GetFileName (szPathName) ;


   {* Determine if directory has been changed *}
IF szFileName <> szPathName THEN
   IF StrLen (szFileName) <> 0 THEN
      bDiffDir := StrLIComp (szPathName, szDirectory, szFileName - szPathName - 1) <> 0
   ELSE
      bDiffDir := StrIComp (szPathName, szDirectory) <> 0
ELSE
   bDiffDir := FALSE;


   {* If file name ends with a backslash, then just change directories *}
IF szPathName[StrLen (szPathName) - 1] = '\' THEN
   BEGIN
   szPathName[StrLen (szPathName) - 1] := #0;
   SetCurDir (szPathName);
   UpdateListBoxes (TRUE) ;
   Exit;
   END;


   {* Delete handle to any existing bitmap *}
IF hBMP <> 0 THEN
    P3_BitmapDestroy (hBMP ) ;


   {* Update bitmap info fields *}   
 InvalidateRect (hWndMainWindow, @EBPtr^.rectWidth, TRUE ) ;
 InvalidateRect (hWndMainWindow, @EBPtr^.rectHeight, TRUE ) ;


   {* Load bitmap from the specified file *}
 hBMP := P3_BitmapLoadFromFile (szPathName, EBPtr^.nWidth, EBPtr^.nHeight, nRC ) ;


   {* If bitmap not loaded check if file name is a directory *}
IF nRC <> 0 THEN
   BEGIN
   {$I-} ChDir (szPathName); {$I+}
   IF IOResult <> 0 THEN
      BEGIN
      MessageBeep (0);
      MessageBox (hWndMainWindow, 'File could not be loaded - not a valid bitmap file.',
                  szPathName, MB_OK);
      END
   ELSE
      BEGIN
      UpdateListBoxes (TRUE) ;
      Exit;
      END;
   END;


   {* Set caption of main window to show name of bitmap *}
StrCopy (szCaption, szTitle);
IF hBMP <> 0 THEN
   BEGIN
   StrCat (szCaption, ' - ');
   StrCat (szCaption, StrUpper (szFileName));
   END;
 SetWindowText (hWndMainWindow, szCaption ) ;

   
   {* Force bitmap window to be redrawn *}
 InvalidateRect (hWndBitmapWindow, NIL, TRUE ) ;


   {* If directory changed, fill list boxes with appropriate information *}
IF bDiffDir THEN
   BEGIN
   StrLCopy (szPathName, szPathName, szFileName - szPathName - 1);
   SetCurDir (szPathName);
   UpdateListBoxes (FALSE) ;
   END;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            idMainWindow_BtnExit :
               BEGIN
               CASE HiWord (lParam) OF
                  BN_CLICKED :
                     BEGIN
                     LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code ******}

 P3_WinClose (hWndMainWindow ) ;


{******* End user-created code *******}

                     Exit;
                     END;

                  END;  {case HiWord}
               END;  {childID}

            END;  {case wParam}

         END;

      WM_CLOSE :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

{****** Begin user-created code for "WM_CLOSE" ******}

   {* Release memory allocated for bitmap *}
IF hBMP <> 0 THEN
    P3_BitmapDestroy (hBMP ) ;
   
   {* Close bitmap child window *}
 P3_WinClose (hWndBitmapWindow ) ;

{******* End user-created code for "WM_CLOSE" *******}

         END;

      WM_DESTROY :
         BEGIN
         LongInt (EBPtr) := GetWindowLong (hWindow, P3_ExtBytesPtr);

            {* Delete brush for painting background for controls *}
         IF EBPtr^.P3_hBrushCtlColor <> 0 THEN
            DeleteObject (EBPtr^.P3_hBrushCtlColor);

{****** Begin user-created code for "WM_DESTROY" ******}

PostQuitMessage(0);

{******* End user-created code for "WM_DESTROY" *******}

         DeleteObject (EBPtr^.hFontMainWindow_ListFiles);
         DeleteObject (EBPtr^.hFontMainWindow_ListDirs);
         DeleteObject (EBPtr^.hFontMainWindow_EditBitmap);
         DeleteObject (EBPtr^.hFontMainWindow_BtnAsis);
         DeleteObject (EBPtr^.hFontMainWindow_BtnStretch);
         DeleteObject (EBPtr^.hFontMainWindow_BtnTile);
         DeleteObject (EBPtr^.hFontMainWindow_BtnDisplay);
         DeleteObject (EBPtr^.hFontMainWindow_BtnExit);

         P3_DestroyAutoTabs (hWindow);

         IF SizeOf(EBPtr^) > 0 THEN
            DISPOSE (EBPtr);
         Exit;
         END;
      END;  {case}

   WinProc_MainWindow := DefWindowProc (hWindow, wMessage, wParam, lParam);
END;


{=================================================================}
FUNCTION MainWindow (hOwner : HWnd) : HWnd;

{*
 *  Create a window and display it.
 *}

VAR
   hWin : HWnd;

BEGIN
   hWin := CreateWindow ('MainWindow Class', 
                         'Phase3 Sample - Bitmap Viewer', 
                         WS_OVERLAPPED or WS_CAPTION or WS_SYSMENU or WS_MINIMIZEBOX
                    or WS_VISIBLE,
                         CW_USEDEFAULT, CW_USEDEFAULT, 
                         600, 370, 
                         hOwner, 
                         0, hInstance, NIL); 
   IF hWin = 0 THEN 
      P3User.SystemError ('Could not create window "MainWindow"'); 

   UpdateWindow (hWin);

   MainWindow := hWin;
END;


{=-------------------------------do-not-remove-this-line-=}
PROCEDURE WinMain; 
{=-------------------------------do-not-remove-this-line-=}

(*  
 *  WinMain Procedure
 *  =================
 *
 *  This procedure is the main windows procedure and is used to register,
 *  create and show the window, and wait for windows messages.
 *)
 
VAR
   message : TMsg;

BEGIN

   MainWindow(0);
   
      {*
       * Windows main message loop - make sure your program issues a
       * call to the Windows API routine "PostQuitMessage" to terminate
       * the program.
       *}
   WHILE GetMessage (message, 0, 0, 0) DO
      BEGIN
      TranslateMessage (message);
      DispatchMessage (message);
      END;

   Halt (message.wParam);      

END;


{=================================================================}
PROCEDURE RegisterWindowClasses;

{*
 *  This procedure registers the window classes which will be used
 *  throughout the program.
 *}

VAR
   WinClass : TWndClass;               {Window class for any window       }

BEGIN
   IF hPrevInst = 0 THEN
      BEGIN
         {* Register class for window "BitmapWindow" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_BitmapWindow;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'BitmapWindow Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 

         {* Register class for window "MainWindow" *}
      WinClass.style         := CS_HREDRAW or CS_VREDRAW or CS_DBLCLKS;
      WinClass.lpfnWndProc   := @WinProc_MainWindow;
      WinClass.cbClsExtra    := 0;
      WinClass.cbWndExtra    := P3Decs.P3_TotalExtBytes;
      WinClass.hInstance     := hInstance;
      WinClass.hIcon         := LoadIcon(0, IDI_APPLICATION);
      WinClass.hCursor       := LoadCursor(0, IDC_ARROW);
      WinClass.hbrBackground := COLOR_WINDOW + 1;    
      WinClass.lpszClassName := 'MainWindow Class';
      WinClass.lpszMenuName  := '';

      IF not RegisterClass (WinClass) THEN
         P3User.SystemError ('Error registering window'); 
      END;
END;


   {================}
   {  Main Control  }
   {================}

BEGIN
   RegisterWindowClasses;
   WinMain;
END.