typedef HANDLE HREPORT;
typedef HANDLE HSESSION;

#define RPS_ReportHeader    1
#define RPS_PageHeader      2
#define RPS_Body            3
#define RPS_PageFooter      4
#define RPS_ReportFooter    5
#define RPS_GroupHeader     6
#define RPS_GroupFooter     7
#define RP_PrinterPageDepth 0xFFFE
#define RP_ScreenPageDepth  0xFFFD
#define RP_CalculateExtent  0

#define RPG_Header          1
#define RPG_Footer          2

HANDLE WINAPI RP_Init (FARPROC, HWND);
BOOL WINAPI RP_SetPageSize (HREPORT, WORD, WORD);
BOOL WINAPI RP_SetSectionDepth (HREPORT, WORD, WORD);
BOOL WINAPI RP_SetBreakBefore (HREPORT, WORD);
BOOL WINAPI RP_SetBreakAfter (HREPORT, WORD);
BOOL WINAPI RP_SwitchToScreen (HREPORT, HWND FAR *);
BOOL WINAPI RP_SwitchToPrinter (HREPORT);
BOOL WINAPI RP_OpenDatabase (HREPORT, LPSTR, LPSTR, LPSTR, LPSTR, LPSTR, LPSTR, LPSTR);
BOOL WINAPI RP_AddText (HREPORT, WORD, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT);
BOOL WINAPI RP_AddDBCol (HREPORT, WORD, LPSTR, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT);
BOOL WINAPI RP_AddSum (HREPORT, WORD, LPSTR, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT, WORD);
BOOL WINAPI RP_AddPageNum (HREPORT, WORD, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT);
BOOL WINAPI RP_AddDate (HREPORT, WORD, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT);
BOOL WINAPI RP_AddTime (HREPORT, WORD, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT);
BOOL WINAPI RP_AddCount (HREPORT, WORD, LPSTR, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT, WORD);
BOOL WINAPI RP_AddAvg (HREPORT, WORD, LPSTR, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT, WORD);
BOOL WINAPI RP_AddMin (HREPORT, WORD, LPSTR, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT, WORD);
BOOL WINAPI RP_AddMax (HREPORT, WORD, LPSTR, LPSTR, WORD, WORD, WORD, WORD, WORD, LPLOGFONT, WORD);
BOOL WINAPI RP_AddRect (HREPORT, WORD, WORD, WORD, WORD, WORD, WORD);
BOOL WINAPI RP_AddLine (HREPORT, WORD, WORD, WORD, WORD, WORD, WORD);
BOOL WINAPI RP_AddUserFunc (HREPORT, WORD, FARPROC, WORD, WORD, WORD, WORD, WORD, LPLOGFONT);
BOOL WINAPI RP_NextPage (HREPORT);
WORD WINAPI RP_CreateGroup (HREPORT, LPSTR, WORD);
BOOL WINAPI RP_RedoPage (HREPORT);
BOOL WINAPI RP_EndOfReport (HREPORT);
void WINAPI RP_Destroy (HREPORT);
BOOL WINAPI RP_IsToPrinter (HREPORT);
WORD WINAPI RP_CreateGroup (HREPORT, LPSTR, WORD);
BOOL WINAPI RP_OpenCatalog (HREPORT, HSESSION, LPSTR, LPSTR);
void WINAPI RP_CloseCatalog (HREPORT);
void WINAPI RP_ExitDatabase (HREPORT);
BOOL WINAPI RP_SetOrder (HREPORT, LPSTR);
BOOL WINAPI RP_ImportSnapshot (HREPORT, HSESSION, LPSTR, LPSTR);
BOOL WINAPI RP_CreateSnapshotTable (HREPORT, HSESSION, LPSTR, LPSTR, LPSTR, WORD);
BOOL WINAPI RP_DropTable (HREPORT);

