#include "windows.h"   /* required for all Windows applications */
#include "RPProcs.h"   /* Phase3 reports */

extern HANDLE hInst;

/*=-----------------------------------------------------=*/
BOOL WINAPI SystemWarning (LPSTR szMessage)
/*=-----------------------------------------------------=*/
   {
   MessageBeep(0);
   MessageBox (0, szMessage, "System Error", MB_ICONSTOP | MB_TASKMODAL);
   return TRUE;
   }


/*=-----------------------------------------------------=*/
void LongWarning (LPSTR szTitle, LPSTR szMessage)
/*=-----------------------------------------------------=*/
   {
   MessageBeep(0);
   MessageBox (0, szMessage, szTitle, MB_ICONSTOP | MB_TASKMODAL);
   }

/*=-----------------------------------------------------=*/
long WINAPI ReportWndProc
   (HWND hWindow, UINT wMessage, WPARAM wParam, LPARAM lParam)
/*=-----------------------------------------------------=*/
   {
   #define ID_NextBtn 1

   HREPORT  hReport;
   HWND     hChildWnd,
            hNextBtn;
   RECT     rect;
   int      x, y;

   switch (wMessage)
      {
      case WM_CREATE :
         SetWindowWord (hWindow, 0, 0);
         SetWindowWord (hWindow, 2, 0);

         hNextBtn = CreateWindow(
            "BUTTON",
            "Next",
            WS_CHILD | WS_VISIBLE | WS_TABSTOP,
            0,0,0,0,
            hWindow,
            ID_NextBtn,
            hInst,
            NULL);
         SetWindowWord (hWindow, 4, hNextBtn);
         SetWindowWord (hWindow, 6, 0);   /* first-time flag */
         return 0;

      case WM_SIZE :
         hChildWnd = GetWindowWord (hWindow, 0);
         if (hChildWnd)
            {
            hReport = GetWindowWord (hWindow, 2);
            hNextBtn = GetWindowWord (hWindow, 4);
            GetClientRect (hWindow, &rect);
            MoveWindow (hChildWnd, rect.left, rect.top, rect.right, rect.bottom - 30, TRUE);
            x = rect.left + 10;
            y = rect.bottom - 27;
            MoveWindow (hNextBtn, x, y, 60, 24, TRUE);
            if (!GetWindowWord (hWindow, 6))
               {
               SendMessage (hWindow, WM_COMMAND, ID_NextBtn, 0);
               SetWindowWord (hWindow, 6, 1);
               };
            }
         return FALSE;

      case WM_COMMAND :
         switch (wParam)
            {
            case ID_NextBtn :
               hReport = GetWindowWord (hWindow, 2);
               hNextBtn = GetWindowWord (hWindow, 4);
               RP_NextPage (hReport);
               if (RP_EndOfReport (hReport))
                  EnableWindow (hNextBtn, FALSE);
               return FALSE;
            };

      case WM_DESTROY :
         RP_DropTable (GetWindowWord (hWindow, 2));
         RP_CloseCatalog (GetWindowWord (hWindow, 2));
         RP_ExitDatabase (GetWindowWord (hWindow, 2));
         RP_Destroy (GetWindowWord (hWindow, 2));
         return FALSE;

      };  /* wMessage */

   return (DefWindowProc(hWindow, wMessage, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL P3_CreateReportWindow (HWND hOwner, HWND FAR * hWindow, LPSTR szTitle)
/*=-----------------------------------------------------=*/
   {
   *hWindow = CreateWindow(
      "Report Screen Display Class",
      szTitle,
      WS_OVERLAPPED | WS_CAPTION | WS_BORDER | WS_THICKFRAME | WS_SYSMENU |
      WS_MINIMIZEBOX | WS_MAXIMIZEBOX ,
      0,0,0,0,
      hOwner,
      0,
      hInst,
      NULL);

   if (!*hWindow)
      {
      SystemWarning ("Could not create report display window.");
      return FALSE;
      }
   else
      return TRUE;
   }


/*=-----------------------------------------------------=*/
void P3_RunReport (HREPORT hReport, HWND hReportWnd, HWND hDisplayWnd)
/*=-----------------------------------------------------=*/
/*
   Run the report with handle "hReport". 
*/
   {
   HCURSOR  hOldCurs;

   SetWindowWord (hReportWnd, 0, hDisplayWnd);
   SetWindowWord (hReportWnd, 2, hReport);

   if (RP_IsToPrinter (hReport))
      {
      hOldCurs = SetCursor (LoadCursor (0, IDC_WAIT));
      while (RP_NextPage (hReport)) { /* nothing */ };            
      DestroyWindow (hReportWnd);
      SetCursor (hOldCurs);
      }
   else   /* to screen */
      {
      MoveWindow (hReportWnd, 50, 50, 500, 300, TRUE);
      ShowWindow (hReportWnd, SW_NORMAL);
      };
   }


/*=-----------------------------------------------------=*/
BOOL P3_RegisterReportWindow (void)
/*=-----------------------------------------------------=*/
/*
   This function registers a window class for reports which will be
   output to the screen.
*/
   {
   WNDCLASS  wc;

   /* Window class structure for report display window */

   wc.style         = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc   = ReportWndProc;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = 20;
   wc.hInstance     = hInst;
   wc.hIcon         = 0;
   wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;  /* Use Windows color */
   wc.lpszMenuName  = "";
   wc.lpszClassName = "Report Screen Display Class";

   /* Register the window class and return success/failure code. */

   if (!RegisterClass(&wc))
      {
      LongWarning ("Report Display Window", "Could not register window.");
      return (FALSE);
      };        

   return (TRUE);
   }

