#include <windows.h>     /* required for all Windows applications */
#include <stdlib.h>
#include <ctype.h>
#include <direct.h>
#include <string.h>
#include "DBProcs.h"     /* Phase3 database */
#include "RPProcs.h"     /* Phase3 reports */
#include "BOOKLIBC.H"    /* required for this application */

HANDLE hInst;            /* current instance of this application */
int    nShowMain;        /* SW constant for showing main window */
LPSTR  lpCommandLine;    /* command-line parameters */


/*========================================================================
 *
 *  Program generated by Phase3 :- 
 *
 *      Date : Thursday, July 22, 1993
 *
 *      Time : 07:37am
 *
 *======================================================================*/


#include "P3Procs.h"   /* Phase3 "P3_" DLL routines */
#include "P3User.h"    /* Phase3 routines as source in P3User.C */

BOOL P3_RegisterWindows (void);  

/*=-----------------------------do-not-remove-this-line-=*/
void Initialise (void)
/*=-----------------------------do-not-remove-this-line-=*/

/* 
   Perform any initialisation your application may require.
*/
   {
   char szCurDir[96];
   char szFile[96];

   _getdcwd (0, szCurDir, 96);
   strcpy (szFile, szCurDir);
   strcat (szFile, "\\");
   strcat (szFile, "BOOKLIBC.SC");
            
      /* obtain a database session */
   if (!( hUser = DB_Init ("Books", P3SESSION_SINGLEUSER ) ))   
      exit (1);

      /* load catalog "Book" into memory */
   if (! DB_LoadCatalog (hUser, "BookLibC", szFile ) )
      {
       DB_Exit (hUser ) ;
      exit (1);
      }
 	 	
      /* open the catalog for use */
   if (! DB_OpenCatalog (hUser, "BookLibC" ) )
      {
       DB_Exit (hUser ) ;
      exit (1);
      }
 	 	
      /* open the table for use */
   if (!( hTable = DB_OpenTable (hUser, "BookC" ) ))
      {
       DB_Exit (hUser ) ;
      exit (1);
      }
   }



/*=-----------------------------do-not-remove-this-line-=*/
void CleanUp (void)
/*=-----------------------------do-not-remove-this-line-=*/

/*
   Perform any finalisation your application may require. 
*/
   {
      /* close down the database session */
    DB_Exit (hUser ) ;
   }



/*=-----------------------------do-not-remove-this-line-=*/
int ProcessHotKeys (int cKey)
/*=-----------------------------do-not-remove-this-line-=*/

/*
   Perform required action depending upon which ALT key combinations was pressed.
*/
   {
   switch (toupper (cKey))
      {
      case 'A' :
          P3_SendNotifyMessage (hWndMainWindow_BtnAdd, BN_CLICKED ) ;
         break;
      case 'B' :
          SetFocus (hWndMainWindow_ListBoxBooks ) ;
         break;
      case 'D' :
          P3_SendNotifyMessage (hWndMainWindow_BtnDelete, BN_CLICKED ) ;
         break;
      case 'F' :
          P3_SendNotifyMessage (hWndMainWindow_BtnFind, BN_CLICKED ) ;
         break;
      case 'M' :
          P3_SendNotifyMessage (hWndMainWindow_BtnModify, BN_CLICKED ) ;
         break;
      case 'N' :
          P3_SendNotifyMessage (hWndMainWindow_BtnNext, BN_CLICKED ) ;
         break;
      case 'R' :
          P3_SendNotifyMessage (hWndMainWindow_BtnReports, BN_CLICKED ) ;
         break;
      case 'X' :
          P3_SendNotifyMessage (hWndMainWindow_BtnExit, BN_CLICKED ) ;
         break;
      default :
          MessageBeep (MB_ICONASTERISK ) ;
         return 0;
      }
   return 1;
   }



/*=-----------------------------do-not-remove-this-line-=*/
BOOL ValidateDataEntryFields (BOOL bDelete)
/*=-----------------------------do-not-remove-this-line-=*/

/*
   Make sure required data entry fields have been entered.
*/
   {
   if (! GetWindowTextLength (hWndMainWindow_DEISBN ) )
      {
       MessageBeep (MB_ICONASTERISK ) ;
      MessageBox (hWndMainWindow, "ISBN field is required", NULL, MB_OK);
       SetFocus (hWndMainWindow_DEISBN ) ;
      return FALSE;
      }

   if (!bDelete)
      if (! GetWindowTextLength (hWndMainWindow_DETitle ) )
         {
          MessageBeep (MB_ICONASTERISK ) ;
         MessageBox (hWndMainWindow, "Title field is required", NULL, MB_OK);
          SetFocus (hWndMainWindow_DETitle ) ;
         return FALSE;
         }
         
   return TRUE;
   }



/*=-----------------------------do-not-remove-this-line-=*/
void BuildFindString (HWND hWin, char * szField)
/*=-----------------------------do-not-remove-this-line-=*/

/*
*/
   {
   char szWork[100];
   
   if (! GetWindowTextLength (hWin ) )
      return;

   GetWindowText (hWin, szWork, 100);
   if (!bFirst)
      strcat (szFind, " .AND. ");
   strcat (szFind, szField);
   strcat (szFind, " ~ ^");
   strcat (szFind, szWork);
   strcat (szFind, "*");
   strcat (szFind, "^");

   bFirst = FALSE;
   }



/*=-----------------------------------------------------=*/
BOOL PrintBooks (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
 *  Set up the report and run it.
 */
   {
   static HSESSION hUser,
                   P3_hUser;
   HREPORT  hReport;
   HWND     hReportWnd,
            hDisplayWnd;
   LOGFONT  P3_font;
   WORD     retCode;  

   WORD     wGrpBookC_Category;

   if (!P3_CreateReportWindow (hOwner, &hReportWnd, "PrintBooks"))
      return FALSE;

   hReport = RP_Init (MakeProcInstance (SystemWarning, hInst), hReportWnd);
   if (!hReport)
      return FALSE;

   if (!RP_SwitchToScreen (hReport, &hDisplayWnd))
      return FALSE;

   if (!RP_SetPageSize (hReport, 640, 1050))
      return FALSE;  
      /* Create all required sort groups */
   wGrpBookC_Category = RP_CreateGroup (hReport, "BookC.Category", RPG_Header);


      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_ReportHeader, 0))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_PageHeader, 75))
      return FALSE;  
 
   P3_GetLogFont (-27, 0, 0, 0, 700, 0, 1, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, "Times New Roman", &P3_font);  
   if (!RP_AddText (hReport, RPS_PageHeader,
                    "List of Books by Category",
                    0, 45, 641, 16, 30, &P3_font))
      return FALSE;  
 
   P3_GetLogFont (16, 7, 0, 0, 700, 0, 0, 0, 0, 1, 2, 2, 
                  FF_SWISS + VARIABLE_PITCH, "System", &P3_font);  
   if (!RP_AddText (hReport, RPS_PageHeader,
                    "Page",
                    576, 0, RP_CalculateExtent, 16, 26, &P3_font))
      return FALSE;  
 
   if (!RP_AddPageNum (hReport, RPS_PageHeader,
                    "0 (General)",
                    616, 0, 25, 16, 24, &P3_font))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_Body, 15))
      return FALSE;  
 
   P3_GetLogFont (16, 7, 0, 0, 700, 0, 0, 0, 0, 1, 2, 2, 
                  FF_SWISS + VARIABLE_PITCH, "System", &P3_font);  
   if (!RP_AddDBCol (hReport, RPS_Body,
                    "BookC.Title", "Asis",
                    40, 0, 641, 16, 24, &P3_font))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_PageFooter, 0))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_ReportFooter, 0))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, wGrpBookC_Category, 60))
      return FALSE;  
 
   P3_GetLogFont (-21, 0, 0, 0, 400, 0, 0, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, "Times New Roman", &P3_font);  
   if (!RP_AddText (hReport, wGrpBookC_Category,
                    "Category:",
                    8, 30, RP_CalculateExtent, 16, 24, &P3_font))
      return FALSE;  
 
   P3_GetLogFont (-21, 0, 0, 0, 700, 0, 0, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, "Times New Roman", &P3_font);  
   if (!RP_AddDBCol (hReport, wGrpBookC_Category,
                    "BookC.Category", "Asis",
                    96, 30, 241, 16, 24, &P3_font))
      return FALSE;  
 
   hUser = DB_Init ("BOOKLIBC", P3SESSION_SINGLEUSER);
   if (!hUser)
      return FALSE;

   P3_hUser = hUser;

   if (!DB_LoadCatalog (P3_hUser, "BOOKLIBC", "f:\\p3-1.1\\disk3\\csamples\\BOOKLIBC.SC"))
      {
      DB_Exit (P3_hUser);
      return FALSE;
      };  

/****** Begin user-created code ******/
/* This report will default to the screen. To send */
/* it to the printer, include the following line:  */

if (bPrinter)
   RP_SwitchToPrinter (hReport); 
/******* End user-created code *******/
 
   if (!DB_CreateDerivedTable (P3_hUser, "BOOKLIBC", "ReptTabl",
      "BOOKC"))
      {
      DB_Exit (P3_hUser);
      return FALSE;
      };    

   if (!RP_OpenCatalog (hReport, P3_hUser, "BOOKLIBC", "ReptTabl")) 
      {
      DB_Exit (P3_hUser);
      return FALSE;
      };  

   if (!RP_SetOrder (hReport, "CATEGORY + TITLE"))
      {
      DB_Exit (P3_hUser);
      return FALSE;
      };  

   P3_RunReport (hReport, hReportWnd, hDisplayWnd); 
   return TRUE;
   }


/*=-----------------------------------------------------=*/
BOOL PrintAuthors (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
 *  Set up the report and run it.
 */
   {
   static HSESSION hUser,
                   P3_hUser;
   HREPORT  hReport;
   HWND     hReportWnd,
            hDisplayWnd;
   LOGFONT  P3_font;
   WORD     retCode;  

   WORD     wGrpBookC_AuthorLastName;

   if (!P3_CreateReportWindow (hOwner, &hReportWnd, "PrintAuthors"))
      return FALSE;

   hReport = RP_Init (MakeProcInstance (SystemWarning, hInst), hReportWnd);
   if (!hReport)
      return FALSE;

   if (!RP_SwitchToScreen (hReport, &hDisplayWnd))
      return FALSE;

   if (!RP_SetPageSize (hReport, 640, 1050))
      return FALSE;  
      /* Create all required sort groups */
   wGrpBookC_AuthorLastName = RP_CreateGroup (hReport, "BookC.AuthorLastName", RPG_Header);


      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_ReportHeader, 0))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_PageHeader, 75))
      return FALSE;  
 
   P3_GetLogFont (-27, 0, 0, 0, 700, 0, 1, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, "Times New Roman", &P3_font);  
   if (!RP_AddText (hReport, RPS_PageHeader,
                    "List of Books by Author",
                    0, 45, 641, 16, 30, &P3_font))
      return FALSE;  
 
   P3_GetLogFont (16, 7, 0, 0, 700, 0, 0, 0, 0, 1, 2, 2, 
                  FF_SWISS + VARIABLE_PITCH, "System", &P3_font);  
   if (!RP_AddText (hReport, RPS_PageHeader,
                    "Page",
                    576, 0, RP_CalculateExtent, 16, 26, &P3_font))
      return FALSE;  
 
   if (!RP_AddPageNum (hReport, RPS_PageHeader,
                    "0 (General)",
                    616, 0, 25, 16, 24, &P3_font))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_Body, 15))
      return FALSE;  
 
   P3_GetLogFont (16, 7, 0, 0, 700, 0, 0, 0, 0, 1, 2, 2, 
                  FF_SWISS + VARIABLE_PITCH, "System", &P3_font);  
   if (!RP_AddDBCol (hReport, RPS_Body,
                    "BookC.Title", "Asis",
                    40, 0, 641, 16, 24, &P3_font))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_PageFooter, 0))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, RPS_ReportFooter, 0))
      return FALSE;  

      /* Define a report section */
   if (!RP_SetSectionDepth (hReport, wGrpBookC_AuthorLastName, 60))
      return FALSE;  
 
   P3_GetLogFont (-21, 0, 0, 0, 400, 0, 0, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, "Times New Roman", &P3_font);  
   if (!RP_AddText (hReport, wGrpBookC_AuthorLastName,
                    "Author:",
                    8, 30, RP_CalculateExtent, 16, 24, &P3_font))
      return FALSE;  
 
   P3_GetLogFont (-21, 0, 0, 0, 700, 0, 0, 0, 0, 3, 2, 1, 
                  FF_ROMAN + VARIABLE_PITCH, "Times New Roman", &P3_font);  
   if (!RP_AddDBCol (hReport, wGrpBookC_AuthorLastName,
                    "BookC.AuthorLastName", "Asis",
                    80, 30, 241, 16, 24, &P3_font))
      return FALSE;  
 
   hUser = DB_Init ("BOOKLIBC", P3SESSION_SINGLEUSER);
   if (!hUser)
      return FALSE;

   P3_hUser = hUser;

   if (!DB_LoadCatalog (P3_hUser, "BOOKLIBC", "f:\\p3-1.1\\disk3\\csamples\\BOOKLIBC.SC"))
      {
      DB_Exit (P3_hUser);
      return FALSE;
      };  

/****** Begin user-created code ******/
/* This report will default to the screen. To send */
/* it to the printer, include the following line:  */

if (bPrinter)
   RP_SwitchToPrinter (hReport); 
/******* End user-created code *******/
 
   if (!DB_CreateDerivedTable (P3_hUser, "BOOKLIBC", "ReptTabl",
      "BOOKC"))
      {
      DB_Exit (P3_hUser);
      return FALSE;
      };    

   if (!RP_OpenCatalog (hReport, P3_hUser, "BOOKLIBC", "ReptTabl")) 
      {
      DB_Exit (P3_hUser);
      return FALSE;
      };  

   if (!RP_SetOrder (hReport, "AUTHORLASTNAME + TITLE"))
      {
      DB_Exit (P3_hUser);
      return FALSE;
      };  

   P3_RunReport (hReport, hReportWnd, hDisplayWnd); 
   return TRUE;
   }


/*=-----------------------------------------------------=*/
BOOL WINAPI DlgProc_ReportsDialog
   (HWND hDlg, WORD wMessage, WORD wParam, long lParam)
/*=-----------------------------------------------------=*/
/*
   Process messages for the dialog box.
*/
   {
   HDC dc; 
WORD wCheck;
   

   switch (wMessage)
      {
      case WM_INITDIALOG :
         /* short circuit compiler warning */
         if (wParam) ;
         if (lParam) ;

         /* Initialise global window handles */

         hWndReportsDialog = hDlg;
         hWndReportsDialog_Btn101_LISTOFBOOKSBYCATEGORY = GetDlgItem (hDlg, 101);
         hWndReportsDialog_Btn102_LISTOFBOOKSBYAUTHOR = GetDlgItem (hDlg, 102);
         hWndReportsDialog_Btn103_PRINTER = GetDlgItem (hDlg, 103);
         hWndReportsDialog_Btn104_SCREEN = GetDlgItem (hDlg, 104);
         hWndReportsDialog_Btn1_PRINT = GetDlgItem (hDlg, 1);
         hWndReportsDialog_Btn2_CANCEL = GetDlgItem (hDlg, 2);


/****** Begin user-created code ******/
/*
 *  Perform required initialisation for reports dialog.
 */
 
   /* Select Books by Category report initially */
 CheckRadioButton (hWndReportsDialog, 101, 102, 101 ) ;
                    
   /* Select destination as Screen initially */
 CheckRadioButton (hWndReportsDialog, 103, 104, 104 ) ;
                    
 SetFocus (hWndReportsDialog_Btn101_LISTOFBOOKSBYCATEGORY ) ;
/******* End user-created code *******/

         return TRUE;

      case WM_PAINT :
         dc = GetDC (hDlg);

         ReleaseDC (hDlg, dc);

         /* fall through to default WM_PAINT processing */
         break;

      case WM_SETFOCUS :

         return TRUE;

      case WM_COMMAND :
         switch (wParam)
            {
            case 1 :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :

/****** Begin user-created code ******/
/*
 *  Reports Dialog : PRINT button pressed - Determine type of report selected
 *        and destination and call appropriate report routine.
 */

bPrinter = ( IsDlgButtonChecked (hWndReportsDialog, 103 ) != 0 );
   
if ( IsDlgButtonChecked (hWndReportsDialog, 101 ) )
   PrintBooks (hWndReportsDialog) ;
else
   PrintAuthors (hWndReportsDialog) ;

/******* End user-created code *******/

                     return TRUE;  

                  } /* HiWord */ 
            case 2 :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :

/****** Begin user-created code ******/
EndDialog (hWndReportsDialog, 0);

/******* End user-created code *******/

                     return TRUE;  

                  } /* HiWord */ 
               break; 

            } /* wParam - Child ID */


         break;

      case WM_CLOSE :

         EndDialog (hDlg, 0);
         return TRUE;

      case WM_DESTROY :

         return TRUE;
      }  /* wMessage */

   return FALSE;

   }  


/*=-----------------------------------------------------=*/
int ReportsDialog (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
   Creates and calls the dialog box. Returns the value returned by
   the dialog (via it's call to EndDialog).
*/
   {
   FARPROC lpfnDlgProc;
   int     nResult;

   lpfnDlgProc = MakeProcInstance (DlgProc_ReportsDialog, hInst);
   nResult = DialogBox (hInst, "ReportsDialog", hOwner, lpfnDlgProc);
   if (nResult == -1)
      {
      LongWarning ("ReportsDialog", "Could not create dialog box.");
      return -1;
      }

   FreeProcInstance (lpfnDlgProc);
   return nResult;
   }   


/*=-----------------------------------------------------=*/
long WINAPI EditSubClass_MainWindow
   (HWND hWindow, WORD wMessage, WORD wParam, long lParam)  
/*=-----------------------------------------------------=*/
   {
   HWND    P3_hParent;
   FARPROC oldProc;

   switch (wMessage)
      {
      case WM_SYSCHAR :
/****** Begin user-created code ******/ 
if (ProcessHotKeys (wParam) )
   return 0;

/******* End user-created code *******/
         break;

      } /* wMessage */

   P3_hParent = GetParent (hWindow);
   oldProc = (FARPROC) GetWindowLong (P3_hParent, P3_ExtBytesOldEditProc);

   return (CallWindowProc(oldProc, hWindow, wMessage, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
long WINAPI ButtonSubClass_MainWindow
   (HWND hWindow, WORD wMessage, WORD wParam, long lParam)  
/*=-----------------------------------------------------=*/
   {
   HWND    P3_hParent;
   FARPROC oldProc;

   switch (wMessage)
      {
      case WM_SYSCHAR :
/****** Begin user-created code ******/ 
if (ProcessHotKeys (wParam) )
   return 0;

/******* End user-created code *******/
         break;

      } /* wMessage */

   P3_hParent = GetParent (hWindow);
   oldProc = (FARPROC) GetWindowLong (P3_hParent, P3_ExtBytesOldButtonProc);

   return (CallWindowProc(oldProc, hWindow, wMessage, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
long WINAPI ListSubClass_MainWindow
   (HWND hWindow, WORD wMessage, WORD wParam, long lParam)  
/*=-----------------------------------------------------=*/
   {
   HWND    P3_hParent;
   FARPROC oldProc;

   switch (wMessage)
      {
      case WM_SYSCHAR :
/****** Begin user-created code ******/ 
if (ProcessHotKeys (wParam) )
   return 0;

/******* End user-created code *******/
         break;

      } /* wMessage */

   P3_hParent = GetParent (hWindow);
   oldProc = (FARPROC) GetWindowLong (P3_hParent, P3_ExtBytesOldListProc);

   return (CallWindowProc(oldProc, hWindow, wMessage, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL CreateObjects_MainWindow (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
   Create all objects on this window.
*/
   {
   HGLOBAL P3_hMem;
   int     P3_nWidth,
           P3_nHeight,
           P3_nRetCode;
   LPMainWindowStruct EBPtr;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("MainWindow", "Invalid extra bytes pointer.");
      return FALSE;
      }  

   EBPtr->hWndMainWindow_DEPublisher = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | ES_AUTOHSCROLL | WS_VISIBLE,
                          116, 150, 155, 19,
                          hWindow,
                          idMainWindow_DEPublisher,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_DEPublisher)
      {
      LongWarning ("MainWindow_DEPublisher", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_DEPublisher = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_DEPublisher)
      {
      LongWarning ("MainWindow_DEPublisher", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_DEPublisher, WM_SETFONT,
                EBPtr->hFontMainWindow_DEPublisher, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_DEPublisher,
      (FARPROC) EditSubClass_MainWindow,
      P3_ExtBytesOldEditProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_DEPublisher, 4);

   EBPtr->hWndMainWindow_DESubTitle = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | ES_AUTOHSCROLL | WS_VISIBLE,
                          116, 120, 200, 19,
                          hWindow,
                          idMainWindow_DESubTitle,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_DESubTitle)
      {
      LongWarning ("MainWindow_DESubTitle", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_DESubTitle = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_DESubTitle)
      {
      LongWarning ("MainWindow_DESubTitle", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_DESubTitle, WM_SETFONT,
                EBPtr->hFontMainWindow_DESubTitle, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_DESubTitle,
      (FARPROC) EditSubClass_MainWindow,
      P3_ExtBytesOldEditProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_DESubTitle, 3);

   EBPtr->hWndMainWindow_DEISBN = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | ES_AUTOHSCROLL | WS_VISIBLE,
                          116, 60, 155, 19,
                          hWindow,
                          idMainWindow_DEISBN,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_DEISBN)
      {
      LongWarning ("MainWindow_DEISBN", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_DEISBN = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_DEISBN)
      {
      LongWarning ("MainWindow_DEISBN", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_DEISBN, WM_SETFONT,
                EBPtr->hFontMainWindow_DEISBN, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_DEISBN,
      (FARPROC) EditSubClass_MainWindow,
      P3_ExtBytesOldEditProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_DEISBN, 1);

   EBPtr->hWndMainWindow_DEAuthorLastName = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | ES_AUTOHSCROLL | WS_VISIBLE,
                          116, 272, 155, 19,
                          hWindow,
                          idMainWindow_DEAuthorLastName,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_DEAuthorLastName)
      {
      LongWarning ("MainWindow_DEAuthorLastName", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_DEAuthorLastName = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_DEAuthorLastName)
      {
      LongWarning ("MainWindow_DEAuthorLastName", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_DEAuthorLastName, WM_SETFONT,
                EBPtr->hFontMainWindow_DEAuthorLastName, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_DEAuthorLastName,
      (FARPROC) EditSubClass_MainWindow,
      P3_ExtBytesOldEditProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_DEAuthorLastName, 7);

   EBPtr->hWndMainWindow_DEAuthorFirstName = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | ES_AUTOHSCROLL | WS_VISIBLE,
                          116, 242, 155, 19,
                          hWindow,
                          idMainWindow_DEAuthorFirstName,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_DEAuthorFirstName)
      {
      LongWarning ("MainWindow_DEAuthorFirstName", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_DEAuthorFirstName = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_DEAuthorFirstName)
      {
      LongWarning ("MainWindow_DEAuthorFirstName", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_DEAuthorFirstName, WM_SETFONT,
                EBPtr->hFontMainWindow_DEAuthorFirstName, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_DEAuthorFirstName,
      (FARPROC) EditSubClass_MainWindow,
      P3_ExtBytesOldEditProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_DEAuthorFirstName, 6);

   EBPtr->hWndMainWindow_BtnAdd = CreateWindow (
                          "BUTTON",
                          "&Add",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          38, 339, 84, 24,
                          hWindow,
                          idMainWindow_BtnAdd,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnAdd)
      {
      LongWarning ("MainWindow_BtnAdd", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnAdd = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "System");
   if (!EBPtr->hFontMainWindow_BtnAdd)
      {
      LongWarning ("MainWindow_BtnAdd", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnAdd, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnAdd, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnAdd,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnAdd, 8);

   EBPtr->hWndMainWindow_BtnDelete = CreateWindow (
                          "BUTTON",
                          "&Delete",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          238, 339, 84, 24,
                          hWindow,
                          idMainWindow_BtnDelete,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnDelete)
      {
      LongWarning ("MainWindow_BtnDelete", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnDelete = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "System");
   if (!EBPtr->hFontMainWindow_BtnDelete)
      {
      LongWarning ("MainWindow_BtnDelete", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnDelete, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnDelete, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnDelete,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnDelete, 10);

   EBPtr->hWndMainWindow_BtnModify = CreateWindow (
                          "BUTTON",
                          "&Modify",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          138, 339, 84, 24,
                          hWindow,
                          idMainWindow_BtnModify,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnModify)
      {
      LongWarning ("MainWindow_BtnModify", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnModify = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "System");
   if (!EBPtr->hFontMainWindow_BtnModify)
      {
      LongWarning ("MainWindow_BtnModify", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnModify, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnModify, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnModify,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnModify, 9);

   EBPtr->hWndMainWindow_BtnFind = CreateWindow (
                          "BUTTON",
                          "&Find",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          397, 102, 84, 24,
                          hWindow,
                          idMainWindow_BtnFind,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnFind)
      {
      LongWarning ("MainWindow_BtnFind", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnFind = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "System");
   if (!EBPtr->hFontMainWindow_BtnFind)
      {
      LongWarning ("MainWindow_BtnFind", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnFind, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnFind, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnFind,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnFind, 11);

   EBPtr->hWndMainWindow_BtnNext = CreateWindow (
                          "BUTTON",
                          "&Next",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          497, 102, 84, 24,
                          hWindow,
                          idMainWindow_BtnNext,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnNext)
      {
      LongWarning ("MainWindow_BtnNext", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnNext = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "System");
   if (!EBPtr->hFontMainWindow_BtnNext)
      {
      LongWarning ("MainWindow_BtnNext", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnNext, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnNext, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnNext,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnNext, 12);

   EBPtr->hWndMainWindow_DECategory = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | ES_AUTOHSCROLL | WS_VISIBLE,
                          116, 180, 155, 19,
                          hWindow,
                          idMainWindow_DECategory,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_DECategory)
      {
      LongWarning ("MainWindow_DECategory", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_DECategory = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_DECategory)
      {
      LongWarning ("MainWindow_DECategory", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_DECategory, WM_SETFONT,
                EBPtr->hFontMainWindow_DECategory, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_DECategory,
      (FARPROC) EditSubClass_MainWindow,
      P3_ExtBytesOldEditProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_DECategory, 5);

   EBPtr->hWndMainWindow_ListBoxBooks = CreateWindow (
                          "LISTBOX",
                          "",
                          WS_CHILD | LBS_NOTIFY | LBS_SORT | 
                                   LBS_USETABSTOPS | LBS_NOINTEGRALHEIGHT | 
                                   LBS_DISABLENOSCROLL | WS_VSCROLL | WS_VISIBLE,
                          380, 167, 216, 140,
                          hWindow,
                          idMainWindow_ListBoxBooks,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_ListBoxBooks)
      {
      LongWarning ("MainWindow_ListBoxBooks", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_ListBoxBooks = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_ListBoxBooks)
      {
      LongWarning ("MainWindow_ListBoxBooks", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_ListBoxBooks, WM_SETFONT,
                EBPtr->hFontMainWindow_ListBoxBooks, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_ListBoxBooks,
      (FARPROC) ListSubClass_MainWindow,
      P3_ExtBytesOldListProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_ListBoxBooks, 13);

   EBPtr->hWndMainWindow_BtnExit = CreateWindow (
                          "BUTTON",
                          "E&xit",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          497, 340, 84, 24,
                          hWindow,
                          idMainWindow_BtnExit,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnExit)
      {
      LongWarning ("MainWindow_BtnExit", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnExit = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "System");
   if (!EBPtr->hFontMainWindow_BtnExit)
      {
      LongWarning ("MainWindow_BtnExit", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnExit, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnExit, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnExit,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnExit, 15);

   EBPtr->hWndMainWindow_DETitle = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | ES_AUTOHSCROLL | WS_VISIBLE,
                          116, 90, 200, 19,
                          hWindow,
                          idMainWindow_DETitle,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_DETitle)
      {
      LongWarning ("MainWindow_DETitle", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_DETitle = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_DETitle)
      {
      LongWarning ("MainWindow_DETitle", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_DETitle, WM_SETFONT,
                EBPtr->hFontMainWindow_DETitle, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_DETitle,
      (FARPROC) EditSubClass_MainWindow,
      P3_ExtBytesOldEditProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_DETitle, 2);

   EBPtr->hWndMainWindow_BtnReports = CreateWindow (
                          "BUTTON",
                          "&Reports",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          397, 340, 84, 24,
                          hWindow,
                          idMainWindow_BtnReports,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnReports)
      {
      LongWarning ("MainWindow_BtnReports", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnReports = P3_GetFont (-13, 700, 0, 0, 0, 0, 1, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "System");
   if (!EBPtr->hFontMainWindow_BtnReports)
      {
      LongWarning ("MainWindow_BtnReports", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnReports, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnReports, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnReports,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnReports, 14);

   GlobalUnlock (P3_hMem);
   return TRUE;
   }


/*=-----------------------------------------------------=*/
void UpdateHandles_MainWindow (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
 *  Store all object handles for this window in global variables.
 */
   {
   HGLOBAL P3_hMem;
   LPMainWindowStruct EBPtr;

   hWndMainWindow = hWindow;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("MainWindow", "Invalid extra bytes pointer.");
      return;
      }  

   hWndMainWindow_DEISBN = EBPtr->hWndMainWindow_DEISBN;
   hWndMainWindow_DETitle = EBPtr->hWndMainWindow_DETitle;
   hWndMainWindow_DESubTitle = EBPtr->hWndMainWindow_DESubTitle;
   hWndMainWindow_DEPublisher = EBPtr->hWndMainWindow_DEPublisher;
   hWndMainWindow_DEAuthorFirstName = EBPtr->hWndMainWindow_DEAuthorFirstName;
   hWndMainWindow_DEAuthorLastName = EBPtr->hWndMainWindow_DEAuthorLastName;
   hWndMainWindow_BtnAdd = EBPtr->hWndMainWindow_BtnAdd;
   hWndMainWindow_BtnDelete = EBPtr->hWndMainWindow_BtnDelete;
   hWndMainWindow_BtnModify = EBPtr->hWndMainWindow_BtnModify;
   hWndMainWindow_BtnFind = EBPtr->hWndMainWindow_BtnFind;
   hWndMainWindow_BtnNext = EBPtr->hWndMainWindow_BtnNext;
   hWndMainWindow_DECategory = EBPtr->hWndMainWindow_DECategory;
   hWndMainWindow_ListBoxBooks = EBPtr->hWndMainWindow_ListBoxBooks;
   hWndMainWindow_BtnExit = EBPtr->hWndMainWindow_BtnExit;
   hWndMainWindow_BtnReports = EBPtr->hWndMainWindow_BtnReports;

   GlobalUnlock (P3_hMem);
   }

     
/*=-----------------------------------------------------=*/
long WINAPI WndProc_MainWindow
   (HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
/*=-----------------------------------------------------=*/
/*
 *  Processes messages for the window.
 */
   {
      /* Phase3-generated declarations */
   HDC         dc;
   PAINTSTRUCT ps;
   HBRUSH      P3_hBrush;
   LPMainWindowStruct EBPtr;
   HGLOBAL     P3_hMem;
   HFONT       P3_hFont;
   HPEN        P3_hPen;
   RECT        P3_rtText;  
   LONG        P3_lHandle;

      /* Your declarations */   
BOOL bOK;

char szTitle[100],
     szEntry[100],
     szISBN[30];

int  iTab;

long lSel;

WORD wSize,
     wSel;     

char * szWork;

HANDLE hTableList;       
   
   


   switch (message)
      {
      case WM_CREATE :
         P3_CreateAutoTabs (hWindow, P3_Phase3Reserved);

         if ((P3_hMem = GlobalAlloc (GHND, sizeof (MainWindowStruct))) == NULL)
            {
            LongWarning ("MainWindow", "Out of memory.");
            return 0;
            }
         SetWindowWord (hWindow, P3_ExtBytesPtr, P3_hMem);  

         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

            /* Initialise brush handle for controls */
         EBPtr->P3_hBrushCtlColor = 0;

            /* Set window background color */
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                           CreateSolidBrush (RGB (192, 192, 192)));  

            /* Create brush for painting background for controls */
         EBPtr->P3_hBrushCtlColor = CreateSolidBrush (RGB (192, 192, 192));

         if (!CreateObjects_MainWindow(hWindow))
            {
            LongWarning ("MainWindow", "Out of memory.");
            return 0;
            }
         UpdateHandles_MainWindow (hWindow);  


/****** Begin user-created code ******/

/*
 *  The following code is executed when the window is first created. The functions
 *  performed by this code are :-
 *     1) Attach the edit boxes to the appropriate database columns allowing 
 *             fields to be extracted and loaded to and from the database.
 *     2) Add the list of book titles from the database to the list box.
 *     3) Set the focus to the first data entry field.
 */

   /* Attach edit boxes to data entry fields */
 DB_EditAttach (hUser, hTable, "ISBN", hWndMainWindow_DEISBN ) ;
 DB_EditAttach (hUser, hTable, "Title", hWndMainWindow_DETitle ) ;
 DB_EditAttach (hUser, hTable, "SubTitle", hWndMainWindow_DESubTitle ) ;
 DB_EditAttach (hUser, hTable, "Publisher", hWndMainWindow_DEPublisher ) ;
 DB_EditAttach (hUser, hTable, "Category", hWndMainWindow_DECategory ) ;
 DB_EditAttach (hUser, hTable, "AuthorFirstName", hWndMainWindow_DEAuthorFirstName ) ;
 DB_EditAttach (hUser, hTable, "AuthorLastName", hWndMainWindow_DEAuthorLastName ) ;

   /* Set tab stop in list box to outside right hand edge */
iTab = 220;
 SendMessage (hWndMainWindow_ListBoxBooks, LB_SETTABSTOPS, 1, (long) (LPINT) &iTab ) ;   

   /* Get all entries from database and add to listbox */
 SendMessage (hWndMainWindow_ListBoxBooks, LB_RESETCONTENT, 0, 0 ) ;   
 SendMessage (hWndMainWindow_ListBoxBooks, WM_SETREDRAW, 0, 0 ) ;   
szWork = (char *) malloc (100);
 DB_GetFirstRow (hUser, hTable, &bOK ) ;
while (bOK) 
   {
    DB_GetText (hUser, hTable, "Title", szWork ) ;
   strcpy (szTitle, szWork);
   strcat (szTitle, "\t");   
    DB_GetText (hUser, hTable, "ISBN", szWork ) ;
   strcat (szTitle, szWork);
    P3_LBAddText (hWndMainWindow_ListBoxBooks, szTitle ) ;
    DB_GetNextRow (hUser, hTable, &bOK ) ;
   }
free (szWork);
 SendMessage (hWndMainWindow_ListBoxBooks, WM_SETREDRAW, 1, 0 ) ;   

   /* Set the focus to the ISBN data entry field */
 SetFocus (hWndMainWindow_DEISBN ) ;

   /* Disable the NEXT button */
 EnableWindow (hWndMainWindow_BtnNext, FALSE ) ;
bFind = FALSE;


/******* End user-created code *******/

         GlobalUnlock (P3_hMem);  

         return 0;

      case WM_SETFOCUS :
         UpdateHandles_MainWindow (hWindow);  
         return 0;  

      case WM_CTLCOLOR :
            /* Paint background of buttons with screen color */
         if (HIWORD (lParam) == CTLCOLOR_BTN)
            {
            P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
            if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
               {
               LongWarning ("MainWindow", "Global lock error.");
               return 0;
               }
            if (EBPtr->P3_hBrushCtlColor)
               {
               SetBkMode ((HDC) wParam, TRANSPARENT);
               SetTextColor ((HDC) wParam, GetSysColor (COLOR_WINDOWTEXT));
               GlobalUnlock (P3_hMem);
               return (LONG) EBPtr->P3_hBrushCtlColor;
               }
            GlobalUnlock (P3_hMem);
            }
         break;

      case WM_PAINT :  /* window being painted */
         P3_hFont = 0;

         /* Get a pointer to the extra-bytes */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

         dc = BeginPaint (hWindow, &ps);
         if (!dc)
            {
            LongWarning ("MainWindow", "Cannot get a device context.");
            return 0;
            }

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 9, 11, 351, 308, 3, 
                            RGB (255, 255, 255), RGB (128, 128, 128));

            /* Paint static text on the screen */
         if (P3_hFont != 0)
            DeleteObject (P3_hFont);
         P3_hFont = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                FF_SWISS + VARIABLE_PITCH, "Arial");
         SelectObject (dc, P3_hFont);
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 1, 59, 108, 79);
         DrawText (dc, "ISBN", 4,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 1, 89, 108, 109);
         DrawText (dc, "Title", 5,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 1, 119, 108, 139);
         DrawText (dc, "SubTitle", 8,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 1, 149, 108, 169);
         DrawText (dc, "Publisher", 9,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 22, 241, 108, 261);
         DrawText (dc, "First Name", 10,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 22, 271, 108, 291);
         DrawText (dc, "Last Name", 9,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 2, 90, 109, 110);
         DrawText (dc, "Title", 5,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 2, 120, 109, 140);
         DrawText (dc, "SubTitle", 8,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 2, 150, 109, 170);
         DrawText (dc, "Publisher", 9,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 23, 242, 109, 262);
         DrawText (dc, "First Name", 10,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 23, 272, 109, 292);
         DrawText (dc, "Last Name", 9,
                   &P3_rtText, 34);

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 113, 86, 319, 112, 2, 
                            RGB (128, 128, 128), RGB (255, 255, 255));

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 113, 268, 274, 294, 2, 
                            RGB (128, 128, 128), RGB (255, 255, 255));

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 113, 238, 274, 264, 2, 
                            RGB (128, 128, 128), RGB (255, 255, 255));

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 113, 176, 274, 202, 2, 
                            RGB (128, 128, 128), RGB (255, 255, 255));

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 113, 116, 319, 142, 2, 
                            RGB (128, 128, 128), RGB (255, 255, 255));

            /* Paint static text on the screen */
         if (P3_hFont != 0)
            DeleteObject (P3_hFont);
         P3_hFont = P3_GetFont (-21, 700, 0, 0, 0, 0, 3, 2, 
                                FF_ROMAN + VARIABLE_PITCH, "Times New Roman");
         SelectObject (dc, P3_hFont);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 22, 210, 98, 236);
         DrawText (dc, "Author", 6,
                   &P3_rtText, 16);

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 9, 318, 351, 384, 3, 
                            RGB (255, 255, 255), RGB (128, 128, 128));

            /* Draw a rectangle on the screen */
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPen = SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (128, 128, 128)));
         Rectangle (dc, 25, 328, 334, 373);
         DeleteObject (SelectObject (dc, P3_hPen));

            /* Draw a rectangle on the screen */
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPen = SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (255, 255, 255)));
         Rectangle (dc, 26, 329, 335, 374);
         DeleteObject (SelectObject (dc, P3_hPen));

            /* Paint static text on the screen */
         if (P3_hFont != 0)
            DeleteObject (P3_hFont);
         P3_hFont = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                FF_SWISS + VARIABLE_PITCH, "Arial");
         SelectObject (dc, P3_hFont);
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 1, 179, 108, 199);
         DrawText (dc, "Category", 8,
                   &P3_rtText, 34);

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 113, 146, 274, 172, 2, 
                            RGB (128, 128, 128), RGB (255, 255, 255));

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 2, 180, 109, 200);
         DrawText (dc, "Category", 8,
                   &P3_rtText, 34);

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 361, 11, 618, 70, 3, 
                            RGB (255, 255, 255), RGB (128, 128, 128));

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 375, 162, 601, 312, 3, 
                            RGB (128, 128, 128), RGB (255, 255, 255));

            /* Draw a rectangle on the screen */
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPen = SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (255, 255, 255)));
         Rectangle (dc, 376, 331, 600, 373);
         DeleteObject (SelectObject (dc, P3_hPen));

            /* Draw a rectangle on the screen */
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPen = SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (255, 255, 255)));
         Rectangle (dc, 377, 93, 601, 135);
         DeleteObject (SelectObject (dc, P3_hPen));

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 361, 80, 618, 384, 3, 
                            RGB (255, 255, 255), RGB (128, 128, 128));

            /* Draw a rectangle on the screen */
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPen = SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (128, 128, 128)));
         Rectangle (dc, 375, 330, 599, 372);
         DeleteObject (SelectObject (dc, P3_hPen));

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 2, 60, 109, 80);
         DrawText (dc, "ISBN", 4,
                   &P3_rtText, 34);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (255, 255, 255));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 375, 144, 435, 162);
         DrawText (dc, "Books", 5,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         if (P3_hFont != 0)
            DeleteObject (P3_hFont);
         P3_hFont = P3_GetFont (-21, 700, 0, 0, 0, 0, 3, 2, 
                                FF_ROMAN + VARIABLE_PITCH, "Times New Roman");
         SelectObject (dc, P3_hFont);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 22, 26, 78, 50);
         DrawText (dc, "Book", 4,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         if (P3_hFont != 0)
            DeleteObject (P3_hFont);
         P3_hFont = P3_GetFont (-13, 700, 0, 0, 0, 0, 3, 2, 
                                FF_SWISS + VARIABLE_PITCH, "Arial");
         SelectObject (dc, P3_hFont);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 376, 145, 436, 163);
         DrawText (dc, "&Books", 6,
                   &P3_rtText, 16);

            /* Draw a relief rectangle on the screen */
         P3_DrawReliefRect (dc, 113, 56, 274, 82, 2, 
                            RGB (128, 128, 128), RGB (255, 255, 255));

            /* Draw a rectangle on the screen */
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPen = SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (128, 128, 128)));
         Rectangle (dc, 376, 92, 600, 134);
         DeleteObject (SelectObject (dc, P3_hPen));

            /* Paint static text on the screen */
         if (P3_hFont != 0)
            DeleteObject (P3_hFont);
         P3_hFont = P3_GetFont (-37, 700, 0, 0, 0, 0, 3, 2, 
                                FF_ROMAN + VARIABLE_PITCH, "Times New Roman");
         SelectObject (dc, P3_hFont);
         SetTextColor (dc, RGB (0, 0, 128));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 380, 17, 598, 64);
         DrawText (dc, "Book Library", 12,
                   &P3_rtText, 53);

         if (P3_hFont != 0)
            DeleteObject (P3_hFont);

         GlobalUnlock (P3_hMem);
         EndPaint (hWindow, &ps);
         return 0;

      case WM_SYSCHAR :
         /* There is some user code, so get the extra-bytes pointer */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

/****** Begin user-created code ******/

if (ProcessHotKeys (wParam) )
   return 0;


/******* End user-created code *******/

         GlobalUnlock (P3_hMem);
         return 0;

      case WM_COMMAND :
         switch (wParam)
            {
            case idMainWindow_BtnAdd :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
/*
 *  ADD Button pressed : Make sure required data entry fields have been entered
 *      and add to database. If entry already exists for given ISBN value then
 *      display an error. If add successful then add book title to listbox.
 */

if (!ValidateDataEntryFields (FALSE) )
   return 0;
   
   /* Add entry to database */
if (! DB_EditsAddToTable (hUser, hTable ) )
   {
   MessageBeep (0);
   return 0;
   }
   
   /* Add entry to listbox */
szWork = (char *) malloc (120);   
GetWindowText (hWndMainWindow_DETitle, szEntry, 100);
strcpy (szWork, szEntry);
strcat (szWork, "\t");
GetWindowText (hWndMainWindow_DEISBN, szEntry, 100);
strcat (szWork, szEntry);
 lSel = SendMessage (hWndMainWindow_ListBoxBooks, LB_ADDSTRING, 0, (long) (LPSTR) szWork ) ;
free (szWork);
 SendMessage (hWndMainWindow_ListBoxBooks, LB_SETCURSEL, (WORD) lSel, 0 ) ;   

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, (WORD) -1 ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnDelete :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
/*
 *  DELETE Button pressed : Make sure required data entry fields have been entered
 *      and delete from database. 
 */

if (!ValidateDataEntryFields (TRUE) )
   return 0;
   
if ( MessageBox (hWndMainWindow, "Do you want to delete this database entry ?", 
                 "Confirm Delete", MB_YESNO | MB_DEFBUTTON2 | MB_ICONQUESTION )  == IDNO)
   return 0;
   
   /* Get existing entry from database */
GetWindowText (hWndMainWindow_DEISBN, szISBN, 30);
szWork = (char *) malloc (120);
strcpy (szWork, "ISBN = ^");
strcat (szWork, szISBN);
strcat (szWork, "^");
 DB_GetFirstRowWhere (hUser, hTable, szWork, &bOK ) ;   
if (!bOK) 
   {
   free (szWork);
   return 0;
   }

   /* Build list box entry for deleting entry from list box */
 DB_GetText (hUser, hTable, "Title", szEntry ) ;
strcpy (szWork, szEntry);
strcat (szWork, "\t");
 DB_GetText (hUser, hTable, "ISBN", szEntry ) ;
strcat (szWork, szEntry);

   /* Delete database entry */
 DB_DeleteRow (hUser, hTable, &bOK ) ;   

   /* Delete the entry from the list box */
 lSel = SendMessage (hWndMainWindow_ListBoxBooks, LB_FINDSTRINGEXACT, (WORD) -1, (long) (LPSTR) szWork ) ;
if (lSel != LB_ERR)
    P3_LBDeleteLine (hWndMainWindow_ListBoxBooks, (int) lSel ) ;

free (szWork);

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, (WORD) -1) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnModify :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
/*
 *  MODIFY Button pressed : Make sure required data entry fields have been entered
 *      and modify entry in database. 
 */

if (!ValidateDataEntryFields (FALSE) )
   return 0;
   
   /* Get existing entry from database */
GetWindowText (hWndMainWindow_DEISBN, szISBN, 30);
szWork = (char *) malloc (120);
strcpy (szWork, "ISBN = ^");
strcat (szWork, szISBN);
strcat (szWork, "^");
 DB_GetFirstRowWhere (hUser, hTable, szWork, &bOK ) ;   
if (!bOK)
   {
   free (szWork);
   return 0;
   }

   /* Build list box entry for existing entry for search later */
 DB_GetText (hUser, hTable, "Title", szEntry ) ;
strcpy (szWork, szEntry);
strcat (szWork, "\t");
 DB_GetText (hUser, hTable, "ISBN", szEntry ) ;
strcat (szWork, szEntry);

   /* Update row in database */
 bOK = DB_EditsUpdateRow (hUser, hTable ) ;   
if (!bOK)
   {
   free (szWork);
   MessageBeep (0);
   return 0;
   }

   /* Find the matching entry in the list box */
 lSel = SendMessage (hWndMainWindow_ListBoxBooks, LB_FINDSTRINGEXACT, (WORD) -1, (long) (LPSTR) szWork ) ;
if (lSel != LB_ERR)
    P3_LBDeleteLine (hWndMainWindow_ListBoxBooks, (int) lSel ) ;

   /* Build list box entry for updated entry */
 DB_GetText (hUser, hTable, "Title", szEntry ) ;
strcpy (szWork, szEntry);
strcat (szWork, "\t");
 DB_GetText (hUser, hTable, "ISBN", szEntry ) ;
strcat (szWork, szEntry);
   
   /* Update entry in listbox */
if (lSel != LB_ERR)
    P3_LBInsertText (hWndMainWindow_ListBoxBooks, (int) lSel, szWork ) ;
else
    P3_LBAddText (hWndMainWindow_ListBoxBooks, szWork ) ;

free (szWork);

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, (WORD) -1) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnFind :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
/*
 *  FIND Button pressed : Find the first entry that matches the criteria in the edit boxes.
 */
   
   /* Build search criteria */
bFirst = TRUE;
szFind = (char *) malloc (500);
bFind = TRUE;
strcpy (szFind, "");
BuildFindString (hWndMainWindow_DEISBN, "ISBN") ;
BuildFindString (hWndMainWindow_DETitle, "Title") ;
BuildFindString (hWndMainWindow_DESubTitle, "SubTitle") ;
BuildFindString (hWndMainWindow_DEPublisher, "Publisher") ;
BuildFindString (hWndMainWindow_DECategory, "Category") ;
BuildFindString (hWndMainWindow_DEAuthorFirstName, "AuthorFirstName") ;
BuildFindString (hWndMainWindow_DEAuthorLastName, "AuthorLastName") ;

if (bFirst)
   {
    MessageBox (hWndMainWindow, "Enter search criteria in appropriate data entry field(s)", 
                 "No Search Criteria", MB_OK | MB_ICONEXCLAMATION ) ;
    SetFocus (hWndMainWindow_DEISBN ) ;
    P3_EditSetSel (hWndMainWindow_DEISBN, 0, (WORD) -1) ;
   free (szFind);
   return 0;
   }
   
 DB_GetFirstRowWhere (hUser, hTable, szFind, &bOK ) ;   
free (szFind);
if (!bOK)
   {
    MessageBox (hWndMainWindow, "No entry found matching search criteria", 
                 "Search", MB_OK | MB_ICONINFORMATION ) ;
    EnableWindow (hWndMainWindow_BtnNext, FALSE ) ;
   bFind = FALSE;
   }
else
   {
      /* Fill data entry boxes with matching row from database */
    bOK = DB_EditsFromRow (hUser, hTable ) ;
    EnableWindow (hWndMainWindow_BtnNext, TRUE ) ;
      /* Select matching entry in listbox */
   szWork = (char *) malloc (120);
    DB_GetText (hUser, hTable, "Title", szWork ) ;
   strcpy (szTitle, szWork);
   strcat (szTitle, "\t");
    DB_GetText (hUser, hTable, "ISBN", szWork ) ;
   strcat (szTitle, szWork);
    P3_LBSelectString (hWndMainWindow_ListBoxBooks, szTitle ) ;
   free (szWork);
   }

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, (WORD) -1 ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnNext :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   /* Don't do anything if FIND has not yet been done */
if (!bFind)
   return 0;

   /* Find next row in database that matches search criteria */
 DB_GetNextRowWhere (hUser, hTable, &bOK ) ;   
if (!bOK)
   {
    MessageBox (hWndMainWindow, "No more entries matching search criteria", 
                 "Search", MB_OK | MB_ICONINFORMATION ) ;
    EnableWindow (hWndMainWindow_BtnNext, FALSE ) ;
   }
else
   {
      /* Fill data entry boxes with matching row from database */
    bOK = DB_EditsFromRow (hUser, hTable ) ;
      /* Select matching entry in listbox */
   szWork = (char *) malloc (120);
    DB_GetText (hUser, hTable, "Title", szWork ) ;
   strcpy (szTitle, szWork);
   strcat (szTitle, "\t");
    DB_GetText (hUser, hTable, "ISBN", szWork ) ;
   strcat (szTitle, szWork);
    P3_LBSelectString (hWndMainWindow_ListBoxBooks, szTitle ) ;
   free (szWork);
   }

 SetFocus (hWndMainWindow_DEISBN ) ;
 P3_EditSetSel (hWndMainWindow_DEISBN, 0, (WORD) -1) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_ListBoxBooks :
               switch (HIWORD(lParam))
                  {
                  case LBN_SELCHANGE :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
/*
 *  The following code is executed whenever a item is selected in the listbox. The data is
 *  retrieved from the listbox and, using the ISBN value extracted from the listbox row, the 
 *  appropriate database row is then displayed in the edit boxes.
 */

   /* Get the ISBN from the currently selected entry from the list box */
wSel = (WORD)  SendMessage (hWndMainWindow_ListBoxBooks, LB_GETCURSEL, 0, 0 ) ;
if (! P3_LBGetTabText (hWndMainWindow_ListBoxBooks, wSel, 2, (LPSTR) szISBN, 30 ) )
   {
   MessageBeep (0);
   return 0;
   }

   /* Extract the row for the given ISBN value from the database */
szWork = (char *) malloc (120);
strcpy (szWork, "ISBN = ^");
strcat (szWork, szISBN);
strcat (szWork, "^");
 DB_GetFirstRowWhere (hUser, hTable, szWork, &bOK ) ;   
if (bOK)
    bOK = DB_EditsFromRow (hUser, hTable ) ;
else
   MessageBeep (0);
free (szWork);

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnExit :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
 P3_WinClose (hWndMainWindow ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnReports :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
/*
 *  REPORTS button pressed : Call reports dialog box to select type of report
 *         to print and destination.
 */

ReportsDialog (hWndMainWindow) ;
 SetFocus (hWndMainWindow_BtnReports ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
               break; 

            } /* wParam */


         break;  

      case WM_CLOSE:            /* message: window being closed */ 
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

/****** Begin user-created code ******/
CleanUp () ;

/******* End user-created code *******/

         GlobalUnlock (P3_hMem);
         break;  
      
      case WM_DESTROY:            /* message: window being destroyed */
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }   

/****** Begin user-created code ******/
PostQuitMessage(0);

/******* End user-created code *******/


            /* Delete brush for painting background for controls */
         if (EBPtr->P3_hBrushCtlColor)
            DeleteObject (EBPtr->P3_hBrushCtlColor);
         DeleteObject (EBPtr->hFontMainWindow_DEISBN);
         DeleteObject (EBPtr->hFontMainWindow_DETitle);
         DeleteObject (EBPtr->hFontMainWindow_DESubTitle);
         DeleteObject (EBPtr->hFontMainWindow_DEPublisher);
         DeleteObject (EBPtr->hFontMainWindow_DEAuthorFirstName);
         DeleteObject (EBPtr->hFontMainWindow_DEAuthorLastName);
         DeleteObject (EBPtr->hFontMainWindow_BtnAdd);
         DeleteObject (EBPtr->hFontMainWindow_BtnDelete);
         DeleteObject (EBPtr->hFontMainWindow_BtnModify);
         DeleteObject (EBPtr->hFontMainWindow_BtnFind);
         DeleteObject (EBPtr->hFontMainWindow_BtnNext);
         DeleteObject (EBPtr->hFontMainWindow_DECategory);
         DeleteObject (EBPtr->hFontMainWindow_ListBoxBooks);
         DeleteObject (EBPtr->hFontMainWindow_BtnExit);
         DeleteObject (EBPtr->hFontMainWindow_BtnReports);
         GlobalUnlock (P3_hMem);
         GlobalFree (P3_hMem);
         P3_DestroyAutoTabs (hWindow);
         return 0;
      }
   return (DefWindowProc(hWindow, message, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL MainWindow (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
 *  Creates and displays the window.
 */
   {
   HWND hWnd;   

   hWnd = CreateWindow(
      "MainWindow Class",
      "Phase3 Sample - Book Library",   
      WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | 
                   WS_MINIMIZEBOX | WS_VISIBLE,
      CW_USEDEFAULT,     
      CW_USEDEFAULT,
      635,  
      420,  
      hOwner,                        
      NULL,   
      hInst,  
      NULL    
      );

   /* If window could not be created, return "failure" */

   if (!hWnd)
      {
      LongWarning ("MainWindow", "Could not create window.");
      return (FALSE);
      }

   /* Make the window visible; update its client area; and return "success" */

   UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
   return (TRUE);               /* Returns the value from PostQuitMessage */

   }   

/*=-----------------------------do-not-remove-this-line-=*/
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpCmdLine,
                    int    nCmdShow)
/*=-----------------------------do-not-remove-this-line-=*/

/*
   WinMain Procedure
   =================
 
   This procedure is the main windows procedure and is used to register,
   create and show the window, and wait for windows messages.
*/
 
   {
   MSG msg;  /* message */

   hInst = hInstance;
   nShowMain = nCmdShow;
   lpCommandLine = lpCmdLine;

   if (!hPrevInstance) /* Other instances of app running? */
      {
      if (!P3_RegisterWindows ())
         return (FALSE);            
      if (!P3_RegisterReportWindow ())
         return (FALSE);            
      };         

   Initialise() ;
   
   if (!MainWindow(0))
      return (FALSE);
   
   while (GetMessage (&msg, NULL, NULL, NULL))
      {
      TranslateMessage(&msg);  /* Translates virtual key codes	     */
      DispatchMessage(&msg);   /* Dispatches message to window	     */
      }
      
   return (msg.wParam);        /* Return the value from PostQuitMessage */
   }



/*=-----------------------------------------------------=*/
BOOL P3_RegisterWindows (void)
/*=-----------------------------------------------------=*/
/*
   Initializes window data and registers window class.
 */
   {
   WNDCLASS  wc;  

   /* Window class structure for MainWindow */

   wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
   wc.lpfnWndProc   = WndProc_MainWindow;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = P3_TotalExtBytes;
   wc.hInstance     = hInst;
   wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;  /* Use Windows color */
   wc.lpszMenuName  = "";
   wc.lpszClassName = "MainWindow Class";

   /* Register the window class and return success/failure code. */

   if (!RegisterClass(&wc))
      {
      LongWarning ("MainWindow", "Could not register window.");
      return (FALSE);
      }        

   return (TRUE);
   }   

