/* extra bytes constants */

#define P3_ExtBytesPtr             0   /* pointer to user data                           */
#define P3_ExtBytesOldEditProc     4   /* pointer to wnd proc for edit sub-classing      */
#define P3_ExtBytesOldButtonProc   8   /* pointer to wnd proc for button sub-classing    */
#define P3_ExtBytesOldListProc     12  /* pointer to wnd proc for list box sub-classing  */
#define P3_ExtBytesOldComboProc    16  /* pointer to wnd proc for combo box sub-classing */
#define P3_Phase3Reserved          20  /* used internally by Phase3                      */
#define P3_TotalExtBytes           22  /* total number of extra bytes                    */

/* Prototypes for all Window processes */

BOOL BitmapWindow (HWND hOwner);
BOOL MainWindow (HWND hOwner);

/************************************
Prototypes for all Dialog processes */


/************************************
Prototypes for all Report processes */


/* Prototypes for all Stub processes */


#define idBitmapWindow  1

/* Global window handles for "BitmapWindow" */

HWND hWndBitmapWindow;

/* Extra bytes structure for "BitmapWindow" */

typedef struct tagBitmapWindowStruct
   {
   HBRUSH P3_hBrushCtlColor;
   } BitmapWindowStruct;
typedef BitmapWindowStruct FAR* LPBitmapWindowStruct;


BOOL UpdateListBoxes (BOOL bDefault);

int ProcessHotKeys (int cKey);

void FileExpand (char * szFileOut, char * szFileIn);

void ChangeDirectory (char *szPath);
#define idMainWindow  2
#define idMainWindow_ListFiles  3
#define idMainWindow_ListDirs  4
#define idMainWindow_TEXT1  5
#define idMainWindow_TEXT2  6
#define idMainWindow_TEXT3  7
#define idMainWindow_EditBitmap  8
#define idMainWindow_STATIC1  9
#define idMainWindow_BtnAsis  10
#define idMainWindow_BtnStretch  11
#define idMainWindow_BtnTile  12
#define idMainWindow_STATIC2  13
#define idMainWindow_BtnDisplay  14
#define idMainWindow_BtnExit  15
#define idMainWindow_TEXT4  16
#define idMainWindow_TEXT5  17
#define idMainWindow_TEXT6  18
#define idMainWindow_TEXT7  19
#define idMainWindow_STATIC4  20
#define idMainWindow_TEXT8  21

/* Global window handles for "MainWindow" */

HWND hWndMainWindow,
     hWndMainWindow_ListFiles,
     hWndMainWindow_ListDirs,
     hWndMainWindow_TEXT1,
     hWndMainWindow_TEXT2,
     hWndMainWindow_TEXT3,
     hWndMainWindow_EditBitmap,
     hWndMainWindow_STATIC1,
     hWndMainWindow_BtnAsis,
     hWndMainWindow_BtnStretch,
     hWndMainWindow_BtnTile,
     hWndMainWindow_STATIC2,
     hWndMainWindow_BtnDisplay,
     hWndMainWindow_BtnExit,
     hWndMainWindow_TEXT4,
     hWndMainWindow_TEXT5,
     hWndMainWindow_TEXT6,
     hWndMainWindow_TEXT7,
     hWndMainWindow_STATIC4,
     hWndMainWindow_TEXT8;

/* Extra bytes structure for "MainWindow" */

typedef struct tagMainWindowStruct
   {
   HBRUSH P3_hBrushCtlColor;
   HWND hWndMainWindow_ListFiles;
   HWND hWndMainWindow_ListDirs;
   HWND hWndMainWindow_TEXT1;
   HWND hWndMainWindow_TEXT2;
   HWND hWndMainWindow_TEXT3;
   HWND hWndMainWindow_EditBitmap;
   HWND hWndMainWindow_STATIC1;
   HWND hWndMainWindow_BtnAsis;
   HWND hWndMainWindow_BtnStretch;
   HWND hWndMainWindow_BtnTile;
   HWND hWndMainWindow_STATIC2;
   HWND hWndMainWindow_BtnDisplay;
   HWND hWndMainWindow_BtnExit;
   HWND hWndMainWindow_TEXT4;
   HWND hWndMainWindow_TEXT5;
   HWND hWndMainWindow_TEXT6;
   HWND hWndMainWindow_TEXT7;
   HWND hWndMainWindow_STATIC4;
   HWND hWndMainWindow_TEXT8;
   HFONT hFontMainWindow_ListFiles;
   HFONT hFontMainWindow_ListDirs;
   HFONT hFontMainWindow_TEXT1;
   HFONT hFontMainWindow_TEXT2;
   HFONT hFontMainWindow_TEXT3;
   HFONT hFontMainWindow_EditBitmap;
   HFONT hFontMainWindow_STATIC1;
   HFONT hFontMainWindow_BtnAsis;
   HFONT hFontMainWindow_BtnStretch;
   HFONT hFontMainWindow_BtnTile;
   HFONT hFontMainWindow_STATIC2;
   HFONT hFontMainWindow_BtnDisplay;
   HFONT hFontMainWindow_BtnExit;
   HFONT hFontMainWindow_TEXT4;
   HFONT hFontMainWindow_TEXT5;
   HFONT hFontMainWindow_TEXT6;
   HFONT hFontMainWindow_TEXT7;
   HFONT hFontMainWindow_STATIC4;
   HFONT hFontMainWindow_TEXT8;
RECT rectHeight;               // Coords for displaying bitmap height
RECT rectWidth;                // Coords for displaying bitmap width
int  nHeight;                  // Current bitmap height (in pixels)
int  nWidth;                   // Current bitmap width (in pixels)

   } MainWindowStruct;
typedef MainWindowStruct FAR* LPMainWindowStruct;


int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpCmdLine,
                    int    nCmdShow);
/* User-created global declarations */

#include "BMPVWRC.dcl"
