#include <windows.h>     /* required for all Windows applications */
#include "DBProcs.h"     /* Phase3 database */
#include "RPProcs.h"     /* Phase3 reports */
#include "BMPVWRC.h"    /* required for this application */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <direct.h>
#include <ctype.h>

HANDLE hInst;            /* current instance of this application */
int    nShowMain;        /* SW constant for showing main window */
LPSTR  lpCommandLine;    /* command-line parameters */


/*========================================================================
 *
 *  Program generated by Phase3 :- 
 *
 *      Date : Thursday, July 22, 1993
 *
 *      Time : 08:01am
 *
 *======================================================================*/


#include "P3Procs.h"   /* Phase3 "P3_" DLL routines */
#include "P3User.h"    /* Phase3 routines as source in P3User.C */

BOOL P3_RegisterWindows (void);  

/*=-----------------------------------------------------=*/
BOOL CreateObjects_BitmapWindow (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
   Create all objects on this window.
*/
   {
   HGLOBAL P3_hMem;
   int     P3_nWidth,
           P3_nHeight,
           P3_nRetCode;
   LPBitmapWindowStruct EBPtr;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPBitmapWindowStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("BitmapWindow", "Invalid extra bytes pointer.");
      return FALSE;
      }  

   GlobalUnlock (P3_hMem);
   return TRUE;
   }


/*=-----------------------------------------------------=*/
void UpdateHandles_BitmapWindow (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
 *  Store all object handles for this window in global variables.
 */
   {
   HGLOBAL P3_hMem;
   LPBitmapWindowStruct EBPtr;

   hWndBitmapWindow = hWindow;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPBitmapWindowStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("BitmapWindow", "Invalid extra bytes pointer.");
      return;
      }  


   GlobalUnlock (P3_hMem);
   }

     
/*=-----------------------------------------------------=*/
long WINAPI WndProc_BitmapWindow
   (HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
/*=-----------------------------------------------------=*/
/*
 *  Processes messages for the window.
 */
   {
      /* Phase3-generated declarations */
   HDC         dc;
   PAINTSTRUCT ps;
   HBRUSH      P3_hBrush;
   LPBitmapWindowStruct EBPtr;
   HGLOBAL     P3_hMem;
   HFONT       P3_hFont;
   HPEN        P3_hPen;
   RECT        P3_rtText;  
   LONG        P3_lHandle;


   switch (message)
      {
      case WM_CREATE :
         P3_CreateAutoTabs (hWindow, P3_Phase3Reserved);

         if ((P3_hMem = GlobalAlloc (GHND, sizeof (BitmapWindowStruct))) == NULL)
            {
            LongWarning ("BitmapWindow", "Out of memory.");
            return 0;
            }
         SetWindowWord (hWindow, P3_ExtBytesPtr, P3_hMem);  

         if ((EBPtr = (LPBitmapWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("BitmapWindow", "Global lock error.");
            return 0;
            }

            /* Initialise brush handle for controls */
         EBPtr->P3_hBrushCtlColor = 0;

         if (!CreateObjects_BitmapWindow(hWindow))
            {
            LongWarning ("BitmapWindow", "Out of memory.");
            return 0;
            }
         UpdateHandles_BitmapWindow (hWindow);  

         return 0;

      case WM_SETFOCUS :
         UpdateHandles_BitmapWindow (hWindow);  
         return 0;  

      case WM_CTLCOLOR :
            /* Paint background of buttons with screen color */
         if (HIWORD (lParam) == CTLCOLOR_BTN)
            {
            P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
            if ((EBPtr = (LPBitmapWindowStruct) GlobalLock (P3_hMem)) == NULL)
               {
               LongWarning ("BitmapWindow", "Global lock error.");
               return 0;
               }
            if (EBPtr->P3_hBrushCtlColor)
               {
               SetBkMode ((HDC) wParam, TRANSPARENT);
               SetTextColor ((HDC) wParam, GetSysColor (COLOR_WINDOWTEXT));
               GlobalUnlock (P3_hMem);
               return (LONG) EBPtr->P3_hBrushCtlColor;
               }
            GlobalUnlock (P3_hMem);
            }
         break;

      case WM_PAINT :  /* window being painted */
         P3_hFont = 0;

         /* Get a pointer to the extra-bytes */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPBitmapWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("BitmapWindow", "Global lock error.");
            return 0;
            }

         dc = BeginPaint (hWindow, &ps);
         if (!dc)
            {
            LongWarning ("BitmapWindow", "Cannot get a device context.");
            return 0;
            }

/****** Begin user-created code for "WM_PAINT" ******/

   /* Display the selected bitmap using the selected style */
if (hBMP)
   switch (wDisplayStyle)
      {
      case idMainWindow_BtnAsis :         // Display the bitmap ASIS
          P3_BitmapPaintWindow (hWndBitmapWindow, hBMP, P3BP_IGNORE, SRCCOPY ) ;
         break;

      case idMainWindow_BtnStretch :      // Stretch/Shrink bitmap to fit window coords
          P3_BitmapPaintWindow (hWndBitmapWindow, hBMP, P3BP_STRETCH, SRCCOPY ) ;
         break;

      case idMainWindow_BtnTile :         // Tile the bitmap as many times as will fit
          P3_BitmapPaintWindow (hWndBitmapWindow, hBMP, P3BP_TILE, SRCCOPY ) ;
         break;
         
      }
   
/******* End user-created code for "WM_PAINT" *******/

         if (P3_hFont != 0)
            DeleteObject (P3_hFont);

         GlobalUnlock (P3_hMem);
         EndPaint (hWindow, &ps);
         return 0;

      case WM_COMMAND :

         break;  

      
      case WM_DESTROY:            /* message: window being destroyed */
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPBitmapWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("BitmapWindow", "Global lock error.");
            return 0;
            }   

            /* Delete brush for painting background for controls */
         if (EBPtr->P3_hBrushCtlColor)
            DeleteObject (EBPtr->P3_hBrushCtlColor);
         GlobalUnlock (P3_hMem);
         GlobalFree (P3_hMem);
         P3_DestroyAutoTabs (hWindow);
         return 0;
      }
   return (DefWindowProc(hWindow, message, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL BitmapWindow (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
 *  Creates and displays the window.
 */
   {
   HWND hWnd;   

   hWnd = CreateWindow(
      "BitmapWindow Class",
      "",   
      WS_CHILD | WS_VISIBLE,
      275,     
      8,
      311,  
      306,  
      hOwner,                        
      NULL,   
      hInst,  
      NULL    
      );

   /* If window could not be created, return "failure" */

   if (!hWnd)
      {
      LongWarning ("BitmapWindow", "Could not create window.");
      return (FALSE);
      }

   /* Make the window visible; update its client area; and return "success" */

   UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
   return (TRUE);               /* Returns the value from PostQuitMessage */

   }   

/*=-------------------------------do-not-remove-this-line-=*/
BOOL UpdateListBoxes (BOOL bDefault)
/*=-------------------------------do-not-remove-this-line-=*/

//
//  Display a list of bitmap files (those with BMP extension) in the current directory,
//  and display a list of subdirectories and drives.
//

{
   char szDir[100];

      //* Fill Files list box with list of BMP files in current directory
    SendMessage (hWndMainWindow_ListFiles, LB_RESETCONTENT, 0, 0 ) ;
    SendMessage (hWndMainWindow_ListFiles, LB_DIR, DDL_READWRITE, (long) (LPSTR) szBMPExt ) ;

      //* Fill Directories list box
    SendMessage (hWndMainWindow_ListDirs, LB_RESETCONTENT, 0, 0 ) ;
   if ( SendMessage (hWndMainWindow_ListDirs, LB_DIR, 
                      DDL_EXCLUSIVE | DDL_DRIVES | DDL_DIRECTORY, 
                      (long) (LPSTR) szDefExt )  == LB_ERR)
      return FALSE;

      //* Display "*.BMP" in the edit box
   if (bDefault)
       SetWindowText (hWndMainWindow_EditBitmap, szBMPExt ) ;

      //* Display the current directory
   _getdcwd (0, szDirectory, sizeof (szDirectory));
    InvalidateRect (hWndMainWindow, &rectDir, TRUE ) ;

    SetFocus (hWndMainWindow_EditBitmap ) ;   
   return TRUE;
}   



/*=-------------------------------do-not-remove-this-line-=*/
int ProcessHotKeys (int cKey)
/*=-------------------------------do-not-remove-this-line-=*/

//
//  Perform required action depending upon which ALT key combination was pressed
//

{
   switch (toupper (cKey))
      {
      case 'A' : 
          P3_SendNotifyMessage (hWndMainWindow_BtnAsis, BN_CLICKED ) ;
         break;
      case 'B' : 
          SetFocus (hWndMainWindow_EditBitmap ) ;
         break;
      case 'D' : 
          P3_SendNotifyMessage (hWndMainWindow_BtnDisplay, BN_CLICKED ) ;
         break;
      case 'F' : 
          SetFocus (hWndMainWindow_ListFiles ) ;
         break;
      case 'R' : 
          SetFocus (hWndMainWindow_ListDirs ) ;
         break;
      case 'S' : 
          P3_SendNotifyMessage (hWndMainWindow_BtnStretch, BN_CLICKED ) ;
         break;
      case 'T' : 
          P3_SendNotifyMessage (hWndMainWindow_BtnTile, BN_CLICKED ) ;
         break;
      case 'X' : 
          P3_SendNotifyMessage (hWndMainWindow_BtnExit, BN_CLICKED ) ;
         break;
      default :
          MessageBeep (MB_ICONASTERISK ) ;
         return 0;
      }
   return 1;
}



/*=-----------------------------do-not-remove-this-line-=*/
void FileExpand (char * szFileOut, char * szFileIn)
/*=-----------------------------do-not-remove-this-line-=*/

//
//  Build the full path name (including drive) from given file name
//

   {
   unsigned disk;
   char     szHold[100],
            szDir[100];
   
   strcpy (szHold, szFileIn);

   _dos_getdrive (&disk);
   if (_fullpath (szDir, szHold, 100) == NULL)
      {
      strcpy (szFileOut, szHold);
      return;
      }
      
   if (szDir[1] != ':')
      sprintf (szFileOut, "%c:%s", disk + 'A' - 1, szDir);
   else
      strcpy (szFileOut, szDir);
   }



/*=-----------------------------do-not-remove-this-line-=*/
void ChangeDirectory (char *szPath)
/*=-----------------------------do-not-remove-this-line-=*/

//
//  Change the directory (and drive) to the given path.
//

   {
   unsigned disk,
            maxdrives;
   char     szWork[150];
   
      //* Make sure fully qualified path name
   strcpy (szWork, szPath);
   if (szWork[1] != ':')
      return;
   _dos_getdrive (&disk);
   if (szWork[0] != (disk + 'A' - 1))
      _dos_setdrive (toupper (szWork[0]) - 'A' + 1, &maxdrives);
      
      //* Remove any trailing backslash
   if ((strlen (szWork) > 3) && (szWork[strlen(szWork)-1] == '\\'))
      szWork[strlen(szWork)-1] = '\0';
      
      //* If change directory command failed, then display error message
#ifdef __BORLANDC__      
   if (chdir (szWork))
#else   
   if (_chdir (szWork))
#endif   
      {
      strcpy (szWork, "Invalid directory - ");
      strcat (szWork, szPath);
      MessageBox (hWndMainWindow, szWork, "Invalid Directory", MB_OK);
      }
   }



/*=-----------------------------------------------------=*/
long WINAPI EditSubClass_MainWindow
   (HWND hWindow, WORD wMessage, WORD wParam, long lParam)  
/*=-----------------------------------------------------=*/
   {
   HWND    P3_hParent;
   FARPROC oldProc;

   switch (wMessage)
      {
      case WM_CHAR :
/****** Begin user-created code ******/ 
   /* If ENTER key pressed then simulate DISPLAY button being clicked */
if (wParam == VK_RETURN)
   {   
    P3_SendNotifyMessage (hWndMainWindow_BtnDisplay, BN_CLICKED ) ;
   return 0;
   }

/******* End user-created code *******/
         break;
      case WM_SYSCHAR :
/****** Begin user-created code ******/ 
if (ProcessHotKeys (wParam) )
   return 0;

/******* End user-created code *******/
         break;

      } /* wMessage */

   P3_hParent = GetParent (hWindow);
   oldProc = (FARPROC) GetWindowLong (P3_hParent, P3_ExtBytesOldEditProc);

   return (CallWindowProc(oldProc, hWindow, wMessage, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
long WINAPI ButtonSubClass_MainWindow
   (HWND hWindow, WORD wMessage, WORD wParam, long lParam)  
/*=-----------------------------------------------------=*/
   {
   HWND    P3_hParent;
   FARPROC oldProc;

   switch (wMessage)
      {
      case WM_SYSCHAR :
/****** Begin user-created code ******/ 
if (ProcessHotKeys (wParam) )
   return 0;

/******* End user-created code *******/
         break;

      } /* wMessage */

   P3_hParent = GetParent (hWindow);
   oldProc = (FARPROC) GetWindowLong (P3_hParent, P3_ExtBytesOldButtonProc);

   return (CallWindowProc(oldProc, hWindow, wMessage, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
long WINAPI ListSubClass_MainWindow
   (HWND hWindow, WORD wMessage, WORD wParam, long lParam)  
/*=-----------------------------------------------------=*/
   {
   HWND    P3_hParent;
   FARPROC oldProc;

   switch (wMessage)
      {
      case WM_CHAR :
/****** Begin user-created code ******/ 
if (wParam == VK_RETURN)
    P3_SendNotifyMessage (hWindow, LBN_DBLCLK ) ;
  
/******* End user-created code *******/
         break;
      case WM_SYSCHAR :
/****** Begin user-created code ******/ 
if (ProcessHotKeys (wParam) )
   return 0;

/******* End user-created code *******/
         break;

      } /* wMessage */

   P3_hParent = GetParent (hWindow);
   oldProc = (FARPROC) GetWindowLong (P3_hParent, P3_ExtBytesOldListProc);

   return (CallWindowProc(oldProc, hWindow, wMessage, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL CreateObjects_MainWindow (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
   Create all objects on this window.
*/
   {
   HGLOBAL P3_hMem;
   int     P3_nWidth,
           P3_nHeight,
           P3_nRetCode;
   LPMainWindowStruct EBPtr;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("MainWindow", "Invalid extra bytes pointer.");
      return FALSE;
      }  

   EBPtr->hWndMainWindow_BtnAsis = CreateWindow (
                          "BUTTON",
                          "&Asis",
                          WS_CHILD | BS_RADIOBUTTON | WS_VISIBLE,
                          19, 270, 57, 20,
                          hWindow,
                          idMainWindow_BtnAsis,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnAsis)
      {
      LongWarning ("MainWindow_BtnAsis", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnAsis = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_BtnAsis)
      {
      LongWarning ("MainWindow_BtnAsis", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnAsis, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnAsis, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnAsis,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnAsis, 4);

   EBPtr->hWndMainWindow_BtnTile = CreateWindow (
                          "BUTTON",
                          "&Tile",
                          WS_CHILD | BS_RADIOBUTTON | WS_VISIBLE,
                          19, 310, 60, 18,
                          hWindow,
                          idMainWindow_BtnTile,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnTile)
      {
      LongWarning ("MainWindow_BtnTile", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnTile = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_BtnTile)
      {
      LongWarning ("MainWindow_BtnTile", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnTile, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnTile, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnTile,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnTile, 6);

   EBPtr->hWndMainWindow_BtnStretch = CreateWindow (
                          "BUTTON",
                          "&Stretch/Shrink",
                          WS_CHILD | BS_RADIOBUTTON | WS_VISIBLE,
                          19, 290, 127, 20,
                          hWindow,
                          idMainWindow_BtnStretch,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnStretch)
      {
      LongWarning ("MainWindow_BtnStretch", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnStretch = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_BtnStretch)
      {
      LongWarning ("MainWindow_BtnStretch", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnStretch, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnStretch, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnStretch,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnStretch, 5);

   EBPtr->hWndMainWindow_BtnDisplay = CreateWindow (
                          "BUTTON",
                          "&Display",
                          WS_CHILD | BS_DEFPUSHBUTTON | WS_VISIBLE,
                          177, 256, 80, 26,
                          hWindow,
                          idMainWindow_BtnDisplay,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnDisplay)
      {
      LongWarning ("MainWindow_BtnDisplay", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnDisplay = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_BtnDisplay)
      {
      LongWarning ("MainWindow_BtnDisplay", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnDisplay, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnDisplay, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnDisplay,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnDisplay, 7);

   EBPtr->hWndMainWindow_ListFiles = CreateWindow (
                          "LISTBOX",
                          "",
                          WS_CHILD | LBS_STANDARD | 
                                   LBS_DISABLENOSCROLL | WS_VISIBLE,
                          9, 93, 120, 145,
                          hWindow,
                          idMainWindow_ListFiles,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_ListFiles)
      {
      LongWarning ("MainWindow_ListFiles", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_ListFiles = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_ListFiles)
      {
      LongWarning ("MainWindow_ListFiles", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_ListFiles, WM_SETFONT,
                EBPtr->hFontMainWindow_ListFiles, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_ListFiles,
      (FARPROC) ListSubClass_MainWindow,
      P3_ExtBytesOldListProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_ListFiles, 2);

   EBPtr->hWndMainWindow_ListDirs = CreateWindow (
                          "LISTBOX",
                          "",
                          WS_CHILD | LBS_STANDARD | 
                                   LBS_DISABLENOSCROLL | WS_VISIBLE,
                          142, 93, 120, 145,
                          hWindow,
                          idMainWindow_ListDirs,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_ListDirs)
      {
      LongWarning ("MainWindow_ListDirs", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_ListDirs = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_ListDirs)
      {
      LongWarning ("MainWindow_ListDirs", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_ListDirs, WM_SETFONT,
                EBPtr->hFontMainWindow_ListDirs, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_ListDirs,
      (FARPROC) ListSubClass_MainWindow,
      P3_ExtBytesOldListProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_ListDirs, 3);

   EBPtr->hWndMainWindow_BtnExit = CreateWindow (
                          "BUTTON",
                          "E&xit",
                          WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
                          177, 294, 80, 26,
                          hWindow,
                          idMainWindow_BtnExit,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_BtnExit)
      {
      LongWarning ("MainWindow_BtnExit", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_BtnExit = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_BtnExit)
      {
      LongWarning ("MainWindow_BtnExit", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_BtnExit, WM_SETFONT,
                EBPtr->hFontMainWindow_BtnExit, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_BtnExit,
      (FARPROC) ButtonSubClass_MainWindow,
      P3_ExtBytesOldButtonProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_BtnExit, 8);

   EBPtr->hWndMainWindow_EditBitmap = CreateWindow (
                          "EDIT",
                          "",
                          WS_CHILD | WS_BORDER | ES_AUTOHSCROLL | 
                                   WS_VISIBLE,
                          54, 15, 208, 21,
                          hWindow,
                          idMainWindow_EditBitmap,
                          hInst,
                          NULL);
   if (!EBPtr->hWndMainWindow_EditBitmap)
      {
      LongWarning ("MainWindow_EditBitmap", "Cannot create window for object.");
      return FALSE;
      }

   EBPtr->hFontMainWindow_EditBitmap = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                              FF_SWISS + VARIABLE_PITCH, 
                                              "Arial");
   if (!EBPtr->hFontMainWindow_EditBitmap)
      {
      LongWarning ("MainWindow_EditBitmap", "Cannot get font for object.");
      return FALSE;
      }

   SendMessage (EBPtr->hWndMainWindow_EditBitmap, WM_SETFONT,
                EBPtr->hFontMainWindow_EditBitmap, 0);


   P3_SetSubClass (hWindow, EBPtr->hWndMainWindow_EditBitmap,
      (FARPROC) EditSubClass_MainWindow,
      P3_ExtBytesOldEditProc);

   P3_AddAutoTab (EBPtr->hWndMainWindow_EditBitmap, 1);

   GlobalUnlock (P3_hMem);
   return TRUE;
   }


/*=-----------------------------------------------------=*/
void UpdateHandles_MainWindow (HWND hWindow)
/*=-----------------------------------------------------=*/
/*
 *  Store all object handles for this window in global variables.
 */
   {
   HGLOBAL P3_hMem;
   LPMainWindowStruct EBPtr;

   hWndMainWindow = hWindow;

   P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
   EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem);
   if (EBPtr == NULL)
      {
      LongWarning ("MainWindow", "Invalid extra bytes pointer.");
      return;
      }  

   hWndMainWindow_ListFiles = EBPtr->hWndMainWindow_ListFiles;
   hWndMainWindow_ListDirs = EBPtr->hWndMainWindow_ListDirs;
   hWndMainWindow_EditBitmap = EBPtr->hWndMainWindow_EditBitmap;
   hWndMainWindow_BtnAsis = EBPtr->hWndMainWindow_BtnAsis;
   hWndMainWindow_BtnStretch = EBPtr->hWndMainWindow_BtnStretch;
   hWndMainWindow_BtnTile = EBPtr->hWndMainWindow_BtnTile;
   hWndMainWindow_BtnDisplay = EBPtr->hWndMainWindow_BtnDisplay;
   hWndMainWindow_BtnExit = EBPtr->hWndMainWindow_BtnExit;

   GlobalUnlock (P3_hMem);
   }

     
/*=-----------------------------------------------------=*/
long WINAPI WndProc_MainWindow
   (HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
/*=-----------------------------------------------------=*/
/*
 *  Processes messages for the window.
 */
   {
      /* Phase3-generated declarations */
   HDC         dc;
   PAINTSTRUCT ps;
   HBRUSH      P3_hBrush;
   LPMainWindowStruct EBPtr;
   HGLOBAL     P3_hMem;
   HFONT       P3_hFont;
   HPEN        P3_hPen;
   RECT        P3_rtText;  
   LONG        P3_lHandle;

      /* Your declarations */   
int   nLen,
      nRC;
long  lSel;
WORD  wPathLen;
BOOL  bDiffPath;
char  * szPtr,
      * szBuffer;
char  szNum[10],
      szDirsEntry[20],
      szCaption[96],
      szDrive[3],
      szExt[5],
      szFile[12],
      szFileName[96],
      szPathName[96];
   


   switch (message)
      {
      case WM_CREATE :
         P3_CreateAutoTabs (hWindow, P3_Phase3Reserved);

         if ((P3_hMem = GlobalAlloc (GHND, sizeof (MainWindowStruct))) == NULL)
            {
            LongWarning ("MainWindow", "Out of memory.");
            return 0;
            }
         SetWindowWord (hWindow, P3_ExtBytesPtr, P3_hMem);  

         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

            /* Initialise brush handle for controls */
         EBPtr->P3_hBrushCtlColor = 0;

            /* Set window background color */
         SetClassWord (hWindow, GCW_HBRBACKGROUND,
                           CreateSolidBrush (RGB (192, 255, 192)));  

            /* Create brush for painting background for controls */
         EBPtr->P3_hBrushCtlColor = CreateSolidBrush (RGB (192, 255, 192));

         if (!CreateObjects_MainWindow(hWindow))
            {
            LongWarning ("MainWindow", "Out of memory.");
            return 0;
            }
         UpdateHandles_MainWindow (hWindow);  


/****** Begin user-created code ******/

   //* Create child window that will display the bitmap
BitmapWindow (hWndMainWindow) ;

   //* Initialise Display style to ASIS
 P3_ButtonSetCheck (hWndMainWindow_BtnAsis, 1 ) ;

   //* Miscellaneous initialisations
hBMP = 0;
_getdcwd (0, szSavePath, sizeof (szDirectory));
strcat (szSavePath, "\\");
SetRect (&rectDir, 47, 49, 262, 70);
SetRect (&EBPtr->rectWidth, 418, 326, 460, 341);
SetRect (&EBPtr->rectHeight, 510, 326, 565, 341);
 SendMessage (hWndMainWindow_EditBitmap, EM_LIMITTEXT, 96, 0 ) ;

   //* Display drives, subdirectories and bitmap files
UpdateListBoxes (TRUE) ;

   //* Set focus to file name edit box
 SetFocus (hWndMainWindow_EditBitmap ) ;


/******* End user-created code *******/

         GlobalUnlock (P3_hMem);  

         return 0;

      case WM_SETFOCUS :
         UpdateHandles_MainWindow (hWindow);  
         return 0;  

      case WM_CTLCOLOR :
            /* Paint background of buttons with screen color */
         if (HIWORD (lParam) == CTLCOLOR_BTN)
            {
            P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
            if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
               {
               LongWarning ("MainWindow", "Global lock error.");
               return 0;
               }
            if (EBPtr->P3_hBrushCtlColor)
               {
               SetBkMode ((HDC) wParam, TRANSPARENT);
               SetTextColor ((HDC) wParam, GetSysColor (COLOR_WINDOWTEXT));
               GlobalUnlock (P3_hMem);
               return (LONG) EBPtr->P3_hBrushCtlColor;
               }
            GlobalUnlock (P3_hMem);
            }
         break;

      case WM_PAINT :  /* window being painted */
         P3_hFont = 0;

         /* Get a pointer to the extra-bytes */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

         dc = BeginPaint (hWindow, &ps);
         if (!dc)
            {
            LongWarning ("MainWindow", "Cannot get a device context.");
            return 0;
            }

            /* Paint static text on the screen */
         if (P3_hFont != 0)
            DeleteObject (P3_hFont);
         P3_hFont = P3_GetFont (-12, 700, 0, 0, 0, 0, 3, 2, 
                                FF_SWISS + VARIABLE_PITCH, "Arial");
         SelectObject (dc, P3_hFont);
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 10, 76, 129, 93);
         DrawText (dc, "&Files", 6,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 10, 49, 40, 65);
         DrawText (dc, "Path:", 5,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 10, 246, 61, 265);
         DrawText (dc, "Display", 7,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 10, 18, 54, 35);
         DrawText (dc, "&Bitmap", 7,
                   &P3_rtText, 16);

            /* Draw a rectangle on the screen */
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPen = SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (0, 0, 0)));
         Rectangle (dc, 10, 264, 159, 333);
         DeleteObject (SelectObject (dc, P3_hPen));

            /* Draw a rectangle on the screen */
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPen = SelectObject (dc, CreatePen (PS_SOLID, 3, RGB (128, 128, 0)));
         Rectangle (dc, 273, 6, 588, 316);
         DeleteObject (SelectObject (dc, P3_hPen));

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 293, 326, 362, 342);
         DrawText (dc, "Bitmap Info", 11,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 375, 326, 415, 341);
         DrawText (dc, "Width:", 6,
                   &P3_rtText, 16);

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 464, 326, 547, 341);
         DrawText (dc, "Height:", 7,
                   &P3_rtText, 16);

            /* Draw a rectangle on the screen */
         SelectObject (dc, GetStockObject (NULL_BRUSH));
         P3_hPen = SelectObject (dc, CreatePen (PS_SOLID, 1, RGB (0, 0, 0)));
         Rectangle (dc, 369, 324, 569, 343);
         DeleteObject (SelectObject (dc, P3_hPen));

            /* Paint static text on the screen */
         SetTextColor (dc, RGB (0, 0, 0));
         SetBkMode (dc, TRANSPARENT);
         SetRect (&P3_rtText, 142, 76, 261, 93);
         DrawText (dc, "Di&rectories", 12,
                   &P3_rtText, 16);

/****** Begin user-created code for "WM_PAINT" ******/

   //* Display current directory path
DrawText (dc, AnsiLower (szDirectory), strlen (szDirectory), &rectDir, DT_SINGLELINE);

   //* If valid bitmap - display height and width
if (hBMP)
   {
   sprintf (szNum, "%d", EBPtr->nWidth);
   DrawText (dc, szNum, strlen (szNum), &EBPtr->rectWidth, DT_SINGLELINE);
   sprintf (szNum, "%d", EBPtr->nHeight);
   DrawText (dc, szNum, strlen (szNum), &EBPtr->rectHeight, DT_SINGLELINE);
   }

/******* End user-created code for "WM_PAINT" *******/

         if (P3_hFont != 0)
            DeleteObject (P3_hFont);

         GlobalUnlock (P3_hMem);
         EndPaint (hWindow, &ps);
         return 0;

      case WM_SYSCHAR :
         /* There is some user code, so get the extra-bytes pointer */

         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

/****** Begin user-created code ******/

   //* Process ALT-key combinations
if (ProcessHotKeys (wParam) )
   return 0;


/******* End user-created code *******/

         GlobalUnlock (P3_hMem);
         return 0;

      case WM_COMMAND :
         switch (wParam)
            {
            case idMainWindow_ListFiles :
               switch (HIWORD(lParam))
                  {
                  case LBN_SELCHANGE :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   //* Get index to currently selected list box entry
if (( lSel = SendMessage (hWndMainWindow_ListFiles, LB_GETCURSEL, 0, 0 ) ) == LB_ERR)
   {
   MessageBeep (0);
   return 0;
   }

   //* Get text of currently selected entry and display in edit box
szBuffer = malloc (20);
 SendMessage (hWndMainWindow_ListFiles, LB_GETTEXT, (WORD) lSel, (long) (LPSTR) szBuffer ) ;
 SetWindowText (hWndMainWindow_EditBitmap, szBuffer ) ;
free (szBuffer);

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  case LBN_DBLCLK :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   //* Simulate the DISPLAY button being clicked
 P3_SendNotifyMessage (hWndMainWindow_BtnDisplay, BN_CLICKED ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  case LBN_KILLFOCUS :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   //* Deselect entry from Files list box
 SendMessage (hWndMainWindow_ListFiles, LB_SETCURSEL, (WORD) -1, 0 ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_ListDirs :
               switch (HIWORD(lParam))
                  {
                  case LBN_SELCHANGE :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   //* Get index to currently selected list box entry
if (( lSel = SendMessage (hWndMainWindow_ListDirs, LB_GETCURSEL, 0, 0 ) ) == LB_ERR)
   {
   MessageBeep (0);
   return 0;
   }

   //* Get text of selected entry from directories list box
szPtr = szDirsEntry;
 SendMessage (hWndMainWindow_ListDirs, LB_GETTEXT, (WORD) lSel, (long) (LPSTR) szPtr ) ;

   //* Is entry = [..] ? - then display "..\*.BMP" in edit box
if (szDirsEntry[1] == '.')
   {
   strcpy (szPathName, "..\\");
   strcat (szPathName, szBMPExt);
    SetWindowText (hWndMainWindow_EditBitmap, szPathName ) ;
   return 0;
   }

   //* Is entry = [-a-] ? - then display "a:*.BMP" in edit box
if (szDirsEntry[1] == '-')
   {
   strncpy (szPathName, szDirsEntry + 2, 1);
   szPathName[1] = '\0';
   strcat (szPathName, ":");
   strcat (szPathName, szBMPExt);
    SetWindowText (hWndMainWindow_EditBitmap, szPathName ) ;
   return 0;
   }

   //* Entry must be a subdirectory
nLen = strlen (szDirsEntry) - 2;   
strncpy (szPathName, szDirsEntry + 1, nLen);
szPathName[nLen] = '\0';
strcat (szPathName, "\\");
strcat (szPathName, szBMPExt);
 SetWindowText (hWndMainWindow_EditBitmap, szPathName ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  case LBN_DBLCLK :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   //* Simulate the DISPLAY button being clicked
 P3_SendNotifyMessage (hWndMainWindow_BtnDisplay, BN_CLICKED ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  case LBN_KILLFOCUS :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   //* Deselect entry from Directories list box
 SendMessage (hWndMainWindow_ListDirs, LB_SETCURSEL, (WORD) -1, 0 ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnAsis :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   //* Check the appropriate button
 P3_ButtonSetCheck (hWndMainWindow_BtnAsis, 1 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnStretch, 0 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnTile, 0 ) ;

wDisplayStyle = idMainWindow_BtnAsis;

   //* If bitmap already loaded then force a paint immediately
if (hBMP)
    InvalidateRect (hWndBitmapWindow, NULL, TRUE ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnStretch :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   //* Check the appropriate button
 P3_ButtonSetCheck (hWndMainWindow_BtnAsis, 0 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnStretch, 1 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnTile, 0 ) ;

wDisplayStyle = idMainWindow_BtnStretch;

   //* If bitmap already loaded then force a paint immediately
if (hBMP)
    InvalidateRect (hWndBitmapWindow, NULL, TRUE ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnTile :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
   //* Check the appropriate button
 P3_ButtonSetCheck (hWndMainWindow_BtnAsis, 0 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnStretch, 0 ) ;
 P3_ButtonSetCheck (hWndMainWindow_BtnTile, 1 ) ;

wDisplayStyle = idMainWindow_BtnTile;

   //* If bitmap already loaded then force a paint immediately
if (hBMP)
    InvalidateRect (hWndBitmapWindow, NULL, TRUE ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnDisplay :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/

   //* Determine style to display bitmap
if ( P3_ButtonGetCheck (hWndMainWindow_BtnAsis ) )
   wDisplayStyle = idMainWindow_BtnAsis;
else
   if ( P3_ButtonGetCheck (hWndMainWindow_BtnStretch ) )
      wDisplayStyle = idMainWindow_BtnStretch;
   else
      wDisplayStyle = idMainWindow_BtnTile;


   //* Get fully qualified file name of bitmap
 GetWindowText (hWndMainWindow_EditBitmap, szFileName, 96 ) ;
FileExpand (szFileName, szFileName) ;


   //* Split up into path and file name
_splitpath (szFileName, szDrive, szPathName, szFile, szExt);


   //* If no extension, then assume file name is part of path
if (!strlen (szExt) && strlen (szFile))
   {
   strcat (szPathName, szFile);
   strcat (szPathName, "\\");
   strcpy (szFile, "");
   }


   //* See if drive/path changed from previous setting   
bDiffPath = FALSE;
strcpy (szCaption, szDrive);
strcat (szCaption, szPathName);
#ifdef __BORLANDC__   
if (stricmp (szCaption, szSavePath))
#else
if (_stricmp (szCaption, szSavePath))
#endif
   {
   strcpy (szSavePath, szCaption);
   bDiffPath = TRUE;
   }


   //* If no file name or wildcards in file name then just update list boxes
if ((strlen (szFile) == 0) || strchr (szFile, '*') || strchr (szFile, '?'))
   {
   if (bDiffPath)
      ChangeDirectory (szSavePath) ;   
   UpdateListBoxes (TRUE) ;
   return 0;
   }


   //* Delete handle to any existing bitmap
if (hBMP)
    P3_BitmapDestroy (hBMP ) ;


   //* Update bitmap info fields
 InvalidateRect (hWndMainWindow, &EBPtr->rectWidth, TRUE ) ;
 InvalidateRect (hWndMainWindow, &EBPtr->rectHeight, TRUE ) ;


   //* Load bitmap from the specified file 
 P3_SetHourGlass () ;
 hBMP = P3_BitmapLoadFromFile (szFileName, &EBPtr->nWidth, &EBPtr->nHeight, &nRC ) ;
 P3_RemoveHourGlass () ;


   //* If bitmap not loaded display error message 
if (nRC)
   {
   MessageBeep (0);
   MessageBox (hWndMainWindow, "File could not be loaded - not a valid bitmap file.",
               szFileName, MB_OK);
   }


   //* Set caption of main window to show name of bitmap
strcpy (szCaption, szTitle);
if (hBMP)
   {
   strcat (szCaption, " - ");
#ifdef __BORLANDC__   
   strcat (szCaption, strupr (szFile));
#else
   strcat (szCaption, _strupr (szFile));
#endif   
   }
 SetWindowText (hWndMainWindow, szCaption ) ;

   
   //* Force bitmap window to be redrawn
 InvalidateRect (hWndBitmapWindow, NULL, TRUE ) ;


if (bDiffPath)
   {
   ChangeDirectory (szSavePath) ;   
   UpdateListBoxes (FALSE) ;
   }

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
            case idMainWindow_BtnExit :
               switch (HIWORD(lParam))
                  {
                  case BN_CLICKED :
                     /* There is user code, so get extra-bytes pointer */
                     P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
                     if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
                        {
                        LongWarning ("MainWindow", "Global lock error.");
                        return 0;
                        }

/****** Begin user-created code ******/
 P3_WinClose (hWndMainWindow ) ;

/******* End user-created code *******/

                     GlobalUnlock (P3_hMem);
                     return 0;  

                  } /* HiWord */ 
               break; 

            } /* wParam */


         break;  

      case WM_CLOSE:            /* message: window being closed */ 
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }

/****** Begin user-created code ******/
   //* Release memory allocated for bitmap
if (hBMP)
    P3_BitmapDestroy (hBMP ) ;
   
   //* Close bitmap child window
 P3_WinClose (hWndBitmapWindow ) ;

/******* End user-created code *******/

         GlobalUnlock (P3_hMem);
         break;  
      
      case WM_DESTROY:            /* message: window being destroyed */
         P3_hMem = GetWindowWord (hWindow, P3_ExtBytesPtr);
         if ((EBPtr = (LPMainWindowStruct) GlobalLock (P3_hMem)) == NULL)
            {
            LongWarning ("MainWindow", "Global lock error.");
            return 0;
            }   

/****** Begin user-created code ******/
PostQuitMessage(0);

/******* End user-created code *******/


            /* Delete brush for painting background for controls */
         if (EBPtr->P3_hBrushCtlColor)
            DeleteObject (EBPtr->P3_hBrushCtlColor);
         DeleteObject (EBPtr->hFontMainWindow_ListFiles);
         DeleteObject (EBPtr->hFontMainWindow_ListDirs);
         DeleteObject (EBPtr->hFontMainWindow_EditBitmap);
         DeleteObject (EBPtr->hFontMainWindow_BtnAsis);
         DeleteObject (EBPtr->hFontMainWindow_BtnStretch);
         DeleteObject (EBPtr->hFontMainWindow_BtnTile);
         DeleteObject (EBPtr->hFontMainWindow_BtnDisplay);
         DeleteObject (EBPtr->hFontMainWindow_BtnExit);
         GlobalUnlock (P3_hMem);
         GlobalFree (P3_hMem);
         P3_DestroyAutoTabs (hWindow);
         return 0;
      }
   return (DefWindowProc(hWindow, message, wParam, lParam));
   }


/*=-----------------------------------------------------=*/
BOOL MainWindow (HWND hOwner)
/*=-----------------------------------------------------=*/
/*
 *  Creates and displays the window.
 */
   {
   HWND hWnd;   

   hWnd = CreateWindow(
      "MainWindow Class",
      "Phase3 Sample - Bitmap Viewer",   
      WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | 
                   WS_VISIBLE,
      CW_USEDEFAULT,     
      CW_USEDEFAULT,
      600,  
      370,  
      hOwner,                        
      NULL,   
      hInst,  
      NULL    
      );

   /* If window could not be created, return "failure" */

   if (!hWnd)
      {
      LongWarning ("MainWindow", "Could not create window.");
      return (FALSE);
      }

   /* Make the window visible; update its client area; and return "success" */

   UpdateWindow(hWnd);          /* Sends WM_PAINT message                 */
   return (TRUE);               /* Returns the value from PostQuitMessage */

   }   

/*=-----------------------------do-not-remove-this-line-=*/
int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpCmdLine,
                    int    nCmdShow)
/*=-----------------------------do-not-remove-this-line-=*/

/*
   WinMain Procedure
   =================
 
   This procedure is the main windows procedure and is used to register,
   create and show the window, and wait for windows messages.
*/
 
   {
   MSG msg;  /* message */

   hInst = hInstance;
   nShowMain = nCmdShow;
   lpCommandLine = lpCmdLine;

   if (!hPrevInstance) /* Other instances of app running? */
      {
      if (!P3_RegisterWindows ())
         return (FALSE);            
      if (!P3_RegisterReportWindow ())
         return (FALSE);            
      };         
   
   if (!MainWindow(0))
      return (FALSE);
   
   while (GetMessage (&msg, NULL, NULL, NULL))
      {
      TranslateMessage(&msg);  /* Translates virtual key codes	     */
      DispatchMessage(&msg);   /* Dispatches message to window	     */
      }
      
   return (msg.wParam);        /* Return the value from PostQuitMessage */
   }



/*=-----------------------------------------------------=*/
BOOL P3_RegisterWindows (void)
/*=-----------------------------------------------------=*/
/*
   Initializes window data and registers window class.
 */
   {
   WNDCLASS  wc;  

   /* Window class structure for BitmapWindow */

   wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
   wc.lpfnWndProc   = WndProc_BitmapWindow;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = P3_TotalExtBytes;
   wc.hInstance     = hInst;
   wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;  /* Use Windows color */
   wc.lpszMenuName  = "";
   wc.lpszClassName = "BitmapWindow Class";

   /* Register the window class and return success/failure code. */

   if (!RegisterClass(&wc))
      {
      LongWarning ("BitmapWindow", "Could not register window.");
      return (FALSE);
      }        

   /* Window class structure for MainWindow */

   wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
   wc.lpfnWndProc   = WndProc_MainWindow;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = P3_TotalExtBytes;
   wc.hInstance     = hInst;
   wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;  /* Use Windows color */
   wc.lpszMenuName  = "";
   wc.lpszClassName = "MainWindow Class";

   /* Register the window class and return success/failure code. */

   if (!RegisterClass(&wc))
      {
      LongWarning ("MainWindow", "Could not register window.");
      return (FALSE);
      }        

   return (TRUE);
   }   

