/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSUTL.H
*
*                          Required by every module calling utility
*                          routines.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      This include file contains all of the defines
*                          and data structures required for the utility
*                          routines not defined elsewhere.
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        OS2.h  - It is assumed that the module will
*                                   include this.
*                          IPS.h  - This file is included by IPS.h.
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Declarations:
*
*     Routines:
*
*     Structures:
*
*   Include files:
*
*ENDPROLOGUE*****************************************************************/

/*****************************************************************************/
/*                                                                           */
/*    Ensure that this include file is not recursively called                */
/*                                                                           */
/*****************************************************************************/

#ifndef IPSUTL_DEFINED
#define IPSUTL_DEFINED

/*****************************************************************************/
/*                                                                           */
/*    Error Codes retuned by the UTL.DLL                                     */
/*                                                                           */
/*****************************************************************************/

#define CANNOT_FREE_SEGMENT              40
#define MAX_NUM_THREADS_EXCEEDED        230
#define NOT_ENOUGH_MEMORY               250
#define SYSTEM_ERROR_ABORT              320
#define COMPLETION_ERROR                330
#define COMPLETION_MSG_NOT_POSTED       340
#define COMPLETION_SEM_EXCL_OWNED       350
#define INTERNAL_ERROR_BAD_FORMAT       999
#define UTL_INITIALIZATION_ERROR        352

/*****************************************************************************/
/*                                                                           */
/*  Define some data structures                                              */
/*                                                                           */
/*****************************************************************************/
typedef void FARPTR16 PTR;

typedef PTR FARPTR16 PPTR;

typedef ULONG           HMSG;
typedef HMSG FARPTR16   PHMSG;

/*****************************************************************************/
/*                                                                           */
/*  Error Information Structure                                              */
/*                                                                           */
/*****************************************************************************/

typedef struct tagVARDATASTRUCT
{
   USHORT  cbStruct;
   USHORT  usVarEntries;
   PPTR    pVarTable;
} VARDATASTRUCT;

typedef VARDATASTRUCT FARPTR16 PVARDATASTRUCT;

typedef enum
{
   message_string,
   message_dll
} MSG_SOURCE;

typedef struct tagMSGINFSTRUCT
{
   USHORT       cbStruct;     /* the length of this data structure          */
   struct tagMSGINFSTRUCT FARPTR16 pNextMsg; /* pointer to next chain element */
   HMSG         hMsgLog;      /* message log handle                         */
   HMSG         hRelMsgLog;   /* Related error log handle                   */
   DATETIME     dtMsgTime;    /* OS/2 date/time structure                   */
   PID16        pidMsgEntry;  /* process ID in effect for the error         */
   USHORT       usClgCode;    /* return code generated by calling routine   */
   PSZ16        pszClgId;     /* pointer to calling routine identification  */
   ULONG        ulCldCode;    /* return code returned by the called routine */
   PSZ16        pszCldId;     /* pointer to called routine indentification  */
   PSZ16        pszMsgText;   /* pointer to message text                    */
} MSGINFSTRUCT;

typedef MSGINFSTRUCT FARPTR16 PMSGINFSTRUCT;

typedef struct tagMSGTEXTSTRUCT
{
   USHORT              cbStruct;        /* the length of this data structure */
   PSZ16               pszMessage;      /* message to be logged */
   MSG_SOURCE          MsgSource;       /* enumeration */
   PVARDATASTRUCT      pVarData;        /* insertion data table */
} MSGTEXTSTRUCT;

typedef MSGTEXTSTRUCT FARPTR16 PMSGTEXTSTRUCT;

typedef struct tagMSGLOGSTRUCT
{
   USHORT       cbStruct;              /* the total structure byte length    */
   USHORT       usMaxSize;             /* Maximum size of logfile, in Kbytes */
   LONG         lOverlayTime;          /* Protection time, in minutes        */
} MSGLOGSTRUCT;

typedef MSGLOGSTRUCT FARPTR16 PMSGLOGSTRUCT;

typedef HERR FARPTR16 PHERR;

/*****************************************************************************/
/*                                                                           */
/*   Messge Logging Utility function Declarations                            */
/*                                                                           */
/*****************************************************************************/

extern USHORT EXPENTRY16 IpsLogMsg(
                         PSZ16           pszLogFile,
                         USHORT          usClgCode,
                         PSZ16           pszClgId,
                         USHORT          usClgSuffix,
                         ULONG           ulCldCode,
                         PSZ16           pszCldId,
                         PHMSG           phMsgLog,
                         PMSGTEXTSTRUCT  pMsgText,
                         HMSG            hRelMsgLog);

extern USHORT EXPENTRY16 IpsInitMsgLogFile (
                         PSZ16           pszLogFile,
                         PMSGLOGSTRUCT   pMsgLogInfo);

extern USHORT EXPENTRY16 IpsDelMsgLogFile( PSZ16  pszLogFile );

extern USHORT EXPENTRY16 IpsGetLoggedMsg(
                         PSZ16           pszLogFile,
                         HMSG            hMsgLog,
                         BOOL16            fASCII,
                         PBUF            *ppLogInfo,
                         USHORT          *pulBufLen );

SHORT EXPENTRY16 IpsInit (PRCSTRUCT pRC);

#endif
