/*BEGINPROLOGUE****************************************************************
*
*   Header Name:            IPSSDS.H
*
*                           Included by every application using the
*                           Spooled Device Service portion.
*
*   Copyright:              5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                           All Rights Reserved
*
*   Descriptive Name:       This include file contains all of the defines
*                           and data structures required by Spooled
*                           Device Services.
*
*   Status:                 Release 1, Level 0
*
*   Notes:
*
*     Dependencies:         This file must be included AFTER OS2.h.
*
*     Restrictions:
*
*   Module Type:            Header file
*
*     Processor:            IBM C/2 version 1.1
*
*   Include files:          This file is included by IPS.h if IPS_INCL_SDS
*                           has been defined in the source.
*
*ENDPROLOGUE*****************************************************************/

//
//
//   Insure that this include file will not be called recursively
//
//

#ifndef IPSSDS_DEFINED
#define IPSSDS_DEFINED

//
// Spooled Device Services Constants:
//

#define IPS_CAPTURE     0              // possible device types returned
#define PM_PRINTER      1              //    in the usDevType field of the
#define IPS_PRINTER     2              //    DEVINFSTRUCT
#define IPS_FAX         3


#define IPS_LOCAL         0            // possible locations returned in the
#define IPS_SERVER        1            //    usLocation field of the
#define IPS_LOCAL_SERVER  2            //    DEVINFSTRUCT


#define SENTFAXQUEUE     "FAXQSENT"    // pre-assigned FAX sent queue name
#define RECEIVEDFAXQUEUE "FAXQRECD"    // pre-assigned FAX received queue name
#define PENDINGFAXQUEUE  "FAXQPEND"    // pre-assigned FAX pending queue name

#define JOBNAME_LEN      33            // Max. job name len. incl. NULL
#define JOBCOMM_LEN      33            // Max. job comment len. incl. NULL

#define KEYNAME_LEN      33            // Max. device key name len. incl. NULL
#define DEVNAME_LEN      33            // Max. device name len. incl. NULL
#define QUENAME_LEN      13            // Max. queue name len. incl. NULL

#define IPS_SCANNER_DRIVER  "IPSNULL"  // Scanner driver name

//
// Spooled Device Services Data Structures:
//

typedef struct _JOBCTLSTRUCT {
   USHORT cbStruct;               // struct size in bytes
   UCHAR  ucPriority;             // job priority
   UCHAR  ucCopies;               // number of copies
   BOOL16   fHeader;                // header page or not
   CHAR   szJobName[JOBNAME_LEN]; // job name
   CHAR   szJobComm[JOBCOMM_LEN]; // job comment
   LONG   lTimeOut;               // printer access wait time
} JOBCTLSTRUCT;

typedef JOBCTLSTRUCT FARPTR16 PJOBCTLSTRUCT;

#define JOBCTLSTRUCTSIZE sizeof(JOBCTLSTRUCT)


typedef struct _DEVINFSTRUCT {
   USHORT cbStruct;                    // struct size in bytes
   USHORT usDevId;                     // spooled device identifier
   USHORT usDevType;                   // spooled device type
   USHORT usLocation;                  // spooled device location
   CHAR   szDevKeyName[KEYNAME_LEN];   // spooled device keyname
   CHAR   szDevName[DEVNAME_LEN];      // spooled device name
   CHAR   szQueName[QUENAME_LEN];      // spool queue associated with
                                       //    usDevId
} DEVINFSTRUCT;

typedef DEVINFSTRUCT FARPTR16 PDEVINFSTRUCT;

#define DEVINFSTRUCTSIZE sizeof(DEVINFSTRUCT)


typedef struct _DEVQRYSTRUCT {
   USHORT        cbStruct;             // struct size in bytes
   USHORT        usDevCount;           // size of DevInfo array
   DEVINFSTRUCT  DevInfo[1];           // array of DEVINFSTRUCT data
                                       //    structures with usDevCount
                                       //    elements
} DEVQRYSTRUCT;

typedef DEVQRYSTRUCT FARPTR16 PDEVQRYSTRUCT;

#define DEVQRYSTRUCTSIZE sizeof(DEVQRYSTRUCT)


typedef struct _QUEQRYSTRUCT {
   USHORT cbStruct;                    // struct size in bytes
   USHORT usJobCount;                  // number of job structures returned
   PBUF   pDevQry[1];                  // pointers to the structures returned
} QUEQRYSTRUCT;

typedef QUEQRYSTRUCT FARPTR16 PQUEQRYSTRUCT;

#define QUEQRYSTRUCTSIZE sizeof(QUEQRYSTRUCT)


//
// Printer Services Structures, Types, and Constants
//

typedef struct _PRTSTATESTRUCT {
   USHORT cbStruct;
   BOOL16   fPower;
   BOOL16   fReset;
   BOOL16   fBusy;
   BOOL16   fEnabled;
   SHORT  sError;
} PRTSTATESTRUCT;

typedef PRTSTATESTRUCT FARPTR16 PPRTSTATESTRUCT;

#define PRTSTATESTRUCTSIZE sizeof(PRTSTATESTRUCT)


typedef struct _PRTCAPSTRUCT {
   USHORT cbStruct;
   USHORT cHMax;
   USHORT cVMax;
   USHORT cHRes;
   USHORT cVRes;
} PRTCAPSTRUCT;

typedef PRTCAPSTRUCT FARPTR16 PPRTCAPSTRUCT;

#define PRTCAPSTRUCTSIZE sizeof(PRTCAPSTRUCT)


typedef struct _PRINT_AREA {
   USHORT usOrigin[2];        // the TopLeft Corner of window
   USHORT usExtent[2];        // the LowerRight Corner of window
} PRINT_AREA;

typedef PRINT_AREA FARPTR16 PPRINT_AREA;

#define PRINT_AREASIZE sizeof(PRINT_AREA)


typedef enum {
   print_actual,               // Print Actual Size
   print_scale,                // Print Scaled to Fill Target Device Area
   print_proportional,         // Print Scaled to Fill, Retain Aspect Ratio
   print_actual_fast           // Print within 20% of Actual Size
} PRINT_OPTION;

typedef PRINT_OPTION FARPTR16 PPRINT_OPTION;

#define PRINT_OPTIONSIZE sizeof(PRINT_OPTION)


//
// Scan Device Services Structures, Types, and Constants
//

#define SCAN_INDEFINITE_WAIT  SEM_INDEFINITE_WAIT

typedef SHORT HSCAN;

//
// Set Scan State parm
//
#define SCPARM_IGNORE     0xFFFF        // Ignore parm

//
// Facsimile Services Data Structures, Types, and Constants
//

#define PHONENUM_LEN      21     // Max. characters in a phone number


typedef struct _COVERTEXT {
   BOOL16         fPageCount;    // TRUE if this line is to depict the
                                 // number of pages in facsimile, i.e.
                                 // the line contains the %d syntax for
                                 // substitution of the page number.
   PSZ16         pszCoverText;   // pointer to array of nil (zero)
                                 // terminated text data
   SHORT         sLineNumber;    // line number of this line
}COVERTEXT;

typedef COVERTEXT FARPTR16 PCOVERTEXT;

#define COVERTEXTSIZE sizeof(COVERTEXT)


typedef struct _FAXJOBSTRUCT {
   USHORT           cbStruct;    // size of structure
   CHAR   szDestPhoneNo [PHONENUM_LEN];
                                 // Destination phone number.  Zero
                                 // terminated ASCII string.  Fax sent to
                                 // this number.  If incoming then our
                                 // receiving phone number is in the field.
                                 // If outgoing the phone number of the
                                 // destination is here. Note: This field
                                 // is mandatory for outgoing faxes.  May
                                 // be filled or null if incoming.
   CHAR    szSrcPhoneNo [PHONENUM_LEN];
                                 // Source telephone number.  Number that
                                 // originated the fax.  If incoming, it
                                 // is the senders phone number else
                                 // (outgoing) its our phone number.
                                 // Since the senders phone phone number
                                 // is an option under current G3 protocols
                                 // this field may be NULL for incoming
                                 // jobs.
   ULONG          ulSendTime;    // Time that job is to be sent.  This is
                                 // expressed in standard "C" time units
                                 // (number of seconds elasped since
                                 // 01/01/70 GMT).
   ULONG        ulCutOffTime;    // Time that the Fax driver should abort
                                 // trying to send.
   USHORT    usAnswerTimeout;    // Number of seconds to wait for answer
                                 // tone carrier from the called party.
   USHORT          usRetries;    // Number of retries to attempt
   USHORT       usRetryDelay;    // Number of seconds between retries
   USHORT    usDialsPerRetry;    // Number of attempted dials per retry
   BOOL16        fDeleteOnOK;    // Automatically deletes files if the fax
                                 // sends the doc ok.  Currently unused.
                                 // This is not a Gamma option and there are
                                 // not current plans for implementation.
                                 // This field can be tested by a an auto-
                                 // background routine that automatically
                                 // queries the SENT queue every X seconds
                                 // or minutes and deletes the TIFF file
                                 // and queue record when this flag is set.
   USHORT         usBaudRate;    // Baud rate to use for transmission.  A
                                 // baud rate of zero indicates that the
                                 // default baud rate should be used.
   BOOL16    fFineResolution;    // Is FAX to go out in fine resolution?
   CHAR      szJobName[JOBNAME_LEN]; // job name
   CHAR      szJobComm[JOBCOMM_LEN]; // job comment
   SHORT         sCoverLines;    // Number of text lines in facsimile cover
                                 // page or zero if cover page is to be
                                 // omitted.
   COVERTEXT (FARPTR16 FARPTR16 aCoverPage); // Array of pointers pointing to
                                             // structures of type COVERTEXT
} FAXJOBSTRUCT;

typedef FAXJOBSTRUCT FARPTR16 PFAXJOBSTRUCT;

#define FAXJOBSTRUCTSIZE sizeof(FAXJOBSTRUCT)


typedef struct _FAXJOBSTATUS {
   USHORT          cbStruct; // Size of structure in bytes.
   USHORT           usJobId; // Fax job identifier
   ULONG    ulTimeCompleted; // Job completion time
   ULONG      ulXmtDuration; // Time it took to send a fax in seconds.
                             // Note:  spec states minutes!
   USHORT      usFaxErrCode; // Error code for imcomplete transmission.
                             // A value of zero indicates no trasmission
                             // errors.
   USHORT   usRetriesToSend; // Number of retries required for last job
                             // completion.
   USHORT        usNumPages; // Number of pages actually sent/received.
   USHORT        usXmtSpeed; // Baud rate used to transmit job.
   USHORT     usSigStrength; // Signal Strength: from -40 dbm to -15 dbm
                             // Gammafax's value, do we pass these through
                             // Value   dBm    Meaning
                             //  6750   -40    marginal
                             // 10000   -35    weak
                             // 13250   -30    acceptable
                             // 16250   -25    good
                             // 19750   -20    strong
                             // 23000   -15    v. strong
   USHORT       usLineNoise; // Line Noise: from -65 dbm to -40 dbm.
                             // A value of 65 is extremly quiet, a value
                             // of 40 indicates unusable.
                             // Ambient Line Noise Measure
                             //      Value   dbm    Meaning
                             //         18   -65    v.v.quiet
                             //         50   -60    v. quiet
                             //        135   -55    quiet
                             //        461   -50    acceptable
                             //       1390   -45    noisy
                             //       2300   -40    unusable
} FAXJOBSTATUS;

typedef FAXJOBSTATUS FARPTR16 PFAXJOBSTATUS;

#define FAXJOBSTATUSSIZE sizeof(FAXJOBSTATUS)


typedef struct _FAXQRYSTRUCT {
   USHORT  cbStruct;                    // size of structure
   USHORT  usJobId;                     // Fax job identifier
   USHORT  usJobStatus;                 // Exit code, defined by GAMMA
   USHORT  usPages;                     // Number of pages sent or received
   ULONG   ulTimeCompleted;             // Job completion time
   ULONG   ulSendTime;                  // Job was to be sent
   CHAR    szJobPhoneNo[PHONENUM_LEN];  // Phone number string
   USHORT  usRetries;                   // number of retried
} FAXQRYSTRUCT;

typedef FAXQRYSTRUCT FARPTR16 PFAXQRYSTRUCT;

#define FAXQRYSTRUCTSIZE sizeof(FAXQRYSTRUCT)


typedef enum {
   spljob_change,
   spljob_delete,
   spljob_resubmit,
   spljob_forward,
   spljob_purge_jobs
} SPL_JOBCHANGE;


//
// Spooled Device Services API Prototypes:
//

SHORT EXPENTRY16 IpsQuerySplDevs(
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure

SHORT EXPENTRY16 IpsBeginSplJob(
      USHORT        usDevId,           // spooled device identifier
      PJOBCTLSTRUCT pJobCtl,           // device independent job control info.
      PBUF          pDevJob,           // device dependent job control info.
      BITS          fOptions,          // function control option flags
      HWND          hSync,             // semaphore/window identifier
      USHORT        usMsgId,           // window message identifier
      PRCSTRUCT     pRC);              // pointer to return data structure


SHORT EXPENTRY16 IpsEndSplJob(
      HJOB      hJob,                  // spooled job handle
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure


SHORT EXPENTRY16 IpsAbortSplJob(
      HJOB      hJob,                  // spooled job handle
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure


SHORT EXPENTRY16 IpsPutSplPage(
      HJOB         hJob,               // output spooled job handle
      HPAGE        hPage,              // page handle
      PPRINT_AREA  pPrintArea,         // pointer to target print area struct
      PRINT_OPTION PrintOption,        // print option
      BITS         fOptions,           // function control option flags
      HWND         hSync,              // semaphore/window identifier
      USHORT       usMsgId,            // window message identifier
      PRCSTRUCT    pRC);               // pointer to return data structure


SHORT EXPENTRY16 IpsGetSplJob(
      USHORT    usDevId,               // spooled input device identifier
      USHORT    usJobId,               // input spool job identifier
      BOOL16    fPeek,                 // request access to PROCESS/VIEW job
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure


SHORT EXPENTRY16 IpsGetSplPage(
      HJOB      hJob,                  // input spooled job handle
      USHORT    usPageNum,             // number of page to get
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure


SHORT EXPENTRY16 IpsDiscardSplJob(
      HJOB      hJob,                  // input spooled job handle
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure


SHORT EXPENTRY16 IpsCloseSplJob(
      HJOB      hJob,                  // input spooled job handle
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure


SHORT EXPENTRY16 IpsPrintDoc(
      USHORT        usDevId,           // spooled input device identifier
      PJOBCTLSTRUCT pJobCtl,           // device independent job control info.
      SHORT         cObj,              // count of doc. obj. handles in array
      HOBJ          (FARPTR16 FARPTR16 ahObj), // pointer to array of doc. obj. handles
      PPRINT_AREA   pPrintArea,        // pointer to target print area struct
      PRINT_OPTION  PrintOption,       // print option
      BITS          fOptions,          // function control option flags
      HWND          hSync,             // semaphore/window identifier
      USHORT        usMsgId,           // window message identifier
      PRCSTRUCT     pRC);              // pointer to return data structure


//
// NOTE - For Release 1.0, the following functions are restricted to FAX use
//
SHORT EXPENTRY16 IpsQuerySplQueue(
      USHORT    usDevId,               // spooled device identifier
      PSZ16     pszQueName,            // name of queue to query
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure


SHORT EXPENTRY16 IpsChangeSplJob(
      USHORT        usDevId,           // spooled input device identifier
      PSZ16         pszQueName,        // Pointer to ASCIIZ queuename
      USHORT        usJobId,           // Job Identifier
      PBUF          pDevJob,           // Pointer to Job information structure
      SPL_JOBCHANGE JobChgOp,          // Job change operation
      BITS          fOptions,          // function control option flags
      HWND          hSync,             // semaphore/window identifier
      USHORT        usMsgId,           // window message identifier
      PRCSTRUCT     pRC);              // pointer to return data structure


//
// Printer Services API Prototypes:
//

SHORT EXPENTRY16 IpsQueryPrtCaps(
      USHORT        usDevId,           // spooled device identifier
      PPRTCAPSTRUCT pPrtCap,           // printer capabilities structure
      BITS          fOptions,          // function control option flags
      HWND          hSync,             // semaphore/window identifier
      USHORT        usMsgId,           // window message identifier
      PRCSTRUCT     pRC);              // pointer to return data structure

SHORT EXPENTRY16 IpsSetPrtState(
      USHORT    usDevId,               // spooled device identifier
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure


//
// Scan Device Services API Prototypes:
//

SHORT EXPENTRY16 IpsQueryScanState(
      USHORT       usDevId,            // spooled capture device identifier
      USHORT       usParm,             // state field to query
      PVOID16      pParm,              // area to put state field value
      BITS         fOptions,           // function control option flags
      HWND         hSync,              // semaphore/window identifier
      USHORT       usMsgId,            // window message identifier
      PRCSTRUCT    pRC);               // pointer to return data structure

SHORT EXPENTRY16 IpsSetScanState(
      USHORT       usDevId,            // spooled capture device identifier
      USHORT       usParm,             // state field to alter
      PVOID16      pParm,              // new state field value
      PSCAN_PARM   pScanState,         // ptr to scanner state buffer
      BOOL16       fDialog,            // dialog flag, TRUE == put up dialog box
      BITS         fOptions,           // function control option flags
      HWND         hSync,              // semaphore/window identifier
      USHORT       usMsgId,            // window message identifier
      PRCSTRUCT    pRC);               // pointer to return data structure

SHORT EXPENTRY16 IpsStartPageScan(
      USHORT    usDevId,               // spooled capture device identifier
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure
                                       //
SHORT EXPENTRY16 IpsStartBatchScan(
      HJOB      hJob,                  // input spooled job handle
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure


SHORT EXPENTRY16 IpsScanLock(
      USHORT    usDevId,               // spooled capture device identifier
      LONG      lTimeout,              // wait time (in milliseconds)
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure

SHORT EXPENTRY16 IpsScanPage(
      HSCAN     hScan,                 // locked capture device identifier
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure

SHORT EXPENTRY16 IpsScanUnlock(
      HSCAN     hScan,                 // locked capture device identifer
      BITS      fOptions,              // function control option flags
      HWND      hSync,                 // semaphore/window identifier
      USHORT    usMsgId,               // window message identifier
      PRCSTRUCT pRC);                  // pointer to return data structure

SHORT EXPENTRY16 IpsScanAndDspPage(
      USHORT           usDevId,        // spooled capture device identifier
      HPS              hpsPaint,       // presentation space identifier
      HWND             hWnd,           // handle to window to display page on
      BOOL16           fPrepare,       // prepare for future operations ?
      DISPLAY_OPTION   DspOption,      // page preparation method
      PSIZEL16         pslTarget,      // pointer to target area extents
      BITS             fOptions,       // function control option flags
      HWND             hSync,          // semaphore/window identifier
      USHORT           usMsgId,        // window message identifier
      PRCSTRUCT        pRC);           // pointer to return data structure

//
// Facsimile Services API Prototypes:
//

SHORT EXPENTRY16 IpsQueryFaxJob(
      USHORT              usDevId,     // Device Identifier
      PSZ16               pszQueueName,// Pointer to ASCIIZ queue name
      USHORT              usJobId,     // Job number
      PFAXJOBSTATUS FARPTR16 ppFaxStat,   // Pointer to struct of job status
      BITS                fOptions,    // function control option flags
      HWND                hSync,       // semaphore/window identifier
      USHORT              usMsgId,     // window message identifier
      PRCSTRUCT           pRC);        // pointer to return data structure

#endif
