/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSPAG.H
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      Header file for Page Services functions,
*                          included by IPS.h.
*
*   Module Owner:          GKL
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        This file is included by IPS.h with the
*                          constant IPS_PAG_INCL defined.
*
*     Restrictions:        None.
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Include files:         None.
*
*ENDPROLOGUE*****************************************************************/

/*************************** typedefs & structures **************************/

/*****************************************************************************/
/*                                                                           */
/*       The ADJDATASTRUCT describes the Page Adjunct Data                   */
/*                                                                           */
/*****************************************************************************/

typedef struct tagADJDATASTRUCT
  {
   ULONG          ulAdjData;           /* size of Adjunct Data               */
   PBUF           pAdjData;            /* Pointer to Adjunct Data            */
  }
   ADJDATASTRUCT;

typedef ADJDATASTRUCT FARPTR16 PADJDATASTRUCT;

/****************************************************************************/
/************* Workstation Page Services function prototypes ****************/
/****************************************************************************/

SHORT EXPENTRY16 IpsCopyPage         (HPAGE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsCopySavedPage    (HPAGE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsCropPage         (HPAGE,
                                     PRATIO,
                                     PRATIO,
                                     UOM,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsFreePageFile     (PHPAGE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsFreePageMem      (PHPAGE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsGetPageAdjunct   (HPAGE,
                                     PHBUF FARPTR16,
                                     PULONG16,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsInvertPage       (HPAGE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsQueryPageAdjunct (HPAGE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsQueryPageImgSegs (HPAGE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsQueryPagePtxSegs (HPAGE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsQueryPageAttrs   (HPAGE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsRestorePage      (HPAGE,
                                     BOOL16,
                                     BOOL16,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsRotatePage       (HPAGE,
                                     USHORT,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsSavePage         (HPAGE,
                                     BOOL16,
                                     BOOL16,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsScalePage        (HPAGE,
                                     PRATIO,
                                     UOM,
                                     IMG_SCALE,
                                     BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsSetPageAdjunct   (PHPAGE,
                                     PHBUF,
                                     ULONG,
                                     BITS, HWND, USHORT, PRCSTRUCT);
