/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSOMS.H
*
*                          These are the definitions and prototypes made
*                          available externally to Object Manager.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      Object Manager external definitions.
*
*   Module Owner:          MCA
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        This header should be included after the
*                          C and Toolkit definitions, since it may use
*                          definitions from these.
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Include files:         None
*
*ENDPROLOGUE*****************************************************************/


/***************************************************************************

NOTE:  Only API related items that the rest of the platform need to know
       about should be placed in this file. Common OMS defines which are
       not part of platform defintion should be placed in the private OMS
       include file named OMSXDEFS.H

***************************************************************************/


/*
** maximum lengths for text strings, includes space for trailing zero
*/

#define MAX_CLASS_OR_GROUP_NAME_LENGTH           33

/* OBJECT SET  HANDLE */
typedef LHANDLE   HOBJSET;
typedef HOBJSET FARPTR16 PHOBJSET;

/*
** defines for the initial position of the object pointer
*/
#define OM_SEEK_SET 0   /* indicates the beginning of the Object */
#define OM_SEEK_CUR 1   /* indicates the current pointer position */
#define OM_SEEK_END 2   /* indicates the byte following the end of the object */


/*
** constants that indicate the location of a volume
*/
#define OM_LOCAL        1    /* volume is at local workstation */
#define OM_GLOBAL       2    /* volume is at the server */
#define OM_INACCESSIBLE 3    /* volume cannot be located */


/*
** constants that indicate the availability of an object
*/
#define OM_READY 1           /* object is immediately available */
#define OM_PENDING 2         /* Staging in progress */
#define OM_AVAILABLE 3       /* volume mounted, NO human intervention*/
#define OM_INVENTORIED 4     /* volume in inventory NO human intervention*/
#define OM_UNAVAILABLE 5     /* is offline, requires manual intervention */

/*
** STRUCTURES FOR THE CONFIGURATION MANAGER
*/

/*
** structure to return a list of volume names from QueryVolumes
*/

typedef struct
   {
   CHAR szVolumeName[MAX_VOL_NAME_LENGTH];
   }
   VOLUMESTRUCT;

typedef VOLUMESTRUCT FARPTR16 PVOLUMESTRUCT;



/*
** structure which holds the name and ID of one Object Storage Group
** and a pointer to the structure
*/
typedef struct
   {
   USHORT cbStruct;
   USHORT usStgGroup;
   CHAR szGroupName[MAX_CLASS_OR_GROUP_NAME_LENGTH];
   }
   STGGROUPNAMESTRUCT;

typedef STGGROUPNAMESTRUCT FARPTR16 PSTGGROUPNAMESTRUCT;



/*
** structure which holds the name and ID of one Object Management Class
** and a pointer to the structure
*/
typedef struct
   {
   USHORT cbStruct;
   USHORT usMgtClass;
   CHAR szClassName[MAX_CLASS_OR_GROUP_NAME_LENGTH];
   }
   MGTCLASSNAMESTRUCT;

typedef MGTCLASSNAMESTRUCT FARPTR16 PMGTCLASSNAMESTRUCT;


/*
** structure which holds the name and ID of one Object Storage Class
** and a pointer to the structure
*/
typedef struct
   {
   USHORT cbStruct;
   UCHAR idStgClass;
   CHAR szClassName[MAX_CLASS_OR_GROUP_NAME_LENGTH];
   }
   STGCLASSNAMESTRUCT;

typedef STGCLASSNAMESTRUCT FARPTR16 PSTGCLASSNAMESTRUCT;

#define MAX_MACHINE_NAME_LENGTH     9

#define MAX_OFFLINE_TEXT_LENGTH   129

/*
** structure which holds the Storage Class Information pointed to by
** the Mgt Class structure
*/

typedef struct
   {
   USHORT   cbStruct;
   UCHAR    idStgClass;
   USHORT   usTimeInClass;
   } MGTSTGCLASSSTRUCT, FARPTR16 PMGTSTGCLASSSTRUCT;

/*
** structure which holds the Management Class information for the MC query
*/

typedef struct
   {
   USHORT               cbStruct;
   USHORT               usMgtClass;
   CHAR                 szMgtClassName [MAX_CLASS_OR_GROUP_NAME_LENGTH];
   ULONG                ulImmedRetention;
   ULONG                ulDelayedRetention;
   SHORT                usMgtStgClasses;
   PMGTSTGCLASSSTRUCT   pMgtStgClassStruct;
   } MGTCLASSSTRUCT, FARPTR16 PMGTCLASSSTRUCT;

/*
** structure which holds information about one storage volume
** and a pointer to the structure
*/
typedef struct
   {
   USHORT cbStruct;
   CHAR  szVolName[MAX_VOL_NAME_LENGTH];
   ULONG ulVolSer;
   UCHAR ucLocation;
   UCHAR idStgClass;
   ULONG ulObjCount;
   ULONG ulVolKSize;
   ULONG ulVolKFree;
   }
   VOLENTRYSTRUCT;

typedef VOLENTRYSTRUCT FARPTR16 PVOLENTRYSTRUCT;

/*
** structure which contains all location information about a
** registered volume, a pointer to the structure and
** length definitions for the structure character strings
*/

#define MAX_MACHINE_NAME_LENGTH     9

#define MAX_OFFLINE_TEXT_LENGTH   129

typedef struct
   {
   USHORT cbStruct;
   CHAR szMachineName [MAX_MACHINE_NAME_LENGTH];
   CHAR szOfflineLoc [MAX_OFFLINE_TEXT_LENGTH];
   }
   VOLLOCSTRUCT;

typedef VOLLOCSTRUCT FARPTR16 PVOLLOCSTRUCT;

/*
** structure which holds information about a specific Object Storage Group
** and a pointer to the structure
*/
typedef struct
   {
   USHORT          cbStruct;
   USHORT          usMgtClass;
   USHORT          usVolEntries;
   PVOLENTRYSTRUCT pVolEntry;
   }
   STGGROUPSTRUCT;

typedef STGGROUPSTRUCT FARPTR16 PSTGGROUPSTRUCT;


/*
** structure which holds information about one object
** and a pointer to the structure
*/
typedef struct
   {
   USHORT cbStruct;
   UCHAR ucAvail;
   UCHAR ucLocation;
   ULONG cbObjSize;
   FDATE dCreateDate;
   FDATE dExpDate;
   FDATE dRefDate;
   FDATE dModDate;
   FDATE dEnterDate;
   FDATE dMigrationDate;
   UCHAR   idObjConCls;
   UCHAR   idStgClass;
   USHORT  usStgGroup;
   USHORT  usMgtClass;
   CHAR    szVolName[MAX_VOL_NAME_LENGTH];
   ULONG   ulVolSer;
   }
   OBJINFOSTRUCT;

typedef OBJINFOSTRUCT FARPTR16 POBJINFOSTRUCT;


/*
** these are prototypes for each of the Object Management API's
*/
SHORT EXPENTRY16 IpsDefineObjectStgGroup
               (USHORT, PSZ16, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsUndefineObjectStgGroup
               (USHORT, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsAddObjectStgGroupVol
               (PSZ16, ULONG, UCHAR, USHORT, USHORT, PVOLLOCSTRUCT, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsRemoveObjectStgGroupVol
               (PSZ16, ULONG, USHORT, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsChangeVolumeNameSerial
               (PSZ16, ULONG, PSZ16, ULONG, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsQueryObjectStgGroupNames
               (BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsQueryObjectMgtClassNames
               (BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsQueryObjectStgClassNames
               (BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsQueryObjectStgGroup
               (USHORT, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsQueryObjectMgtClass
               (USHORT, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsQueryVolumeObjects
               (PSZ16, ULONG, USHORT, PULONG16, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsQueryObject
               (HOBJ, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsChangeVolumeLocation
               (PSZ16, ULONG, PVOLLOCSTRUCT, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsQueryVolumeLocation
               (PSZ16, ULONG, BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsCatalogObject
               (UCHAR, PSZ16, ULONG, USHORT, PSZ16, PSZ16, BOOL16, UCHAR, HSEM, BOOL16, BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsDeleteObjectReference
               (HOBJ, PSZ16, PULONG16, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsChangeObjectStgGroup
               (HOBJ, PSZ16, ULONG, UCHAR, USHORT, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsCreateObject
               (UCHAR, PSZ16, ULONG, UCHAR, USHORT, PSZ16, UCHAR, HSEM, BOOL16, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsDeleteObject
               (HOBJ, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsOpenObject
               (HOBJ, UCHAR, UCHAR, BOOL16, BOOL16, HSEM, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsOpenObject2
               (HOBJ, UCHAR, UCHAR, BOOL16, BOOL16, HSEM, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsReopenObject
               (HOBJACC, UCHAR, BOOL16, BOOL16, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsReadObject
               (HOBJACC, PHBUF, ULONG, PULONG16, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsWriteObject
               (HOBJACC, PHBUF, ULONG, PULONG16, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsSeekObject
               (HOBJACC, BYTE, LONG, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsResizeObject
               (HOBJACC, ULONG, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsCopyObject
               (HOBJ, HOBJ, UCHAR, HSEM, BOOL16, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsCloseObject
               (HOBJACC, BOOL16, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsMigrateObject
               (HOBJ, PSZ16, ULONG, UCHAR, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsStageObject
               (HOBJ, UCHAR, BITS, HWND, USHORT, PRCSTRUCT) ;

SHORT EXPENTRY16 IpsAbortStage
               (USHORT, BITS, HWND, USHORT, PRCSTRUCT) ;


