/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSOAS.H
*
*                          Included by every application using the Object
*                          Access Services portion.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      This include file contains all of the defines
*                          and data structures required by Object
*                          Access Services.
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        This file must be included AFTER OS2.h.
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Include files:         This file is included by IPS.h if IPS_OAS_INCL
*                          has been defined in the source.
*
*ENDPROLOGUE*****************************************************************/

//-----------------------------------------------------------------------------
//
//   Insure that this include file will not be called recursively
//
//-----------------------------------------------------------------------------

#ifndef IPSOAS_DEFINED
#define IPSOAS_DEFINED

//-----------------------------------------------------------------------------
//
//                                OAS Defines
//
//-----------------------------------------------------------------------------

#define MAXCONCLSNAMESIZE  33          // Maximum size for an Object Content
                                       //   Class name; only 32 significant
                                       //   characters
#define MAXDLLNAMESIZE      9          // Maximum size for an Object Content
                                       //   Class DLL name; only 8 significant
                                       //   characters
#define MAXCONTENTCLASSES 256          // Maximum number of Object
                                       //   Content Classes that can be defined
                                       //   in the system
#define MAX_OBJECT_PAGES  0xFFFFFFFF   // Maximum number of pages that Object
                                       //   Access Services can support
#define MAX_RATIO_NUMERATOR 32767      // Maximum for numerator in a ratio

#define MODCA_P1            1          // Object Content Class identifier for
                                       //   the MO:DCA-P.1 content class
                                       //   supported in Release 1.0
#define TIFF                2          // Object Content Class identifier for
                                       //   the TIFF object content class
                                       //   supported in Release 1.0
#define MODCA_P2            3          // Object Content Class identifier for
                                       //   the MO:DCA-P.2 content class
                                       //   supported in UR1200

//-----------------------------------------------------------------------------
//
//   The CONCLSSTRUCT describes a particular Object Content Class
//
//-----------------------------------------------------------------------------

typedef struct tagCONCLSSTRUCT
   {
   USHORT       cbStruct;              // Number of bytes in this structure
   UCHAR        idObjConCls;           // Object Content Class identifier
   CHAR         szObjClsDef[MAXCONCLSNAMESIZE];
                                       // Object Content Class name
   CHAR         szDLLName[MAXDLLNAMESIZE];
                                       // Object Content Class DLL name
   }
   CONCLSSTRUCT;

typedef CONCLSSTRUCT FARPTR16 PCONCLSSTRUCT;

//-----------------------------------------------------------------------------
//
//   The OBJCLSSTRUCT describes available Object Content Classes
//
//-----------------------------------------------------------------------------

typedef struct tagOBJCLSSTRUCT
   {
   USHORT        cbStruct;             // Number of bytes in this structure
   USHORT        cClasses;             // Number of Object Content Classes
                                       //   defined in the system
   PCONCLSSTRUCT pConCls;              // Pointer to the list of Object Content
                                       //   Classes defined in the system
   }
   OBJCLSSTRUCT;

typedef OBJCLSSTRUCT FARPTR16 POBJCLSSTRUCT;

//-----------------------------------------------------------------------------
//
//                          OAS Function Prototypes
//
//-----------------------------------------------------------------------------

SHORT EXPENTRY16 IpsQueryObjCls(   BITS, HWND, USHORT, PRCSTRUCT );

SHORT EXPENTRY16 IpsCreateClsObj(  UCHAR, PSZ16, ULONG, UCHAR, USHORT,
                                           PSZ16, UCHAR, HSEM, BOOL16, BITS, HWND,
                                           USHORT, PRCSTRUCT );

SHORT EXPENTRY16 IpsCatalogClsObj( UCHAR, PSZ16, ULONG, USHORT,
                                           PSZ16, PSZ16, BOOL16, UCHAR, HSEM,
                                           BOOL16, PULONG16, BITS, HWND,
                                           USHORT, PRCSTRUCT );

SHORT EXPENTRY16 IpsDeleteClsObj(  HOBJ, BITS, HWND, USHORT,
                                           PRCSTRUCT );

SHORT EXPENTRY16 IpsUncatClsObj(   HOBJ, PSZ16, PULONG16, HSEM, BITS, HWND,
                                           USHORT, PRCSTRUCT );

SHORT EXPENTRY16 IpsOpenClsObj(    HOBJ, UCHAR, UCHAR, BOOL16, BOOL16,
                                           HSEM, BITS, HWND, USHORT,
                                           PRCSTRUCT );

SHORT EXPENTRY16 IpsReopenClsObj(  HOBJACC, UCHAR, BOOL16, BOOL16, BITS,
                                           HWND, USHORT, PRCSTRUCT );

SHORT EXPENTRY16 IpsCloseClsObj(   HOBJACC, BOOL16, BITS, HWND, USHORT,
                                           PRCSTRUCT );

SHORT EXPENTRY16 IpsGetObjPage(    HOBJACC, PHPAGE, ULONG, BOOL16, BITS,
                                           HWND, USHORT, PRCSTRUCT );

SHORT EXPENTRY16 IpsPutObjPage(    HOBJACC, PHPAGE, ULONG, BOOL16, BOOL16,
                                           BITS, HWND, USHORT, PRCSTRUCT );

SHORT EXPENTRY16 IpsDeleteObjPage( HOBJACC, ULONG, ULONG, BITS, HWND,
                                           USHORT, PRCSTRUCT );

//-----------------------------------------------------------------------------
//
//   SPI Prototypes
//
//-----------------------------------------------------------------------------
SHORT EXPENTRY16 IpcCreateNormImgSeg(HPAGE, PIMGSEGSTRUCT,
                                             PIMGCONTSTRUCT, PIMGAREASTRUCT,
                                             PHUCHAR, PRCSTRUCT);

SHORT EXPENTRY16 IpcCreateRawImgSeg( HPAGE, HIMAGE, UOM,
                                             PIMGSEGSTRUCT FARPTR16,
                                             PIMGCONTSTRUCT FARPTR16,
                                             PIMGAREASTRUCT FARPTR16,
                                             PHUCHAR FARPTR16, PRCSTRUCT );

SHORT EXPENTRY16 IpcCreateNormPage(  PPAGEINFSTRUCT, PRCSTRUCT );

SHORT EXPENTRY16 IpcQueryNormPageAttrs(HPAGE, PPAGEINFSTRUCT FARPTR16,
                                             PRCSTRUCT );
#endif
