/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSLCS.H
*
*                          LAN Communications Services definitions.
*
*                          Required by every module that calls an LCS
*                          function.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      This include file contains all function
*                          prototypes, typedefs, and data structures
*                          that are required for use of the LCS functions.
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        IPS.h -- In order to get this (IPSLCS.h) file
*                                   brought in to your compilation, you must
*                                     #define IPS_LCS_INCL
*                                   prior to:
*                                     #include <ips.h>
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Declarations:
*
*     Routines:            IpsCallResource
*                          IpsCloseResource
*                          IpsConnectResource
*                          IpsCreateResource
*                          IpsDisconnectResource
*                          IpsOpenResource
*                          IpsPeekAtSession
*                          IpsQuerySession
*                          IpsReceiveFromSession
*                          IpsSendToSession
*                          IpsTransactSession
*
*     Structures:          PEEKINFO
*                          QUERYINFO
*
*   Include files:
*
*ENDPROLOGUE*****************************************************************/

/*****************************************************************************/
/*                                                                           */
/*    Ensure that this include file is not recursively called                */
/*                                                                           */
/*****************************************************************************/

#ifndef IPSLCS_DEFINED
#define IPSLCS_DEFINED

/****************************************************************************/
/*                                                                          */
/*  The PEEKINFO structure describes the information returned by            */
/*  the IpsPeekAtSession function.                                          */
/*                                                                          */
/****************************************************************************/

typedef struct {
  USHORT  cbStruct;                                      // structure length in bytes
  USHORT  usBytesSess;                           // no. of bytes currently buffered in session
  USHORT  usBytesMsg;                            // no. of bytes in current message
  USHORT  usSessState;                           // session state:DISCONNECTED,LISTENING,CONNECTED,CLOSED
} PEEKINFO;

typedef   PEEKINFO  FARPTR16 PPEEKINFO;

#define IPS_LCS_DISCONNECTED     1                                       // possible values for usSessState
#define IPS_LCS_LISTENING        2
#define IPS_LCS_CONNECTED                       3
#define IPS_LCS_CLOSED           4

/****************************************************************************/
/*                                                                          */
/*  The QUERYINFO structure describes the information returned by           */
/*  the IpsQuerySession function.                                           */
/*                                                                          */
/****************************************************************************/

typedef struct {
  USHORT  cbStruct;                                      // structure length in bytes
  USHORT  usRequestorType;                       // 0-session id is client end of session
  USHORT  usMaxSessions;                         // 1-only 1 session with resource, 255 unlimited
} QUERYINFO;

typedef   QUERYINFO FARPTR16 PQUERYINFO;

/****************************************************************************/
/*                                                                          */
/*      LCS Function prototypes                                             */
/*                                                                          */
/****************************************************************************/

extern SHORT EXPENTRY16 IpsCreateResource (
                                   PSZ16,           // pszResName
                                   USHORT,          // usMaxSessions
                                   BOOL16,          // fConnect
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsConnectResource (
                                   USHORT,          // usSessionId
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsDisconnectResource (
                                   USHORT,          // usSessionId
                                   BOOL16,          // fConnect
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsOpenResource (
                                   PSZ16,           // pszResName
                                   BOOL16,          // fRetry
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsCloseResource (
                                   USHORT,          // usSessionId
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsSendToSession (
                                   USHORT,          // usSessionId
                                   PBUF,            // pBuffer
                                   USHORT,          // usCount
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsReceiveFromSession (
                                   USHORT,          // usSessionId
                                   PBUF,            // pBuffer
                                   USHORT,          // usCount
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsPeekAtSession (
                                   USHORT,          // usSessionId
                                   PBUF,            // pBuffer
                                   USHORT,          // usCount
//                                   PPEEKINFO,
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,                                                                                       // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsQuerySession (
                                   USHORT,          // usSessionId
//                                   PQUERYINFO,
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsTransactSession  (
                                   USHORT,          // usSessionId
                                   PBUF,            // pBuffIn
                                   USHORT,          // usInCount
                                   PBUF,            // pBuffOut
                                   USHORT,          // usOutCount
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

extern SHORT EXPENTRY16 IpsCallResource (
                                   PSZ16,           // pszResName
                                   PBUF,            // pBuffIn
                                   USHORT,          // usInCount
                                   PBUF,            // pBuffOut
                                   USHORT,          // usOutCount
                                   ULONG,           // ulTimeOut
                                   BITS,            // fOptions
                                   HWND,            // hSync
                                   USHORT,          // usMsgId
                                   PRCSTRUCT );

#endif   /* #ifndef IPSLCS_DEFINED */
