/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSIMG.H
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      Header file for Image Services functions,
*                          included by IPS.h.
*
*   Module Owner:          GKL
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        This file is included by IPS.h with the
*                          constant IPS_IMG_INCL defined.
*
*     Restrictions:        None.
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Include files:         None.
*
*ENDPROLOGUE*****************************************************************/

/****************************************************************************/
/******************************** definitions *******************************/
/****************************************************************************/

/****************************************************************************/
/*************************** typedefs & structures **************************/
/****************************************************************************/

typedef struct _IMGENCSTRUCT
   {
    USHORT cbStruct;         // structure byte length, including this value
    USHORT usHorzRed;        // anti-aliasing horizontal reduction factor
    USHORT usVertRed;        // anti-aliasing vertical reduction factor
    IMG_DITHER HalfTone;     // half-toning method identifer
    IMG_ERROR CarryErr;      // half-toning carry error flag
   } IMGENCSTRUCT;

typedef IMGENCSTRUCT FARPTR16 PIMGENCSTRUCT;

/****************************************************************************/
/************* Workstation Image Services function prototypes ***************/
/****************************************************************************/
SHORT EXPENTRY16 IpsQueryImgSegAttrs(HPAGE,
                                    HIMAGE,
                                    UOM,
                                    PIMGSEGSTRUCT FARPTR16,
                                    PIMGCONTSTRUCT FARPTR16,
                                    PIMGAREASTRUCT FARPTR16,
                                    BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsTransposeImgSeg (HPAGE,
                                    HIMAGE,
                                    USHORT,
                                    USHORT,
                                    PIMGENCSTRUCT,
                                    BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsInvertImgSeg    (HPAGE,
                                    HIMAGE,
                                    BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsCropImgSeg      (HPAGE,
                                    HIMAGE,
                                    PRECTL16,
                                    BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsRotateImgSeg    (HPAGE,
                                    HIMAGE,
                                    USHORT,
                                    BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsScaleImgSeg     (HPAGE,
                                    HIMAGE,
                                    ULONG,
                                    ULONG,
                                    IMG_SCALE,
                                    BITS, HWND, USHORT, PRCSTRUCT);
