/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSI2DEF.H
*
*                          Required by every Platform module that needs
*                          common data types and data structures defined.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      This include file contains the common defines
*                          and data structures required by the platform
*                          routines.
*
*   Status:                Release 1, Level 0
*
*
*   Notes:
*
*     Dependencies:        IPS.h  - It is assumed that the module will
*                                   include this.  IPSI2DEF.h is included
*                                   by IPSDEF.h which is included by IPS.h.
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Declarations:
*
*     Routines:
*
*     Structures:
*
*   Include files:
*
*ENDPROLOGUE*****************************************************************/

/*
 * This will NEVER be redefined if this file is included from within EXYTYPE.H
 */
#ifndef HUCHARD
#ifndef PHUCHARD
typedef unsigned char huge       HUCHAR;
typedef unsigned char HUGEPTR16  PHUCHAR;
#define HUCHARD
#define PHUCHARD
#endif
#endif

/******************************************************************************
* :Detail.Definitions which are global to all operating systems.
******************************************************************************/
typedef ULONG       OBJ_HANDLE;      /* generic object handle                */
typedef PULONG16    POBJ_HANDLE;

typedef OBJ_HANDLE  HIMAGE;          /* image object handle */
typedef POBJ_HANDLE PHIMAGE;

typedef OBJ_HANDLE  HPTEXT;          /* presentation text object handle */
typedef POBJ_HANDLE PHPTEXT;

/* Compression methods--same as the 1-byte code defined by IOCA */
#define IMG_IBM_MMR                                     1
#define IMG_UNCOMPRESSED                                3
#define IMG_ABIC                                        8
#define IMG_TIFF_2                                      9
#define IMG_ABIC_CONCAT                                10
#define IMG_G3_MH                                    0x80
#define IMG_G3_MR                                    0x81
#define IMG_G4_MMR                                   0x82
#define IMG_JPEG                                     0x83
#define IMG_RUN_END                                    50
/* jpeg compression algorithm coding types - not all supported */
#define IMG_JPEG_NHC_BASELINE_DCT                    0xC0
#define IMG_JPEG_NHC_EXTENDED_DCT                    0xC1
#define IMG_JPEG_NHC_PROGRESSIVE_DCT                 0xC2
#define IMG_JPEG_NHC_SPATIAL_DPCM                    0xC3
#define IMG_JPEG_HHC_SEQUENTIAL_DCT                  0xC5
#define IMG_JPEG_HHC_PROGRESSIVE_DCT                 0xC6
#define IMG_JPEG_HHC_SPATIAL                         0xC7
#define IMG_JPEG_NAC_EXTENDED_DCT                    0xC9
#define IMG_JPEG_NAC_PROGRESSIVE_DCT                 0xCA
#define IMG_JPEG_NAC_SPATIAL_DPCM                    0xCB
#define IMG_JPEG_HAC_SEQUENTIAL_DCT                  0xCD
#define IMG_JPEG_HAC_PROGRESSIVE_DCT                 0xCE
#define IMG_JPEG_HAC_SPATIAL                         0xCF

/******************************************************************************
* :Detail.Definition of RATIO and PRATIO
******************************************************************************/
typedef struct
{
  ULONG ulNumerator;
  ULONG ulDenominator;
} RATIO;
typedef RATIO FARPTR16  PRATIO;
#define RATIOD

/******************************************************************************
* :Detail ID=STRUCT. UOM.
******************************************************************************/
typedef enum
{
  uom_inch,
  uom_centimeter,
  uom_pixel,
  uom_inch_decimal,
  uom_millimeter,
  uom_pica,
  uom_cicero,
  uom_logical,
  uom_none
}  UOM;
#define UOMD

typedef enum
{
  position_and_trim,
  scale_to_fit,
  center_and_trim
} PG_MIO;              /* Map Image Object option from MO:DCA */

typedef PG_MIO FARPTR16 PPG_MIO;

typedef enum
{
  scale_ignore, /* pels dropping or replicating */
  scale_smooth  /* averaging or interpolation */
} IMG_SCALE;    /* scaling method */

typedef enum
{
  dither_threshold,
  dither_mesh,
  dither_superline,
  dither_supercircle
} IMG_DITHER; /* dither/halftoning methods */

typedef enum
{
  error_none,
  error_pel_to_pel
} IMG_ERROR; /* error diffusion */


// SCANNER


#define  MAX_DESC_SIZE        40

/* Defines used by Scan Parm */
#define SCAN_SINGLE_FEED           -1  // Single Feed (Flat Bed)
#define SCAN_CONTINUOUS_FEED        0  // Continuous feed - no ADF
#define SCAN_CONTINUOUS_ADF_BIN_1   1  // Bin Number for ADF

/* Query Parms parms */

#define SCPARM_VERSION        0      // Get DLL Version number (Query only)
#define SCPARM_INIT           0      // Use default parameters (Set only)
#define SCPARM_RESOLUTION     1      // Get scanner resolution
#define SCPARM_BPP            2      // Get Bits per Pel
#define SCPARM_AREA           3      // Get Scan Area
#define SCPARM_COMPRESSION    4      // Get Compression type
#define SCPARM_ADF            5      // Get ADF info

#ifndef SCNDPARM
#define SCNDPARM
typedef  CHAR  DEVPARMS;      /* dummy type definition for device specific
                                 data structure.  Each device driver
                                 implementation should redefine this definition
                                 with the actual device control block data
                                 structure definition.                     */
#endif

typedef  struct _SCAN_PARM
{
  USHORT   cbStruct;                     //Length of the complete structure.
  CHAR     szProfileDesc[MAX_DESC_SIZE+1];//ASCII Desc for this profile
                                         //Should be 40 chars and is NULL term.
  DEVPARMS dparms;                       //Label for Scanner Device Parameters.
} SCAN_PARM;

typedef SCAN_PARM FARPTR16 PSCAN_PARM;


 /******************************************************************************
 * :Detail ID=STRUCT. RESOLUTION.
 ******************************************************************************/

typedef struct
{
  RATIO rResolution; /* in pixels/uom */
  UOM   uom;
} RESOLUTION;

