/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSERR.H
*
*                          Required by every Platform module and any
*                          module that calls a Platform function.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      This include file contains all of the error
*                          defines and includes all error code files.
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        OS2.h  - It is assumed that the module will
*                                     include this.
*                          IPS.h  - This file is included by IPS.h.
*
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Declarations:
*
*     Routines:
*
*     Structures:
*
*   Include files:
*
*ENDPROLOGUE*****************************************************************/



/*****************************************************************************/
/*                                                                           */
/*    Ensure that this include file is not recursively called                */
/*                                                                           */
/*****************************************************************************/

#ifndef IPSERR_DEFINED
#define IPSERR_DEFINED

/****************************************************************************/
/*                                                                          */
/* Maximum value of an information return code                              */
/*                                                                          */
/****************************************************************************/

#define MAX_INFO    0xFFFF

/****************************************************************************/
/*                                                                          */
/* Minimum value of a warning Return code                                   */
/*                                                                          */
/****************************************************************************/

#define MIN_WARN    0x064

/****************************************************************************/
/*                                                                          */
/* Minimum value of an error return code                                    */
/*                                                                          */
/****************************************************************************/

#define MIN_ERROR   0x01F4


/****************************************************************************/
/*                                                                          */
/* Information Return Codes                                                 */
/*                                                                          */
/****************************************************************************/

#define SUCCESS                                                  0X0000
#define ASYNCH_STARTED                                           0XFFFF
#define FUNCTION_TERMINATED                                      0XFFFE

#define MESSAGE_FILE_EMPTY                                       0XFFF6
#define OVERLAY_INTERVAL_AT_200_PERCENT                          0XFFF5
#define OVERLAY_INTERVAL_AT_150_PERCENT                          0XFFF4
#define MESSAGE_ENTRY_OVERWRITTEN                                0XFFF3
#define MESSAGE_ENTRY_NOT_LOGGED                                 0XFFF2
#define STAGE_PENDING                                            0XFFF1
#define STAGE_ABORTED                                            0XFFF0
#define STAGE_NO_OBJECT_ACCESSES                                 0XFFEF

/****************************************************************************/
/*                                                                          */
/* Warning Condition Return Codes                                0x0064     */
/*                                                                          */
/****************************************************************************/

#define WARNING_NO_MORE_PAGES                                    0X0069

#define WARNING_FILE_CLEANUP_FAILED                              0X006D
#define WARNING_MODCA_ACCESS_INFO                                0X006E
#define WARNING_MODCA_MEMORY_NOT_FREED                           0X006F
#define WARNING_MODCA_UNUSABLE_OBJECT                            0X0070
#define WARNING_DEVICE_PARM_MODIFIED                             0X0071
#define WARNING_DEVICE_STATE_NOT_SET                             0X0072
#define WARNING_OPENING_RESOURCE                                 0X0073
#define WARNING_CREATING_RESOURCE                                0X0074
#define WARNING_JOB_ALREADY_ENDING                               0X0075
#define WARNING_JOB_ALREADY_ABORTING                             0X0076
#define WARNING_JOB_ALREADY_CLOSING                              0X0077
#define WARNING_CONFIG_KEY_NOT_FOUND                             0X0078
#define WARNING_CONFIG_APP_NOT_FOUND                             0X0079
#define WARNING_FEED_TRAY_IS_EMPTY                               0X007A
#define WARNING_FILE_MEMORY_NOT_FREED                            0X007B
#define WARNING_LOG_CHAIN_IS_EMPTY                               0X007C
#define WARNING_LAST_DEV_MGR_DELETED                             0X007D
#define WARNING_INACCURATE_VOL_INFO                              0X007E
#define WARNING_CANNOT_UPDATE_VOL_DATA                           0X007F
#define WARNING_CANNOT_CLEAR_MST_ENTRY                           0X0080
#define WARNING_CANNOT_SUPPORT_DRIVE                             0X0081
#define WARNING_VOLUME_NOT_IN_DRIVE                              0X0082
#define WARNING_EUI_OMS_BKGD_STGCLS_SP                           0X0083
#define WARNING_READ_PAST_END_OF_FILE                            0X0084
#define WARNING_MST_ENTRY_NOT_FOUND                              0X0085
#define WARNING_CANNOT_LOAD_HELP_FILE                            0X0086
#define WARNING_CANNOT_LOAD_HELP_MGR                             0X0087
#define WARNING_OS_DISK_CHANGE                                   0X0088
#define WARNING_DEV_MGR_INVALID_PARM                             0X0089
#define WARNING_ALL_DMS_DID_NOT_INIT                             0X008A
#define WARNING_EUI_OMS_BKGD_STAGE_SP                            0X008B
#define WARNING_EUI_OMS_BKGD_STAGE_LOW                           0X008C
#define WARNING_EUI_OMS_BKGD_OP_BACKLOG                          0X008D
#define WARNING_WORM_ADD_FLIP_SIDE                               0X008E
#define WARNING_BDI_NOT_FOUND                                    0X008F
#define WARNING_CANNOT_SUPPORT_DRIVE_WO                          0X0090


/****************************************************************************/
/*                                                                          */
/* API Parameter Error Return Codes                              0x01F4     */
/*                                                                          */
/****************************************************************************/

#define INVALID_ACCESS_CODE                                      0X01F6
#define INVALID_BITS_PER_PEL                                     0X01F7
#define INVALID_BUFFER_PTR                                       0X01F8
#define INVALID_CONTENT_CLASS                                    0X01F9
#define INVALID_RECTANGLE                                        0X01FA
#define INVALID_RECTANGLE_PTR                                    0X01FB
#define INVALID_DEVICE_ID                                        0X01FC
#define INVALID_DEVICE_STRUCT_PTR                                0X01FD
#define INVALID_ENCODE_STRUCT_DATA                               0X01FF
#define INVALID_ENCODE_STRUCT_PTR                                0X0200

#define INVALID_IMAGE_FORMAT_CODE                                0X0202
#define INVALID_IMAGE_HANDLE                                     0X0203
#define INVALID_INPUT_COUNT                                      0X0204
#define INVALID_JOB_HANDLE                                       0X0205
#define INVALID_JOB_STRUCT_PTR                                   0X0206
#define INVALID_OBJECT_HANDLE                                    0X0207
#define INVALID_OPTIONS_FLAG                                     0X0208
#define INVALID_OUTPUT_COUNT                                     0X0209
#define INVALID_PAGE_HANDLE                                      0X020A
#define INVALID_PAGE_HANDLE_PTR                                  0X020B
#define INVALID_PAGE_NUMBER                                      0X020C
#define INVALID_PAINT_PS_HANDLE                                  0X020D
#define INVALID_PEEK_STRUCT_PTR                                  0X020E
#define INVALID_PRIORITY_CODE                                    0X020F
#define INVALID_QUERY_STRUCT_PTR                                 0X0210
#define INVALID_RC_STRUCT_PTR                                    0X0211
#define INVALID_RESOURCE_NAME                                    0X0212
#define INVALID_RESOURCE_NAME_PTR                                0X0213
#define INVALID_ROTATION_DEGREES                                 0X0214
#define INVALID_SCALING_METHOD                                   0X0215
#define INVALID_SESSION_ID                                       0X0216
#define INVALID_STORAGE_CLASS                                    0X0217
#define INVALID_STORAGE_GROUP                                    0X0218
#define INVALID_UOM_CODE                                         0X021A
#define INVALID_VOLUME_NAME                                      0X021B

#define INVALID_WINDOW_HANDLE                                    0X021D
#define INVALID_ZOOM_FACTOR                                      0X021E

#define INVALID_IMG_SEG_STRUCT_PTR                               0X0222
#define INVALID_IMAGE_DATA_PTR                                   0X0223
#define INVALID_FILE_NAME                                        0X0224
#define INVALID_FILE_NAME_PTR                                    0X0225
#define INVALID_VOLUME_NAME_PTR                                  0X0226
#define INVALID_SEEK_ORIGIN                                      0X0227
#define INVALID_MANAGEMENT_CLASS                                 0X0228
#define INVALID_STG_GROUP_NAME                                   0X0229
#define INVALID_STG_GROUP_NAME_PTR                               0X022A
#define INVALID_VOLUME_SERIAL                                    0X022B
#define INVALID_OBJECT_ACCESS_HANDLE                             0X022C
#define INVALID_SEEK_OFFSET                                      0X022D
#define INVALID_STAGE_IDENTIFIER                                 0X022E
#define INVALID_OBJECT_SET_HANDLE                                0X022F
#define INVALID_VOL_NAME_OUTPUT_PTR                              0X0230
#define INVALID_VOL_SERIAL_OUTPUT_PTR                            0X0231
#define INVALID_BYTES_READ_PTR                                   0X0232
#define INVALID_IMG_CONT_STRUCT_PTR                              0X0233
#define INVALID_IMG_AREA_STRUCT_PTR                              0X0234
#define INVALID_IMG_SEG_COMPRESSION                              0X0235
#define INVALID_IMG_CONT_EXTENT                                  0X0236
#define INVALID_IMG_CONT_ORIGIN                                  0X0237
#define INVALID_IMG_CONT_COORD_CODE                              0X0238
#define INVALID_IMG_AREA_POSITION_ID                             0X0239
#define INVALID_IMG_AREA_EXTENT                                  0X023A
#define INVALID_IMG_AREA_MIO_CODE                                0X023B
#define INVALID_IMG_AREA_COORD_UOM                               0X023C
#define INVALID_IMG_AREA_ORIGIN                                  0X023D
#define INVALID_IMG_SEG_WIDTH                                    0X023E
#define INVALID_IMG_SEG_HEIGHT                                   0X023F
#define INVALID_PAGE_NAME                                        0X0240
#define INVALID_IMG_SEG_RESOLUTION                               0X0241
#define INVALID_IMG_SEG_BITS_PER_PEL                             0X0242
#define INVALID_IMG_SEG_BYTES_PER_LINE                           0X0243
#define INVALID_IMG_SEG_TOTAL_BYTES                              0X0244
#define INVALID_IMG_SEG_RES_UOM                                  0X0245
#define INVALID_IMG_SEG_NAME                                     0X0246

#define INVALID_PAGE_EXTENT                                      0X0248
#define INVALID_PAGE_EXTENT_UOM                                  0X0249
#define INVALID_PAGE_INF_STRUCT_PTR                              0X024A
#define INVALID_IMG_AREA_ORIENTATION                             0X024B
#define INVALID_IMG_CONT_ORIENTATION                             0X024C
#define INVALID_VERSION_STRUCT_PTR                               0X024D
#define INVALID_CONFIG_LOCATION_CODE                             0X024E
#define INVALID_CONFIG_APP_NAME                                  0X024F
#define INVALID_CONFIG_APP_NAME_PTR                              0X0250
#define INVALID_CONFIG_KEY_NAME                                  0X0251
#define INVALID_INPUT_BUFFER_PTR                                 0X0252
#define INVALID_VALUE_BUFFER_PTR                                 0X0253
#define INVALID_IMG_CONT_ORIGIN_UOM                              0X0254
#define INVALID_OUTPUT_BUFFER_PTR                                0X0255
#define INVALID_PRINT_OPTION                                     0X0256
#define INVALID_MAXIMUM_SESSIONS                                 0X0257
#define INVALID_VALUE_BUFFER_SIZE                                0X0258
#define INVALID_FILE_ID_STRING                                   0X0259
#define INVALID_WIDTH_VALUE                                      0X025A
#define INVALID_HEIGHT_VALUE                                     0X025B
#define INVALID_BLT_OPTION                                       0X025C
#define INVALID_BITMAPONLY_FLAG                                  0X025D
#define INVALID_ORIGIN_RATIO                                     0X025E
#define INVALID_ORIGIN_RATIO_PTR                                 0X025F
#define INVALID_EXTENT_RATIO                                     0X0260
#define INVALID_EXTENT_RATIO_PTR                                 0X0261
#define INVALID_ADJUNCT_BUFFER_PTR                               0X0262
#define INVALID_ADJUNCT_LENGTH_PTR                               0X0263
#define INVALID_VOLLOC_OFFLINE_STRING                            0X0264
#define INVALID_MACHINE_NAME                                     0X0265
#define INVALID_STG_CLASS_NAME                                   0X0266
#define INVALID_STG_CLASS_NAME_PTR                               0X0267
#define INVALID_MGT_CLASS_NAME                                   0X0268
#define INVALID_MGT_CLASS_NAME_PTR                               0X0269
#define INVALID_DEV_MGR_DLL_NAME                                 0X026A
#define INVALID_JOB_ID                                           0X026B
#define INVALID_QUEUE_LOCATION                                   0X026C
#define INVALID_QUEUE_NAME                                       0X026D
#define INVALID_QUEUE_NAME_PTR                                   0X026E
#define INVALID_STATE_JOB_ID                                     0X026F
#define INVALID_STATE_STRUCT_PTR                                 0X0270
#define INVALID_STATE_XMIT_MODE                                  0X0271
#define INVALID_STATE_XMIT_STATE                                 0X0272
#define INVALID_CAP_STRUCT_PTR                                   0X0273

#define INVALID_TIFF_CLT_PTR                                     0X027F
#define INVALID_SOURCE_CLT_PTR                                   0X0280
#define INVALID_BYTES_OUTPUT_PTR                                 0X0281
#define INVALID_IMG_SEG_COLOR_TBL_PTR                            0X0282
#define INVALID_LOG_FILE_NAME                                    0X0283
#define INVALID_LOG_FILE_NAME_PTR                                0X0284
#define INVALID_ERROR_LOG_HANDLE                                 0X0285
#define INVALID_ERROR_INFO_REF_PTR                               0X0286
#define INVALID_ERROR_LOG_INFO_PTR                               0X0287
#define INVALID_ERROR_LOG_INFO_DATA                              0X0288
#define INVALID_CALLING_ERROR_CODE                               0X0289
#define INVALID_CALLING_ID_PTR                                   0X028A
#define INVALID_DEVICE_PARAMETER                                 0X028B
#define INVALID_VOLUME_LOCATION_PTR                              0X028C
#define INVALID_JOB_CHANGE_OPTION                                0X028D
#define INVALID_LOG_HANDLE_PTR                                   0X028E
#define INVALID_LOG_INFO_PTR                                     0X028F
#define INVALID_NUM_STAGING_AREAS                                0X0290
#define INVALID_DISPLAY_OPTION                                   0X0291
#define INVALID_NULL_PTR_TO_NUM_PAGES                            0X0292
#define INVALID_OS_PARAMETER                                     0X0293

/****************************************************************************/
/*                                                                          */
/* Configuration Errors                                         0x03E8      */
/*                                                                          */
/****************************************************************************/

#define CONFIG_CC_COUNT_NOT_FOUND                               0X03E9
#define CONFIG_CC_COUNT_SYNTAX_ERROR                            0X03EA
#define CONFIG_CC_COUNT_VALUE_ERROR                             0X03EB
#define CONFIG_CC_DLL_NAME_NOT_FOUND                            0X03EC
#define CONFIG_CC_DLL_NAME_SYNTAX_ERROR                         0X03ED
#define CONFIG_CC_ID_NOT_FOUND                                  0X03EE
#define CONFIG_CC_ID_SYNTAX_ERROR                               0X03EF
#define CONFIG_CC_ID_VALUE_ERROR                                0X03F0
#define CONFIG_CC_INFO_NOT_FOUND                                0X03F1
#define CONFIG_CC_NAME_SYNTAX_ERROR                             0X03F2
#define CONFIG_FIELD_SEP_NOT_FOUND                              0X03F3
#define CONFIG_INSUFFICIENT_QUEUE_COUNT                         0X03F4
#define CONFIG_TEMP_FILE_PATH_NOT_FOUND                         0X03F5
#define CONFIG_CC_NAME_NOT_FOUND                                0X03F6


/****************************************************************************/
/*                                                                          */
/* Execution Errors                                             0x07D0      */
/*                                                                          */
/****************************************************************************/

#define ERROR_DOS_GET_PID                                       0X07E9
#define ERROR_DOS_GET_HUGE_SHIFT                                0X082D
#define ERROR_OBJECT_IN_USE                                     0X084C
#define ERROR_OBJECT_MARKED_DELETED                             0X084D
#define ERROR_SAME_STG_GROUP                                    0X084F
#define ERROR_VOLUME_MOUNT_FAILED                               0X0850

#define ERROR_NETWORK_FAILURE                                   0X0853
#define ERROR_SYSTEM_HAS_RECOVERED                              0X0854
#define ERROR_SYSTEM_CANNOT_RECOVER                             0X0855
#define ERROR_VOLUME_NOT_IN_STG_CLASS                           0X0856
#define ERROR_OMS_CONTROL_ACCESS                                0X0857
#define ERROR_STG_GROUP_LIMIT_REACHED                           0X0858
#define ERROR_STG_GROUP_ALREADY_EXISTS                          0X0859

#define ERROR_ACCESS_MODE_CONFLICT                              0X085B
#define ERROR_VOLUME_IN_USE                                     0X085C
#define ERROR_SAME_OBJECT_HANDLE                                0X085D
#define ERROR_INSUFFICIENT_MEMORY                               0X085E
#define ERROR_UTL_DLL_INIT_FAILED                               0X085F
#define ERROR_THREAD_LIMIT_REACHED                              0X0860
#define ERROR_OMS_DLL_INIT_FAILED                               0X0861
#define ERROR_VOLUME_ALREADY_EXISTS                             0X0862
#define ERROR_VOLUME_NOT_IN_STG_GROUP                           0X0863
#define ERROR_OBJECT_NOT_IN_SET                                 0X0865

#define ERROR_SEMAPHORE_LIMIT_REACHED                           0X0873
#define ERROR_CONFIG_FILE_NOT_FOUND                             0X0874
#define ERROR_CNF_DLL_INIT_FAILED                               0X0875
#define ERROR_STORAGE_LIMIT_REACHED                             0X0876

/*
|  REQUIRED FOR SPOOL
*/
#define ERROR_CONFIG_APP_NOT_FOUND                             0X0877
#define ERROR_CONFIG_KEY_NOT_FOUND                             0X0878
#define ERROR_VALUE_BUFFER_TOO_SMALL                           0X0879
#define ERROR_OBJECT_NOT_FOUND                                 0X087A
#define ERROR_DEVICE_NOT_AVAILABLE                             0X087B
#define ERROR_OBJECT_IN_EXCLUSIVE_USE                          0X087C
#define ERROR_OPEN_OBJECT_LIMIT_REACHED                        0X087D
#define ERROR_PAGE_BUSY                                        0X087E
#define ERROR_PAG_DLL_INIT_FAILED                              0X087F
#define ERROR_LCS_DLL_INIT_FAILED                              0X0880
#define ERROR_OUTPUT_BUFFER_TOO_SMALL                          0X0881
#define ERROR_SESSION_BROKEN                                   0X0882
#define ERROR_NETWORK_RESOURCE_BUSY                            0X0883
#define ERROR_FUNCTION_INTERRUPTED                             0X0884
#define ERROR_INVALID_CLIENT_REQUEST                           0X0885
#define ERROR_SESSION_NOT_CONNECTED                            0X0886
#define ERROR_NETWRK_RESOURCE_NOT_FOUND                        0X0887
#define ERROR_CANNOT_CREATE_RESOURCE                           0X0888
#define ERROR_OAS_DLL_INIT_FAILED                              0X0889
#define ERROR_CC_DLL_NOT_FOUND                                 0X088A
#define ERROR_OPEN_FILE_LIMIT_REACHED                          0X088B
#define ERROR_INVALID_CONT_CLASS_DLL                           0X088C
#define ERROR_CC_FUNCTION_NOT_FOUND                            0X088D
#define ERROR_INVALID_CONTENT_CLASS                            0X088E
#define ERROR_AT_LAST_PAGE                                     0X088F
#define ERROR_AT_FIRST_PAGE                                    0X0890
#define ERROR_PAGE_LIMIT_REACHED                               0X0891
#define ERROR_NO_WRITE_ACCESS                                  0X0892
#define ERROR_RECOVERED_CANT_FREE_FILE                         0X0893
#define ERROR_UNRECOVRD_CANT_FREE_FILE                         0X0894
#define ERROR_RECOVERED_CANT_FREE_PAGE                         0X0895
#define ERROR_UNRECOVRD_CANT_FREE_PAGE                         0X0896
#define ERROR_MODCA_DLL_INIT_FAILED                            0X0897
#define ERROR_INVALID_MODCA_PAGE                               0X0898
#define ERROR_ILLEGAL_ADJUNCT_DATA                             0X0899
#define ERROR_UNRECOVERED_CLOSE_OBJECT                         0X089A
#define ERROR_THREAD_LIMIT_CLOSE_OBJECT                        0X089B
#define ERROR_INSUF_MEMORY_CLOSE_OBJECT                        0X089C
#define ERROR_STORAGE_LIMIT_CLOSE_OBJ                          0X089D
#define ERROR_PAGE_EXTENT                                      0X089E
#define ERROR_IMAGE_CONTENT_ORIGIN                             0X089F
#define ERROR_IMAGE_CONTENT_EXTENT                             0X08A0
#define ERROR_IMAGE_AREA_ORIGIN                                0X08A1
#define ERROR_IMAGE_AREA_EXTENT                                0X08A2
#define ERROR_RECOVERED_CLOSE_OBJECT                           0X08A3
#define ERROR_INVALID_MODCA_DOCUMENT                           0X08A4
#define ERROR_TEMP_FILE_PATH_NOT_FOUND                         0X08A5
#define ERROR_TEMP_FILE_PATH_DISK_FULL                         0X08A6
#define ERROR_MORE_DATA_AVAILABLE                              0X08A7
#define ERROR_PIPE_IS_BROKEN                                   0X08A8
#define ERROR_LOCK_VIOLATION_OCCURRED                          0X08A9
#define ERROR_NON_DOS_DISK                                     0X08AA
#define ERROR_INTERNAL_FILE_HANDLE                             0X08AB
#define ERROR_ACCESS_IS_DENIED                                 0X08AC
#define ERROR_PAG_DLL_CANT_FREE_PAGE                           0X08AD
#define ERROR_INVALID_VOLUME_SERIAL                            0X08AE
#define ERROR_IMG_DLL_INIT_FAILED                              0X08AF
#define ERROR_DISPLAY_PAGE_BUSY                                0X08B0
#define ERROR_PAGE_NOT_PREPARED                                0X08B1
#define ERROR_PAGE_NOT_IN_MEMORY                               0X08B2
#define ERROR_DSP_DLL_INIT_FAILED                              0X08B3
#define ERROR_PAGE_NOT_SAVED                                   0X08B4
#define ERROR_PAGE_ALREADY_SAVED                               0X08B5
#define ERROR_MODCA_MISSING_BEGIN_OBJ                          0X08B6
#define ERROR_MODCA_DUPLICATE_GCS                              0X08B7
#define ERROR_MODCA_DUPLICATE_IMG_FS                           0X08B8
#define ERROR_MODCA_DUPLICATE_IS                               0X08B9
#define ERROR_MODCA_DUPLICATE_PTX_FS                           0X08BA

#define ERROR_TEMP_FILE_LIMIT_REACHED                          0X08BC

#define ERROR_MODCA_IOCA_FUNC_SET                              0X08BE
#define ERROR_MODCA_TRAILING_DATA                              0X08BF
#define ERROR_MODCA_BEGIN_OBJ_LENGTH                           0X08C0
#define ERROR_MODCA_BPG_LENGTH                                 0X08C1
#define ERROR_MODCA_FUNCTION_SET                               0X08C2
#define ERROR_MODCA_DOC_SECURITY                               0X08C3
#define ERROR_MODCA_END_OBJ_LENGTH                             0X08C4
#define ERROR_MODCA_EPG_LENGTH                                 0X08C5
#define ERROR_MODCA_FS_LENGTH                                  0X08C6
#define ERROR_MODCA_GCS_LENGTH                                 0X08C7
#define ERROR_MODCA_INTERCHANGE_SET                            0X08C8
#define ERROR_MODCA_DOCUMENT_TYPE                              0X08C9
#define ERROR_MODCA_IS_LENGTH                                  0X08CA
#define ERROR_MODCA_VERSION                                    0X08CB
#define ERROR_MODCA_BDT_LENGTH                                 0X08CC
#define ERROR_MODCA_MISSING_BDT                                0X08CD
#define ERROR_MODCA_MISSING_BPG                                0X08CE
#define ERROR_MODCA_MISSING_EPG                                0X08CF
#define ERROR_MODCA_MISSING_END_OBJ                            0X08D0
#define ERROR_MODCA_MISSING_GCS                                0X08D1
#define ERROR_MODCA_MISSING_IS                                 0X08D2
#define ERROR_MODCA_BEGIN_END_NAME                             0X08D3
#define ERROR_MODCA_MISSING_FS                                 0X08D4
#define ERROR_MODCA_PTOCA_FUNC_SET                             0X08D5
#define ERROR_MODCA_RESERVED_FIELD                             0X08D6
#define ERROR_SDS_DLL_INIT_FAILED                              0X08D7
#define ERROR_LL_LIST_HANDLE                                   0X08D9
#define ERROR_LL_LIST_HANDLE_PTR                               0X08DA
#define ERROR_LL_SEARCH_KEY_PTR                                0X08DB
#define ERROR_LL_SEARCH_KEY_LENGTH                             0X08DC
#define ERROR_LL_LIST_EMPTY                                    0X08DD
#define ERROR_LL_RECORD_NOT_FOUND                              0X08DE
#define ERROR_LL_LIST_ALREADY_LOCKED                           0X08DF
#define ERROR_LL_NO_MORE_RECORDS                               0X08E0
#define ERROR_LL_NO_PREV_RECORDS                               0X08E1
#define ERROR_LL_LIST_NOT_UNLOCKED                             0X08E2
#define ERROR_LL_LIST_NOT_LOCKED                               0X08E3
#define ERROR_LL_CANNOT_RESET_LIST                             0X08E4
#define ERROR_LL_CANNOT_RELEASE_ACCESS                         0X08E5

#define ERROR_DEVICE_TABLE_CORRUPTED                           0X08E7
#define ERROR_SYSTEM_DLL_NOT_FOUND                             0X08E8
#define ERROR_HEAP_MAX_SIZE_REACHED                            0X08E9
#define ERROR_HEAP_OUT_OF_MEMORY                               0X08EA

#define ERROR_INVALID_SYSTEM_DLL                               0X08EC
#define ERROR_JOB_DOES_NOT_EXIST                               0X08EE
#define ERROR_NET_REDIRECTOR_DOWN                              0X08EF
#define ERROR_NET_REQUESTOR_DOWN                               0X08F0
#define ERROR_DEVICE_QUEUE_NOT_NETUSED                         0X08F1
#define ERROR_SERVER_REQUEST_FAILED                            0X08F2

#define ERROR_OBJECT_CLOSED_NO_COMMIT                          0X08F4
#define ERROR_MODCA_OBJECT_CORRUPTED                           0X08F5
#define ERROR_OMS_CONTROL_LIMIT_REACHED                        0X08F6
#define ERROR_OBJECT_SET_EMPTY                                 0X08F7
#define ERROR_OBJ_HANDLE_LIMIT_REACHED                         0X08F8
#define ERROR_STG_GROUP_IN_USE                                 0X08F9
#define ERROR_MGT_CLASS_IN_USE                                 0X08FA
#define ERROR_OBJECT_IS_READ_ONLY                              0X08FB
#define ERROR_OBJECT_IN_SET                                    0X08FC
#define ERROR_MACHINE_NAME_MISMATCH                            0X08FD
#define ERROR_CONNECTION_LIMIT_REACHED                         0X08FE
#define ERROR_OMS_CONTROL_CORRUPTED                            0X08FF

#define ERROR_SYS_INI_ENTRY_NOT_FOUND                          0X0901
#define ERROR_INVALID_SYS_INI_ENTRY                            0X0902

#define ERROR_JOB_LIMIT_REACHED                                0X090E
#define ERROR_JOB_ALREADY_DISCARDING                           0X090F

#define ERROR_CREATING_QUEUE_RECORD                            0X0911
#define ERROR_INVALID_FAX_DOCUMENT                             0X0912
#define ERROR_QUEUE_LIST_NOT_FOUND                             0X0913
#define ERROR_QUEUE_RECORD_CHANGED                             0X0914
#define ERROR_JOB_BEING_TRANSMITTED                            0X0915
#define ERROR_QUEUE_FILE_NOT_FOUND                             0X0916
#define ERROR_READING_TIFF_FILE                                0X0917
#define ERROR_GAMMA_FILE_NOT_FOUND                             0X0918
#define ERROR_INVALID_TIFF_VERSION                             0X0919
#define ERROR_QUEUE_FILE_BUSY                                  0X091A
#define ERROR_MODCA_CONTROL_ACCESS                             0X091B
#define ERROR_MGT_CLASS_LIMIT_REACHED                          0X091C
#define ERROR_STG_CLASS_LIMIT_REACHED                          0X091D
#define ERROR_STG_CLASS_IN_USE                                 0X091E
#define ERROR_NUMERATOR_EXCEEDS_LIMIT                          0X091F
#define ERROR_INVALID_DEVICE_DLL                               0X0920
#define ERROR_NOT_CAPTURE_DEVICE                               0X0921
#define ERROR_DEVICE_LOCKED                                    0X0922
#define ERROR_DEVICE_NOT_ATTACHED                              0X0923
#define ERROR_DEVICE_POWERED_OFF                               0X0924
#define ERROR_DEVICE_FAILURE                                   0X0925
#define ERROR_JOB_ALREADY_PROCESSED                            0X0926
#define ERROR_CREATING_LOCAL_REFERENCE                         0X0927
#define ERROR_NOT_INPUT_DEVICE                                 0X0928
#define ERROR_INVALID_MACHINE_TYPE                             0X0929
#define ERROR_SERVER_DLL_MISMATCH                              0X092A
#define ERROR_INVALID_TIFF_DOCUMENT                            0X092B
#define ERROR_TAG_COLOR_MAP                                    0X092C
#define ERROR_TAG_RESOLUTION_UNIT                              0X092D
#define ERROR_TAG_Y_RESOLUTION                                 0X092E
#define ERROR_TAG_X_RESOLUTION                                 0X092F
#define ERROR_TAG_STRIP_BYTE_COUNTS                            0X0930
#define ERROR_TAG_STRIP_OFFSETS                                0X0931
#define ERROR_TAG_COMPRESSION                                  0X0932
#define ERROR_TAG_BITS_PER_SAMPLE                              0X0933
#define ERROR_TAG_IMAGE_LENGTH                                 0X0934
#define ERROR_TAG_IMAGE_WIDTH                                  0X0935
#define ERROR_TIFF_DLL_INIT_FAILED                             0X0936
#define ERROR_MULTIPLE_IMAGE_SEGMENTS                          0X0937
#define ERROR_INVALID_TIFF_COMPRESSION                         0X0938
#define ERROR_OOT_ENTRY_NOT_FOUND                              0X0939
#define ERROR_INVALID_TIFF_TAG                                 0X093A
#define ERROR_DEVICE_DRIVER_NOT_FOUND                          0X093B
#define ERROR_INVALID_RESOURCE_DLL                             0X093C
#define ERROR_RESOURCE_DLL_NOT_FOUND                           0X093D
#define ERROR_COUNTRY_SYS_FILE_NOT_FND                         0X093E
#define ERROR_COUNTRY_CODE_NOT_FOUND                           0X093F
#define ERROR_WRITING_DATE_TIME                                0X0940
#define ERROR_INVALID_DEVICE_QUEUE                             0X0941
#define ERROR_STG_CLASS_ALREADY_EXISTS                         0X0942
#define ERROR_MGT_CLASS_ALREADY_EXISTS                         0X0943
#define ERROR_INVALID_MIGRATION_TIME                           0X0944
#define ERROR_MIGRATOR_UNKNOWN_DEF_OP                          0X0945
#define ERROR_MIGRATOR_PROCESS_ABORTED                         0X0946
#define ERROR_MIGRATOR_OPERATION_FAILED                        0X0947
#define ERROR_MIGRATOR_DEVICE_NOT_READY                        0X0948
#define ERROR_DEVICE_DLL_NOT_FOUND                             0X0949
#define ERROR_NOT_PRINTER_DEVICE                               0X094A
#define ERROR_MODCA_MISSING_EDT                                0X094B
#define ERROR_MODCA_INVALID_BDT                                0X094C
#define ERROR_FAX_JOB_NOT_FOUND                                0X094D
#define ERROR_FAX_QFILE_BUSY_TIMEOUT                           0X094E
#define ERROR_FAX_BAD_GFAX_OR_PATH                             0X094F
#define ERROR_FAX_RECORD_ACTIVE                                0X0950
#define ERROR_ENVIRONMENT_VAR_NOT_FOUND                        0X0951
#define ERROR_GAMMA_DLL_INIT_FAILED                            0X0952
#define ERROR_MIGRATOR_TERMINATED                              0X0953
#define ERROR_MIGRATOR_CONFIG_ACCESS                           0X0954
#define ERROR_MIGRATOR_OP_LIMIT_REACHED                        0X0955
#define ERROR_OMS_BKGD_CM_QUERY                                0X0956
#define ERROR_OMS_BKGD_DB_QUERY                                0X0957
#define ERROR_OMS_BKGD_DB_UPDATE                               0X0958
#define ERROR_OMS_BKGD_CRIT_DB_QUERY                           0X0959
#define ERROR_OMS_BKGD_CRIT_DB_UPDATE                          0X095A
#define ERROR_OMS_BKGD_MOUNT_INIT                              0X095B
#define ERROR_OMS_BKGD_MOUNT_FREE                              0X095C
#define ERROR_OMS_BKGD_MOUNT_FAILED                            0X095D
#define ERROR_OMS_BKGD_DISMOUNT_FAILED                         0X095E
#define ERROR_OMS_BKGD_MOUNT_QUERY                             0X095F
#define ERROR_OMS_BKGD_FILE_DELETE                             0X0960
#define ERROR_OMS_BKGD_FILE_COPY                               0X0961
#define ERROR_OMS_BKGD_FILE_QUERY                              0X0962
#define ERROR_OMS_BKGD_FILE_CREATE                             0X0963
#define ERROR_OMS_BKGD_STAGING_AREA                            0X0964
#define ERROR_LOG_FILE_NOT_FOUND                               0X0965
#define ERROR_LOG_FILE_DELETE_FAILED                           0X0966
#define ERROR_INVALID_LOG_FILE                                 0X0967
#define ERROR_LOG_FILE_OP_FAILED                               0X0968
#define ERROR_CANNOT_REDUCE_FILE_SIZE                          0X0969
#define ERROR_FILE_SIZE_INCREASE_FAILED                        0X096A
#define ERROR_LOG_FILE_CREATE_FAILED                           0X096B
#define ERROR_LOG_FILE_UPDATE_FAILED                           0X096C
#define ERROR_INVALID_JOB_PRIORITY                             0X096D
#define ERROR_SPOOLER_NOT_INSTALLED                            0X096E
#define ERROR_FAX_INVALID_JOB_PATH                             0X096F
#define ERROR_WRITE_ACCESS_FAILED                              0X0970

#define ERROR_INVALID_SERVER_NAME                              0X0972
#define ERROR_PROCESS_ACCESS_REQUIRED                          0X0973
#define ERROR_FAX_FILE_PATH_NOT_FOUND                          0X0974
#define ERROR_FAX_FILE_NOT_FOUND                               0X0975
#define ERROR_TABLE_CANNOT_BE_LOCKED                           0X0976

#define ERROR_DLL_NAME_ALREADY_DEFINED                         0X0979
#define ERROR_CONFIG_DM_INFO_NOT_FOUND                         0X097A
#define ERROR_DEV_MGR_DLL_NOT_FOUND                            0X097B
#define ERROR_MNT_DLL_INIT_FAILED                              0X097C
#define ERROR_INVALID_DEV_MGR_DLL                              0X097D
#define ERROR_DEV_MGR_FUNC_NOT_FOUND                           0X097E
#define ERROR_NOT_OUTPUT_DEVICE                                0X097F
#define ERROR_DEV_MGR_CANNOT_MOUNT_VOL                         0X0980
#define ERROR_DEV_MGR_INIT_DUPLICATE                           0X0981
#define ERROR_DEV_MGR_INIT_NOT_CALLED                          0X0982
#define ERROR_DEV_MGR_INVALID_PARM                             0X0983
#define ERROR_DEV_MGR_REQUEST_BUSY                             0X0984
#define ERROR_DEV_MGR_VOL_ENTRY_NOT_FND                        0X0985
#define ERROR_DEV_MGR_MOUNTER_NOT_TOLD                         0X0986
#define ERROR_MOUNT_LIMIT_REACHED                              0X0987
#define ERROR_INVALID_STARVE_TIME_PARM                         0X0988
#define ERROR_MOUNT_CANNOT_BE_DONE_NOW                         0X0989
#define ERROR_MOUNT_REJECTED                                   0X098A
#define ERROR_CANNOT_SUPPORT_DRIVES                            0X098B
#define ERROR_INVALID_MACHINE_NAME                             0X098C
#define ERROR_INVALID_PAGE_DATA                                0X098D
#define ERROR_QUEUE_RECORD_ACTIVE                              0X098E
#define ERROR_USER_HANDLES_EXCEEDED                            0X0990
#define ERROR_RESOURCE_PATH_NOT_SHARED                         0X0991
#define ERROR_NO_STAGE_PATH                                    0X0992
#define ERROR_CANNOT_ABORT                                     0X0993
#define ERROR_NLS_INITIALIZATION                               0X0994
#define ERROR_SERIALIZATION                                    0X0995
#define ERROR_CURR_STGCLS_EQU_TO_REQUES                        0X0996
#define ERROR_MIGR_TIMES_NOT_CONFIGURED                        0X0997
#define ERROR_OBJECT_RECOVERY_FAILED                           0X0998
#define ERROR_IMAGE_SIZE_TOO_SMALL                             0X0999
#define ERROR_DB_REQUEST_FAILED                                0X099A
#define ERROR_INVALID_MAGIC_NUMBER                             0X099B
#define ERROR_PTEXT_NOT_SUPPORTED                              0X099C
#define ERROR_CANNOT_LOCATE_HELP_FILE                          0X099D

#define ERROR_NULL_ULONG_PTR                                   0X099F
#define ERROR_CANNOT_OPEN_SCANNER                              0X09A0
#define ERROR_INVALID_SCAN_PARM_VALUE                          0X09A1
#define ERROR_SCN_PARM_CANT_BE_MODIFIED                        0X09A2
#define ERROR_TOO_MANY_SCN_OPEN_REQUEST                        0X09A3
#define ERROR_SCANNER_BUSY                                     0X09A4
#define ERROR_INVALID_HSCAN_PARM                               0X09A5
#define ERROR_SCAN_DEVICE_ERROR                                0X09A6
#define ERROR_TOO_MANY_PRN_JOBS_WAITING                        0X09A7
#define ERROR_DEV_MGR_DLL_NOT_CONFIGURE                        0X09A8
#define ERROR_CROPPING_RECT_NOTIN_IMAGE                        0X09A9
#define ERROR_CLIPPED_IMAGE_TOO_SMALL                          0X09AA
#define ERROR_SYSTEM_NOT_CONFIGURED                            0X09AB
#define ERROR_STAGER_PROCESS_ABORTED                           0X09AC
#define ERROR_OBJ_MGR_PROCESS_ABORTED                          0X09AD
#define ERROR_INVALID_PATH_DEFINED                             0X09AE
#define ERROR_PATH_NOT_UNIQUE                                  0X09AF
#define ERROR_STARTING_BACKGND_PROCESS                         0X09B0
#define ERROR_OS_INVALID_CATEGORY                              0X09B1
#define ERROR_OS_SHARING_VIOLATION                             0X09B2
#define ERROR_OS_SEMAPHORE                                     0X09B3
#define ERROR_OS_PROTECTION_VIOLATION                          0X09B4
#define ERROR_OS_PATH_NOT_FOUND                                0X09B5
#define ERROR_OS_OPEN_FAILED                                   0X09B6
#define ERROR_OS_NO_VOLUME_LABEL                               0X09B7
#define ERROR_OS_NO_PROC_SLOT                                  0X09B8
#define ERROR_OS_NO_MORE_SEARCH_HANDLES                        0X09B9
#define ERROR_OS_NO_MORE_FILES                                 0X09BA
#define ERROR_OS_INVALID_LEVEL                                 0X09BB
#define ERROR_OS_INVALID_HANDLE                                0X09BC
#define ERROR_OS_FILE_NOT_FOUND                                0X09BD
#define ERROR_OS_FILENAME_EXCED_RANGE                          0X09BE
#define ERROR_OS_EA                                            0X09BF
#define ERROR_OS_DISK_FULL                                     0X09C0
#define ERROR_OS_CURRENT_DIRECTORY                             0X09C1
#define ERROR_OS_DIRECTORY                                     0X09C2
#define ERROR_OS_CANNOT_MAKE                                   0X09C3
#define ERROR_SERVER_NOT_FOUND                                 0X09C4
#define ERROR_EXCEEDED_MAX_FILE_SIZE                           0X09C5
#define ERROR_OS_INVALID_FUNCTION                              0X09C6
#define ERROR_NO_GFAX_ENVVAR                                   0X09C7
#define ERROR_DEV_MGR_INITS_FAILED                             0X09C8
#define ERROR_EUI_OMS_BKGD_MOUNT                               0X09C9
#define ERROR_EUI_OMS_BKGD_VOL_WR_PROT                         0X09CA
#define ERROR_EUI_OMS_BKGD_VOL_IO                              0X09CB
#define ERROR_EUI_OMS_BKGD_STAGE_IO                            0X09CC
#define ERROR_EUI_OMS_BKGD_NON_CRIT_ERR                        0X09CD
#define ERROR_EUI_OMS_BKGD_CRITICAL_ERR                        0X09CE
#define ERROR_USER_NAME_NOT_UNIQUE                             0X09CF
#define ERROR_DB_STORAGE_LIMIT_REACHED                         0X09D0
#define ERROR_VOLUME_OFFLINE                                   0X09D1
#define ERROR_INVALID_DATETIME                                 0X09D2

/***************************************************************************/
/*  System/Admin Error Messages for WORM Media Migration                   */
/***************************************************************************/

#define ERROR_WORM_NO_NE_STGGRP                                0X09D3
#define ERROR_WORM_ADD_TO_SAME_GRP                             0X09D4
#define ERROR_WORM_NO_NE_VOL                                   0X09D5
#define ERROR_DIFF_FLIPSIDE_STG_GROUP                          0X09D6
#define ERROR_FLIPSIDE_OFFLINE                                 0X09D7
#define ERROR_WORM_VOL_EXISTS_IN_SG                            0X09D8

#define ERROR_DIFF_FLIPSIDE_STG_CLASS                          0X09DD
#define ERROR_WORM_ADD_TO_SAME_CLS                             0X09DE

/****************************************************************************/
/*  Display Services errors                                                 */
/****************************************************************************/
#define ERROR_IAA_ALREADY_INITIALIZED                          0X09DF
#define ERROR_IAA_INVALID_DISPLAY_TYPE                         0X09E0
#define ERROR_IAA_INITIALIZE_FAILED                            0X09E1

/****************************************************************************/
/*                                                                          */
/* Scanner support Return Codes                                 0x6100      */
/*                                                                          */
/****************************************************************************/

#define RC_SCAN_BASE_ERR                  0x6100
#define RC_SCAN_ALREADY_BUSY              0x6100
#define RC_SCAN_ALREADY_INITIALIZED       0x6101
#define RC_SCAN_DEVICE_ERROR              0x6102
#define RC_SCAN_DLG_CANCEL                0x6103
#define RC_SCAN_ERROR_TRUNC               0x6104
#define RC_SCAN_FUNC_NOT_SUPPORTED        0x6105
#define RC_SCAN_HEADER_TOO_SHORT          0x6106
#define RC_SCAN_INVALID_DEVICE_NAME       0x6107
#define RC_SCAN_INVALID_HANDLE            0x6108
#define RC_SCAN_INVALID_IDENTIFIER        0x6109
#define RC_SCAN_INVALID_PARM              0x610A
#define RC_SCAN_LENGTH_TOO_SHORT          0x610B
#define RC_SCAN_MORE_DATA                 0x610C
#define RC_SCAN_NOT_ENOUGH_MEMORY         0x610D
#define RC_SCAN_NOT_INITIALIZED           0x610E
#define RC_SCAN_NO_DATA                   0x610F
#define RC_SCAN_NO_ERROR_MESSAGE          0x6110
#define RC_SCAN_NO_ERROR_STORED           0x6111
#define RC_SCAN_OPEN_VIOLATION            0x6112
#define RC_SCAN_PARM_CANNOT_BE_MODIFIED   0x6113
#define RC_SCAN_POWER_OFF                 0x6114
#define RC_SCAN_TIMEOUT                   0x6115
#define RC_SCAN_ADF_EMPTY                 0x6116
#define RC_SCAN_ATT_REQ                   0x6117

#endif /* #ifndef IPSERR_DEFINED */
