/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSDSP.H
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      Header file for Display Services functions,
*                          included by IPS.h.
*
*   Module Owner:          G. Salsi
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        This file is included by IPS.h with the
*                          constant IPS_DSP_INCL defined.
*
*     Restrictions:        None.
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Include files:         None.
*
*ENDPROLOGUE*****************************************************************/

/*************************** typedefs & structures **************************/
/* Blt options for DisplayPage */
#define IPS_BLT_OR         0L
#define IPS_BLT_AND        1L
#define IPS_BLT_IGNORE     2L

/*****************************************************************************/
/*                                                                           */
/*       The DSPPAGEATTRSTRUCT desribes the prepared page attributes         */
/*                                                                           */
/*****************************************************************************/

typedef struct tagDSPPAGEATTRSTRUCT
  {
   USHORT         cbStruct;            /* length of this structure           */
   ULONG          ulWidth;             /* prepared page width in pels        */
   ULONG          ulHeight;            /* prepared page height in pels       */
   LONG           lOrigin[2];          /* page origin (top left RDIC)        */
  }
   DSPPAGEATTRSTRUCT;

typedef DSPPAGEATTRSTRUCT FARPTR16 PDSPPAGEATTRSTRUCT;

/****************************************************************************/
/************* Workstation Display Services function prototypes *************/
/****************************************************************************/

SHORT EXPENTRY16 IpsQueryDspPageAttrs (HPAGE,
                                      BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsPrepDspPage       (HPAGE,
                                      DISPLAY_OPTION,
                                      PSIZEL16,
                                      BOOL16,
                                      BOOL16,
                                      BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsSetDspPageMode    (HPAGE,
                                      ULONG,
                                      BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsDisplayPage       (HPS,
                                      HPAGE,
                                      HWND,
                                      PRECTL16,
                                      BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsPanDspPage        (HPAGE,
                                      LONG,
                                      LONG,
                                      BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsZoomDspPage       (HPAGE,
                                      PPOINTL,
                                      ULONG,
                                      ULONG,
                                      BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsScreenToImage     (HWND,
                                      PRECTL16,
                                      BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsRotateDspPage     (HPAGE,
                                      USHORT,
                                      BITS, HWND, USHORT, PRCSTRUCT);

SHORT EXPENTRY16 IpsInvertDspPage     (HPAGE,
                                      BITS, HWND, USHORT, PRCSTRUCT);

/****************************************************************************/
/***** Workstation Image Adapter/A Display Services function prototypes *****/
/****************************************************************************/

SHORT EXPENTRY16 IpsInitIA ( PDUALDSPATTRSTRUCT pDualDspAttrs,/* IAA Display attrs*/
                           BITS fOptions,          /* options flag            */
                           HWND hSync,             /* window/semaphore handle */
                           USHORT usMsgId,         /* message id for posting  */
                           PRCSTRUCT pRC);         /* return code structure   */

SHORT EXPENTRY16 IpsClearIAWindow ( HWND hWnd,       /* client window handle    */
                                  BITS fOptions,   /* options flag            */
                                  HWND hSync,      /* window/semaphore handle */
                                  USHORT usMsgId,  /* message id for posting  */
                                  PRCSTRUCT pRC);  /* return code structure   */

SHORT EXPENTRY16 IpsFreeIA ( HWND hWnd,              /* client window handle    */
                           BITS fOptions,          /* options flag            */
                           HWND hSync,             /* window/semaphore handle */
                           USHORT usMsgId,         /* message id for posting  */
                           PRCSTRUCT pRC);         /* return code structure   */

SHORT EXPENTRY16 IpsDisplayIAPage ( HPAGE hPage,     /* Page handle             */
                                  HWND hWnd,       /* client window handle    */
                                  BITS fOptions,   /* options flag            */
                                  HWND hSync,      /* window/semaphore handle */
                                  USHORT usMsgId,  /* message id for posting  */
                                  PRCSTRUCT pRC);  /* return code structure   */

SHORT EXPENTRY16 IpsQueryDspDevs ( BITS fOptions,    /* options flag            */
                                 HWND hSync,       /* window/semaphore handle */
                                 USHORT usMsgId,   /* message id for posting  */
                                 PRCSTRUCT pRC);   /* return code structure   */

SHORT EXPENTRY16 IpsPrepIADspPage ( HPAGE hPage,     /* Page handle             */
                                  BITS fOptions,   /* options flag            */
                                  HWND hSync,      /* window/semaphore handle */
                                  USHORT usMsgId,  /* message id for posting  */
                                  PRCSTRUCT pRC);  /* return code structure   */

SHORT EXPENTRY16 IpsZoomIADspPage ( HPAGE hPage,     /* Page handle             */
                                  ULONG ulZoomNum, /* Zomm numerator          */
                                  ULONG ulZoomDen, /* Zomm Denominator        */
                                  BITS fOptions,   /* options flag            */
                                  HWND hSync,      /* window/semaphore handle */
                                  USHORT usMsgId,  /* message id for posting  */
                                  PRCSTRUCT pRC);  /* return code structure   */
