/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSDM.H
*
*                          Included by every user of the Device Manager
*                          SPI's.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      This include file contains all of the defines
*                          and data structures required by the
*                          Device Manager.
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        This file must be included AFTER OS2.h.
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Include files:         This file is included by IPS.h if IPS_DM_INCL
*                          has been defined in the source.
*
*ENDPROLOGUE*****************************************************************/

//-----------------------------------------------------------------------------
//
//   Insure that this include file will not be called recursively
//
//-----------------------------------------------------------------------------

#ifndef IPSDM_DEFINED
#define IPSDM_DEFINED

//-----------------------------------------------------------------------------
//
//                       Device Manager Defines
//
//-----------------------------------------------------------------------------
#define MAX_DM_DESCRIPTION_LEN  80     // Maximum length of a DM description
#define MAX_DM_PARAMS_LEN      128     // Maximum length of a DM parameter
                                       //   string

                                       //--------------------------------------
                                       //   Defines for the mount request status
                                       //--------------------------------------
#define DEVMGR_MOUNT_COMPLETE     1    // Mount request was completed (mounted)
#define DEVMGR_MOUNT_INCOMPLETE   2    // Mount request could not be completed
#define DEVMGR_MOUNT_CANCELLED    3    // Mount request was cancelled by user
#define DEVMGR_MOUNT_DEFERRED     4    // Mount request was deferred by user

//-----------------------------------------------------------------------------
//
//   The DMINITSTRUCT describes Device Manager initialization parameters
//
//-----------------------------------------------------------------------------
typedef struct tagDMINITSTRUCT
   {
   USHORT      cbStruct;               // Number of bytes in this structure
   BITSL       fDrives;                // Drives to be managed by the Device
                                       //   Manager
                                       // Device Manager DLL name
   CHAR        szDescription[MAX_DM_DESCRIPTION_LEN];
                                       // Device Manager description
   CHAR        szParms[MAX_DM_PARAMS_LEN];
                                       // Device Manager specific parameters
   HQUEUE      hQueue;                 // Queue handle to be used by the Device
                                       //   Manager for sending completion
                                       //   notification of a mount request
   HWND        hWnd;                   // Window handle used by Device Manager
                                       //   for any End User Interface needed
   }
  DMINITSTRUCT;

typedef DMINITSTRUCT FARPTR16 PDMINITSTRUCT;

//-----------------------------------------------------------------------------
//
//   The DMINITRCSTRUCT describes the Device Manager initialization return
//   code information.
//
//-----------------------------------------------------------------------------
typedef struct tagDMINITRCSTRUCT
   {
   USHORT        cbStruct;             // Number of bytes in this structure
   SHORT         sDMRC;                // Device Manager extended return code
   }
   DMINITRCSTRUCT;

typedef DMINITRCSTRUCT FARPTR16 PDMINITRCSTRUCT;

//-----------------------------------------------------------------------------
//
//   The ONLINEVOLSTRUCT describes the volume identification and status
//   information.
//
//-----------------------------------------------------------------------------
typedef struct tagONLINEVOLSTRUCT
   {
   USHORT        cbStruct;             // Number of bytes in this structure
   VOLUMEID      VolumeID;             // Volume information
   USHORT        usStatus;             // Status of the volume
   }
   ONLINEVOLSTRUCT;

typedef ONLINEVOLSTRUCT FARPTR16 PONLINEVOLSTRUCT;

//-----------------------------------------------------------------------------
//
//               Device Manager SPI Function Prototypes
//
//-----------------------------------------------------------------------------


SHORT EXPENTRY16 DevMgrInit(               PDMINITSTRUCT,
                                           PDMINITRCSTRUCT );

SHORT EXPENTRY16 DevMgrMountVolume(        PVOLUMEID, BOOL16, UCHAR,
                                           USHORT, PVOLINFOSTRUCT );

SHORT EXPENTRY16 DevMgrDismountVolume(     USHORT, PVOLUMEID,
                                           PVOLINFOSTRUCT );

SHORT EXPENTRY16 DevMgrQueryVolume(        PVOLUMEID, PVOLINFOSTRUCT,
                                           PBOOL16 );

SHORT EXPENTRY16 DevMgrQueryOnlineVolumes( PUSHORT16,
                                           PONLINEVOLSTRUCT FARPTR16 );

SHORT EXPENTRY16 DevMgrFree( VOID );

SHORT EXPENTRY16 DevMgrFastQueryVolume(    PVOLUMEID, BOOL16, PVOLINFOSTRUCT,
                                           PBOOL16 );
#endif
