/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSDEF.H
*
*                          Required by every Platform module that needs
*                          common data types and data structures defined.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                          All Rights Reserved
*
*   Descriptive Name:      This include file contains all of the common
*                          defines and data structures required by the
*                          platform routines.
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        IPS.h  - It is assumed that the module will
*                                   include this.  IPSDEF.h is included
*                                   by IPS.h.
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Declarations:
*
*     Routines:
*
*     Structures:
*                  Common
*                          RCSTRUCT
*                          IMGSEGSTRUCT
*                          PAGEDEFSTRUCT
*
*   Include files:
*                 xxxdef.h
*
*ENDPROLOGUE******************************************************************/

/*****************************************************************************/
/*                                                                           */
/*       Ensure that this include file is not INCLUDEd more than once        */
/*                                                                           */
/*****************************************************************************/

#ifndef IPSDEF_DEFINED
#define IPSDEF_DEFINED

/*****************************************************************************/
/*                                                                           */
/*       Some general defines                                                */
/*                                                                           */
/*****************************************************************************/


/*****************************************************************************/
/*  Definitions for VERSIONSTRUCT (product version information)              */
/*****************************************************************************/
#define MAXSZNAMESIZE        12        // Max. size of the Product Name
#define MAXSZRELEASESIZE      4        // Max. size of the release number
#define MAXSZVERSIONSIZE      4        // Max. size of the version number
#define MAXSZMODELSIZE        4        // Max. size of the model number
#define MAXSZCOPYRIGHTSIZE   64        // Max. size of the copyright statement

/*****************************************************************************/
/*  Definitions for message logging                                          */
/*****************************************************************************/
#define DLL_INIT_ERL_HDL         0xffffffff
#define NULL_PRC_ERL_HDL         0xfffffffe
#define NULL_HERR_ERL_HDL        0xfffffffd
#define BACKGROUND_PROC_ERL_HDL  0xfffffffc
#define BKGD_MIGRATOR_ERL_HDL    0xfffffffb
#define BKGD_STAGER_ERL_HDL      0xfffffffa
#define BKGD_MOUNTER_ERL_HDL     0xfffffff9
#define BKGD_SERVER_ERL_HDL      0xfffffff8
#define BKGD_DEVICE_MGR_ERL_HDL  0xfffffff7

#define MAX_PROTECT_TIME         1000000L
                                       // Maximum allowed protection time for
                                       // message log entries

/*****************************************************************************/
/*  Definitions for fOptions, used for synch/asynch processing               */
/*****************************************************************************/
#define IPS_OPT_SYNC          0x0000
#define IPS_OPT_ASYNC         0x0001
#define IPS_OPT_MSG           0x0000
#define IPS_OPT_SEM           0x0002
#define IPS_VALID_FOPTIONS    (IPS_OPT_ASYNC | IPS_OPT_SEM)
#define IPS_INVALID_FOPTIONS  ~(IPS_VALID_FOPTIONS)

/*****************************************************************************/
/* Values for ucCoord in the IMGCONTSTRUCT                                   */
/*****************************************************************************/

#define IMG_AREA_ORIGIN    0x00
#define IMG_PAGE_ORIGIN    0x01

/*****************************************************************************/
/* Values for usOrient in the IMGCONTSTRUCT                                  */
/*****************************************************************************/

#define IMG_ORIENT_0       0x0000
#define IMG_ORIENT_90      0x2D00

/*****************************************************************************/
/*  values for idBPP, bits per pel                                           */
/*****************************************************************************/
#define IPS_BPP_1              1       /* 1 bit per pel   */
#define IPS_BPP_2              2       /* 2 bit per pel   */
#define IPS_BPP_4              4       /* 4 bits per pel  */
#define IPS_BPP_8              8       /* 8 bits per pel  */
#define IPS_BPP_24             24      /* 24 bits per pel */

/*****************************************************************************/
/*  values for idMONITOR, bits per pel                                       */
/*****************************************************************************/
#define IPS_SINGLE             0       /* Single display monitor */
#define IPS_DUAL               1       /* Dual display monitor   */

/*****************************************************************************/
/*  Values for cmdAccess, used to determine how an object should be opened.  */
/*****************************************************************************/
#define OM_SHARED_READ    0            // Object is opened for reading only,
                                       //   and is available to others for
                                       //   shared read or read/write accesses.
#define OM_EXCL_READ      1            // Object is opened for reading only,
                                       //   and is excluded to all other
                                       //   accesses.
#define OM_READ_WRITE     2            // Object is opened for reading and
                                       //   writing, and is only available for
                                       //   shared read accesses.

/*****************************************************************************/
/*  Values for cmdPriority, used to indicate how fast a client wants a       */
/*  request processed.                                                       */
/*****************************************************************************/
#define OM_RUSH_PRIORITY        1      // Process it as soon as possible.
#define OM_NORMAL_PRIORITY      2      // Process it in a reasonable amount
                                       //   of time (but behind RUSH requests).
#define OM_BACKGROUND_PRIORITY  3      // Process it whenever it can be done
                                       //   (but behind NORMAL requests).

/*****************************************************************************/
/* Maximum length for file id -- user defined name for an object.            */
/*****************************************************************************/

#define MAX_FILE_ID_LENGTH      65535

/*****************************************************************************/
/* Maximum volume name length                                                */
/*****************************************************************************/

#define MAX_VOL_NAME_LENGTH      12

/*****************************************************************************/
/* Maximum file name length                                                  */
/*   For: directory and name of file (excluding the drive)                   */
/*****************************************************************************/

#define MAX_FILE_NAME_LENGTH    234


/*****************************************************************************/
/* Maximum length of a device access specifier                               */
/*****************************************************************************/

#define MAX_DEV_ACC_SPEC_LEN    23

/*****************************************************************************/
/* Maximum length of file specifier                                          */
/*****************************************************************************/

#define MAX_FILE_SPEC_LENGTH  MAX_DEV_ACC_SPEC_LEN+MAX_FILE_NAME_LENGTH-1

/*****************************************************************************/
/*                                                                           */
/*       Some General TYPEDEFs                                               */
/*                                                                           */
/*****************************************************************************/

typedef USHORT BITS;

typedef SHANDLE HOBJACC;               // Object Access Handle

typedef LHANDLE         HJOB;
typedef HJOB FARPTR16   PHJOB;

typedef LHANDLE         HOBJ;
typedef HOBJ FARPTR16   PHOBJ;

typedef LHANDLE         HPAGE;
typedef HPAGE FARPTR16  PHPAGE;

typedef ULONG           HERR;

typedef PCHAR16         PBUF;
typedef CHAR HUGEPTR16  PHBUF;

typedef ULONG           BITSL;

/*****************************************************************************/
/*                                                                           */
/*       The RCSTRUCT describes the return values                            */
/*                                                                           */
/*****************************************************************************/

typedef struct _RCSTRUCT
  {
   USHORT         cbStruct;            // the size of this data structure
   SHORT          sRC;                 // Final completion return code
   USHORT         usParam;             // short parameter
   ULONG          ulParam;             // long parameter
   HERR           hErrLog;             // handle to logged error chain
  }
   RCSTRUCT;

typedef RCSTRUCT FARPTR16 PRCSTRUCT;


typedef enum
  {
   display_pel_for_pel,
   display_actual,
   display_scale,
   display_proportional,
   display_actual_fast,
   display_JPEG_initial,
   display_JPEG_final
  }
  DISPLAY_OPTION;


#if defined(IPS_OMS_INCL) || defined(IPS_DM_INCL)


// Defines for the status of a volume

#define OM_OFFLINE               0     // Not accessible without manual
                                       //   intervention
#define OM_ONLINE                2     // Accessible without manual
                                       //   intervention, but not in the drive
#define OM_INLINE                4     // Online and in the drive, but no
                                       //   active mounts
#define OM_MOUNTED               6     // Online and in the drive with active
                                       //   mounts
#define OM_FIXED                 8     // Online and fixed

//-----------------------------------------------------------------------------
// Values for Fast Query's fVolInfo field
//-----------------------------------------------------------------------------
#define FQ_GET_ALL_INFO      0x0007  // Requesting info for szDevAccSpec, ulSize, and ulFreeSpace
#define FQ_GET_DEVACC        0x0004  // Requesting info for szDevAccSpec only

//-----------------------------------------------------------------------------
//
//   The VOLUMEID describes volume identification information.
//
//-----------------------------------------------------------------------------

typedef struct _VOLUMEID
  {
   USHORT        cbStruct;             // Number of bytes in this structure
   CHAR          szVolName[MAX_VOL_NAME_LENGTH];
                                       // Volume name string
   ULONG         ulVolSer;             // Volume serial number
  }
   VOLUMEID;

typedef VOLUMEID FARPTR16 PVOLUMEID;

//-----------------------------------------------------------------------------
//
//   The VOLINFOSTRUCT describes the volume information
//
//-----------------------------------------------------------------------------

typedef struct _VOLINFOSTRUCT
  {
   USHORT        cbStruct;             // Number of bytes in this structure
   USHORT        usStatus;             // Status of the volume
   CHAR          szDevAccSpec[MAX_DEV_ACC_SPEC_LEN];
                                       // Device access specifier
   ULONG         ulSize;               // Size of a volume in thousands of
                                       //   bytes
   ULONG         ulFreeSpace;          // Free space on the volume in
                                       //   thousands of bytes
   VOLUMEID      FlipSideVolID;        // Flip side volume ID structure.
                                       // Caller is responsible to NULL out
                                       // szVolName and ulVolSer before calling.
                                       // When there is a flip side volume,
                                       // the called function will set these
                                       // fields.
  }
   VOLINFOSTRUCT;

typedef VOLINFOSTRUCT FARPTR16 PVOLINFOSTRUCT;

#endif


#if defined(IPS_OAS_INCL) || defined(IPS_IMG_INCL) || \
    defined(IPS_DSP_INCL) || defined(IPS_PAG_INCL) || \
    defined(IPS_SDS_INCL)

/*****************************************************************************/
/*                                                                           */
/*       The IMGSEGSTRUCT describes only information related to image        */
/*       objects.                                                            */
/*                                                                           */
/*****************************************************************************/

typedef struct _IMGSEGSTRUCT
  {
   USHORT       cbStruct;              // Structure byte length
   USHORT       usCompression;         // Current compression format
   USHORT       usBitsPerPel;          // Bits per pixel
   USHORT       usPlanes;              // Number of image planes
   USHORT       usBytesPerLine;        // Byte length of a single image line
                                       //   (usLineSize)
   ULONG        ulTotalBytes;          // Byte length of image (ulImageSize)
   ULONG        ulWidth;               // Image width in pixels
   ULONG        ulHeight;              // Image height in pixels
   UOM          uomResolution;         // Horz and vert units of measure
                                       //   (uomCoord) - only one value applies
                                       //   to both rResolution elements
   RATIO        rResolution[2];        // Horz and vert resolution of image
                                       //   object in pixels/UOM
   RGB FARPTR16 prgbCLT;               // Pointer to color table (pColorTab)
   CHAR         szName[9];             // Name of the image

  }
   IMGSEGSTRUCT;

typedef IMGSEGSTRUCT FARPTR16 PIMGSEGSTRUCT;

/*****************************************************************************/
/*                                                                           */
/*       The IMGCONTSTRUCT describes an area that represents the             */
/*       presentation space (NOT PM's presentation space) for a              */
/*       particular image object.  There is a one-to-one relationship        */
/*       between an image object and an image content.                       */
/*                                                                           */
/*****************************************************************************/

typedef struct _IMGCONTSTRUCT
  {
   USHORT       cbStruct;              // Structure byte length
   UCHAR        ucCoord;               // Origin reference for image content
                                       //   (can be IMG_AREA_ORIGIN or
                                       //   IMG_PAGE_ORIGIN)
   UOM          uomOrigin[2];          // Horz and vert unit of measure for
                                       //   rOrigin below
   RATIO        rOrigin[2];            // Horz and vert offsets from the
                                       //   origin indicated by ucCoord,
                                       //   expressed in uomOrigin units of
                                       //   measure
   USHORT       usExtent[2];           // Horz and vert extents of the image
                                       //   content area, expressed in pixels
                                       //   and limited to a range of
                                       //   1 to 32767
   USHORT       usOrient[2];           // Degrees of rotation from the X and
                                       //   Y axis of image content area
                                       //   in the image area
  }
   IMGCONTSTRUCT;

typedef IMGCONTSTRUCT FARPTR16 PIMGCONTSTRUCT;

/*****************************************************************************/
/*                                                                           */
/*       The IMGAREASTRUCT describes the page area within which image        */
/*       objects (and their corresponding image contents) can be presented.  */
/*                                                                           */
/*****************************************************************************/

typedef struct _IMGAREASTRUCT
  {
   USHORT       cbStruct;              // Structure byte length
   UCHAR        ucPosID;               // Area position identifier
   PG_MIO       MapImgObj;             // Controls mapping of the image object
   UOM          uomCoord[2];           // Horz and vert units of measure for
                                       //   rOrigin and rExtent (can be
                                       //   uom_inch or uom_centimeter)
   RATIO        rOrigin[2];            // Horz and vert offsets from page
                                       //   origin (in image area UOM)
   RATIO        rExtent[2];            // Horz and vert extents of image area
                                       //   (in image area UOM)
   USHORT       usOrient[2];           // Defines rotation of the image area
  }
   IMGAREASTRUCT;

typedef IMGAREASTRUCT FARPTR16 PIMGAREASTRUCT;


/*****************************************************************************/
/*                                                                           */
/*       The PAGEDEFSTRUCT contains values that describe the contents of a   */
/*       page to be created.                                                 */
/*                                                                           */
/*****************************************************************************/

typedef struct _PAGEDEFSTRUCT
  {
   USHORT       cbStruct;              // structure byte length
   PHIMAGE      phImage;               // pointer to image segment handle array
   USHORT       usImageSegCnt;         // number of elements in phImg
   PHPTEXT      phPText;               // pointer to presentation text segment
                                       //   handle array
   USHORT       usPTextSegCnt;         // number of elements in phPtx
   PHBUF        pAdjData;              // pointer to adjunct data buffer
   ULONG        ulAdjBytes;            // Adjunct Data byte count
  }
   PAGEDEFSTRUCT;

typedef PAGEDEFSTRUCT FARPTR16 PPAGEDEFSTRUCT;

/*****************************************************************************/
/*                                                                           */
/*      The PAGEINFSTRUCT describes the characteristics of a normal          */
/*      application form page, without considering the contents of the page. */
/*                                                                           */
/*****************************************************************************/

typedef struct _PAGEINFSTRUCT
  {
   USHORT       cbStruct;              // Number of bytes in this structure
   UOM          uomExtent[2];          // Horizontal and vert units of measure
                                       //   for rExtent
   RATIO        rExtent[2];            // Ratios that define the horizontal and
                                       //   vertical extents of the page based
                                       //   on the unit of measure
   CHAR         szName[9];             // Name of the page
   BOOL16       fJPEG;                 // TRUE if JPEG compressed image
  }
   PAGEINFSTRUCT;

typedef PAGEINFSTRUCT FARPTR16 PPAGEINFSTRUCT;

#endif


#if defined(IPS_DSP_INCL) || defined(IPS_CNF_INCL)

/*****************************************************************************/
/*                                                                           */
/*      The IAA_DISPLAY_TYPE describes the Image Adapter/A display models    */
/*                                                                           */
/*****************************************************************************/

typedef enum
  {
   display_NULL,                /* no IAA display model */
   display_8506,                /* 8506 - portrait      */
   display_8508                 /* 8508 - landscape     */
  }
  IAA_DISPLAY_TYPE;

/*****************************************************************************/
/*                                                                           */
/*      The DUALDSPATTRSTRUCT describes the characteristics of a second      */
/*      display in a dual display setup.                                     */
/*                                                                           */
/*****************************************************************************/

typedef struct _DUALDSPATTRSTRUCT
  {
   USHORT           cbStruct;       /* Number of bytes in this structure     */
   BITS             fDualDisplay;   /* Flag to represent an Image Adapter/A  */
                                    /* display used as a secondary display.  */
   USHORT           usBitsPerPel;   /* Number of bits/pel for initialization */
   USHORT           usWidth;        /* Image Adapter/A width in pixels       */
   USHORT           usHeight;       /* Image Adapter/A height in pixels      */
   IAA_DISPLAY_TYPE DisplayType;    /* Image Adapter/A display type - 8506,  */
                                    /* 8508, etc.                            */
  }
   DUALDSPATTRSTRUCT;

typedef DUALDSPATTRSTRUCT FARPTR16 PDUALDSPATTRSTRUCT;

#endif /* defined(IPS_DSP_INCL) || defined(IPS_CNF_INCL) */

#endif /* IPSDEF_DEFINED not true*/
