/*BEGINPROLOGUE***************************************************************
*
*   Header Name:             IPSCNF.H
*
*                            Configuration Services definitions.
*
*                            Required by every module that calls a CNF
*                            function.
*
*   Copyright:               5696-125 (5042) - (C) Copyright IBM Corp. 1991
*                            All Rights Reserved
*
*   Descriptive Name:        This include file contains all external function
*                            prototypes, typedefs, and data structures
*                            that are required for use of the CNF functions.
*
*   Status:                  Release 1, Level 0
*
*   Notes:
*
*     Dependencies:          The OS2.h and IPS.h include files must be brought
*                            in before this file, since this file uses typedefs
*                            defined in that file (or files that it, in turn,
*                            brings in).  "#define IPS_CNF_INCL" will
*                            bring in the appropriate CNF include file.
*
*     Restrictions:
*
*   Module Type:             Header file
*
*     Processor:             IBM C/2 version 1.1
*
*   Declarations:
*
*     Routines:              IpsQueryConfigSize
*                            IpsReadConfigString
*                            IpsReadConfigData
*                            IpsWriteConfigData
*                            IpsWriteConfigString
*                            IpsReturnVersionInfo
*
*     Structures:            VERSION, PVERSION
*
*ENDPROLOGUE*****************************************************************/

/****************************************************************************/
/*                                                                          */
/*    Ensure that this include file is not recursively called               */
/*                                                                          */
/****************************************************************************/

#ifndef IPSCNF_DEFINED
#define IPSCNF_DEFINED


/****************************************************************************/
/*                                                                          */
/*                              CNF Defines                                 */
/*                                                                          */
/****************************************************************************/

#define CNF_LOCAL               0x0010             // local machine
#define CNF_SERVER              0x0020             // server machine
#define CNF_IMAGE               0x0001             // Platform .INI file
#define CNF_SYSTEM              0x0002             // OS2SYS.INI file
#define CNF_OS2                 0x0004             // OS2.INI file

#define CNF_IPS_DFT_DIRECTORY   "C:\\"             // Default location of
                                                   // Platform .INI file

#define CNF_IPS_APP_NAME        "ImagePlus"
#define CNF_IPS_KEY_NAME        "Directory"
#define CNF_IPS_REMOTE_PATH     "REMOTE_PATH"
#define CNF_IPS_FILENAME        "FCABIPS.INI"
#define CNF_CNF_APP_NAME        "IP_CONFIGURATION"
#define CNF_CNF_SERVER          "GLOBAL_SERVER"
#define CNF_CNF_TEMP            "TEMP_PATH"
#define CNF_CNF_MACHINE         "MACHINE_TYPE"
#define CNF_CNF_MACH_NAME       "MACHINE_NAME"
#define CNF_CNF_INSTALL_STAT    "INIT_DATABASE"
#define CNF_CNF_INSTALLED       "Installed"
#define CNF_CNF_PUBS_PATH       "PUBS_PATH"
#define CNF_LCS_APP_NAME        "IP_COMMUNICATION"
#define CNF_LCS_RETRY           "RETRY"
#define CNF_LCS_INSIZE          "INBUFSIZE"
#define CNF_LCS_OUTSIZE         "OUTBUFSIZE"
#define CNF_LCS_TIMEOUT         "TIMEOUT"
#define CNF_LCS_SESSIONS        "MAXSESSIONS"
#define CNF_OAS_APP_NAME        "IP_OBJECT_ACCESS"
#define CNF_OAS_CC_INFO         "DCA"
#define CNF_OAS_CC_RETIRED      "DCA_RETIRED"
#define CNF_ERR_APP_NAME        "IP_ERROR_LOGGING"
#define CNF_ERR_MSGFILENAME     "MSGFILENAME"        // name of error msg DLL
#define CNF_ERR_MAXSIZE         "MaxFileSize"
#define CNF_ERR_OVLYINTVL       "OVLYINTVL"          // overlay interval
#define CNF_ERR_LOGOPTIONS      "LOGOPTIONS"
#define CNF_MNT_APP_NAME        "IP_MOUNTER"
#define CNF_MNT_DEVMGR          "DEVICE_MANAGER"
#define CNF_OMS_APP_NAME        "IP_OBJECT_MANAGER"
#define CNF_OMS_MIGRATE_TIMES   "MIGRATE_TIMES"
#define CNF_OMS_STAGING_AREAS   "STAGING_AREAS"
#define CNF_OMS_DATABASE_PATH   "DATABASE_PATH"
#define CNF_STG_APP_NAME        "IP_STAGING"
#define CNF_STG_STAGING_PATH    "STAGING_PATH"
#define CNF_STG_STAGING_SIZE    "STAGING_SIZE"
#define CNF_INS_APP_NAME        "IP_INSTALLATION"
#define CNF_SDS_CAP_APP_NAME    "IP_SPOOLER_CAPTURE"
#define CNF_SDS_FAX_APP_NAME    "IP_SPOOLER_FAX"
#define CNF_SDS_GAMMAFAX_APP_NAME "IP_FAX"
#define CNF_SDS_GAMMAFAX_DIR    "DIR"
#define CNF_GAMMAFAX_KEY_NAME   "GammaFax CP MC Fax card:1 "
#define CNF_IBMFAX_KEY_NAME     "IBMFAX"
#define CNF_SDS_PRT_APP_NAME    "IP_PRINTER"
#define CNF_CRT_MONITOR_KEY     "MONITOR"
#define CNF_CRT_RESOLUTION_KEY  "BITSPERPEL"
#define CNF_CRT_IAADISPLAY_KEY  "IAADISPLAY"

#define CNF_PARAMETERS          0
#define CNF_CAPDEVICE           1
#define CNF_FACSIMILE           2
#define CNF_PRINTER             3
#define CNF_DEVMGR              4
#define CNF_CONCLS              5
#define CNF_DUALCRT             6

/****************************************************************************/
/*                                                                          */
/*                        Potential Values for                              */
/*                CNF_CNF_APP_NAME + CNF_CNF_MACHINE                        */
/*              ("IP_CONFIGURATION" + "MACHINE_TYPE")                       */
/*                                                                          */
/****************************************************************************/
#define CNF_CNF_TYPE_SERVER      "SERVER"
#define CNF_CNF_TYPE_WORKSTATION "WORKSTATION"
#define CNF_CNF_TYPE_STANDALONE  "STANDALONE"
#define CNF_CNF_TYPE_NOVELLWS    "NOVELLWS" /* Extra Novell Support for IP/2 */
#define CNF_CNF_TYPE_NPSERVER    "NPSERVER"

#define NOV_WORKSTATION 0x0001
#define NOV_NOVELLWS    0x0010
#define NOV_NPSERVER    0x0100
#define NOV_SERVER      0x1000

/****************************************************************************/
/*                                                                          */
/*                            CNF global structures                         */
/*                                                                          */
/****************************************************************************/

/*****************************************************************************/
/*  These typedefs are conditionally compiled so internal IP/2 routines will */
/*  not get a duplicate definition error in compilation for VERSION and      */
/*  PVERSION typedefs.  VERSION and PVERSION are structures defined for the  */
/*  Utility routine IpsReturnVersionInfo.  VERSION and PVERSION              */
/*  are also typedefs for a function prototype in the image enabler package  */
/*  used by IP/2.  If you want to use the image enabler package in a module, */
/*  IPS_EXCLUDE_COMMON_DATA will suppress the typedefs for VERSION and       */
/*  PVERSION and the function prototype for IpsReturnVersionInfo in IPSCNF.H */
/*  from your compilation.  If you are not using the image enabler package,  */
/*  then you will get all the typedefs from IPSCNF.H, including VERSION,     */
/*  PVERSION, and the prototype for IpsReturnVersionInfo.                    */
/*  IPS_EXCLUDE_COMMON_DATA is conditionally defined in IPS.H depending      */
/*  on whether or not you have defines which will cause the inclusion        */
/*  of the image enabler package header files.  See IPS.H for details.       */
/*****************************************************************************/
#ifndef IPS_EXCLUDE_COMMON_DATA
typedef struct {
  char szName[64];
  char szRelease[4];
  char szVersion[4];
  char szModel[4];
  char szCopyright[96];
} VERSION;

typedef VERSION FARPTR16 PVERSION;

#endif /* ifndef IPS_EXCLUDE_COMMON_DATA */


/****************************************************************************/
/*                                                                          */
/*                         CNF Function prototypes                          */
/*                                                                          */
/****************************************************************************/

extern SHORT EXPENTRY16 IpsQueryConfigSize(
                        BITS       fLoc,
                        PSZ16      pszAppName,
                        PSZ16      pszKeyName,
                        BITS       fOptions,
                        HWND       hHandle,
                        USHORT     usMsgId,
                        PRCSTRUCT  pRC );

extern SHORT EXPENTRY16 IpsReadConfigString(
                        BITS       fLoc,
                        PSZ16      pszAppName,
                        PSZ16      pszKeyName,
                        PSZ16      pszDefault,
                        PBUF       pValue,
                        ULONG      ulSize,
                        BITS       fOptions,
                        HWND       hHandle,
                        USHORT     usMsgId,
                        PRCSTRUCT  pRC );

extern SHORT EXPENTRY16 IpsReadConfigData(
                        BITS       fLoc,
                        PSZ16      pszAppName,
                        PSZ16      pszKeyName,
                        PBUF       pValue,
                        ULONG      ulSize,
                        BITS       fOptions,
                        HWND       hHandle,
                        USHORT     usMsgId,
                        PRCSTRUCT  pRC );

extern SHORT EXPENTRY16 IpsWriteConfigData(
                        BITS       fLoc,
                        PSZ16      pszAppName,
                        PSZ16      pszKeyName,
                        PBUF       pValue,
                        ULONG      ulSize,
                        BITS       fOptions,
                        HWND       hHandle,
                        USHORT     usMsgId,
                        PRCSTRUCT  pRC );

extern SHORT EXPENTRY16 IpsWriteConfigString(
                        BITS       fLoc,
                        PSZ16      pszAppName,
                        PSZ16      pszKeyName,
                        PSZ16      pValue,
                        BITS       fOptions,
                        HWND       hHandle,
                        USHORT     usMsgId,
                        PRCSTRUCT  pRC );

/*****************************************************************************/
/*  See the comments for VERSION and PVERSION above.                         */
/*****************************************************************************/
#ifndef IPS_EXCLUDE_COMMON_DATA
extern SHORT EXPENTRY16 IpsReturnVersionInfo( PVERSION  pVersion );
#endif /* ifndef IPS_EXCLUDE_COMMON_DATA */

#endif /* #ifndef IPSCNF_DEFINED */
