/*BEGINPROLOGUE***************************************************************
*
*   Header Name:           IPSCCX.H
*
*                          Included by routines requiring access to
*                          content class function prototypes.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991
*                          All Rights Reserved
*
*   Descriptive Name:      This include file contains the Content Class
*                          function prototypes.
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        IPS.h  - It is assumed that this file is included
*                                   by IPS.h.  The module requiring this must
*                                   #define IPS_CCX_INCL
*                                   #define IPS_OAS_INCL
*                                   #define IPS_OMS_INCL
*                                      prior to
*                                   #include <IPS.h>
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Declarations:
*
*     Routines:
*                          ccCreateClassObject
*                          ccCatalogClassObject
*                          ccDeleteClassObject
*                          ccUncatalogClassObject
*                          ccGetObjectPage
*                          ccPutObjectPage
*                          ccDeleteObjectPage
*                          ccOpenClassObject
*                          ccReopenClassObject
*                          ccCloseClassObject
*
*     Structures:
*
*   Include files:
*
*ENDPROLOGUE*****************************************************************/

//-----------------------------------------------------------------------------
//
//   Ensure that this file is not called recursively
//
//-----------------------------------------------------------------------------
#ifndef IPSCCX_DEFINED
#define IPSCCX_DEFINED

//-----------------------------------------------------------------------------
//
//                  Object Content Class function prototypes
//
//-----------------------------------------------------------------------------
SHORT EXPENTRY16 ccCreateClassObject(    UCHAR, PSZ16, ULONG, UCHAR,
                                         USHORT, PSZ16, UCHAR, HSEM,
                                         BOOL16, PRCSTRUCT );

SHORT EXPENTRY16 ccCatalogClassObject(   UCHAR, PSZ16, ULONG, USHORT,
                                         PSZ16, PSZ16, BOOL16, UCHAR,
                                         HSEM, BOOL16,
                                         PULONG16,PRCSTRUCT );

SHORT EXPENTRY16 ccDeleteClassObject(    HOBJ, PRCSTRUCT );

SHORT EXPENTRY16 ccUncatalogClassObject( HOBJ, PSZ16, PULONG16, HSEM,
                                         PRCSTRUCT );

SHORT EXPENTRY16 ccGetObjectPage(        HOBJACC, ULONG, PRCSTRUCT );

SHORT EXPENTRY16 ccPutObjectPage(        HOBJACC, ULONG, BOOL16, HPAGE,
                                         PRCSTRUCT );

SHORT EXPENTRY16 ccDeleteObjectPage (    HOBJACC, ULONG, ULONG,
                                         PRCSTRUCT );

SHORT EXPENTRY16 ccOpenClassObject(      HOBJ, UCHAR, UCHAR, BOOL16,
                                         BOOL16, HSEM, PRCSTRUCT );

SHORT EXPENTRY16 ccReopenClassObject(    HOBJACC, UCHAR, BOOL16, BOOL16,
                                         PRCSTRUCT );

SHORT EXPENTRY16 ccCloseClassObject(     HOBJACC, BOOL16, PRCSTRUCT );

#endif
