/*BEGINPROLOGUE****************************************************************
*
*   Header Name:           IPSCAP.H
*
*                          Included by every application using the
*                          Capture Device Service portion.
*
*   Copyright:             5696-125 (5042) - (C) Copyright IBM Corp. 1991
*                          All Rights Reserved
*
*   Descriptive Name:      This include file contains all of the defines
*                          and data structures required by Capture Device
*                          Services.
*
*   Status:                Release 1, Level 0
*
*   Notes:
*
*     Dependencies:        This file must be included AFTER OS2.h.
*
*     Restrictions:
*
*   Module Type:           Header file
*
*     Processor:           IBM C/2 version 1.1
*
*   Include files:         This file is included by IPS.h if IPS_CAP_INCL
*                          has been defined in the source.
*
*ENDPROLOGUE*****************************************************************/

//-----------------------------------------------------------------------------
//
//   Insure that this include file will not be called recursively
//
//-----------------------------------------------------------------------------

#ifndef IPSCAP_DEFINED
#define IPSCAP_DEFINED

typedef struct _DEV_RESOLUTION
{
  RATIO rResolution[2]; /* in pixels/uom */
  UOM   uom;
} DEV_RESOLUTION;

typedef DEV_RESOLUTION FARPTR16 PDEV_RESOLUTION;

typedef struct _IMAGE_AREA
{
  USHORT usOrigins[2], /* capture area origins (in pels) (RIDIC) */
         usExtents[2]; /* capture area extents (in pels) (RIDIC) */
} IMAGE_AREA;

typedef IMAGE_AREA FARPTR16 PIMAGE_AREA;

//----------------------
// Scan Query Info parms
//----------------------

#define SCPARM_SIZE           0      // Get size of scan parameters area
#define SCPARM_DEVNAMESIZE    1      // Get size of Device Names buffer.
#define SCPARM_CAPS           2      // Get scanner capabilities.
#define SCPARM_SCNHEADSIZE    3      // Get maximum possible size
                                     // of SCAN_HEADER

//----------------------
// Define SCPARM options
//----------------------

#define SCPARM_CAP_PATCH_CODE_SUPPORT   0x0001  // Patch Code Support
#define SCPARM_CAP_BAR_CODE_SUPPORT     0x0002  // Bar Code Support
#define SCPARM_CAP_OCR_SUPPORT          0x0004  // OCR Support
#define SCPARM_CAP_SINGLE_FEED          0x0008  // Single Feed (ie Flat Bed)
#define SCPARM_CAP_CONTINUOUS_FEED      0x0010  // Continuous Feed (Sheet
                                                // feed or ADF).

//------------------------
// Scan Header Definitions
//------------------------

typedef  struct _SCAN_HEADER
{
  USHORT            cbStruct;         //Length of the complete structure.
  USHORT            usDataField;      //Offset of data field from beginning of
                                      //this structure.  MUST be set to NULL if
                                      //no data fields exist.
  USHORT            usResvd1;         //Reserved.  Must be set to NULL.
  USHORT            usResvd2;         //Reserved.  Must be set to NULL.
  USHORT            usResvd3;         //Reserved.  Must be set to NULL.
  DEV_RESOLUTION    rScanRes;         //Scanner Resolution (pixels/uom)
  USHORT            usNumLines;       //Image Height in pels.
  USHORT            usBytesPerLine;   //# of bytes/captured line  set by the device
  USHORT            usBitsPerPel;     //# of bits per pel.
  USHORT            usCompression;    //Compression format

// Batch or High Speed Scanner Parameters

  UCHAR             ucSide;           //0 = Front, 1 = Rear
  ULONG             ulSequenceNumber; //Sequential Page number
  UCHAR             ucLevel;          //Level (1-3)
                                      // 3 - Start of new batch
                                      // 2 - Start of new document
                                      // 1 - New Page

} SCAN_HEADER;

typedef SCAN_HEADER FARPTR16 PSCAN_HEADER;

//------------------------------------------------------------------
// NOTE: All scanner package return codes are #define'd in IPSERR.H.
//------------------------------------------------------------------

//---------------------
// Prototype statements
//---------------------

MRESULT EXPENTRY16 ScanArea      ( ULONG        hScanHdl,
                                 SCAN_HEADER    (FARPTR16 FARPTR16 ppScnHeader),
                                 PHUCHAR        pucData,
                                 PULONG16       pulDataLen);

MRESULT EXPENTRY16 ScanAreaEject ( ULONG        hScanHdl,
                                 SCAN_HEADER    (FARPTR16 FARPTR16 ppScnHeader),
                                 PHUCHAR        pucData,
                                 PULONG16       pulDataLen);

MRESULT EXPENTRY16 ScanClose     ( ULONG          hScanHdl);

MRESULT EXPENTRY16 ScanEndPage   ( ULONG          hScanHdl);

MRESULT EXPENTRY16 ScanFlush     ( ULONG          hScanHdl);

MRESULT EXPENTRY16 ScanFree      ( VOID );

MRESULT EXPENTRY16 ScanGetData   ( ULONG        hScanHdl,
                                 PHUCHAR        pucData,
                                 PULONG16       pulDataLen,
                                 SCAN_HEADER FARPTR16 pScnHeader);

MRESULT EXPENTRY16 ScanInit      ( VOID );

MRESULT EXPENTRY16 ScanLastError ( PSZ16        pszBuffer,
                                 USHORT         usBufLen);

MRESULT EXPENTRY16 ScanOpen      ( PSZ16        pszDevName,
                                 LONG           lTimeout,
                                 PULONG16       pScanHdl);

MRESULT EXPENTRY16 ScanParmsDlg  ( PSZ16        pszDevName,
                                 PSCAN_PARM     pScanParm );

MRESULT EXPENTRY16 ScanPause     ( ULONG          hScanHdl);

MRESULT EXPENTRY16 ScanQueryCLT  ( PSCAN_PARM     pScanParm,
                                 RGB            FARPTR16 pRGB);

MRESULT EXPENTRY16 ScanQueryDevNames ( PSZ16    pDevNames,
                                 USHORT         usLength);

MRESULT EXPENTRY16 ScanQueryInfo ( PSZ16        pszDevName,
                                 USHORT         usParm,
                                 PVOID16        pParm);

MRESULT EXPENTRY16 ScanQueryParm ( PSCAN_PARM     pScanParm,
                                 USHORT         usParm,
                                 PVOID16        pParm);

MRESULT EXPENTRY16 ScanReset     ( ULONG          hScanHdl);

MRESULT EXPENTRY16 ScanRestart   ( ULONG          hScanHdl,
                                 LONG           lSeqNumber);

MRESULT EXPENTRY16 ScanSetParm   ( PSZ16        pszDevName,
                                 PSCAN_PARM     pScanParm,
                                 USHORT         usParm,
                                 PVOID16        pParm);

MRESULT EXPENTRY16 ScanSetState  ( ULONG          hScanHdl,
                                 PSCAN_PARM     pScanParm);

MRESULT EXPENTRY16 ScanSetSeqNum ( ULONG          hScanHdl,
                                 LONG           lSeqNumber);

#endif
