/*BEGINPROLOGUE***************************************************************
*
*   Header Name:             IPS.H
*
*                            Included by every application using the Platform.
*                            Included by every Platform Module.
*
*   Copyright:               5696-125 (5042) - (C) Copyright IBM Corp. 1991,1992
*                            All Rights Reserved
*
*   Descriptive Name:        This include file contains the external view
*                            of the Platform.
*
*   Status:                  Release 1, Level 0
*
*   Notes:
*
*     Dependencies:          This file should be included after OS2.h
*                            The following values, if defined, will bring
*                            in optional include files:
*                             IPS_PAG_INCL     Page Services
*                             IPS_DSP_INCL     Display Services
*                             IPS_IMG_INCL     Image Services
*                             IPS_LCS_INCL     LAN Communication Services
*                             IPS_CNF_INCL     Configuration Services
*                             IPS_OAS_INCL     Object Access Services
*                             IPS_CCX_INCL     Content Class Services
*                             IPS_SDS_INCL     Spooled Device Services
*                             IPS_OMS_INCL     Object Management Services
*                             IPS_DM_INCL      Device Manager Services
*                             IPS_CAP_INCL     Capture Device Services
*                             IPS_ALL_INCL     All Previous Services
*     Restrictions:
*
*   Module Type:             Header file
*
*     Processor:             IBM C/2 version 1.1
*
*   Declarations:
*
*     Routines:
*
*     Structures:
*
*   Include files:           This include file always includes:
*                             IPSDEF.h
*                             IPSERR.h
*                             IPSUTL.h
*
*                            Based upon previously defined values (see the
*                            dependencies listed above), this include file
*                            may include:
*                             IPSPAG.h
*                             IPSDSP.h
*                             IPSIMG.h
*                             IPSLCS.h
*                             IPSCNF.h
*                             IPSOAS.h
*                             IPSCCX.h
*                             IPSSDS.h
*                             IPSOMS.h
*                             IPSDM.h
*                             IPSCAP.h
*
*ENDPROLOGUE*****************************************************************/

/****************************************************************************/
/*  We are now allowing for C++ compilations.                               */
/****************************************************************************/

#ifdef __cplusplus
   extern "C" {
#endif

/****************************************************************************/
/*  Ensure that this include file is not recursively included               */
/****************************************************************************/
#ifndef IPS_DEFINED
#define IPS_DEFINED

/****************************************************************************/
/*  This version of the headers are 32-bit enabled.  Here are the #defines  */
/*  that determine whether we are compiling for 32-bit or 16-bit.           */
/****************************************************************************/

#ifdef __IBMC__  /* then we are 32-bit */

#define FARPTR16        * _Seg16
#define HUGEPTR16       * _Seg16
#define EXPENTRY16         APIENTRY16
#define PID16              USHORT
typedef unsigned char   * _Seg16 PSZ16;
typedef unsigned short  * _Seg16 PUSHORT16;
typedef unsigned long   * _Seg16 PULONG16;
typedef RECTL           * _Seg16 PRECTL16;
typedef SIZEL           * _Seg16 PSIZEL16;

/* If compiled with the migration option /Sm, huge will be defined.  If     */
/* not, then we define it.                                                  */

#ifndef huge
#define huge
#endif

#endif /* __IBMC__ defined */

#ifndef __IBMC__  /* then we are 16-bit */

/* The following are from the 32-bit OS2DEF.H */
#define BOOL16       BOOL
#define PBOOL16      PBOOL
#define PCHAR16      PCHAR
#define PUCHAR16     PUCHAR
#define PVOID16      PVOID
#define MAKE16P      MAKEP
#define APIENTRY16   APIENTRY

/* The following we've defined ourselves */
#define FARPTR16     FAR *
#define HUGEPTR16    huge *
#define EXPENTRY16   EXPENTRY
#define PSZ16        PSZ
#define PUSHORT16    PUSHORT
#define PULONG16     PULONG
#define PSIZEL16     PSIZEL
#define PRECTL16     PRECTL
#define PID16        PID

#endif /* __IBMC__ not defined */

/*****************************************************************************/
/*  If IPS_ALL_INCL is defined, define all applicable values                 */
/*****************************************************************************/
#ifdef IPS_ALL_INCL

#ifndef IPS_PAG_INCL     /* Page Services */
#define IPS_PAG_INCL
#endif

#ifndef IPS_DSP_INCL     /* Display Services */
#define IPS_DSP_INCL
#endif

#ifndef IPS_IMG_INCL     /* Image Services */
#define IPS_IMG_INCL
#endif

#ifndef IPS_LCS_INCL     /* LAN Communication Services */
#define IPS_LCS_INCL
#endif

#ifndef IPS_CNF_INCL     /* Configuration Services */
#define IPS_CNF_INCL
#endif

#ifndef IPS_OAS_INCL     /* Object Access Services */
#define IPS_OAS_INCL
#endif

#ifndef IPS_CCX_INCL     /* Content Class Services */
#define IPS_CCX_INCL
#endif

#ifndef IPS_SDS_INCL     /* Spooled Device Services */
#define IPS_SDS_INCL
#endif

#ifndef IPS_OMS_INCL     /* Object Management Services */
#define IPS_OMS_INCL
#endif

#ifndef IPS_DM_INCL      /* Device Manager Services */
#define IPS_DM_INCL
#endif

#ifndef IPS_CAP_INCL      /* Capture Device Services */
#define IPS_CAP_INCL
#endif

#endif /* ifdef IPS_ALL_INCL */

/*****************************************************************************/
/*  conditionally bring in the common image dependent structures             */
/*****************************************************************************/

#if defined(IPS_OAS_INCL) || defined(IPS_IMG_INCL) || \
    defined(IPS_DSP_INCL) || defined(IPS_PAG_INCL) || \
    defined(IPS_SDS_INCL)

#include <IPSI2DEF.H>

#endif
/*****************************************************************************/
/*  bring in the common data types and data structures                       */
/*****************************************************************************/

#include <IPSDEF.h>


/*****************************************************************************/
/*  bring in the error codes                                                 */
/*****************************************************************************/
#include <IPSERR.h>


/*****************************************************************************/
/*  bring in the defines, data types, and function prototypes for each       */
/*  service group                                                            */
/*****************************************************************************/

/*****************************************************************************/
/*  Page Services                                                            */
/*****************************************************************************/
#ifdef IPS_PAG_INCL
#include <IPSPAG.h>
#endif

/*****************************************************************************/
/*  Display Services                                                         */
/*****************************************************************************/
#ifdef IPS_DSP_INCL
#include <IPSDSP.h>
#endif

/*****************************************************************************/
/*  Image Services                                                           */
/*****************************************************************************/
#ifdef IPS_IMG_INCL
#include <IPSIMG.h>
#endif

/*****************************************************************************/
/*  LAN Communication Services                                               */
/*****************************************************************************/
#ifdef IPS_LCS_INCL
#include <IPSLCS.h>
#endif

/*****************************************************************************/
/*  These conditional defines are needed so that internal IP/2 routines will */
/*  not get a duplicate definition error in compilation for VERSION and      */
/*  PVERSION typedefs.  VERSION and PVERSION are structures defined for the  */
/*  Utility routine IpsReturnVersionInfo in IPSCNF.H.  VERSION and PVERSION  */
/*  are also typedefs for a function prototype in the image enabler package  */
/*  used by IP/2.  If you want to use the image enabler package in a module, */
/*  IPS_EXCLUDE_COMMON_DATA will suppress the typedefs for VERSION and       */
/*  PVERSION and the function prototype for IpsReturnVersionInfo in IPSCNF.H */
/*  from your compilation.  If you are not using the image enabler package,  */
/*  then you will get all the typedefs from IPSCNF.H, including VERSION,     */
/*  PVERSION, and the prototype for IpsReturnVersionInfo.                    */
/*****************************************************************************/
/*****************************************************************************/
/* <<<<<<<<<<<<<<<<<<<<<<<<<<< NOTE >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */
/* <   This list of defines comes from IPX.H.  Any internal IP/2 program   > */
/* <   which includes IPX.H and contains one of these defines has a        > */
/* <   potential to have duplicate definition compilation errors with      > */
/* <   IPSCNF.H because these defines will cause IPX.H to include          > */
/* <   IPXLNX.H.  Therefore, if any new defines are added to IPX.H which   > */
/* <   cause IPXLNX.H to be included, this #if statement MUST be updated   > */
/* <   to reflect that change also.                                        > */
/* <<<<<<<<<<<<<<<<<<<<<<<<<<< NOTE >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */
/*****************************************************************************/
#if defined(IPS_LIMG_INCL) || defined(IPS_LENV_INCL) || \
    defined(IPS_LDSP_INCL) || defined(IPS_LPTX_INCL) || \
    defined(IPS_LDS_INCL)  || defined(IPS_LPG_INCL) || \
    defined(IPS_LIAA_INCL) || defined(IPS_LPRT_INCL)
#ifndef IPS_EXCLUDE_COMMON_DATA
#define IPS_EXCLUDE_COMMON_DATA
#endif /* ifndef IPS_EXCLUDE_COMMON_DATA */
#endif /* if including the image enabler header files from IPX.H */

/*****************************************************************************/
/*  Platform Configuration Services                                          */
/*****************************************************************************/
#ifdef IPS_CNF_INCL
#include <IPSCNF.h>
#endif

/*****************************************************************************/
/*  Object Management Services                                               */
/*****************************************************************************/
#ifdef IPS_OMS_INCL
#include <IPSOMS.h>
#endif

/*****************************************************************************/
/*  Object Access Services                                                   */
/*****************************************************************************/
#ifdef IPS_OAS_INCL
#include <IPSOAS.h>
#endif

/*****************************************************************************/
/*  Content Class Services                                                   */
/*****************************************************************************/
#ifdef IPS_CCX_INCL
#include <IPSCCX.h>
#endif

/*****************************************************************************/
/*  Spooled Device Services                                                  */
/*****************************************************************************/
#ifdef IPS_SDS_INCL
#include <IPSSDS.h>
#endif

/*****************************************************************************/
/*  Device Manager Services                                                  */
/*****************************************************************************/
#ifdef IPS_DM_INCL
#include <IPSDM.h>
#endif

/*****************************************************************************/
/*  Capture Device Services                                                  */
/*****************************************************************************/
#ifdef IPS_CAP_INCL
#include <IPSCAP.h>
#endif

/*****************************************************************************/
/*  Utility routines                                                         */
/*****************************************************************************/
#include <IPSUTL.h>

#endif /* if IPS_DEFINED */

/*****************************************************************************/
/* We need to close out the C++ enablement.                                  */
/*****************************************************************************/
#ifdef __cplusplus
   }
#endif
