/*<<TITLE User Exit definitions>>*/
/*
**********************************************************************

FCAEUSRX.h of KDMS - User Exit definitions

**********************************************************************

5696-125 - (C) Copyright Eastman Kodak Co. 1991, 1992.  All Rights Reserved

**********************************************************************


*/

/****************************************************************************/
/*  We are now allowing for C++ compilations.                               */
/****************************************************************************/

#ifdef __cplusplus
   extern "C" {
#endif


/*
** This structure is passed to all user exits that require index
** field information:
**
**    Save Record
**    Determine Storage Group
**    Determine Next Work Basket
**    Overload Trigger
**
** Note that the following elements will be NULL if the user exit
** is called from the Library Object Manager (when no Index Form
** has been opened):
**
**    sFields
**    pFields
**
*/

#define UX_PRIV_READ       1  /* User has read-only privileges           */
#define UX_PRIV_WRITE      2  /* User has read/write privileges          */

/*
** These are used in the Determine Next Workbasket user exit
*/
#define UX_SAVE_ITEM       1  /* Called during a save operation          */
#define UX_ROUTE           2  /* Called during a route to operation      */
#define UX_START_WORKFLOW  3  /* Called during a start workflow          */
#define UX_CHANGE_WORKFLOW 4  /* Called during a change workflow         */

#ifndef FT_AN
#define FT_AN           0   /* Alpha-numeric                             */
#define FT_ALPHA        1
#define FT_INTEGER      2   /* Numeric, decimal point not allowed        */
#define FT_REAL         3   /* Numeric, decimal point allowed            */
#define FT_DIGITS       4   /* A string consisting of all num chars      */
#define FT_DATE         5
#define FT_TIME         6
#define FT_OTHER        7
#define FT_AN_EXT       8
#define FT_USER         100 /* 100+ are user-defined field types         */
#endif

typedef struct _FIELDVALUE
   {
   ATID        usFieldId;     /* Oim user defined attribute (field) id   */
   USHORT      usDataType;    /* Form manager data type of attribute id  */
   USHORT      usMaxLength;   /* Maximum number of bytes for field       */
   BOOL16      fIsReq;        /* TRUE if field is required               */
   PSZ16       pBuffer;       /* Current value of the field in display   */
                              /* format (ASCIIZ).  The buffer size is    */
                              /* usMaxLength + 1.                        */
   }
               FIELDVALUE;

typedef FIELDVALUE FARPTR16 PFIELDVALUE;

typedef struct _USEREXITSTRUCT
   {
   UID         uidItem;       /* Uid of currently opened item            */
   USHORT      usWorkflowId;  /* Workflow ID of currently opened item    */
   BOOL16      fIsUnindexed;  /* TRUE if original item was unindexed     */
   CLASSID     hOrigClass;    /* Original class id of the item           */
   CLASSID     hClass;        /* Current class id of the item            */
   CHAR        szUserId[USERID_LENGTH + 1];
                              /* User id of user accessing item          */
   USHORT      usUserHandle;  /* User handle of user accessing item      */
   USHORT      usAccessLevel; /* UX_PRIV_READ or UX_PRIV_WRITE           */
   SHORT       sFields;       /* Number of fields in pFields             */
   FIELDVALUE FARPTR16 pFields; /* Array of index field values & info.     */
   }
               USEREXITSTRUCT;


/*
** Query Sort
*/

#define  SF_HIDE  0x0001

typedef struct _ATINFO
   {
   ATID        atid;
   PATTRINFOSTRUCT pai;
   }
               ATINFO;

typedef ATINFO FARPTR16 PATINFO;

typedef struct _ATLIST
   {
   USHORT      usClass;       /* Oim Class of this item                  */
   USHORT      usCount;       /* # of attributes in patinfo list         */
   PATINFO     patinfo;       /* List of Oim attributes                  */
   USHORT      usUserCount;   /* # of attributes in patid list           */
   ATID FARPTR16 patidUserList; /* List of user attributes                 */
   }
               ATLIST;

typedef ATLIST FARPTR16 PATLIST;

typedef struct _USERSORTSTRUCT
   {
   USHORT      usType;        /* OIM_FOLDER or OIM_DOCUMENT              */
   USHORT      usClass;       /* Oim Class of this item                  */
   UID         uid;           /* Oim UID of this item                    */
   USHORT      usPriority;    /* Priority of this item                   */
   PCHAR16 FARPTR16 pszVals;       /* Array of values for this item      */
   PCHAR16 FARPTR16 pszWbVals;     /* Workbasket-view values for item    */
   PATLIST     pAttrList;     /* Attribute list for this item            */
   BOOL16      fCheckedOut;   /* TRUE if item is checked out             */
   USHORT      usFlags;       /* Sort flags: SF_HIDE = don't display item*/
   CHAR        reserved[6];   /* Reserved for system use                 */
   }
               USERSORTSTRUCT;

typedef USERSORTSTRUCT FARPTR16 PUSERSORTSTRUCT;

/*****************************************************************************/
/* We need to close out the C++ enablement.                                  */
/*****************************************************************************/
#ifdef __cplusplus
   }
#endif
