/*<<TITLE FCAEOIM.H of OIM - header file for OIM user applications>>*/
/*
***************************************************************************

FCAEOIM.H of OIM - Include file for OIM user applications

***************************************************************************

5696-125 - (C) Copyright Eastman Kodak Company 1991, 1992.  All Rights Reserved

***************************************************************************

IMPORTANT

It is assumed that IPS.H has been included before this file.  This file
is needed for the definitions of HOBJ, PHOBJ, BITS, and other platform
data types.

***************************************************************************
*/
/*<<PAGE>>*/

/****************************************************************************/
/*  We are now allowing for C++ compilations.                               */
/****************************************************************************/

#ifdef __cplusplus
   extern "C" {
#endif

/*
** general defines for all OIM routines
*/
#ifndef SUCCESS
#define SUCCESS                  0
#endif

#define FAILURE                  1
#define TRUE                     1
#define FALSE                    0
#define OIM_NOT_FOUND            2

#define NULL_ANGORA_HANDLE       0L

#define OIM_CHECKOUT             0
#define OIM_READ                 2
#define OIM_WRITE                4

#define OIM_SAVE                 0
#define OIM_DISCARD              1

/*
** Lengths of various fields related to various OIM database structures
*/
#define OWNER_NAME_LENGTH        20
#define WB_NAME_LENGTH           20
#define WF_NAME_LENGTH           20
#define DB_NAME_LENGTH           8
#define APPLICATION_NAME_LENGTH   8

/*
** Workstation id maximum length
*/
#define WSID_LENGTH                    8

/*
** miscellaneous defines for OIM data types
*/
#define UID_LENGTH                     16
#define USERID_LENGTH                  8
#define CLASS_NAME_LENGTH              20
#define ATTR_NAME_LENGTH               20
#define OIM_MAX_SEARCH_STRING_LEN      30000
#define OIM_MAX_ATTR_LENGTH            3984
#define OIM_MAX_AWAITED_CLASSES        8

/*
** defines for the OIM data type for attributes
*/
#define OIM_STRING                     1
#define OIM_LONG                       2
#define OIM_SHORT                      3
#define OIM_FLOAT                      4
#define OIM_DATE                       5
#define OIM_TIME                       6

#define OIM_FOLDER                     1
#define OIM_DOCUMENT                   2
#define OIM_WORKBASKET                 3

#define OIM_ALL                        0
#define OIM_FOLDERS_ONLY               1
#define OIM_WORK_BASKETS_ONLY          2

/*
** defines for the WIP statuses
*/
#define OIM_NOT_WIP_ACTIVE             0
#define OIM_WIP_ACTIVE                 1
#define OIM_WIP_CANCELLED              2
#define OIM_WIP_COMPLETED              3

/*
** defines for modify the workbasket
*/
#define OIM_WB_CHANGE_NAME             1
#define OIM_WB_CHANGE_LIMIT            2

/*
** defines for modify the index class and attribute APIs
*/
#define OIM_CLASS_CHANGE_NAME          0x0001
#define OIM_CLASS_CHANGE_ATTRS         0x0002
#define OIM_ATTR_CHANGE_NAME           0x0001
#define OIM_ATTR_CHANGE_TYPE           0x0002


/*
** defines for search filters
*/
#define OIM_ITEMS_NOT_IN_WORKFLOW      0x0002
#define OIM_CURRENT_WORKFLOW_ITEMS     0x0004
#define OIM_COMPLETED_WORKFLOW_ITEMS   0x0008
#define OIM_CANCELLED_WORKFLOW_ITEMS   0x0010

#define OIM_ITEMS_NOT_SUSPENDED        0x0002
#define OIM_ITEMS_SUSPENDED            0x0004

/*
** defines for wildcards used in search
*/
#define OIM_MULTI_WILDCARD           '%'
#define OIM_SINGLE_WILDCARD          '_'

/*
** masks used by a user to set the cross reference (Xref) filter bits;
** any combination of these can be ANDed together in forming the Xref
** filter when calling the OIMGetXref API function
*/
#define  OIM_XREF_ALL_FILTER           0x8000
#define  OIM_XREF_FOLDERS_ONLY_FILTER  0x0001
#define  OIM_XREF_WB_ONLY_FILTER       0x0002

/*
** workflow defines for the workflow info struct
*/
#define OIM_WF_SAVE_HISTORY            1
#define OIM_WF_DISCARD_HISTORY         2

/*
** the following defines the max numbers for workflow ids, overload,
** class attributes, attribute ids
*/
#define OIM_MAX_OVERLOAD_LIMIT         32000
#define OIM_MAX_WORKFLOW_ID            32000
#define OIM_MIN_PRIORITY              -32000
#define OIM_MAX_PRIORITY               32000
#define OIM_MAX_CLASS_ID               32000
#define OIM_MAX_ATTR_ID                32000


/*
** The following flags are ORed together to indicate what to change
** when calling the modify workflow function
*/
#define OIM_WF_CHANGE_NAME             0x0001
#define OIM_WF_CHANGE_DISPOSITION      0x0002
#define OIM_WF_CHANGE_GROUP            0x0004
#define OIM_WF_CHANGE_WBS              0x0008
#define OIM_WF_CHANGE_INVALID          0xFFF0


/*
** system defined attribute ids
*/
#define OIM_SYS_ID_LOW                 0
#define OIM_SYS_ID_HIGH                50
#define OIM_SYS_ID_MAX                 52

#define OIM_ID_UID                     0
#define OIM_ID_SUPER_CLASS             1
#define OIM_ID_CLASS                   2
#define OIM_ID_ATTR_MOD_TIME           3
#define OIM_ID_ATTR_MOD_DATE           4
#define OIM_ID_WORKFLOW                5
#define OIM_ID_RELEASE_TYPE            6
#define OIM_ID_EXPIRE_TIME             7
#define OIM_ID_EXPIRE_DATE             8
#define OIM_ID_DEADLINE_UID            9
#define OIM_ID_READY_UID               10
#define OIM_ID_CHECKOUT                11
#define OIM_ID_WIP_MOD_TIME            12
#define OIM_ID_WIP_MOD_DATE            13
#define OIM_ID_WIP_STATUS              14
#define OIM_ID_HISTORY_LOG             15
#define OIM_ID_ADD_REM_TIME            16
#define OIM_ID_ADD_REM_DATE            17
#define OIM_ID_SYS_MOD_TIME            18
#define OIM_ID_SYS_MOD_DATE            19
#define OIM_ID_ITEM_CREATE_TIME        20
#define OIM_ID_ITEM_CREATE_DATE        21

#define OIM_HIMAGE_ID                  51
#define OIM_HNOTE_ID                   52

#define OIM_COMMIT                     1
#define OIM_ROLLBACK                   0

#define OIM_WAIT                       5
#define OIM_DONT_WAIT_STAGE_IT         4
#define OIM_ITEM_STAGED                2
#define OIM_WAIT_WITH_ABORT_SEM        3

/*
** defines for the undefined system attributes
*/
#define OIM_UNDEFN_CLASS               0
#define OIM_UNDEFN_HANDLE              0L
#define OIM_UNDEFN_TIME                0
#define OIM_UNDEFN_DATE                0
#define OIM_UNDEFN_WF                  0
#define OIM_UNDEFN_WIP_STATUS          0
#define OIM_UNDEFN_RELEASE_TYPE        0
#define OIM_UNDEFN_UID                 '0'
#define OIM_UNDEFN_USER_ID             '0'
#define OIM_UNDEFN_OWNER_NAME          '0'
#define OIM_UNDEFN_CLASS_NAME          '0'
#define OIM_UNDEFN_ATTR_NAME           '0'
#define OIM_UNDEFN_WF_NAME             '0'
#define OIM_UNDEFN_WB_NAME             '0'
#define OIM_UNDEFN_WB_LIMIT            0xFFFF

/*
** defines for Startup/Shutdown Session Services
*/
#define OIM_CONFIG_SESSION             1
#define OIM_NORMAL_SESSION             2
#define OIM_NO_MULTIPLE_LOGONS         4
#define OIM_ADMIN_SESSION              8

/*
** the maximum number of users allowed access at any time
*/
#define OIM_MAX_NUMBER_OF_USERS   50

/*
** the maximum number of open items allowed at any time
*/
#define OIM_MAX_NUMBER_OF_OPEN_ITEMS   1200

/*
** defines for backup db
*/
#define OIM_FULL_BACKUP                0
#define OIM_CHANGES_ONLY_BACKUP        1

/*
** defines for the forward item call
*/
#define OIM_NO_PRIORITY_CHANGE         -1

/*
** create defines for strings in the system
*/
#define NO_OWNER                       "NO_OWNER"
#define NO_NAME                        "NO_NAME"
#define ALL                            "ALL"

/*
** general typedefs used by all OIM routines
*/
typedef UCHAR        UID[UID_LENGTH];
typedef UID          FARPTR16 PUID;
typedef USHORT       HITEM;
typedef CHAR         USERID[USERID_LENGTH + 1];
typedef USERID       FARPTR16 PUSERID;
typedef HITEM        FARPTR16 PHITEM;
typedef USHORT       CLASSID;
typedef CLASSID      FARPTR16 PCLASSID;
typedef USHORT       ATID;
typedef ATID         FARPTR16 PATID;
typedef CHAR         WSID[WSID_LENGTH + 1];
typedef WSID         FARPTR16 PWSID;
typedef CHAR         DBID[DB_NAME_LENGTH + 1];
typedef DBID         FARPTR16 PDBID;
typedef CHAR         APPID[APPLICATION_NAME_LENGTH + 1];
typedef APPID        FARPTR16 PAPPID;

/*
** typedefs unique to the TOC logic
*/
typedef  USHORT          HTOC;
typedef  HTOC            FARPTR16 PHTOC;

/*
** defines for backup db
*/
#define OIM_FULL_BACKUP                0
#define OIM_CHANGES_ONLY_BACKUP        1

/*
** The following constants denote the various release types available
** when suspending an item
*/
#define OIM_NOT_SUSPENDED              0
#define OIM_SUSP_TIME_ONLY             1
#define OIM_SUSP_ANY_CLASS             2
#define OIM_SUSP_ALL_CLASS             3
#define OIM_SUSP_NO_CRITERIA           4
/*
** defines for SNAPSHOT filters
*/
#define OIM_SYSTEM_ATTR                0x0002
#define OIM_USER_ATTR                  0x0004
#define OIM_PRIORITY_ATTR              0x0008
#define OIM_STAGING_ATTR               0x0010

/*
** defines for the Online Staging API operations and required objects
*/
#define OIM_RESET                      0x0001
#define OIM_ADD_OBJECTS                0x0002

#define OIM_IMAGE_ONLINE               0x0001
#define OIM_NOTE_ONLINE                0x0002
#define OIM_ACTIVITY_LOG_ONLINE        0x0004

/*
**  defines for the Profile APIs
*/
#define OIM_MAX_APP_LENGTH  64
#define OIM_MAX_KEY_LENGTH  64
#define OIM_MAX_VAL_LENGTH  1023
#define OIM_SZ_APP_LENGTH   65
#define OIM_SZ_KEY_LENGTH   65
#define OIM_SZ_VAL_LENGTH   1024

/*
**  define for the maximum number of items that can be returned in
**  an in memory list from OimSearch or OimComplexSearch
*/
#define OIM_MAX_IN_MEM_LIST_ITEMS  4095

/*
** The following structure is used to define the release criteria
** for an item when Suspending it.
*/
typedef struct _RELCRITERIASTRUCT
   {
   USHORT   usReleaseType;         /* Release criteria type        */
   UID      uidDeadlineWB;         /* WB to go to upon expiration  */
   DATETIME dtExpDateTime;         /* Date & time of expiration    */
   UID      uidReadyWB;            /* WB to go to upon release     */
   USHORT   usNumAwaitedClasses;   /* Number of Classes waited for */
   USHORT   ausAwaitedClasses[1];  /* Class IDs waited for         */
   }
   RELCRITERIASTRUCT;

typedef RELCRITERIASTRUCT FARPTR16 PRELCRITERIASTRUCT;

/*
** The following structure is used to define the online staging criteria
** for an item
*/
typedef struct _STAGINGCRITERIASTRUCT
   {
   BITS     fObjectsRequired;      /* Type of Angora objects to stage  */
   BITS     fOperation;            /* Indicates if new criteria or not */
   DATETIME dtExpireDateTime;      /* Date & time of expiration        */
   }
   STAGINGCRITERIASTRUCT;

typedef STAGINGCRITERIASTRUCT FARPTR16 PSTAGINGCRITERIASTRUCT;

/*
** class attribute information list structure
*/
typedef struct
   {
   USHORT  usAttrId;
   BOOL16  fAttrRequiredField;
   BOOL16  fAttrIndexField;
   }
   CLASSATTRSTRUCT;

typedef CLASSATTRSTRUCT FARPTR16 PCLASSATTRSTRUCT;

/*
** class information structure
*/
typedef struct
   {
   CHAR              szClassName[CLASS_NAME_LENGTH+1];
   CHAR              szOwnerName[OWNER_NAME_LENGTH+1];
   USHORT            usNbrAttrIds;
   PCLASSATTRSTRUCT  pAttrInfoList;
   }
   CLASSINFOSTRUCT;

typedef CLASSINFOSTRUCT FARPTR16 PCLASSINFOSTRUCT;

/*
** attribute information structure
*/
typedef struct
   {
   CHAR    szAttributeName[ATTR_NAME_LENGTH+1];
   CHAR    szOwnerName[OWNER_NAME_LENGTH+1];
   USHORT  usDataType;
   USHORT  usMinLength;
   USHORT  usMaxLength;
   }
   ATTRINFOSTRUCT;

typedef ATTRINFOSTRUCT FARPTR16 PATTRINFOSTRUCT;

/*
** define the structure returned from OimGetWorkbasketInfo
*/
typedef struct
   {
   USHORT   cbStruct;
   CHAR     szWorkbasketName [WB_NAME_LENGTH+1];
   CHAR     szOwnerName [OWNER_NAME_LENGTH+1];
   USHORT   usOverLoadLimit;
   }
   WBINFOSTRUCT;

typedef WBINFOSTRUCT FARPTR16 PWBINFOSTRUCT;
/*
** This structure is returned by the OimItemSnapshot API function.
*/
typedef struct _SNAPSHOTSTRUCT
   {
   UID       uidItem;
   USHORT    usItemType;
   USHORT    usIndexClass;
   ULONG     ulOMImage;
   ULONG     ulOMNote;
   USHORT    usWIPStatus;
   USHORT    usWorkFlowID;
   USHORT    usReleaseType;
   USERID    useridCheckedOut;
   UID       uidWorkBasket;
   USHORT    usPriority;
   CHAR      ucDateEnteredWB[11];
   CHAR      ucTimeEnteredWB[9];
   STAGINGCRITERIASTRUCT StagingCriteria;
   USHORT    usNumAttributes;
   struct
      {
      USHORT usAttrId;
      USHORT usAttrType;
      PSZ16  pszAttrValue;
      }
   aAttributes[1];
   }
   SNAPSHOTSTRUCT;

typedef SNAPSHOTSTRUCT FARPTR16 PSNAPSHOTSTRUCT;


/*
** An array of this structure is returned in the event that one or
** more users' access to an item blocks the caller from completing
** an operation.
*/
typedef struct
   {
   USERID  useridUser;    /* User holding blocking access          */
   UID     uidItem;       /* UID user has access to                */
   SHORT   sAccessType;   /* OIM_READ, OIM_WRITE, or OIM_CHECKOUT  */
   }
   USERACCESSSTRUCT;

typedef USERACCESSSTRUCT FARPTR16 PUSERACCESSSTRUCT;

/*
** this is the workflow info struct
*/
typedef struct
   {
   USHORT   cbStruct;
   CHAR     szWorkFlowName[WF_NAME_LENGTH+1];
   CHAR     szOwnerName [OWNER_NAME_LENGTH+1];
   USHORT   cmdHistoryLogDisposition;
   USHORT   idStorageGroup;
   USHORT   usNbrItemsinWf;
   USHORT   usNbrWbIds;
   PUID     pWbIds;
   }
   WFINFOSTRUCT;

typedef WFINFOSTRUCT FARPTR16 PWFINFOSTRUCT;


/*
** this typedef is used when accessing a history log
*/
typedef  char HUGEPTR16 PHUGE;

/*
** define the structure returned from OimListHistory
*/
typedef struct
   {
   ULONG    ulNumOfBytes;
   PHUGE    pHistoryLog;
   } LISTHISTORYSTRUCT;

typedef LISTHISTORYSTRUCT FARPTR16 PLISTHISTORYSTRUCT;


/*
** define the structure returned from OimGetItemInfo
*/
typedef struct
   {
   USHORT   cbStruct;
   USHORT   usItemType;
   USHORT   usIndexClass;
   USERID   useridCheckout;
   USHORT   usWipStatus;
   BOOL16   fSuspended;
   USHORT   idWorkFlow;
   }
   ITEMINFOSTRUCT;

typedef ITEMINFOSTRUCT FARPTR16 PITEMINFOSTRUCT;

/*
** define the structure that is returned in OimGetWorkBasketPriority for
** the date and time the item entered the workbasket
*/
typedef struct
   {
   CHAR  szTime[9];
   CHAR  szDate[11];
   } TIMEDATESTRUCT;

typedef TIMEDATESTRUCT FARPTR16 PTIMEDATESTRUCT;

/*
** this structure is used to pass a list of attribute ids and values
** to Create or Update
*/
typedef struct {
   USHORT   idAttribute;
   PSZ16    pszAttributeValue;
   } ATTRLISTSTRUCT;

typedef ATTRLISTSTRUCT FARPTR16 PATTRLISTSTRUCT;

#define  OIM_LEVEL_1_DUP   1
#define  OIM_LEVEL_2_DUP   2

#define  OIM_LEVEL_1_UPDATE   1
#define  OIM_LEVEL_2_UPDATE   2

#define OIM_TOC_DELETE           1
#define OIM_TOC_ADD              2
#define OIM_TOC_MODIFIED         3

/*
** The TOC Entry Structure defines each element in the array of structures
** returned by the OIMGetTOC and OIMTOCUpdates functions.  Each structure
** of the array defines the status and UID of an item in the TOC:
**
**    USHORT   - A status code indicating if the item was added, removed
**               or modified; this value is NULL upon return from the
**               OIMGetTOC function call; the OIMTOCUpdate function
**               assigns one of the following values to this location:
**                   OIM_TOC_DELETE
**                   OIM_TOC_ADD
**                   OIM_TOC_MODIFIED
**
**    UID      - The unique identifier of this item in the TOC.
*/
typedef struct _TOCENTRYSTRUCT
   {
   USHORT         usTOCItemType;
   UID            uidTOCItem;
   }
   TOCENTRYSTRUCT;

typedef  TOCENTRYSTRUCT FARPTR16 PTOCENTRYSTRUCT;

#define OIM_SEARCH_AND     1
#define OIM_SEARCH_OR      2

#define OIM_SEARCH_EQUAL    1
#define OIM_SEARCH_NEQUAL   2
#define OIM_SEARCH_GTHAN    3
#define OIM_SEARCH_LTHAN    4
#define OIM_SEARCH_GETHAN   5
#define OIM_SEARCH_LETHAN   6
#define OIM_SEARCH_BETWEEN  7
#define OIM_SEARCH_LIKE     8
#define OIM_SEARCH_IN       9
#define OIM_SEARCH_IS_NULL  10

typedef struct
   {
   USHORT usAttrValueLength;
   PSZ16  pszAttrValue;
   } SEARCHATTRVALUESTRUCT;

typedef SEARCHATTRVALUESTRUCT FARPTR16 PSEARCHATTRVALUESTRUCT;

typedef struct
   {
   USHORT                 usAttrId;
   BOOL16                 fNotFlag;
   BOOL16                 fAttrAndOr;
   USHORT                 usAttrOperation;
   USHORT                 usNumAttrValues;
   PSEARCHATTRVALUESTRUCT pSearchAttrValueStruct;
   } SEARCHATTRSTRUCT;

typedef SEARCHATTRSTRUCT FARPTR16 PSEARCHATTRSTRUCT;

typedef struct
   {
   USHORT            usClassId;
   USHORT            usNumClassAttrs;
   PSEARCHATTRSTRUCT pSearchClassAttrStruct;
   } SEARCHCLASSSTRUCT;

typedef SEARCHCLASSSTRUCT FARPTR16 PSEARCHCLASSSTRUCT;

typedef struct
   {
   USHORT            usNumSysAttrs;
   PSEARCHATTRSTRUCT pSearchSysAttrStruct;
   } SEARCHSYSSTRUCT;

typedef SEARCHSYSSTRUCT FARPTR16 PSEARCHSYSSTRUCT;

typedef struct
   {
   PSEARCHSYSSTRUCT   pSearchSystemStruct;
   USHORT             usNumClasses;
   PSEARCHCLASSSTRUCT pSearchClassStruct;
   } SEARCHCRITERIA;

typedef SEARCHCRITERIA FARPTR16 PSEARCHCRITERIA;

/*
** Highest Level errors that are returned to the user
*/
#define USER_ERR_BASE   8000
#define OIM_DLL_NOT_INIT               USER_ERR_BASE+1
#define OIM_PRC_INVALID                USER_ERR_BASE+2
#define OIM_FOPTIONS_INVALID           USER_ERR_BASE+3
#define OIM_NOT_LOGGED_ON              USER_ERR_BASE+4
#define OIM_GENERAL_FAILURE            USER_ERR_BASE+5
#define OIM_OUT_OF_MEMORY              USER_ERR_BASE+6
#define OIM_INVALID_UID                USER_ERR_BASE+7
#define OIM_INVALID_ITEM_TYPE          USER_ERR_BASE+8
#define OIM_INVALID_INDEX_CLASS        USER_ERR_BASE+10
#define OIM_INVALID_ACCESS_LEVEL       USER_ERR_BASE+11
#define OIM_INVALID_DISPOSITION        USER_ERR_BASE+12
#define OIM_INVALID_ATTRIBUTE_ID       USER_ERR_BASE+13
#define OIM_CANT_WRITE_SYS_ATTR        USER_ERR_BASE+14
#define OIM_INVALID_HANDLE             USER_ERR_BASE+15
#define OIM_CANT_CREATE_UID            USER_ERR_BASE+16
#define OIM_INVALID_FILTER             USER_ERR_BASE+17
#define OIM_INVALID_APPLICATION_NAME   USER_ERR_BASE+20
#define OIM_INVALID_SESSION            USER_ERR_BASE+21
#define OIM_INVALID_WORKBASKET         USER_ERR_BASE+25
#define OIM_INVALID_WORKFLOW_ID        USER_ERR_BASE+28
#define OIM_INVALID_ITEM_UID           USER_ERR_BASE+29
#define OIM_INVALID_FOLDER_UID         USER_ERR_BASE+30
#define OIM_INVALID_OWNER              USER_ERR_BASE+32
#define OIM_INVALID_CHECK_LEVEL        USER_ERR_BASE+33
#define OIM_ACTIVE_WIP_ITEM            USER_ERR_BASE+34
#define OIM_INVALID_WIP_FILTER         USER_ERR_BASE+37
#define OIM_INVALID_TYPE_FILTER        USER_ERR_BASE+38
#define OIM_INVALID_SUSPEND_FILTER     USER_ERR_BASE+40
#define OIM_INVALID_CLASS_ID_LIST      USER_ERR_BASE+41
#define OIM_INVALID_CRITERIA           USER_ERR_BASE+42
#define OIM_INVALID_PRIORITY           USER_ERR_BASE+43
#define OIM_ABORTED_BY_USER_REQUEST    USER_ERR_BASE+47
#define OIM_INVALID_ACTION             USER_ERR_BASE+49
#define OIM_INVALID_DISPLAY_NAME       USER_ERR_BASE+50
#define OIM_INVALID_LOCK_NAME          USER_ERR_BASE+51
#define OIM_INVALID_DB_NAME            USER_ERR_BASE+52
#define OIM_TRANSACTION_IN_PROGRESS    USER_ERR_BASE+58
#define OIM_INVALID_OPERATION_REQUEST  USER_ERR_BASE+59
#define OIM_TABLE_OVERFLOW             USER_ERR_BASE+61
#define OIM_NO_TRANSACTION_IN_PROGRESS USER_ERR_BASE+62
#define OIM_NO_ASYNC_WITHIN_TRANS      USER_ERR_BASE+63
#define OIM_INVALID_UID_LIST           USER_ERR_BASE+65
#define OIM_DEADLOCK_CONDITION         USER_ERR_BASE+66
#define OIM_INVALID_PROFILE_PARAMETER  USER_ERR_BASE+67
#define OIM_PROFILE_OVERFLOW           USER_ERR_BASE+68
#define OIM_NO_ASYNC                   USER_ERR_BASE+69
#define OIM_MAX_NUMBER_USERS           USER_ERR_BASE+70
#define OIM_MAX_NUMBER_OPEN_ITEMS      USER_ERR_BASE+71


#define USER_WRN_BASE                  9000

#define OIM_SUCCESS_DIRTY_READ         USER_WRN_BASE+2
#define OIM_ALREADY_IN_WIP             USER_WRN_BASE+4
#define OIM_HISTORY_LOG_NOT_ONLINE     USER_WRN_BASE+5
#define OIM_ALL_WB_VISITED             USER_WRN_BASE+6
#define OIM_ITEM_ALREADY_IN_FOLDER     USER_WRN_BASE+7
#define OIM_ITEM_NOT_SUSPENDED         USER_WRN_BASE+11
#define OIM_ITEM_ALREADY_IN_WORKBASKET USER_WRN_BASE+13
#define OIM_NORMAL_SESSION_IN_PROGRESS USER_WRN_BASE+14
#define OIM_NOT_CHECKED_OUT            USER_WRN_BASE+15
#define OIM_ITEM_CHECKED_OUT_BY_CALLER USER_WRN_BASE+16
#define OIM_BUSY                       USER_WRN_BASE+17
#define OIM_ALREADY_LOGGED_ON          USER_WRN_BASE+19
#define OIM_NOT_WIP_ITEM               USER_WRN_BASE+21
#define OIM_WORKBASKET_OVERLOAD        USER_WRN_BASE+22
#define OIM_NO_ITEMS_AVAILABLE         USER_WRN_BASE+23
#define OIM_NO_HISTORY_LOG             USER_WRN_BASE+25
#define OIM_CONFIG_SESSION_IN_PROGRESS USER_WRN_BASE+28
#define OIM_ITEM_NOT_IN_FOLDER         USER_WRN_BASE+29
#define OIM_ITEM_NOT_IN_WORKBASKET     USER_WRN_BASE+30
#define OIM_ITEM_ALREADY_IN_WORKFLOW   USER_WRN_BASE+31
#define OIM_TOO_MANY_AWAITED_CLASSES   USER_WRN_BASE+33
#define OIM_USER_ALREADY_LOGGED_ON     USER_WRN_BASE+34
#define OIM_PROFILE_VALUE_NOT_FOUND    USER_WRN_BASE+35
#define OIM_MAX_SEARCH_ITEMS           USER_WRN_BASE+36
#define OIM_MAX_IN_MEM_LIST            USER_WRN_BASE+37
#define OIM_MAX_TOC_ITEMS              USER_WRN_BASE+38


/*
** the Item Services APIs
*/
SHORT EXPENTRY16 OimGetItemInfo (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimCreateItem (USHORT, USHORT, USHORT, PATTRLISTSTRUCT, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimOpenItem (PUID, USHORT, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimSaveItem (HITEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimCloseItem (HITEM, USHORT, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimChangeIndexClass (HITEM, CLASSID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimWriteItemAttr (HITEM, ATID, PVOID16, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimReadItemAttr (HITEM, ATID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimSearch (USHORT, USHORT,USHORT, USHORT, PCHAR16, PCHAR16, BOOL16, HSEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimComplexSearch (USHORT, USHORT,USHORT, USHORT, PSEARCHCRITERIA, BOOL16, HSEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimChangeItemAccess (USHORT, USHORT,BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimGetItemType (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimDeleteItem (PUID, HSEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimGetItemXref (PUID, USHORT, HSEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimSuspendItem (PUID, PRELCRITERIASTRUCT, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimListHistory (PUID, BOOL16, HSEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimCheckInItem (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimCheckOutItem (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimDeleteHistory (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimActivateItem (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimGetSuspendCriteria (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimItemSnapshot (PUID, BITS, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimOnlineStaging (PUID, PSTAGINGCRITERIASTRUCT, BITS, HWND, USHORT, PRCSTRUCT);

/*
** the Folder Services APIs
*/
SHORT EXPENTRY16 OimAddFolderItem (PUID, PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimRemoveFolderItem (PUID, PUID, BITS, HWND, USHORT, PRCSTRUCT);

/*
** the Table of Contents Services APIs
*/
SHORT EXPENTRY16 OimGetTOC (PUID, USHORT, USHORT, USHORT, USHORT, PUSHORT16, PHTOC, HSEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimTOCCount (PUID, USHORT, USHORT, USHORT, USHORT, PUSHORT16, HSEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimTOCStatus (HTOC, USHORT, HSEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimGetTOCUpdates (HTOC, USHORT, HSEM, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimCloseTOC (HTOC, BITS, HWND, USHORT, PRCSTRUCT);

/*
** the Session Services APIs
*/
SHORT EXPENTRY16 OimLogon (PSZ16, PSZ16, PSZ16, PSZ16, BITS, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimLogoff (BITS, HWND, USHORT, PRCSTRUCT);

/*
** the Database Services APIs
*/
SHORT EXPENTRY16 OimStartTransaction ( HSEM, BITS, HWND, USHORT, PRCSTRUCT );
SHORT EXPENTRY16 OimEndTransaction ( USHORT, BITS, HWND, USHORT, PRCSTRUCT );
SHORT EXPENTRY16 OimProfileReadString ( PSZ16, PSZ16, PSZ16, USHORT, BOOL16, BITS, HWND, USHORT, PRCSTRUCT );
SHORT EXPENTRY16 OimProfileWriteString ( PSZ16, PSZ16, PSZ16, ULONG, BITS, HWND, USHORT, PRCSTRUCT );
SHORT EXPENTRY16 OimProfileEnumerate ( PSZ16, BOOL16, BITS, HWND, USHORT, PRCSTRUCT );


/*
** the Configuration Services APIs
*/
SHORT EXPENTRY16 OimGetClassInfo (CLASSID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimGetAttrInfo (ATID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimEnumerateClasses (PSZ16, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimEnumerateAttrs (PSZ16, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimXrefAttr (USHORT, BITS, HWND, USHORT, PRCSTRUCT);

/*
** the WorkBasket Services APIs
*/
SHORT EXPENTRY16 OimGetWorkBasketInfo (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimEnumerateWorkBaskets (PSZ16,BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimAddWorkBasketItem (PUID,PUID,USHORT,BOOL16,BITS,HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimRemoveWorkBasketItem (PUID, PUID, BITS,HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimNextWorkBasketInWorkFlow (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimSetWorkBasketItemPriority (PUID, USHORT, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimGetWorkBasketItemPriority (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimGetNextWorkBasketItem (PUID, BOOL16, USHORT, BITS, HWND, USHORT, PRCSTRUCT);

/*
** the WorkFlow Services APIs
*/
SHORT EXPENTRY16 OimStartWorkFlow(PUID,USHORT, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimRouteWipItem (PUID, PUID, BOOL16, SHORT, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimEnumerateWorkFlows (PSZ16, BITS, HWND, USHORT,PRCSTRUCT);
SHORT EXPENTRY16 OimGetWorkFlowInfo (USHORT, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimRemoveFromWorkFlow (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimCompleteWorkFlow (PUID, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimChangeWorkFlow (PUID, USHORT, BITS, HWND, USHORT, PRCSTRUCT);
SHORT EXPENTRY16 OimXrefWorkFlow (USHORT, BITS, HWND, USHORT, PRCSTRUCT);

/*****************************************************************************/
/* We need to close out the C++ enablement.                                  */
/*****************************************************************************/
#ifdef __cplusplus
   }
#endif
