/*<<TITLE Library Object Manager API Include file>>*/
/*
**********************************************************************

FCAELOBJ.h - Library Object Manager API include file.

**********************************************************************

5696-125 - (C) Copyright Eastman Kodak Co. 1991, 1992.  All Rights Reserved

**********************************************************************

*/

/****************************************************************************/
/*  We are now allowing for C++ compilations.                               */
/****************************************************************************/

#ifdef __cplusplus
   extern "C" {
#endif

/*-----------------------------------*/
/*  constants                        */
/*-----------------------------------*/

/*
** LOC_DB_NAME:           The identifier given to the OS/2 Database
**                        Manager database that is being used by this
**                        application.
** LOC_APPLICATION_NAME:  The identifier for the application using
**                        the OIM.
** LOC_OWNER_NAME:        The identifier for the owner of this resource.
*/
#define LOC_DB_NAME           "FCAEDB"
#define LOC_APPLICATION_NAME  "IMGPLUS"
#define LOC_OWNER_NAME        "IMGPLUS"

/*
** Library Object Open constants.
*/
#define LOO_USECURRENT     0
#define LOO_DISPLAY        1
#define LOO_HIDE           2
#define LOO_DISALLOW       3

#define LOO_SHAREDREAD     0x0000  /* Open item in read only mode     */
#define LOO_EXCLWRITE      0x0001  /* Open item in update mode        */
#define LOO_LIST           0x0002  /* Open UIDs into a list window    */

/*
** Library Object Create constants.
*/
#define LOC_PMDEFAULT      0

#define LOC_DEFAULT        0
#define LOC_MAXIMIZE       1
#define LOC_MINIMIZE       2

/*
** Library Object API error codes.
*/
#define LO_SUCCESS           0
#define LO_WRN_NOUPDATE      1
#define LO_ERR_BASE          100
#define LO_ERR_ALLOCMEM      LO_ERR_BASE + 1
#define LO_ERR_THREAD        LO_ERR_BASE + 2
#define LO_ERR_GETMEM        LO_ERR_BASE + 3
#define LO_ERR_RESOURCE      LO_ERR_BASE + 4
#define LO_ERR_OIMSTART      LO_ERR_BASE + 5
#define LO_ERR_WINCREATE     LO_ERR_BASE + 6
#define LO_ERR_CHILDCREATE   LO_ERR_BASE + 7
#define LO_ERR_BUSY          LO_ERR_BASE + 8
#define LO_ERR_OIMOPEN       LO_ERR_BASE + 9
#define LO_ERR_OIMACCESS     LO_ERR_BASE + 10
#define LO_ERR_CONFIG        LO_ERR_BASE + 11
#define LO_ERR_CLOSEERR      LO_ERR_BASE + 12
#define LO_ERR_CANCEL        LO_ERR_BASE + 13
#define LO_ERR_CHILDCLOSE    LO_ERR_BASE + 14
#define LO_ERR_SECURITY      LO_ERR_BASE + 15
#define LO_ERR_OIMOPENNEXT   LO_ERR_BASE + 16
#define LO_ERR_INVALIDUID    LO_ERR_BASE + 17
#define LO_ERR_GENERAL       LO_ERR_BASE + 18
#define LO_ERR_LOWLIMIT      LO_ERR_BASE + 19
#define LO_ERR_CANCELLIST    LO_ERR_BASE + 20


/*-----------------------------------*/
/*  typedefs                         */
/*-----------------------------------*/

typedef struct _LIBOBJRET     /* Return structure for API calls   */
   {
   SHORT       rc;            /* Return code                      */
   HWND        hwndLibObj;    /* Window handle of Lib Obj window  */
   UID         uidLibObj;     /* UID of the Library Object        */
   HERR        hErrLog;       /* Error Log handle                 */
   } LIBOBJRET;

typedef LIBOBJRET FARPTR16 PLIBOBJRET;

/*-----------------------------------*/
/*  prototypes                       */
/*-----------------------------------*/


SHORT EXPENTRY16 LibObjCreateWin(
   HWND,USHORT,USHORT,USHORT,USHORT,USHORT,USHORT,USHORT,PLIBOBJRET);


SHORT EXPENTRY16 LibObjOpenObject(
   HWND,HWND,PUID,USHORT,USHORT,USHORT,USHORT,BOOL16,USHORT,PLIBOBJRET);


SHORT EXPENTRY16 LibObjCloseObject(
   HWND, HWND, PUID, USHORT, PLIBOBJRET);

/*****************************************************************************/
/* We need to close out the C++ enablement.                                  */
/*****************************************************************************/
#ifdef __cplusplus
   }
#endif
