# svrtask.mak

# This makefile assumes that the INCLUDE and LIB environment variables
# are set up to point at the Notes and C "include" and "lib" directories.

# The name of the program.

# Compilation command.
!IF $(SVRTASK_DEBUG)
COPT=/Zi /Od
LOPT=/CO
!ELSE
COPT=
LOPT=
!ENDIF

#LIB=C:\C600\LIB\OS2.LIB C:\NOTESAPI\LIB\NOTESOS2.LIB
MYLIB=OS2.LIB NOTESOS2.LIB

# Compile command
.C.OBJ:
    CL  /c  /ALu  /Zpe  /G2s  /DOS2  /W3  $(COPT)  $*.C > $*.out

# Link command.
.OBJ.EXE:
    LINK /PMTYPE:VIO  $(LOPT)  $*.OBJ,  $*.EXE,  NUL, $(MYLIB), $*.DEF;
    RC  $*.RC  $*.EXE

# Dependencies
# all: exptask.exe imptask.exe
all: imptask.exe impreply.exe exptask.exe myexec.exe findbeep.exe

imptask.EXE:  imptask.OBJ  ^imptask.H

imptask.OBJ:  imptask.C    ^imptask.H

impreply.EXE: impreply.OBJ

impreply.OBJ: impreply.C

exptask.EXE:  exptask.OBJ  ^exptask.H
    LINK /PMTYPE:VIO  $(LOPT)  $*.OBJ sprintf.obj,  $*.EXE,  NUL, $(MYLIB), $*.DEF;
    RC  $*.RC  $*.EXE

exptask.OBJ:  exptask.C    ^exptask.H

myexec.EXE:  myexec.OBJ
    LINK   /PMTYPE:VIO  $(LOPT)  $*.OBJ,  $*.EXE,  NUL,  NOTESOS2.LIB, $*.DEF;

myexec.OBJ:  myexec.C

findbeep.EXE: findbeep.OBJ
    LINK   /PMTYPE:VIO  $(LOPT)  $*.OBJ,  $*.EXE,  NUL,  os2.lib, ;

findbeep.OBJ: findbeep.C

