//
// imptask.h
//

#if ! defined (imptask_INCLUDED)
#define imptask_INCLUDED


// MACRO DEF's
//      123456789012345678901234567890
#define IMPORT_TASK_INIT_FILENAME       "svrtask.ini"
#define MAX_INI_KEY_LEN                 32
#define MAX_INI_VALUE_LEN               80

#define MAX_INX_LINE_LEN                132
#define MAX_INX_KEY_LEN                 32
#define MAX_INX_VAL_LEN                 80
#define MAX_NUM_OF_INX_VAL              3
#define MAX_INX_NOTE_LEN                32000 // in bytes
#define MAX_ATTRNAME_LEN                32
#define MAX_ATTRVALUE_LEN               32
#define MAX_CLASSNAME_LEN               32
#define MAX_NUM_OF_ATTR                 20
#define MAX_FULL_PATHNAME_LEN           133
#define MAX_FILENAME_LEN                13
#define MAX_DIRNAME_LEN                 121
#define MAX_LNOTES_DBNAME_LEN           32

#define INIKEY_COMMENT_MARKER           "#"
#define INIKEY_IMPTASK_WAKEUP_INTERVAL  "IMPTASK_WAKEUP_INTERVAL"
#define INIKEY_IMPTASK_CIF_DIR          "IMPTASK_CIF_DIR"
#define INIKEY_IMPTASK_CIF_SAVE_DIR     "IMPTASK_CIF_SAVE_DIR"
#define INIKEY_LNOTES_DEFAULT_DB        "IMPTASK_LNOTES_DEF_IMPORT_DB"
#define INIKEY_MAX_SERVER_LOOPS         "IMPTASK_MAX_SERVER_LOOPS"
#define INIKEY_LNOTES_MAIL_ADDRESS      "IMPTASK_LNOTES_MAIL_ADDRESS"

#define INIDEF_IMPTASK_WAKEUP_INTERVAL  15    // in seconds

#define INXKEY_BEGIN_DOCUMENT           ":document"
#define INXKEY_CLASS                    ":class"
#define INXKEY_ATTR_COUNT               ":attrcnt"
#define INXKEY_ATTR                     ":attr"
#define INXKEY_ATTR_INDEX               ":attri"
#define INXKEY_BEGIN_NOTE               ":note"
#define INXKEY_NOTE_LINE                ":line"
#define INXKEY_END_NOTE                 ":enote"
#define INXKEY_IMAGE                    ":image"
#define INXKEY_END_DOCUMENT             ":edoc"
#define INXKEY_BEGIN_FOLDER             ":folder"
#define INXKEY_END_FOLDER               ":efolder"
#define INXKEY_FOLDERITEM               ":folderitem"

#define INX_TAG_DELIMITER               ':'
#define INX_TAG_PARAM_DELIMITER         '.'

#define LNOTES_IP2_NOTES_FIELD          "IP2_NOTES_FIELD"
#define LNOTES_EMBEDICON_FIELD          "LNOTES_EMBEDICON_FIELD"

#define LNDI_FAX_ADDRESS                "LNDI FAX"
#define LNDI_FAX_REPLY_ADDRESS          "Tom"
#define TEMPORARY_PCX_FILENAME          "TMPIMPRT.PCX"
#define LNDI_FAX_REPLY_OPTION_FIELD     "LNDIFAX_REPLY_OPTION_FIELD"
#define OIS_PCX_FORMAT                  "PCX"
#define OIS_NO_COMPRESSION              "OFF"
#define CIFIMPORT_FIELD_MARKER_STR      "CIF_Import_Field_Marker"

// TYPEDEF's
typedef struct
{
   char            name[MAX_ATTRNAME_LEN];
   char            value[MAX_ATTRVALUE_LEN];
   BOOL            findex;
} INX_ATTR;
typedef struct _inx_obj_node
{
   char            objType; // 'F', 'D'
   char            classname[MAX_CLASSNAME_LEN]; // used for folder & doc
   int             attrcnt;                      
   INX_ATTR        attr[MAX_NUM_OF_ATTR];
   char            *note;
   char            image[MAX_FILENAME_LEN];
   struct _inx_obj_node *pNext;
} INX_OBJ_NODE, *PINX_OBJ_NODE;
typedef struct
{
   unsigned short usItemCount;          // Number of items in the list
   PINX_OBJ_NODE pHead;                 // Pointer to head node
   PINX_OBJ_NODE pCur;
   PINX_OBJ_NODE pTail;                 // Pointer to tail node
} INX_OBJ_LST, *PINX_OBJ_LST;
typedef struct
{
   int             wakeupInterval;
   int             iMaxServerLoops;
   char            szCIFDir[MAX_DIRNAME_LEN];
   char            szCIFSaveDir[MAX_DIRNAME_LEN];
   char            szLNotesDefaultDB[MAX_LNOTES_DBNAME_LEN];
} INIT_PARAMS;
typedef struct _iplst_node
{
   struct _iplst_node *pNext;
   char szInxFile[MAX_FILENAME_LEN];   // Pointer to actual data
} IPLST_NODE, *PIPLST_NODE;
typedef struct _iplist
{
//   char szLSTFileName[MAX_FILENAME_LEN];
   unsigned short usItemCount;         // Number of items in the list
   PIPLST_NODE pHead;                  // Pointer to head node
   PIPLST_NODE pCur;
   PIPLST_NODE pTail;                  // Pointer to tail node
} IPLIST, *PIPLIST;
typedef struct
{
   DBHANDLE     *pReplyDbHndl;
   BOOL         fFound;
} ACTION_SEARCH_ROUTINE_PARAM;

// FUNCTION PROTOTYPES

#endif
