//      Filename:       imptask.c
//
//      Purpose:
//              Main module for the CIF import server task.  Used to import CIF
//              data objects into Lotus Notes.


// OS and C include files 
#define INCL_DOSPROCESS
#include <os2.h>        
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

// Notes API include files
#include <global.h>
#include <addin.h>
#include <nsfdb.h>
#include <nsfdata.h>
#include <nsfnote.h>
#include <nsfsearc.h>
#include <ostime.h>
#include <osenv.h>
#include <osmem.h>
#include <osfile.h>
#include <stdnames.h>
#include <names.h>

// Local include files
#include "imptask.h"
#include "impRCstr.h"

// Function prototypes
int impInitializeTask (INIT_PARAMS *pParams);
int impCleanupTask (void);
int impGetInitParams (INIT_PARAMS *pParams);
int impGetCmdPrmptCh (void);
int impDosChDir (char *pszDir);

char *impfgets (char *pszStr, int n, FILE *fp);
int impGetNextCIFFile (char *pszCIFFileName);
int impParseCIF (char *pszCIFFile, char *pszLstFile);
void impEnforceExtension(char *szPath,char *szExt);
int impMoveFile (char *szSrcFile, char *szDestFile);

int impParseLSTFile (char *szLSTFileName, PIPLIST pIPLst);
int impInitializeIPLst (PIPLIST pIPLst);
int impDestroyIPLst (PIPLIST pIPLst);
int impAddIPLstNode (PIPLIST pIPLst, char *szInxFile);
int impResetIPLstCurPtr (PIPLIST pIPLst);
char *impGetNextIPLstItem (PIPLIST pIPLst);

int impParseINXFile (char *pszINXFileName, PINX_OBJ_LST pinxLst);
char *impStrncpyc (char *pDest, char *pSrc, int dest_len, char ch);
int impInitializeINXObjLst (PINX_OBJ_LST pinxObjLst);
int impAddInxObjToLst (PINX_OBJ_LST pinxLst, PINX_OBJ_NODE pinxObj);
int impAddInxObjToFrontOfLst (PINX_OBJ_LST pinxLst, PINX_OBJ_NODE pinxObj);
int impResetInxLstCurPtr (PINX_OBJ_LST pinxLst);
PINX_OBJ_NODE impGetNextInxLstItem (PINX_OBJ_LST pinxLst);
int impReplaceFirstInxLstItem (PINX_OBJ_LST pinxLst, PINX_OBJ_NODE pinxObj);
BOOL impIsFirstInxLstItemAFolder (PINX_OBJ_LST pinxLst);
int impParseDocument (char *pszDocPath, PINX_OBJ_LST pinxLst);
int impParseFolder (char *pszFolderPath, PINX_OBJ_LST pinxLst);
int impParseINXLine (
   char *pszLine,
   char *pszKey,
   char szVal[MAX_NUM_OF_INX_VAL][MAX_INX_VAL_LEN],
   USHORT numVal);
int impDestroyINXObjLst (PINX_OBJ_LST pinxLst);

int impInsertInxLstIntoLN (PINX_OBJ_LST pinxLst, char *pszLNotesDefaultDB);
int impAddInxItemToLN (DBHANDLE *db_handle, PINX_OBJ_NODE pinxTmpObj);
int impStrChReplace (char *pszStr, char oldCh, char newCh);
int impSendImgToLNDIFAX (char *pszImageFile, char *pszOptionStr);
int impExpandPath (char *pszFileName, char *pszFullPath);
int impAddIP2NoteToLN (NOTEHANDLE noteHndl, char *pszNote);

// Standard entry for all Notes server add-in tasks
STATUS far PASCAL  AddInMain (HMODULE hModule, int argc, char *argv[])
{

   INIT_PARAMS params;
   char szCIFFileName[MAX_FILENAME_LEN];
   char szLSTFileName[MAX_FILENAME_LEN];
   char szTmpFilePath[MAX_FULL_PATHNAME_LEN];
   char *pszINXFileName;
   char szMsg[132];
   IPLIST IPLst;
   INX_OBJ_LST inxObjLst;
   int iLoopCount=0;
   BOOL fLoop=TRUE;
   char chCmdPrmpt;

   // Initialize this task.
   if (impInitializeTask (&params) != 0)
      return (1);

   sprintf (szMsg, "Interval processing = <%d>.", params.wakeupInterval);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);
   sprintf (szMsg, "Maximum loops = <%d>.", params.iMaxServerLoops);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);
   sprintf (szMsg, "CIF directory = <%s>.", params.szCIFDir);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);
   sprintf (szMsg, "CIF save directory = <%s>.", params.szCIFSaveDir);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);

   // Change current drive and directory to the import CIF dir
   impDosChDir (params.szCIFDir);

   // Begin the main loop.  We give up control to the server at the start of
   // each iteration, and get control back when the server says it is OK to
   // proceed.  The server returns TRUE when it is time to shut down this task.
   // Main loop will be exited after the specifed number of interations if
   // "params.maxServerLoops" is not equal to 0.
   while (!AddInIdle() && fLoop)
   {
      if (AddInSecondsHaveElapsed(params.wakeupInterval))
      {
         AddInSetStatus(ADDIN_MSG_FMT, "Processing");

         // Get next .CIF file
         if (impGetNextCIFFile (szCIFFileName) == 0)
         {
            // Parse .CIF file
            sprintf (szMsg, "Start processing of <%s>.", szCIFFileName);
            AddInLogMsg (ADDIN_MSG_FMT, szMsg);
            impParseCIF (szCIFFileName, szLSTFileName);
        
            // Parse .LST file
            impParseLSTFile (szLSTFileName, &IPLst);
        
            // For each .INX file in IP list
            while ((pszINXFileName = impGetNextIPLstItem (&IPLst)) != NULL)
            {
               // Parse .INX file
               impParseINXFile (pszINXFileName, &inxObjLst);
        
               // Insert document into lotus notes
               if (impInsertInxLstIntoLN (&inxObjLst, params.szLNotesDefaultDB) != 0)
               {
                  sprintf (szMsg, 
                     "Error inserting objects into <%s> DB.", 
                     params.szLNotesDefaultDB);
                  AddInLogMsg (ADDIN_MSG_FMT, szMsg);
               }

        
               // Destroy inx object
               impDestroyINXObjLst (&inxObjLst);
        
               // Delete INX file
               remove (pszINXFileName);
            }
        
            // Delete LST file
            remove (szLSTFileName);
        
            if (params.szCIFSaveDir[0] != '\0')  // Move CIF file to save directory
            {
               strcpy (szTmpFilePath, params.szCIFSaveDir);
               if (szTmpFilePath[strlen(szTmpFilePath)-1] != '\\')
               {
                  strcat (szTmpFilePath, "\\");
               }
               strcat (szTmpFilePath, szCIFFileName);
               impMoveFile (szCIFFileName, szTmpFilePath);
            }
            else // Delete CIF File
            {
               remove (szCIFFileName);
            }
        
            // Delete IP List
            impDestroyIPLst (&IPLst);

            sprintf (szMsg, "Completed processing of <%s>.", szCIFFileName);
            AddInLogMsg (ADDIN_MSG_FMT, szMsg);
         }
        
         // Reset status
         AddInSetStatus (ADDIN_MSG_FMT, "Idle");

         // Check if maximum processing loops have been reached
         if (params.iMaxServerLoops != 0)
         {
            iLoopCount++;
            if (iLoopCount >= params.iMaxServerLoops)
            {
               sprintf (szMsg,
                  "[%d] loops completed.  Maximum processing loops reached.",
                  params.iMaxServerLoops);
               AddInLogMsg (ADDIN_MSG_FMT, szMsg);
               fLoop = FALSE;
            }
         }
      }
      else if (AddInSecondsHaveElapsed (1)) // Check for console commands every 1 second
      {
         while ((chCmdPrmpt=(char)impGetCmdPrmptCh()) != (char)0)
         {
            if (chCmdPrmpt == 'q')
            {
               AddInLogMsg (ADDIN_MSG_FMT, "Console termination requested.");
               fLoop = FALSE;
               break;
            }
         }
      }

   } // End of main task loop.

   // We get here when the server notifies us that it is time to terminate.
   // This is usually when the user has entered "quit" to the server console.
   // Clean up anything we have been doing.  */
   impCleanupTask ();

   // End of add-in task.  We must "return" here rather than "exit".
   return (NOERROR);
      
} // End AddInMain()

int impDosChDir (char *pszDir)
{
   char *pszTmp;

   strupr (pszDir);

   if ((pszTmp = strchr(pszDir, ':')) != NULL)
   {
      DosSelectDisk (pszTmp[-1] - 'A' + 1);
   }
   DosChDir (pszDir, 0L);

   return (0);

} // impDosChDir()

int impGetCmdPrmptCh (void)
{
   if (kbhit ())
   {
      // Get char
      return (getche());
   }
   else
      return (0);

} // impGetCmdPrmptStr()

int impMoveFile (char *szSrcFile, char *szDestFile)
{
   DosCopy (szSrcFile, szDestFile, DCPY_EXISTING, 0L);
   remove (szSrcFile);

   return (0);

} // impMoveFile()

int impInitializeTask (INIT_PARAMS *pParams)
{
   impGetInitParams (pParams);

   AddInSetStatus (ADDIN_MSG_FMT, "Initializing");
   AddInLogMsg (ADDIN_MSG_FMT, "CIF Import Task: Initialization complete.");
   AddInSetStatus (ADDIN_MSG_FMT, "Idle");

   return (0);

} // impInitializeTask ()

int impCleanupTask (void)
{

   AddInSetStatus(ADDIN_MSG_FMT, "Terminating");
   AddInLogMsg(ADDIN_MSG_FMT, "CIF Import Task: Termination complete.");

   return (0);

} // impCleanupTask ()

int impGetInitParams (INIT_PARAMS *pParams)
{
   char szLine[132];
   FILE *fp;
   char szKey[MAX_INI_KEY_LEN];
   char szValue[MAX_INI_VALUE_LEN];

   // Open ini file
   if ((fp = fopen (IMPORT_TASK_INIT_FILENAME, "r")) == NULL)
      return (-1);

   // Initialize input param
   memset (pParams, '\0', sizeof(INIT_PARAMS));
   pParams->wakeupInterval = INIDEF_IMPTASK_WAKEUP_INTERVAL;
   pParams->szCIFSaveDir[0] = '\0';
   pParams->iMaxServerLoops = 0;

   // Parse ini file
   while (impfgets (szLine, sizeof(szLine), fp) != NULL)
   {
      szKey[0] = '\0';
      szValue[0] = '\0';

      if (sscanf (szLine, "%s %s", szKey, szValue) == 0)
         continue;

      if (stricmp (szKey, INIKEY_COMMENT_MARKER) == 0)
      {
         continue;
      }
      else if (stricmp (szKey, INIKEY_IMPTASK_WAKEUP_INTERVAL) == 0)
      {
         pParams->wakeupInterval = atoi (szValue);
      }
      else if (stricmp (szKey, INIKEY_IMPTASK_CIF_DIR) == 0)
      {
         strcpy (pParams->szCIFDir, szValue);
      }
      else if (stricmp (szKey, INIKEY_IMPTASK_CIF_SAVE_DIR) == 0)
      {
         strcpy (pParams->szCIFSaveDir, szValue);
      }
      else if (stricmp (szKey, INIKEY_LNOTES_DEFAULT_DB) == 0)
      {
         strcpy (pParams->szLNotesDefaultDB, szValue);
      }
      else if (stricmp (szKey, INIKEY_MAX_SERVER_LOOPS) == 0)
      {
         pParams->iMaxServerLoops = atoi(szValue);
      }
   }

   // Close file
   fclose (fp);

   return (0);

} // impGetInitParams()

char *impfgets (char *pszStr, int n, FILE *fp)
{
   char *pszRC, *pszTmp;

   if ((pszRC = fgets (pszStr, n, fp)) == NULL)
      return (NULL);

   pszTmp = strchr (pszStr, '\n');
   pszTmp[0] = '\0';

   return (pszTmp);

} // impfgets()

// Assumes that the CIF file is in the current directory
int impGetNextCIFFile (char *pszCIFFileName)
{
   HDIR FindHandle = HDIR_SYSTEM;
   FILEFINDBUF FindBuffer;
   USHORT FindCount = 1;
   int rc;
   char szPattern[80];
   USHORT attrFile = FILE_NORMAL;

   // Search for a CIF file
   strcpy (szPattern, "*.CIF");

   rc = DosFindFirst(                  // Find first file occurrence
            szPattern,                 // Search pattern
            &FindHandle,               // Directory search handle
            attrFile,                  // Search attribute
            &FindBuffer,               // Result buffer
            sizeof(FindBuffer),        // Result buffer length
            &FindCount,                // # of entries to find
            0L);                       // Reserved long value
   if (rc == 0)
   {
      strcpy (pszCIFFileName, FindBuffer.achName);
   }

   DosFindClose (FindHandle);

   return (rc);

} // impGetNextCIFFile()

// Assumes that the parsecif command is in the PATH variable
int impParseCIF (char *pszCIFFile, char *pszLstFile)
{
   register int rc = 0;
   CHAR parm[128];
   CHAR szDirPath[256];

   strcpy (pszLstFile, pszCIFFile);
   impEnforceExtension (pszLstFile, ".LST");
   strcpy (szDirPath, pszCIFFile);
   impEnforceExtension (szDirPath, ".log");

   sprintf (parm, "parsecif %s %s > %s", pszCIFFile, pszLstFile, szDirPath);
   system (parm);

   return (rc);

} // impParseCIF ()

void impEnforceExtension(char *szPath,char *szExt)
{
   char *p;

   p = strchr(szPath,'.');
   if (p != NULL)
      *p = '\0';

   if (szExt[0] != '.')
      strcat(szPath,".");

   strcat(szPath,szExt);
   return;
}

int impParseLSTFile (char *szLSTFileName, PIPLIST pIPLst)
{
   char szLine[80];
   char szInxFile[80];
   FILE *fp;

   impInitializeIPLst (pIPLst);

   // Open .LST file
   if ((fp = fopen (szLSTFileName, "r")) == NULL)
   {
      return (-1);
   }
 
   // Get all files in list
   pIPLst->usItemCount = 0;
   while (impfgets (szLine, sizeof(szLine), fp) != NULL)
   {
      if (strlen (szLine) > 0)
      {
         impStrncpyc (szInxFile, szLine, sizeof(szInxFile), '-');
         if (impAddIPLstNode (pIPLst, szInxFile) != 0)
         {
            return (-1);
         }
      }
   }

   fclose (fp);

   impResetIPLstCurPtr (pIPLst);

   return (pIPLst->usItemCount);

} // impParseLSTFile ()

char *impStrncpyc (char *pDest, char *pSrc, int dest_len, char ch)
{
   char *p = pDest;
   register int i = 1, n = dest_len;

   while (*pSrc != '\0' && *pSrc != ch && i++ < n)
   {
      *pDest++ = *pSrc++;
   }
   *pDest = '\0';

   return(p);

} // impStrncpyc()

int impInitializeIPLst (PIPLIST pIPLst)
{

   pIPLst->usItemCount = 0;
   pIPLst->pHead = NULL;
   pIPLst->pCur = NULL;
   pIPLst->pTail = NULL;

   return (0);

} // impInitializeIPLst()

int impDestroyIPLst (PIPLIST pIPLst)
{
   PIPLST_NODE pCurNode, pNextNode;
   int i;

   pCurNode = pIPLst->pHead;

   // Destroy nodes
   for (i=0; i < (int)pIPLst->usItemCount; i++)
   {
      pNextNode = pCurNode->pNext;
      free (pCurNode);
      pCurNode = pNextNode;

   } /* endwhile */

   pIPLst->usItemCount = 0;
   pIPLst->pHead = NULL;
   pIPLst->pCur = NULL;
   pIPLst->pTail = NULL;

   return (0);

} // impDestroyIPLst()

int impAddIPLstNode (PIPLIST pIPLst, char *szInxFile)
{
   PIPLST_NODE pTmpNode;

   if ((pTmpNode = (PIPLST_NODE)malloc(sizeof(IPLST_NODE))) == NULL)
      return (-1);

   if (pIPLst->usItemCount == 0) // First node in list
   {
      pIPLst->pHead = pTmpNode;
      pIPLst->pCur = pIPLst->pHead;
      pIPLst->pTail = pIPLst->pHead;
   }
   else
   {
      pIPLst->pTail->pNext = pTmpNode;
      pIPLst->pTail = pTmpNode;
   }

   pIPLst->usItemCount++;
   pIPLst->pTail->pNext = NULL;
   strcpy (pIPLst->pTail->szInxFile, szInxFile);

   return (0);

} // impAddIPLstNode()

int impResetIPLstCurPtr (PIPLIST pIPLst)
{
   pIPLst->pCur = pIPLst->pHead;

   return (0);

} // impResetIPLstCurPtr()

char *impGetNextIPLstItem (PIPLIST pIPLst)
{
   PIPLST_NODE pTmpIPNode;

   if (pIPLst->pCur == NULL)
      return (NULL);

   pTmpIPNode = pIPLst->pCur;
   pIPLst->pCur = pIPLst->pCur->pNext;

   return (pTmpIPNode->szInxFile);

} // impGetNextIPLstItem()

int impParseINXFile (char *pszINXFileName, PINX_OBJ_LST pinxObjLst)
{
   int iRC;

   impInitializeINXObjLst (pinxObjLst);

   // ONLY will parse document type INX's currently !!!
   if (pszINXFileName[0] == 'D')
   {
      if ((iRC = impParseDocument (pszINXFileName, pinxObjLst)) != 0)
         return (iRC);
   }
   else
   {
      if ((iRC = impParseFolder (pszINXFileName, pinxObjLst)) != 0)
         return (iRC);
   }

   impResetInxLstCurPtr (pinxObjLst);

   return (0);

} // impParseINXFile()

int impResetInxLstCurPtr (PINX_OBJ_LST pinxObjLst)
{
   pinxObjLst->pCur = pinxObjLst->pHead;

   return (0);

} // impResetInxLstCurPtr()

int impInitializeINXObjLst (PINX_OBJ_LST pinxObjLst)
{
   //
   pinxObjLst->usItemCount = 0;
   pinxObjLst->pHead = NULL;
   pinxObjLst->pCur = NULL;
   pinxObjLst->pTail = NULL;

   return (0);

} // impInitializeINXObjLst()

// This folder parsing routine flattens a multi level folder
// structure.  It will performs this by putting all documents
// in the top level folder.
int impParseFolder (char *pszFolderPath, PINX_OBJ_LST pinxLst)
{
   char szLine[MAX_INX_LINE_LEN];
   char szKey[MAX_INX_KEY_LEN];
   char szVal[MAX_NUM_OF_INX_VAL][MAX_INX_VAL_LEN];
   FILE *fp;
   int iAttrCount;
   PINX_OBJ_NODE pinxObj;

   // Open .INX file
   if ((fp = fopen (pszFolderPath, "r")) == NULL)
   {
      return (-1);
   }

   // Allocate new node for folder object data
   pinxObj = (PINX_OBJ_NODE) malloc (sizeof(INX_OBJ_NODE));

   // Read file line by line
   iAttrCount = 0;
   while (impfgets (szLine, sizeof(szLine), fp) != NULL)
   {
      impParseINXLine (szLine, szKey, szVal, MAX_NUM_OF_INX_VAL);

      if (stricmp (szKey, INXKEY_BEGIN_FOLDER) == 0)
         pinxObj->objType = 'F';
      else if (stricmp (szKey, INXKEY_CLASS) == 0)
         strcpy (pinxObj->classname, szVal[0]);
      else if (stricmp (szKey, INXKEY_ATTR_COUNT) == 0)
         pinxObj->attrcnt = atoi (szVal[0]);
      else if (stricmp (szKey, INXKEY_ATTR) == 0)
      {
         if (iAttrCount < MAX_NUM_OF_ATTR)
         {
            strcpy (pinxObj->attr[iAttrCount].name, szVal[0]);
            strcpy (pinxObj->attr[iAttrCount].value, szVal[1]);
            pinxObj->attr[iAttrCount].findex = FALSE;
            iAttrCount++;
         }
      }
      else if (stricmp (szKey, INXKEY_ATTR_INDEX) == 0)
      {
         if (iAttrCount < MAX_NUM_OF_ATTR)
         {
            strcpy (pinxObj->attr[iAttrCount].name, szVal[0]);
            strcpy (pinxObj->attr[iAttrCount].value, szVal[1]);
            pinxObj->attr[iAttrCount].findex = TRUE;
            iAttrCount++;
         }
      }
      else if (stricmp (szKey, INXKEY_BEGIN_NOTE) == 0)
      {
         pinxObj->note = malloc(MAX_INX_NOTE_LEN);
         strcpy (pinxObj->note, szVal[0]);
         strcat (pinxObj->note, "\n");
      }
      else if (stricmp (szKey, INXKEY_NOTE_LINE) == 0)
      {
         strcat (pinxObj->note, szVal[0]);
         strcat (pinxObj->note, "\n");
      }
      else if (stricmp (szKey, INXKEY_END_NOTE) == 0)
         realloc (pinxObj->note, strlen (pinxObj->note));
      else if (stricmp (szKey, INXKEY_END_FOLDER) == 0)
         continue;
      else if (stricmp (szKey, INXKEY_FOLDERITEM) == 0)
      {
         if (szVal[0][0] == 'D')
            impParseDocument (szVal[0], pinxLst);
         else
            impParseFolder (szVal[0], pinxLst);
      }
   }

   // Close document inx file
   fclose (fp);

   // If first item is a folder
   if (impIsFirstInxLstItemAFolder (pinxLst))
      impReplaceFirstInxLstItem (pinxLst, pinxObj);
   else
      impAddInxObjToFrontOfLst (pinxLst, pinxObj);

   return (0);

} // impParseFolder()

int impParseDocument (char *pszDocPath, PINX_OBJ_LST pinxLst)
{
   char szLine[MAX_INX_LINE_LEN];
   char szKey[MAX_INX_KEY_LEN];
   char szVal[MAX_NUM_OF_INX_VAL][MAX_INX_VAL_LEN];
   FILE *fp;
   int iAttrCount;
   PINX_OBJ_NODE pinxObj;

   // Open .INX file
   if ((fp = fopen (pszDocPath, "r")) == NULL)
   {
      return (-1);
   }

   // Allocate new node for document object data
   pinxObj = (PINX_OBJ_NODE) malloc (sizeof(INX_OBJ_NODE));

   // Read file line by line
   iAttrCount = 0;
   while (impfgets (szLine, sizeof(szLine), fp) != NULL)
   {
      impParseINXLine (szLine, szKey, szVal, MAX_NUM_OF_INX_VAL);

      if (stricmp (szKey, INXKEY_BEGIN_DOCUMENT) == 0)
         pinxObj->objType = 'D';
      else if (stricmp (szKey, INXKEY_CLASS) == 0)
         strcpy (pinxObj->classname, szVal[0]);
      else if (stricmp (szKey, INXKEY_ATTR_COUNT) == 0)
         pinxObj->attrcnt = atoi (szVal[0]);
      else if (stricmp (szKey, INXKEY_ATTR) == 0)
      {
         if (iAttrCount < MAX_NUM_OF_ATTR)
         {
            strcpy (pinxObj->attr[iAttrCount].name, szVal[0]);
            strcpy (pinxObj->attr[iAttrCount].value, szVal[1]);
            pinxObj->attr[iAttrCount].findex = FALSE;
            iAttrCount++;
         }
      }
      else if (stricmp (szKey, INXKEY_ATTR_INDEX) == 0)
      {
         if (iAttrCount < MAX_NUM_OF_ATTR)
         {
            strcpy (pinxObj->attr[iAttrCount].name, szVal[0]);
            strcpy (pinxObj->attr[iAttrCount].value, szVal[1]);
            pinxObj->attr[iAttrCount].findex = TRUE;
            iAttrCount++;
         }
      }
      else if (stricmp (szKey, INXKEY_BEGIN_NOTE) == 0)
      {
         pinxObj->note = malloc(MAX_INX_NOTE_LEN);
         strcpy (pinxObj->note, szVal[0]);
         strcat (pinxObj->note, "\n");
      }
      else if (stricmp (szKey, INXKEY_NOTE_LINE) == 0)
      {
         strcat (pinxObj->note, szVal[0]);
         strcat (pinxObj->note, "\n");
      }
      else if (stricmp (szKey, INXKEY_END_NOTE) == 0)
         realloc (pinxObj->note, strlen (pinxObj->note) + 200);
      else if (stricmp (szKey, INXKEY_IMAGE) == 0)
      {
         strcpy (pinxObj->image, szVal[0]);
      }
      else if (stricmp (szKey, INXKEY_END_DOCUMENT) == 0)
         continue;
   }

   // Close document inx file
   fclose (fp);

   // Attach new node to the list
   impAddInxObjToLst (pinxLst, pinxObj);

   return (0);

} // impParseDocument()

int impAddInxObjToLst (PINX_OBJ_LST pinxLst, PINX_OBJ_NODE pinxObj)
{
   if (pinxLst->usItemCount == 0) // First node in list
   {
      pinxLst->pHead = pinxObj;
      pinxLst->pCur = pinxLst->pHead;
      pinxLst->pTail = pinxLst->pHead;
   }
   else
   {
      pinxLst->pTail->pNext = pinxObj;
      pinxLst->pTail = pinxObj;
   }

   pinxLst->usItemCount++;
   pinxLst->pTail->pNext = NULL;

   return (0);

} // impAddInxObjToLst()

int impAddInxObjToFrontOfLst (PINX_OBJ_LST pinxLst, PINX_OBJ_NODE pinxObj)
{
   if (pinxLst->usItemCount == 0)
   {
      pinxLst->pHead = pinxObj;
      pinxLst->pCur = pinxObj;
      pinxLst->pTail = pinxObj;
      pinxObj->pNext = NULL;
   }
   else
   {
      pinxObj->pNext = pinxLst->pHead;
      pinxLst->pHead = pinxObj;
   }

   pinxLst->usItemCount++;

   return (0);

} // impAddInxObjToLst()

int impReplaceFirstInxLstItem (PINX_OBJ_LST pinxLst, PINX_OBJ_NODE pinxObj)
{
   PINX_OBJ_NODE pTmp;

   // Delete first item
   pTmp = pinxLst->pHead->pNext;
   free (pinxLst->pHead);
   pinxLst->pHead = pTmp;
   pinxLst->usItemCount--;

   // Add Item to front
   impAddInxObjToFrontOfLst (pinxLst, pinxObj);

   return (0);

} // impReplaceFirstInxLstItem()

BOOL impIsFirstInxLstItemAFolder (PINX_OBJ_LST pinxLst)
{
   if (pinxLst->pHead->objType == 'F')
      return (TRUE);
   else
      return (FALSE);

} // impIsFirstInxLstItemAFolder()

int impParseINXLine (
   char *pszLine, 
   char *pszKey,
   char szVal[MAX_NUM_OF_INX_VAL][MAX_INX_VAL_LEN],
   USHORT usNumVal)
{
   char *pszCur, *pszNext;

   if (((pszCur = strchr (pszLine, INX_TAG_DELIMITER)) == NULL) ||
       ((pszNext = strchr (pszLine, INX_TAG_PARAM_DELIMITER)) == NULL))
      return (-1);

   strncpy (pszKey, pszCur, (int)((ULONG)pszNext - (ULONG)pszCur));
   pszKey[(int)((ULONG)pszNext-(ULONG)pszCur)]='\0';

   if ((stricmp (pszKey, INXKEY_ATTR) == 0) ||
       (stricmp (pszKey, INXKEY_ATTR_INDEX) == 0))
   {
      pszCur = pszNext + 1;
      pszNext = strchr (pszCur, INX_TAG_PARAM_DELIMITER);
      strncpy (szVal[0], pszCur, (int)((ULONG)pszNext - (ULONG)pszCur));
      szVal[0][(int)((ULONG)pszNext-(ULONG)pszCur)]='\0';

      pszCur = pszNext + 1;
      strcpy (szVal[1], pszCur);
   }
   else // only one parameter for these tags
   {
      pszCur = pszNext + 1;
      strcpy (szVal[0], pszCur);
   }

/* Tried to get fancy!!!  This don't work when '.' is allowed in a legal string.
   for (i=0; ((i < (INT)usNumVal) && (pszNext != NULL)); i++)
   {
      pszCur = pszNext + 1;
      pszNext = strchr (pszCur, INX_TAG_PARAM_DELIMITER);
      if (pszNext == NULL)
         strcpy (szVal[i], pszCur);
      else
         strncpy (szVal[i], pszCur, (int)((ULONG)pszNext - (ULONG)pszCur));
         szVal[i][(int)((ULONG)pszNext-(ULONG)pszCur)]='\0';
   }
*/
   return (0);

} // impParseINXLine()

int impDestroyINXObjLst (PINX_OBJ_LST pinxLst)
{
   PINX_OBJ_NODE pCurNode, pNextNode;
   int i;

   pCurNode = pinxLst->pHead;

   // Destroy nodes
   for (i=0; i < (int)pinxLst->usItemCount; i++)
   {
      // Assign pointer to next node in list
      pNextNode = pCurNode->pNext;

      // Delete any associated image files before deleting node
      if (pCurNode->objType == 'D')
      {
         remove (pCurNode->image);
      }

      // Free memory allocated for note and inx node
      free (pCurNode->note);
      free (pCurNode);

      pCurNode = pNextNode;
   } 

   // Reset list counters and pointers
   pinxLst->usItemCount = 0;
   pinxLst->pHead = NULL;
   pinxLst->pCur = NULL;
   pinxLst->pTail = NULL;

   return (0);

} // impdestroyINXObj()

int impInsertInxLstIntoLN (PINX_OBJ_LST pinxLst, char *pszLNotesDefaultDB)
{
   // Local data declarations.
   DBHANDLE             db_handle;           // database handle
   STATUS               error;               // return code from API calls
   PINX_OBJ_NODE        pinxTmpObj;
   char                 szErr[132];

   // Open the database.  If object is a standalone document then
   // use the default import database.  Otherwise, if a folder object
   // then use the folder class name as the database to open
   if (impIsFirstInxLstItemAFolder (pinxLst))
   {
      if (error = NSFDbOpen (pinxLst->pHead->classname, &db_handle))
      {
         sprintf (szErr,
            "Could not open the <%s> database in Lotus Notes", pinxLst->pHead->classname);
         return (-1);
      }
      impGetNextInxLstItem (pinxLst);
   }
   else
   {
      if (error = NSFDbOpen (pszLNotesDefaultDB, &db_handle))
      {
         sprintf (szErr, 
            "Could not open the <%s> database in Lotus Notes", pszLNotesDefaultDB);
         AddInLogMsg (ADDIN_MSG_FMT, szErr);
         return (-1);
      }
   }

   while ((pinxTmpObj = impGetNextInxLstItem (pinxLst)) != NULL)
   {
      if (impAddInxItemToLN (&db_handle, pinxTmpObj) != 0)
      {
         AddInLogMsg (ADDIN_MSG_FMT, "Error trying to add INX item to LNotes.");
      }
   }

   // Close the database
   if (error = NSFDbClose (db_handle))
      return (-1);

   // End of function.
   return (0);

} // impinsertInxLstIntoLN()

int impAddInxItemToLN (DBHANDLE *pDbHndl, PINX_OBJ_NODE pinxObj)
{
   NOTEHANDLE           note_handle;         // note handle
   STATUS               error;               // return code from API calls
   char                 szErr[132];
   int                  i;
   char                 szTmpAttrName[MAX_ATTRNAME_LEN];
   CHAR                 parm[128];
   CHAR                 szLogFile[MAX_FULL_PATHNAME_LEN];
   NOTEID               noteID;
   CHAR                 szDBPath[MAXPATH];
   CHAR                 szOptionString[MAXPATH+32];

   // Create a new data note.
   if (error = NSFNoteCreate (*pDbHndl, &note_handle))
   {
      return (-1);
   }

   // Write the form name to the note.
   if (error = NSFItemSetText (note_handle, "Form",
                      pinxObj->classname, MAXWORD))
   {
      NSFNoteClose (note_handle);
      AddInLogMsg (ADDIN_MSG_FMT, "Error writing form type to lotus note.");
      return (-1);
   }

   // Write INX object's attributes to the note.
   for (i=0; i < pinxObj->attrcnt; i++)
   {
      strcpy (szTmpAttrName, pinxObj->attr[i].name);
      impStrChReplace (szTmpAttrName, ' ', '_');
      if (error = NSFItemSetText (
                     note_handle,
                     szTmpAttrName,
                     pinxObj->attr[i].value,
                     MAXWORD))
      {
         AddInLogMsg (ADDIN_MSG_FMT, "Error writing inx attribute to lotus note.");
      }
   }

   // Write INX object's note to the note
   impAddIP2NoteToLN (note_handle, pinxObj->note);

   // Convert MODCA-P to PCX
   // ******* !!!! Warning cannot redirect output of this rexx command without getting an
   //         !!!! error.
   strcpy (szLogFile, pinxObj->image);
   impEnforceExtension (szLogFile, ".log");
   sprintf (parm, "CONVIMG.CMD %s %s %s %s",
      pinxObj->image, TEMPORARY_PCX_FILENAME, OIS_PCX_FORMAT, OIS_NO_COMPRESSION);
   system (parm);

   // Add the note to the database.
   if (error = NSFNoteUpdate (note_handle, 0))
   {
      NSFNoteClose (note_handle);
      return (-1);
   }

   // Get note ID to send in msg to LNDIFAX.  Must be done after updating note.
   NSFNoteGetInfo (note_handle, _NOTE_ID, &noteID);

   // Deallocate the new note from memory.
   if (error = NSFNoteClose (note_handle))
   {
      return (-1);
   }

   // Send image to LNDIFAX for import with name of note DB and the note ID
   if (NSFDbPathGet (*pDbHndl, szDBPath, NULL))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Could not get DB Path");
      return (-1);
   }

   sprintf (szOptionString, "%s %ld", szDBPath, noteID);
   if (impSendImgToLNDIFAX (TEMPORARY_PCX_FILENAME, szOptionString))
   {
      sprintf (szErr, "Error: Could not add <%s> to the image field.", pinxObj->image);
      AddInLogMsg (ADDIN_MSG_FMT, szErr);
      return (-1);
   }

   return (0);

} // impAddInxItemToLN()

int impAddIP2NoteToLN (NOTEHANDLE noteHndl, char *pszNote)
{
   char *pszCur;
   char *pszNext;

   pszCur = pszNote;
   pszNext = strchr (pszCur, '\n');
   while (pszNext != NULL)
   {
      if (NSFItemAppendTextList (
         noteHndl, LNOTES_IP2_NOTES_FIELD,
         pszCur, (WORD)((ULONG)pszNext-(ULONG)pszCur), TRUE))
      {
         return (-1);
      }
      pszCur = pszNext + 1;
      pszNext = strchr (pszCur, '\n');
   }

/*
   if (error = NSFItemSetText (
                  note_handle,
                  LNOTES_IP2_NOTES_FIELD,
                  pinxObj->note,
                  MAXWORD))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error writing IP2 notes field to lotus note.");
   }
*/

   return (0);

} // impAddIP2NoteToLN()

int impExpandPath (char *pszFileName, char *pszFullPath)
{
   USHORT               cbPath, usDisk;
   ULONG                ulDrives;

   DosQCurDisk (&usDisk, &ulDrives);
   cbPath = MAX_FULL_PATHNAME_LEN;
   pszFullPath[0] = '\\';                // Needed due to apparent bug w/ DosQCurDir()
   DosQCurDir (usDisk, &pszFullPath[1], &cbPath);
   strcat (pszFullPath, "\\");
   strcat (pszFullPath, pszFileName);

   return (0);

} // impExpandPath()

int impSendImgToLNDIFAX (char *pszImageFile, char *pszOptionStr)
{
   DBHANDLE             db_handle;           // DB HANDLE
   NOTEHANDLE           note_handle;         // note handle
   STATUS               error;               // return code from API calls
   char                 szErr[132];
   char                 szFullPath[MAX_FULL_PATHNAME_LEN];

   // Open the mail.box database.
   if (error = NSFDbOpen ("mail.box", &db_handle))
   {
      sprintf (szErr, "Could not open the <mail.box> database in Lotus Notes");
      AddInLogMsg (ADDIN_MSG_FMT, szErr);
      return (-1);
   }

   // Create a new data note.
   if (error = NSFNoteCreate (db_handle, &note_handle))
   {
      NSFDbClose (db_handle);
      return (-1);
   }

   // Write the form name to the note.
   if (error = NSFItemSetText (note_handle, FIELD_FORM, "Memo", MAXWORD))
   {
      NSFNoteClose (note_handle);
      NSFDbClose (db_handle);
      sprintf (szErr, "Error: Form of type Memo does not exist.");
      AddInLogMsg (ADDIN_MSG_FMT, szErr);
      return (-1);
   }

   // Fill in SendTo field
   if (error = NSFItemSetText (note_handle, MAIL_SENDTO_ITEM, 
      LNDI_FAX_ADDRESS, MAXWORD))
   {
      NSFNoteClose (note_handle);
      NSFDbClose (db_handle);
      sprintf (szErr, "Error: could not insert sendto field.");
      AddInLogMsg (ADDIN_MSG_FMT, szErr);
      return (-1);
   }

   // Fill in recipients field
   if (error = NSFItemSetText (note_handle, MAIL_RECIPIENTS_ITEM,
      LNDI_FAX_ADDRESS, MAXWORD))
   {
      NSFNoteClose (note_handle);
      NSFDbClose (db_handle);
      sprintf (szErr, "Error: could not insert recipient field.");
      AddInLogMsg (ADDIN_MSG_FMT, szErr);
      return (-1);
   }

   // Fill in From field
   if (error = NSFItemSetText (note_handle, MAIL_FROM_ITEM, LNDI_FAX_REPLY_ADDRESS, MAXWORD))
   {
      NSFNoteClose (note_handle);
      NSFDbClose (db_handle);
      sprintf (szErr, "Error: could not insert From field.");
      AddInLogMsg (ADDIN_MSG_FMT, szErr);
      return (-1);
   }

   // Fill in Subject field
   if (error = NSFItemSetText (note_handle, MAIL_SUBJECT_ITEM, pszOptionStr, MAXWORD))
   {
      NSFNoteClose (note_handle);
      NSFDbClose (db_handle);
      sprintf (szErr, "Error: could not insert subject field.");
      AddInLogMsg (ADDIN_MSG_FMT, szErr);
      return (-1);
   }

   // Write CIF IMPORT FIELD MARKER
   if (error = NSFItemSetText (
                  note_handle,
                  CIFIMPORT_FIELD_MARKER_STR,
                  "trash",
                  MAXWORD))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error writing CIF_IMPORT_FIELD_MARKER");
   }

   // Write LNDIFAX reply option string
   if (error = NSFItemSetText (
                  note_handle,
                  LNDI_FAX_REPLY_OPTION_FIELD,
                  pszOptionStr,
                  MAXWORD))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error writing CIF_IMPORT_FIELD_MARKER");
   }

   // Attach image file
   impExpandPath (pszImageFile, szFullPath);
   if (NSFNoteAttachFile (note_handle,       
      ITEM_NAME_ATTACHMENT, strlen(ITEM_NAME_ATTACHMENT),
      szFullPath, pszImageFile, COMPRESS_NONE))
   {
      NSFNoteClose (note_handle);
      NSFDbClose (db_handle);
      AddInLogMsg (ADDIN_MSG_FMT, "Error on NSFNoteAttachFile()");
      return (-1);
   }

   // Add the note to the database.
   if (error = NSFNoteUpdate (note_handle, 0))
   {
      NSFNoteClose (note_handle);
      NSFDbClose (db_handle);
      AddInLogMsg (ADDIN_MSG_FMT, "Error on NSFNoteUpdate()");
      return (-1);
   }

   // Deallocate the new note from memory.
   if (error = NSFNoteClose (note_handle))
   {
      NSFDbClose (db_handle);
      return (-1);
   }

   // Close the database
   if (error = NSFDbClose (db_handle))
      return (-1);

   return (0);

} // impSendImgToLNDIFAX()

PINX_OBJ_NODE impGetNextInxLstItem (PINX_OBJ_LST pinxLst)
{
   PINX_OBJ_NODE pTmp;

   if (pinxLst->pCur == NULL)
      return (NULL);

   pTmp = pinxLst->pCur;
   pinxLst->pCur = pinxLst->pCur->pNext;

   return (pTmp);

} // impGetNextInxLstItem()

int impStrChReplace (char *pszStr, char oldCh, char newCh)
{
   while (*pszStr != '\0')
   {
      if (*pszStr == oldCh)
         *pszStr = newCh;

      pszStr++;
   }

   return (0);

} // impStrChReplace()
