//
//      Purpose:
//              Main module for the CIF import server task.  Used to import CIF
//              data objects into Lotus Notes.


// OS and C include files
#define INCL_DOSPROCESS
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

// Notes API include files
#include <global.h>
#include <addin.h>
#include <nsfdb.h>
#include <nsfdata.h>
#include <nsfnote.h>
#include <nsfsearc.h>
#include <ostime.h>
#include <osenv.h>
#include <osmem.h>
#include <osfile.h>
#include <stdnames.h>

// Local include files
#include "imptask.h"
#include "impRCstr.h"

// Function prototypes
int impInitializeTask (INIT_PARAMS *pParams);
int impCleanupTask (void);
int impGetInitParams (INIT_PARAMS *pParams);
int impGetCmdPrmptCh (void);
int impDosChDir (char *pszDir);

char *impfgets (char *pszStr, int n, FILE *fp);
void impEnforceExtension(char *szPath,char *szExt);
int impMoveFile (char *szSrcFile, char *szDestFile);

char *impStrncpyc (char *pDest, char *pSrc, int dest_len, char ch);
int impProcessLNDIFAXReply (void);
STATUS far PASCAL impActionSearchFunc (
   void *pParam,
   SEARCH_MATCH *searchInfo,
   ITEM_TABLE *summaryInfo);
int impCopyAttachedFiles (NOTEHANDLE fromNote, NOTEHANDLE toNote);
int impExpandPath (char *pszFileName, char *pszFullPath);
int impGetAttachedFilename (BLOCKID valBlkID, DWORD len, CHAR *szFilename);
int impGetReplyInfo (NOTEHANDLE noteHndlFrom, DBHANDLE *pDbHndlTo, NOTEHANDLE *pNoteHndlTo);
int impCopyEmbeddedIcon (NOTEHANDLE noteHndlFrom, NOTEHANDLE notHndlTo);

// Standard entry for all Notes server add-in tasks
STATUS far PASCAL  AddInMain (HMODULE hModule, int argc, char *argv[])
{

   INIT_PARAMS params;
   char szMsg[132];
   int iLoopCount=0;
   BOOL fLoop=TRUE;
   char chCmdPrmpt;

   // Initialize this task.
   if (impInitializeTask (&params) != 0)
      return (1);
   sprintf (szMsg, "Interval processing = <%d>.", params.wakeupInterval);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);
   sprintf (szMsg, "Maximum loops = <%d>.", params.iMaxServerLoops);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);

   // Change current directory to the import CIF dir
   impDosChDir (params.szCIFDir);

   // Begin the main loop.  We give up control to the server at the start of
   // each iteration, and get control back when the server says it is OK to
   // proceed.  The server returns TRUE when it is time to shut down this task.
   // Main loop will be exited after the specifed number of interations if
   // "params.maxServerLoops" is not equal to 0.
   while (!AddInIdle() && fLoop)
   {
      if (AddInSecondsHaveElapsed(params.wakeupInterval))
      {
         AddInSetStatus(ADDIN_MSG_FMT, "Processing");

         // Check for LNDI FAX reply memo
         if (impProcessLNDIFAXReply () == 0)
         {
            AddInLogMsg (ADDIN_MSG_FMT, "LNDIFAX reply message was processed.");
         }

         // Reset status
         AddInSetStatus (ADDIN_MSG_FMT, "Idle");

         // Check if maximum processing loops have been reached
         if (params.iMaxServerLoops != 0)
         {
            iLoopCount++;
            if (iLoopCount >= params.iMaxServerLoops)
            {
               sprintf (szMsg,
                  "[%d] loops completed.  Maximum processing loops reached.",
                  params.iMaxServerLoops);
               AddInLogMsg (ADDIN_MSG_FMT, szMsg);
               fLoop = FALSE;
            }
         }
      }
      else if (AddInSecondsHaveElapsed (1)) // Check for console commands every 1 second
      {
         while ((chCmdPrmpt=(char)impGetCmdPrmptCh()) != (char)0)
         {
            if (chCmdPrmpt == 'q')
            {
               AddInLogMsg (ADDIN_MSG_FMT, "Console termination requested.");
               fLoop = FALSE;
               break;
            }
         }
      }

   } // End of main task loop.

   // We get here when the server notifies us that it is time to terminate.
   // This is usually when the user has entered "quit" to the server console.
   // Clean up anything we have been doing.  */
   impCleanupTask ();

   // End of add-in task.  We must "return" here rather than "exit".
   return (NOERROR);

} // End AddInMain()

int impDosChDir (char *pszDir)
{
   char *pszTmp;

   strupr (pszDir);

   if ((pszTmp = strchr(pszDir, ':')) != NULL)
   {
      DosSelectDisk (pszTmp[-1] - 'A' + 1);
   }
   DosChDir (pszDir, 0L);

   return (0);

} // impDosChDir()

int impGetCmdPrmptCh (void)
{
   if (kbhit ())
   {
      // Get char
      return (getche());
   }
   else
      return (0);

} // impGetCmdPrmptStr()

int impMoveFile (char *szSrcFile, char *szDestFile)
{
   DosCopy (szSrcFile, szDestFile, DCPY_EXISTING, 0L);
   remove (szSrcFile);

   return (0);

} // impMoveFile()

int impInitializeTask (INIT_PARAMS *pParams)
{
   impGetInitParams (pParams);

   AddInSetStatus (ADDIN_MSG_FMT, "Initializing");
   AddInLogMsg (ADDIN_MSG_FMT, "CIF Import Task: Initialization complete.");
   AddInSetStatus (ADDIN_MSG_FMT, "Idle");

   return (0);

} // impInitializeTask ()

int impCleanupTask (void)
{

   AddInSetStatus(ADDIN_MSG_FMT, "Terminating");
   AddInLogMsg(ADDIN_MSG_FMT, "CIF Import Task: Termination complete.");

   return (0);

} // impCleanupTask ()

int impGetInitParams (INIT_PARAMS *pParams)
{
   char szLine[132];
   FILE *fp;
   char szKey[MAX_INI_KEY_LEN];
   char szValue[MAX_INI_VALUE_LEN];

   // Open ini file
   if ((fp = fopen (IMPORT_TASK_INIT_FILENAME, "r")) == NULL)
      return (-1);

   // Initialize input param
   memset (pParams, '\0', sizeof(INIT_PARAMS));
   pParams->wakeupInterval = INIDEF_IMPTASK_WAKEUP_INTERVAL;
   pParams->szCIFSaveDir[0] = '\0';
   pParams->iMaxServerLoops = 0;

   // Parse ini file
   while (impfgets (szLine, sizeof(szLine), fp) != NULL)
   {
      szKey[0] = '\0';
      szValue[0] = '\0';

      if (sscanf (szLine, "%s %s", szKey, szValue) == 0)
         continue;

      if (stricmp (szKey, INIKEY_COMMENT_MARKER) == 0)
      {
         continue;
      }
      else if (stricmp (szKey, INIKEY_IMPTASK_WAKEUP_INTERVAL) == 0)
      {
         pParams->wakeupInterval = atoi (szValue);
      }
      else if (stricmp (szKey, INIKEY_IMPTASK_CIF_DIR) == 0)
      {
         strcpy (pParams->szCIFDir, szValue);
      }
      else if (stricmp (szKey, INIKEY_IMPTASK_CIF_SAVE_DIR) == 0)
      {
         strcpy (pParams->szCIFSaveDir, szValue);
      }
      else if (stricmp (szKey, INIKEY_LNOTES_DEFAULT_DB) == 0)
      {
         strcpy (pParams->szLNotesDefaultDB, szValue);
      }
      else if (stricmp (szKey, INIKEY_MAX_SERVER_LOOPS) == 0)
      {
         pParams->iMaxServerLoops = atoi(szValue);
      }
   }

   // Close file
   fclose (fp);

   return (0);

} // impGetInitParams()

char *impfgets (char *pszStr, int n, FILE *fp)
{
   char *pszRC, *pszTmp;

   if ((pszRC = fgets (pszStr, n, fp)) == NULL)
      return (NULL);

   pszTmp = strchr (pszStr, '\n');
   pszTmp[0] = '\0';

   return (pszTmp);

} // impfgets()

void impEnforceExtension(char *szPath,char *szExt)
{
   char *p;

   p = strchr(szPath,'.');
   if (p != NULL)
      *p = '\0';

   if (szExt[0] != '.')
      strcat(szPath,".");

   strcat(szPath,szExt);
   return;
}

char *impStrncpyc (char *pDest, char *pSrc, int dest_len, char ch)
{
   char *p = pDest;
   register int i = 1, n = dest_len;

   while (*pSrc != '\0' && *pSrc != ch && i++ < n)
   {
      *pDest++ = *pSrc++;
   }
   *pDest = '\0';

   return(p);

} // impStrncpyc()

int impProcessLNDIFAXReply ()
{
   DBHANDLE db_handle;
   FORMULAHANDLE formula_handle;
   ACTION_SEARCH_ROUTINE_PARAM actionParam;
   char szAddr[132];
   char formula[80];
   WORD wdc;
   char szErr[132];
   STATUS error;

   // Open LNDIFAX reply DB
   sprintf (szAddr, "MAIL\\%s", LNDI_FAX_REPLY_ADDRESS);
   if (error = NSFDbOpen (szAddr, &db_handle))
   {
      sprintf (szErr, "Could not open the LNDI FAX reply database in Lotus Notes");
      AddInLogMsg (ADDIN_MSG_FMT, szErr);
      return (-1);
   }

   // Formulate filter for search
   sprintf (formula,"@IsAvailable(%s)", CIFIMPORT_FIELD_MARKER_STR);
   if (error = NSFFormulaCompile (NULL,0,formula,strlen(formula),&formula_handle,
      &wdc,&wdc,&wdc,&wdc,&wdc,&wdc))
   {
      NSFDbClose (db_handle);
      return (-1);
   }

   // Search for a reply from LNDIFAX until timeout occurs
   actionParam.pReplyDbHndl = &db_handle;
   actionParam.fFound = FALSE;
   NSFSearch (db_handle, formula_handle, NULL, 0, NOTE_CLASS_DATA, NULL,
      impActionSearchFunc, &actionParam, NULL);

//   NSFSearch (db_handle, NULLHANDLE, NULL, 0, NOTE_CLASS_DATA, NULL,
//      impActionSearchFunc, &actionParam, NULL);

   // Free memory from formula compile
   OSMemFree (formula_handle);
   NSFDbClose (db_handle);

   if (actionParam.fFound)
      return (0);
   else
      return (1);

} // impProcessLNDIFAXReply()

STATUS far PASCAL impActionSearchFunc (
   void *pParam,
   SEARCH_MATCH *searchInfo,
   ITEM_TABLE *summaryInfo)
{
   ACTION_SEARCH_ROUTINE_PARAM *pActionParam;
   NOTEHANDLE noteHndlReply;
   NOTEHANDLE noteHndlNew;
   DBHANDLE dbHndlNew;
   STATUS error;

   pActionParam = pParam;

   // Check if this note is a true match
   if (searchInfo->MatchesFormula != SE_FMATCH)
      return (0);

   // Open note
   if (error = NSFNoteOpen (*(pActionParam->pReplyDbHndl),
      searchInfo->ID.NoteID, 0, &noteHndlReply))
   {
      return (error);
   }

   // Check if this is Truly a reply from CIF import task via LNDIFAX
   if (NSFItemIsPresent (
      noteHndlReply, CIFIMPORT_FIELD_MARKER_STR, strlen(CIFIMPORT_FIELD_MARKER_STR)))
   {
       pActionParam->fFound = TRUE;
       AddInLogMsg (ADDIN_MSG_FMT, "LNDIFAX import reply message found.");
   }
   else
   {
      AddInLogMsg (ADDIN_MSG_FMT, "This is not a CIF IMPORT item.  Item will be deleted.");
      NSFNoteClose (noteHndlReply);
      NSFNoteDelete (*(pActionParam->pReplyDbHndl), searchInfo->ID.NoteID, UPDATE_FORCE);
      return (-1);
   }

   // Get DB and note handle for new note
   if (impGetReplyInfo (noteHndlReply, &dbHndlNew, &noteHndlNew))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error getting note handle and DB handle from reply.");
      NSFNoteClose (noteHndlReply);
      NSFNoteDelete (*(pActionParam->pReplyDbHndl), searchInfo->ID.NoteID, UPDATE_FORCE);
      return (-1);
   }

   // Copy body field with imbedded info to new note
   if (impCopyEmbeddedIcon (noteHndlReply, noteHndlNew))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error copying embedded icon.");
      NSFNoteClose (noteHndlReply);
      NSFNoteClose (noteHndlNew);
      NSFDbClose (dbHndlNew);
      NSFNoteDelete (*(pActionParam->pReplyDbHndl), searchInfo->ID.NoteID, UPDATE_FORCE);
      return (-1);
   }

   // Copy attached file info to new note
   if (impCopyAttachedFiles (noteHndlReply, noteHndlNew))
   {
      NSFNoteClose (noteHndlReply);
      NSFNoteClose (noteHndlNew);
      NSFDbClose (dbHndlNew);
      NSFNoteDelete (*(pActionParam->pReplyDbHndl), searchInfo->ID.NoteID, UPDATE_FORCE);
      return (-1);
   }

   // Deallocate the new note from memory.
   if (NSFNoteClose (noteHndlReply))
   {
      NSFNoteClose (noteHndlNew);
      NSFDbClose (dbHndlNew);
      NSFNoteDelete (*(pActionParam->pReplyDbHndl), searchInfo->ID.NoteID, UPDATE_FORCE);
      return (-1);
   }

   // Update and close new note and its associated DB
   if (NSFNoteUpdate (noteHndlNew, 0))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error on NSFNoteUpdate()");
      NSFNoteClose (noteHndlNew);
      NSFDbClose (dbHndlNew);
      NSFNoteDelete (*(pActionParam->pReplyDbHndl), searchInfo->ID.NoteID, UPDATE_FORCE);
      return (-1);
   }
   NSFNoteClose (noteHndlNew);
   NSFDbClose (dbHndlNew);

   // Delete reply note
   NSFNoteDelete (*(pActionParam->pReplyDbHndl), searchInfo->ID.NoteID, UPDATE_FORCE);

   return (0);

} // impActionSearchFunc()

int impGetReplyInfo (NOTEHANDLE noteHndlFrom, DBHANDLE *pDbHndlTo, NOTEHANDLE *pNoteHndlTo)
{
   NOTEID noteID;
   char szDbNameNew[32];
   char szText[132];

   // Get DB name and note id
   if (NSFItemGetText (noteHndlFrom,
      LNDI_FAX_REPLY_OPTION_FIELD, szText, sizeof(szText)) == 0)
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Could not get text from LNDIFAX_REPLY_OPTION_FIELD.");
      return (-1);
   }

   sscanf (szText, "%s %ld", szDbNameNew, &noteID);

   // Open DB
   if (NSFDbOpen (szDbNameNew, pDbHndlTo))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Could not open note DB.");
      return (-1);
   }

   // Open note
   if (NSFNoteOpen (*pDbHndlTo, noteID, 0, pNoteHndlTo))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Could not open note.");
      NSFDbClose (*pDbHndlTo);
      return (-1);
   }

   return (0);

}  // impGetReplyInfo()

int impCopyEmbeddedIcon (NOTEHANDLE noteHndlFrom, NOTEHANDLE noteHndlTo)
{
   BLOCKID itemBlkID;
   WORD valDataType;
   BLOCKID valBlkID;
   DWORD valLen;

   if (NSFItemInfo (noteHndlFrom, MAIL_BODY_ITEM, strlen(MAIL_BODY_ITEM),
      &itemBlkID, &valDataType, &valBlkID, &valLen))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error getting embedded info.");
      return (-1);
   }

   if (NSFItemCopy (noteHndlTo, itemBlkID))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error copying body of embedded info.");
      return (-1);
   }

   return (0);

} // impCopyEmbeddedIcon()

int impCopyAttachedFiles (NOTEHANDLE fromNote, NOTEHANDLE toNote)
{
   BLOCKID itemBlkID;
   BLOCKID item2BlkID;
   WORD valDataType;
   BLOCKID valBlkID;
   DWORD valLen;
   char szFullPath[MAX_FULL_PATHNAME_LEN];
   char szFileName[MAX_FILENAME_LEN];
   STATUS error;
   char szErr[132];

   // Find first attached document
   if (error = NSFItemInfo (fromNote, ITEM_NAME_ATTACHMENT, strlen(ITEM_NAME_ATTACHMENT),
      &itemBlkID, &valDataType, &valBlkID, &valLen))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error finding attached item info.");
      return (error);
   }

   while (error == NOERROR)
   {
      if (impGetAttachedFilename (valBlkID, valLen, szFileName))
      {
         AddInLogMsg (ADDIN_MSG_FMT, "Error getting attached file name.");
      }
      else
      {
         // Extract first document from reply note to temporary doc
         if (error = NSFNoteExtractFile (fromNote, itemBlkID, szFileName, NULL))
         {
            sprintf (szErr, "Error extracting LNDI document.");
            AddInLogMsg (ADDIN_MSG_FMT, szErr);
         }

         // Attach first document to my note
         impExpandPath (szFileName, szFullPath);
         if (error = NSFNoteAttachFile (toNote,
            ITEM_NAME_ATTACHMENT, strlen(ITEM_NAME_ATTACHMENT),
            szFullPath, szFileName, COMPRESS_NONE))
         {
            AddInLogMsg (ADDIN_MSG_FMT, "Error on NSFNoteAttachFile()");
         }

         // Delete temporary doc on file
         remove (szFileName);
      }

      // Find next attached document
      if ((error = NSFItemInfoNext (
         fromNote, itemBlkID, ITEM_NAME_ATTACHMENT, strlen(ITEM_NAME_ATTACHMENT),
         &item2BlkID, &valDataType, &valBlkID, &valLen)) == NOERROR)
      {
         itemBlkID = item2BlkID;
      }

   } // end while

   return (0);

} // impCopyAttachedFiles

int impExpandPath (char *pszFileName, char *pszFullPath)
{
   USHORT               cbPath, usDisk;
   ULONG                ulDrives;

   DosQCurDisk (&usDisk, &ulDrives);
   cbPath = MAX_FULL_PATHNAME_LEN;
   pszFullPath[0] = '\\';                // Needed due to apparent bug w/ DosQCurDir()
   DosQCurDir (usDisk, &pszFullPath[1], &cbPath);
   strcat (pszFullPath, "\\");
   strcat (pszFullPath, pszFileName);

   return (0);

} // impExpandPath()

int impGetAttachedFilename (BLOCKID valBlkID, DWORD len, CHAR *szFilename)
{
   FILEOBJECT *ptr;

   // Lock block
   ptr = OSLockBlock (FILEOBJECT, valBlkID);
   ptr = (FILEOBJECT *)((char *)ptr + 2);
   if (ptr->Header.ObjectType == OBJECT_FILE)
   {
      strncpy (szFilename, ((char *)ptr + sizeof(FILEOBJECT)), ptr->FileNameLength);
      szFilename[ptr->FileNameLength] = '\0';
      OSUnlockBlock (valBlkID);
      return (0);
   }
   else
   {
      OSUnlockBlock (valBlkID);
      return (-1);
   }

} // impGetAttachFilename()

int impStrChReplace (char *pszStr, char oldCh, char newCh)
{
   while (*pszStr != '\0')
   {
      if (*pszStr == oldCh)
         *pszStr = newCh;

      pszStr++;
   }

   return (0);

} // impStrChReplace()
