//
// exptask.h
//

#if ! defined (exptask_INCLUDED)
#define exptask_INCLUDED


// MACRO DEF's
//      123456789012345678901234567890
#define EXPORT_TASK_INIT_FILENAME       "svrtask.ini"
#define MAX_INI_KEY_LEN                 32
#define MAX_INI_VALUE_LEN               80

#define MAX_INX_LINE_LEN                132
#define MAX_INX_KEY_LEN                 32
#define MAX_INX_VAL_LEN                 80
#define MAX_NUM_OF_INX_VAL              3
#define MAX_INX_NOTE_LEN                1000 // in bytes
#define MAX_ATTRNAME_LEN                32
#define MAX_ATTRVALUE_LEN               32
#define MAX_CLASSNAME_LEN               32
#define MAX_NUM_OF_ATTR                 20
#define MAX_FULL_PATHNAME_LEN           133
#define MAX_FILENAME_LEN                13
#define MAX_DIRNAME_LEN                 121
#define MAX_LNOTES_DBNAME_LEN           32

#define INIKEY_COMMENT_MARKER           "#"
#define INIKEY_EXPTASK_WAKEUP_INTERVAL  "EXPTASK_WAKEUP_INTERVAL"
#define INIKEY_EXPTASK_CIF_DIR          "EXPTASK_CIF_DIR"
#define INIKEY_LNOTES_MAIL_ADDRESS      "EXPTASK_LNOTES_MAIL_ADDRESS"
#define INIKEY_MAX_SERVER_LOOPS         "EXPTASK_MAX_SERVER_LOOPS"
#define INIKEY_DELETE_FILES             "EXPTASK_DELETE_FILES"
#define LNOTES_IP2_NOTES_FIELD          "IP2_NOTES_FIELD"

#define INIDEF_EXPTASK_WAKEUP_INTERVAL  15    // in seconds
#define INIDEF_EXPTASK_MAX_SERVERLOOPS  0     // means server loops forever

#define INXKEY_BEGIN_DOCUMENT           ":document"
#define INXKEY_CLASS                    ":class"
#define INXKEY_ATTR_COUNT               ":attrcnt"
#define INXKEY_ATTR                     ":attr"
#define INXKEY_ATTR_INDEX               ":attri"
#define INXKEY_BEGIN_NOTE               ":note"
#define INXKEY_NOTE_LINE                ":line"
#define INXKEY_END_NOTE                 ":enote"
#define INXKEY_IMAGE                    ":image"
#define INXKEY_END_DOCUMENT             ":edoc"
#define INXKEY_BEGIN_FOLDER             ":folder"
#define INXKEY_END_FOLDER               ":efolder"
#define INXKEY_FOLDERITEM               ":folderitem"

#define INX_TAG_DELIMITER               ':'
#define INX_TAG_PARAM_DELIMITER         '.'

#define OIS_MDI_FORMAT                  "MO:DCA-P"
#define OIS_NO_COMPRESSION              "OFF"
#define OIS_COMPRESSION                 "ON"

// TYPEDEF's
typedef struct
{
   int             wakeupInterval;
   int             iMaxServerLoops;
   char            szCIFDir[MAX_DIRNAME_LEN];
   char            szLNotesMailAddress[MAX_FULL_PATHNAME_LEN];
   BOOL            fDeleteFiles;
} INIT_PARAMS;
typedef struct
{
   char            name[MAX_ATTRNAME_LEN];
   char            value[MAX_ATTRVALUE_LEN];
   BOOL            findex;
} INX_ATTR;
typedef struct _inx_obj_node
{
   char            objType; // 'F', 'D'
   char            classname[MAX_CLASSNAME_LEN]; // used for folder & doc
   int             attrcnt;                      
   INX_ATTR        attr[MAX_NUM_OF_ATTR];
   char            note[MAX_INX_NOTE_LEN];
   char            image[MAX_FILENAME_LEN];
   struct _inx_obj_node *pNext;
} INX_OBJ_NODE, *PINX_OBJ_NODE;
typedef struct
{
   NOTEHANDLE     noteHndl;
   PINX_OBJ_NODE  pInxNode;
} SCAN_ROUTINE_PARAM;
typedef struct
{
   DBHANDLE       *pMailboxDbHndl;
   PINX_OBJ_NODE  pInxNode;
   INT            iItems;
} SEARCH_ROUTINE_PARAM;


// FUNCTION PROTOTYPES

#endif
