//      Filename:       exptask.c
//
//      Purpose:
//              Main module for the CIF export server task.  Used to export Lotus
//              Lotus Notes objects to a CIF structure.


// OS and C include files 
#define INCL_DOSPROCESS
#include <os2.h>        
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>

// Notes API include files
#include <global.h>
#include <addin.h>
#include <nsfdb.h>
#include <nsfnote.h>
#include <nsfsearc.h>
#include <stdnames.h>
#include <ostime.h>
#include <osmem.h>

// Local include files
#include "exptask.h"
#include "expRCstr.h"

// Function prototypes
int expInitializeTask (INIT_PARAMS *pParams);
int expCleanupTask (void);
int expGetInitParams (INIT_PARAMS *pParams);
int expGetCmdPrmptCh (void);
int expDosChDir (char *pszDir);
int expGetExportItem (PINX_OBJ_NODE pinxNode, char *pszExpMailbox);
int expInitializeInxNode (PINX_OBJ_NODE pTmpNode);

char *expfgets (char *pszStr, int n, FILE *fp);
void expEnforceExtension(char *szPath,char *szExt);

BOOL expIsInxItemAFolder (PINX_OBJ_NODE pinxNode);
int expGetUniqueFileName (char *pszFileName, char prefixCh, char *pszExtension);
int expBuildLstAndInxFiles (PINX_OBJ_NODE pInxNode, char *pszLSTFileName);
int expBuildCIFFile (char *pszLSTFile, char *pszCIFFile);

STATUS far PASCAL expActionSearchFunc (
   void *pParam,
   SEARCH_MATCH *searchInfo,
   ITEM_TABLE *summaryInfo);
STATUS far PASCAL expScanRoutine (
   WORD spare,
   WORD itemFlags,
   char *name,
   WORD nameLen,
   void *val,
   DWORD valLen,
   void *param);
int expGetAttachedFilename (BLOCKID valBlkID, DWORD len, CHAR *szFilename);
char *expGetNoteLine (char *pszBuf, char *pszLine);
int expAddItemInfoToInxNode (NOTEHANDLE noteHndl, PINX_OBJ_NODE pInxNode);

// Standard entry for all Notes server add-in tasks
STATUS far PASCAL  AddInMain (HMODULE hModule, int argc, char *argv[])
{

   INIT_PARAMS params;
   char szCIFFileName[MAX_FILENAME_LEN];
   char szLSTFileName[MAX_FILENAME_LEN];
   char szInxFileName[MAX_FILENAME_LEN];
   char szMsg[132];
   INX_OBJ_NODE inxNode;
   int iLoopCount=0;
   BOOL fLoop=TRUE;
   char chCmdPrmpt;
   char szNotifyFileName[MAX_FILENAME_LEN];
   FILE *fpNotify;

   // Initialize this task.
   if (expInitializeTask (&params) != 0)
      return (1);
   sprintf (szMsg, "Interval processing = <%d>.", params.wakeupInterval);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);
   sprintf (szMsg, "Maximum loops = <%d>.", params.iMaxServerLoops);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);
   sprintf (szMsg, "CIF directory = <%s>.", params.szCIFDir);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);
   sprintf (szMsg, "Lotus Notes export mail address = <%s>.", params.szLNotesMailAddress);
   AddInLogMsg (ADDIN_MSG_FMT, szMsg);

   // Change current directory to the export CIF dir
   expDosChDir (params.szCIFDir);

   // Begin the main loop.  We give up control to the server at the start of
   // each iteration, and get control back when the server says it is OK to
   // proceed.  The server returns TRUE when it is time to shut down this task.
   // Main loop will be exited after the specifed number of interations if
   // "params.maxServerLoops" is not equal to 0.
   while (!AddInIdle() && fLoop)
   {
      if (AddInSecondsHaveElapsed(params.wakeupInterval))
      {
         AddInSetStatus(ADDIN_MSG_FMT, "Processing");

         // Build list of Lotus Notes documents to export
         if (expGetExportItem (&inxNode, params.szLNotesMailAddress) == 0)
         {
            AddInLogMsg (ADDIN_MSG_FMT, "Start exporting notes to CIF File.");

            // Build .LST and .INX files
            expGetUniqueFileName (szLSTFileName, 'L', "LST");
            expBuildLstAndInxFiles (&inxNode, szLSTFileName);

            // Build .CIF file                      
            expGetUniqueFileName (szCIFFileName, 'C', "CIF");
            expBuildCIFFile (szLSTFileName, szCIFFileName);

            // Destroy LST and INX files
            if (params.fDeleteFiles)
            {
               remove (szLSTFileName);
               remove (inxNode.image);
               strcpy (szInxFileName, inxNode.image);
               expEnforceExtension (szInxFileName, ".INX");
               remove (szInxFileName);
            }

            // Create notify file
            strcpy (szNotifyFileName, inxNode.image);
            expEnforceExtension (szNotifyFileName, ".NTY");
            fpNotify = fopen (szNotifyFileName, "w");
            fclose (fpNotify);

            AddInLogMsg (ADDIN_MSG_FMT, "Completed exporting note to CIF File.");
         }
        
         // Reset status
         AddInSetStatus (ADDIN_MSG_FMT, "Idle");

         // Check if maximum processing loops have been reached
         if (params.iMaxServerLoops != 0)
         {
            iLoopCount++;
            if (iLoopCount >= params.iMaxServerLoops)
            {
               AddInLogMsg (ADDIN_MSG_FMT, "Maximum processing loops reached.");
               fLoop = FALSE;
            }
         }
      }
      else if (AddInSecondsHaveElapsed (1)) // Check for console commands every 1 second
      {
         while ((chCmdPrmpt=(char)expGetCmdPrmptCh()) != (char)0)
         {
            if (chCmdPrmpt == 'q')
            {
               AddInLogMsg (ADDIN_MSG_FMT, "Console termination requested.");
               fLoop = FALSE;
               break;
            }
         }
      }

   } // End of main task loop.

   // We get here when the server notifies us that it is time to terminate.
   // This is usually when the user has entered "quit" to the server console.
   // Clean up anything we have been doing.  */
   expCleanupTask ();

   // End of add-in task.  We must "return" here rather than "exit".
   return (NOERROR);
      
} // End AddInMain()

int expDosChDir (char *pszDir)
{
   char *pszTmp;

   strupr (pszDir);

   if ((pszTmp = strchr(pszDir, ':')) != NULL)
   {
      DosSelectDisk (pszTmp[-1] - 'A' + 1);
   }
   DosChDir (pszDir, 0L);

   return (0);

} // expDosChDir()

int expInitializeTask (INIT_PARAMS *pParams)
{
   expGetInitParams (pParams);

   AddInSetStatus (ADDIN_MSG_FMT, "Initializing");
   AddInLogMsg (ADDIN_MSG_FMT, "CIF Export Task: Initialization complete.");
   AddInSetStatus (ADDIN_MSG_FMT, "Idle");

   return (0);

} // expInitializeTask ()

int expCleanupTask (void)
{

   AddInSetStatus(ADDIN_MSG_FMT, "Terminating");
   AddInLogMsg(ADDIN_MSG_FMT, "CIF Export Task: Termination complete.");

   return (0);

} // expCleanupTask ()

int expGetInitParams (INIT_PARAMS *pParams)
{
   char szLine[132];
   FILE *fp;
   char szKey[MAX_INI_KEY_LEN];
   char szValue[MAX_INI_VALUE_LEN];

   // Open ini file
   if ((fp = fopen (EXPORT_TASK_INIT_FILENAME, "r")) == NULL)
      return (-1);

   // Initialize input param
   memset (pParams, '\0', sizeof(INIT_PARAMS));
   pParams->wakeupInterval = INIDEF_EXPTASK_WAKEUP_INTERVAL;
   pParams->szCIFDir[0] = '\0';
   pParams->iMaxServerLoops = INIDEF_EXPTASK_MAX_SERVERLOOPS;

   // Parse ini file
   while (expfgets (szLine, sizeof(szLine), fp) != NULL)
   {
      szKey[0] = '\0';
      szValue[0] = '\0';

      if (sscanf (szLine, "%s %s", szKey, szValue) == 0)
         continue;

      if (stricmp (szKey, INIKEY_COMMENT_MARKER) == 0)
      {
         continue;
      }
      else if (stricmp (szKey, INIKEY_EXPTASK_WAKEUP_INTERVAL) == 0)
      {
         pParams->wakeupInterval = atoi (szValue);
      }
      else if (stricmp (szKey, INIKEY_EXPTASK_CIF_DIR) == 0)
      {
         strcpy (pParams->szCIFDir, szValue);
      }
      else if (stricmp (szKey, INIKEY_LNOTES_MAIL_ADDRESS) == 0)
      {
         strcpy (pParams->szLNotesMailAddress, szValue);
      }
      else if (stricmp (szKey, INIKEY_MAX_SERVER_LOOPS) == 0)
      {
         pParams->iMaxServerLoops = atoi(szValue);
      }
      else if (stricmp (szKey, INIKEY_DELETE_FILES) == 0)
      {
         if (stricmp (strupr(szValue), "NO") == 0)
            pParams->fDeleteFiles = FALSE;
         else
            pParams->fDeleteFiles = TRUE;
      }
   }

   // Close file
   fclose (fp);

   return (0);

} // expGetInitParams()

int expGetExportItem (PINX_OBJ_NODE pInxNode, char *pszExpMailbox)
{
   DBHANDLE db_handle;
   FORMULAHANDLE formula_handle;
   SEARCH_ROUTINE_PARAM actionParam;
   char formula[80];
   WORD wdc;
   STATUS error;

   // Initialize IP lst
   expInitializeInxNode (pInxNode);

   // Open CIF export mail box
   if (error = NSFDbOpen (pszExpMailbox, &db_handle))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Could not open the CIF export mailbox in Lotus Notes");
      return (-1);
   }

   // Formulate filter for search
   sprintf (formula,"@IsAvailable(%s)", ITEM_NAME_ATTACHMENT);
   if (error = NSFFormulaCompile (NULL,0,formula,strlen(formula),&formula_handle,
      &wdc,&wdc,&wdc,&wdc,&wdc,&wdc))
   {
      NSFDbClose (db_handle);
      return (-1);
   }

   // Search for notes to export to CIF file
   actionParam.pMailboxDbHndl = &db_handle;
   actionParam.pInxNode = pInxNode;
   actionParam.iItems = 0;
   NSFSearch (db_handle, formula_handle, NULL, 0, NOTE_CLASS_DATA, NULL,
      expActionSearchFunc, &actionParam, NULL);

   // Free memory from formula compile
   OSMemFree (formula_handle);
   NSFDbClose (db_handle);

   if (actionParam.iItems)
      return (0);
   else
      return (-1);

   return (0);

} // expGetExportItem()

STATUS far PASCAL expActionSearchFunc (
   void *pParam,
   SEARCH_MATCH *searchInfo,
   ITEM_TABLE *summaryInfo)
{
   SEARCH_ROUTINE_PARAM *pActionParam;
   NOTEHANDLE noteHndl;
   STATUS error;

   pActionParam = pParam;

   // Check if this note is a true match
   if (searchInfo->MatchesFormula != SE_FMATCH)
      return (0);

   // Check if item already found
   if (pActionParam->iItems)
      return (0);

   AddInLogMsg (ADDIN_MSG_FMT, "Export item found.");

   // Open note
   if (error = NSFNoteOpen (*(pActionParam->pMailboxDbHndl),
      searchInfo->ID.NoteID, 0, &noteHndl))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error opening mailbox.");
      return (error);
   }

   // Get all fields and add to a inx node
   if (expAddItemInfoToInxNode (noteHndl, pActionParam->pInxNode))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error getting fields from note.");
      NSFNoteDelete (*(pActionParam->pMailboxDbHndl), searchInfo->ID.NoteID, UPDATE_FORCE);
      return (-1);
   }

   // Deallocate the new note from memory.
   if (NSFNoteClose (noteHndl))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error deallocating note from memory.");
   }

   // Delete reply note
   NSFNoteDelete (*(pActionParam->pMailboxDbHndl), searchInfo->ID.NoteID, UPDATE_FORCE);

   pActionParam->iItems++;

   return (0);

} // expActionSearchFunc()

int expAddItemInfoToInxNode (NOTEHANDLE noteHndl, PINX_OBJ_NODE pInxNode)
{
   SCAN_ROUTINE_PARAM param;

   // Scan note
   param.noteHndl = noteHndl;
   param.pInxNode = pInxNode;

   if (NSFItemScan (noteHndl, expScanRoutine, &param))
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error returned by NSFItemScan()");
      return (-1);
   }

   return (0);

} // expAddItemInfoToInxLst()

STATUS far PASCAL expScanRoutine (
   WORD spare,
   WORD itemFlags,
   char *name,
   WORD nameLen,
   void *val,
   DWORD valLen,
   void *param)
{
   PINX_OBJ_NODE pInxNode;
   SCAN_ROUTINE_PARAM *scanParam;
   BLOCKID itemBlkID;
   WORD valType;
   BLOCKID valBlkID;
   DWORD valBlkLen;
   char szPCXFileName[MAX_FILENAME_LEN];
   char szMDIFileName[MAX_FILENAME_LEN];
   CHAR parm[128];
   WORD lineLen;
   char szLine[200];
   WORD iNotes;
   int i;
   char *pszBuf;

/*
char achFailName[128];
RESULTCODES rescResults;
USHORT usErr;
*/

   scanParam = param;
   pInxNode = scanParam->pInxNode;

   // Get item data type
   if (NSFItemInfo (scanParam->noteHndl,
      name, nameLen, &itemBlkID, &valType, &valBlkID, &valBlkLen))
   {
      return (-1);
   }

   if (strnicmp (name, FIELD_FORM, nameLen) == 0)
   {
      // Get value
      pInxNode->objType = 'D';
      strncpy (pInxNode->classname, (char *)val + sizeof(WORD), (int)valLen - sizeof(WORD));
      pInxNode->classname[(int)valLen - sizeof(WORD)] = '\0';
   }
   else if (strnicmp (name, ITEM_NAME_ATTACHMENT, nameLen) == 0)
   {
      // Only one PCX file is allowed to be exported from LNDI note for this sample code
      if (strlen (pInxNode->image) != 0)
         return (0);

      // Get filename
      if (expGetAttachedFilename (valBlkID, valBlkLen, szPCXFileName))
      {
         AddInLogMsg (ADDIN_MSG_FMT, "Error getting attached file name.");
         return (-1);
      }

      // LOOK FOR EMBEDDED ICON FILE used by LNDIFAX
      strupr (szPCXFileName);
      if (strstr (szPCXFileName, "EMBDICON.DOC") != NULL)
         return (0);

      // Extract file to disk
      if (NSFNoteExtractFile (scanParam->noteHndl, itemBlkID, szPCXFileName, NULL))
      {
         AddInLogMsg (ADDIN_MSG_FMT, "Error extracting LNDI document.");
         return (-1);
      }

      // Get unique filename for MDI file
      expGetUniqueFileName (szMDIFileName, 'D', "MDI");

      // Convert PCX to MDI file
      sprintf (parm, "CONVIMG.CMD %s %s %s %s",
         szPCXFileName, szMDIFileName, OIS_MDI_FORMAT, OIS_COMPRESSION);
      AddInLogMsg (ADDIN_MSG_FMT, parm);
      system (parm);

/*
sprintf (parm, "CONVIMG.CMD %s %s %s %s\0\0",
   szPCXFileName, szMDIFileName, OIS_MDI_FORMAT, OIS_COMPRESSION);
if (usErr = DosExecPgm (achFailName, sizeof(achFailName),
   EXEC_SYNC, parm, 0, &rescResults, "myexec.exe"))
{
   AddInLogMsg (ADDIN_MSG_FMT, "Error returned by DosExecPgm");
   return (-1);
}
*/

      // Delete PCX file
      remove (szPCXFileName);

      // Add filename to image field
      strcpy (pInxNode->image, szMDIFileName);
   }
   else if (strnicmp (name, LNOTES_IP2_NOTES_FIELD, nameLen) == 0)
   {
      // Get number of text items
      iNotes = NSFItemGetTextListEntries (scanParam->noteHndl, LNOTES_IP2_NOTES_FIELD);
      pInxNode->note[0] = '\0';
      for (i=0; i < (int)iNotes; i++)
      {
         lineLen = NSFItemGetTextListEntry(scanParam->noteHndl,
            LNOTES_IP2_NOTES_FIELD, i, szLine, sizeof(szLine));
         szLine[lineLen] = '\0';
         strcat (pInxNode->note, szLine);
         strcat (pInxNode->note, "\n");
      }
   }
   else if (valType == TYPE_TEXT) // text item
   {
      if (pInxNode->attrcnt < MAX_NUM_OF_ATTR)
      {
         // Add attribute to list
         strncpy (pInxNode->attr[pInxNode->attrcnt].name, name, nameLen);
         pInxNode->attr[pInxNode->attrcnt].name[nameLen] = '\0';

         // Another kludge
         pszBuf = pInxNode->attr[pInxNode->attrcnt].name;
         while ((pszBuf = strchr (pszBuf, '_')) != NULL)
         {
            pszBuf[0] = ' ';
            pszBuf++;
         }

         strncpy (pInxNode->attr[pInxNode->attrcnt].value,
            (char *)val + sizeof(WORD), (int)valLen - sizeof(WORD));
         pInxNode->attr[pInxNode->attrcnt].value[(int)valLen - sizeof(WORD)] = '\0';

         pInxNode->attr[pInxNode->attrcnt].findex = FALSE;

         // Increment item count
         pInxNode->attrcnt++;
      }
   }
/*
   else if (valType == TYPE_NUMBER) // numeric value
   {
      if (pInxNode->attrcnt < MAX_NUM_OF_ATTR)
      {
         // Add attribute to list
         strncpy (pInxNode->attr[pInxNode->attrcnt].name, name, nameLen);
         pInxNode->attr[pInxNode->attrcnt].name[nameLen] = '\0';
         strncpy (pInxNode->attr[pInxNode->attrcnt].value, val, valLen);
         pInxNode->attr[pInxNode->attrcnt].value[valLen] = '\0';
         pInxNode->attr[pInxNode->attrcnt].findex = FALSE;

         // Increment item count
         pInxNode->attrcnt++;
   }
*/

   return (0);

} // expScanRoutine()

char *expfgets (char *pszStr, int n, FILE *fp)
{
   char *pszRC, *pszTmp;

   if ((pszRC = fgets (pszStr, n, fp)) == NULL)
      return (NULL);

   pszTmp = strchr (pszStr, '\n');
   pszTmp[0] = '\0';

   return (pszTmp);

} // expfgets()

char *expStrncpyc (char *pDest, char *pSrc, int dest_len, char ch)
{
   char *p = pDest;
   register int i = 1, n = dest_len;

   while (*pSrc != '\0' && *pSrc != ch && i++ < n)
   {
      *pDest++ = *pSrc++;
   }
   *pDest = '\0';

   return(p);

} // expStrncpyc()

void expEnforceExtension(char *szPath,char *szExt)
{
   char *p;

   p = strchr(szPath,'.');
   if (p != NULL)
      *p = '\0';

   if (szExt[0] != '.')
      strcat(szPath,".");

   strcat(szPath,szExt);

   return;

} // expEnforceExtension()

int expInitializeInxNode (PINX_OBJ_NODE pTmpNode)
{
   // Initialize node
   pTmpNode->pNext = NULL;
   pTmpNode->classname[0] = '\0';
   pTmpNode->attrcnt = 0;
   pTmpNode->image[0] = '\0';
   pTmpNode->note[0] = '\0';

   return (0);

} // expInitializeInxNode()

int expGetAttachedFilename (BLOCKID valBlkID, DWORD len, CHAR *szFilename)
{
   FILEOBJECT *ptr;

   // Lock block
   ptr = OSLockBlock (FILEOBJECT, valBlkID);
   ptr = (FILEOBJECT *)((char *)ptr + 2);
   if (ptr->Header.ObjectType == OBJECT_FILE)
   {
      strncpy (szFilename, ((char *)ptr + sizeof(FILEOBJECT)), ptr->FileNameLength);
      szFilename[ptr->FileNameLength] = '\0';
      OSUnlockBlock (valBlkID);
      return (0);
   }
   else
   {
      OSUnlockBlock (valBlkID);
      return (-1);
   }

} // expGetAttachFilename()

int expGetUniqueFileName (char *pszFileName, char prefixCh, char *pszExtension)
{
   int iCount=0;

   sprintf(pszFileName, "%c%7.7d.%s", prefixCh, iCount, pszExtension);
   while (access (pszFileName, 0) == 0)
   {
      iCount++;
      sprintf(pszFileName, "%c%7.7d.%s", prefixCh, iCount, pszExtension);
   }

   return (0);

} // expGetUniqueFilename()

int expBuildLstAndInxFiles (PINX_OBJ_NODE pInxNode, char *pszLSTFileName)
{
   FILE *fpLst, *fpInx;
   char *pszBuf;
   char szLine[MAX_INX_LINE_LEN];
   char szInxFileName[MAX_FILENAME_LEN];
   char szErr[132];
   int i;

   // Open list file
   if ((fpLst = fopen (pszLSTFileName, "w")) == NULL)
      return (-1);

   // Process each IP node

   if (expIsInxItemAFolder (pInxNode))
      return (-1);

   // Create INX image filename
   strcpy (szInxFileName, pInxNode->image);
   expEnforceExtension (szInxFileName, ".INX");

   // Open inx file
   if ((fpInx = fopen (szInxFileName, "w")) == NULL)
   {
      AddInLogMsg (ADDIN_MSG_FMT, "Error opening inx file.");
      AddInLogMsg (ADDIN_MSG_FMT, szInxFileName);
      return(-1);
   }
         
   // Write all inx file data
   sprintf (szErr, "%s.\n", INXKEY_BEGIN_DOCUMENT);
   fwrite (szErr, strlen(szErr), 1, fpInx);

   sprintf (szErr, "%s.%s\n", INXKEY_CLASS, pInxNode->classname);
   fwrite (szErr, strlen(szErr), 1, fpInx);

   sprintf (szErr, "%s.%d\n", INXKEY_ATTR_COUNT, pInxNode->attrcnt);
   fwrite (szErr, strlen(szErr), 1, fpInx);

   for (i=0; i < pInxNode->attrcnt; i++)
   {
      if (pInxNode->attr[i].findex)
      {
         sprintf (szErr, "%s.%s.%s\n", INXKEY_ATTR_INDEX,
         pInxNode->attr[i].name, pInxNode->attr[i].value);
      }
      else
      {
         sprintf (szErr, "%s.%s.%s\n", INXKEY_ATTR,
            pInxNode->attr[i].name, pInxNode->attr[i].value);
         fwrite (szErr, strlen(szErr), 1, fpInx);
      }
   }

   sprintf (szErr, "%s.\n", INXKEY_BEGIN_NOTE);
   fwrite (szErr, strlen(szErr), 1, fpInx);
   pszBuf = pInxNode->note;
   while ((pszBuf = expGetNoteLine (pszBuf, szLine)) != NULL)
   {
      sprintf (szErr, "%s.%s\n", INXKEY_NOTE_LINE, szLine);
      fwrite (szErr, strlen(szErr), 1, fpInx);
      pszBuf++;
   }
   sprintf (szErr, "%s.\n", INXKEY_END_NOTE);
   fwrite (szErr, strlen(szErr), 1, fpInx);

   sprintf (szErr, "%s.%s\n", INXKEY_IMAGE, pInxNode->image);
   fwrite (szErr, strlen(szErr), 1, fpInx);
   sprintf (szErr, "%s.\n", INXKEY_END_DOCUMENT);
   fwrite (szErr, strlen(szErr), 1, fpInx);

   // Write inx entry to list file
   sprintf (szErr, "%s-\n", szInxFileName);
   fwrite (szErr, strlen(szErr), 1, fpLst);

   // Close inx file
   fclose (fpInx);

   // Close list file
   fclose (fpLst);

   return (0);

} // expBuildLstAndInxFiles()

int expGetCmdPrmptCh (void)
{
   if (kbhit ())
   {
      // Get char
      return (getche());
   }
   else
      return (0);

} // expGetCmdPrmptStr()

BOOL expIsInxItemAFolder (PINX_OBJ_NODE pinxNode)
{
   if (pinxNode->objType == 'F')
      return (TRUE);
   else
      return (FALSE);

} // expIsInxItemAFolder()

char *expGetNoteLine (char *pszBuf, char *pszLine)
{
   char *pszNew;

   if ((pszNew = strchr (pszBuf, '\n')) != NULL)
   {
      strncpy (pszLine, pszBuf, (INT)((ULONG)pszNew-(ULONG)pszBuf));
      pszLine[(INT)((ULONG)pszNew-(ULONG)pszBuf)] = '\0';
   }

   return (pszNew);

} // expGetNoteLine()

int expBuildCIFFile (char *pszLSTFile, char *pszCIFFile)
{
   CHAR parm[128];
   CHAR szLogFile[32];

   strcpy (szLogFile, pszCIFFile);
   expEnforceExtension (szLogFile, ".LOG");

   sprintf (parm, "buildcif %s %s > %s", pszLSTFile, pszCIFFile, szLogFile);
   system (parm);

   return (0);

} // expbuildCIFFile()

