/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols
#include "iplist.h"

int main(void);
void PrintList(PIPLIST pList);
void Populate(PIPLIST pList);

int main(void)
{
   PIPLIST pList;
   register int index, count;

   pList = CreateList(LT_VARLEN,0);
   if (pList == NULL)
      {
      printf("Error creating list...\n");
      }
   else
      {
      printf("With an empty list...\n");
      SeekList(pList,LSEEK_TOP);
      SeekList(pList,LSEEK_END);
      DeleteTopListItem(pList);
      DeleteBottomListItem(pList);
      printf("Top item  - %s\n",TopListItem(pList));
      printf("Next item - %s\n",NextListItem(pList));
      printf("Bott item - %s\n",BottomListItem(pList));
      printf("Prev item - %s\n",PrevListItem(pList));
      printf("By index  - %s\n",ListItemByIndex(pList,3));
      printf("Lst count - %d\n",QueryListCount(pList));

      Populate(pList);
      printf("After append...\n");
      PrintList(pList);
      printf("Lst count - %d\n",QueryListCount(pList));

      while (pList->pHead != NULL)
         {
         DeleteTopListItem(pList);
         printf("Lst count - %d\n",QueryListCount(pList));
         }
      printf("After delete from top...\n");
      PrintList(pList);

      Populate(pList);
      while (pList->pHead != NULL)
         {
         DeleteBottomListItem(pList);
         printf("Lst count - %d\n",QueryListCount(pList));
         }
      printf("After delete from bottom...\n");
      PrintList(pList);

      Populate(pList);
      SeekList(pList,LSEEK_TOP);
      SeekList(pList,LSEEK_END);
      InsertTopListItem(pList,"Insert #2");
      InsertTopListItem(pList,"Insert #1");
      printf("After insert top...\n");
      PrintList(pList);

      DeleteTopListItem(pList);
      printf("After delete top...\n");
      PrintList(pList);

      DeleteBottomListItem(pList);
      printf("Lst count - %d\n",QueryListCount(pList));
      printf("After delete bottom...\n");
      PrintList(pList);

      printf("Top item  - %s\n",TopListItem(pList));
      printf("Next item - %s\n",NextListItem(pList));
      printf("Next item - %s\n",NextListItem(pList));
      printf("Next item - %s\n",NextListItem(pList));
      printf("Next item - %s\n",NextListItem(pList));
      printf("Next item - %s\n",NextListItem(pList));
      printf("Next item - %s\n",NextListItem(pList));

      printf("Bott item - %s\n",BottomListItem(pList));
      printf("Prev item - %s\n",PrevListItem(pList));
      printf("Prev item - %s\n",PrevListItem(pList));
      printf("Prev item - %s\n",PrevListItem(pList));
      printf("Prev item - %s\n",PrevListItem(pList));
      printf("Prev item - %s\n",PrevListItem(pList));
      printf("Prev item - %s\n",PrevListItem(pList));

      printf("Listing items by index, count = %d\n",count = QueryListCount(pList));
      for (index = 0; index < count; index++)
         {
         printf("%s\n",ListItemByIndex(pList,index));
         }

      SeekList(pList,LSEEK_TOP);
      printf("After seek top...\n");
      printf("Next item - %s\n",NextListItem(pList));
      printf("Prev item - %s\n",PrevListItem(pList));

      DestroyList(pList);
      }
   return(0);
}

void PrintList(PIPLIST pList)
{
   int i = 1;
   char *p = NULL;

   SeekList(pList,LSEEK_TOP);
   if (QueryListCount(pList) > 0)
      {
      printf("Item %d - %-20s %10lX %10lX\n",0,TopListItem(pList),pList->pCurr->pPrev,pList->pCurr->pNext);
      do
         {
         p = (char *) NextListItem(pList);
         if (p != NULL)
            {
            printf("Item %d - %-20s %10lX %10lX\n",i,p,pList->pCurr->pPrev,pList->pCurr->pNext);
            }
         i++;
         }
      while (p != NULL);
      }
   else
      {
      printf("list is empty\n");
      }
   return;
}



void Populate(PIPLIST pList)
{
   AppendListItem(pList,"Append #1");
   AppendListItem(pList,"Append #2");
   AppendListItem(pList,"Append #3");
   AppendListItem(pList,"Append #4");
   AppendListItem(pList,"Append #5");
   AppendListItem(pList,"Append #6");

   return;
}
