/* READ_HDR.C */
/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define  INCL_WINCOUNTRY
#include <os2.h>
#include "cif_defs.h"
#include "cif_util.h"
FILE *in,*out,*trc;
int doc = 1;
short in_folder = 0;
char index[100];
char doctype[100];
char type_des[100];
char id_des[100];
void strip_blank(char *line);
unsigned char do_line(char line[255]);
unsigned char do_line_un(char line[255]);
USHORT tot_classes = 1,tot_attrs = 1;
CLASS Class[MAXCLAS];
char *nattrs[MAXATTR];
int main(argc,argv,envp)
  int argc;
  char *argv[];
  char *envp[];
{
  USHORT i,j;

  if (argc <= 1)
    {
    if ((in = fopen("maintest.cif", "rb")) == NULL)
      {
      printf("Could not open CIF.\n");
      exit(0);
      }
    }
  else
    {
    if ((in = fopen(argv[1], "rb")) == NULL)
      {
      printf("Could not open CIF.\n");
      exit(0);
      }
    }
  if (argc <= 2)
    {
    if ((out = fopen("maintest.rpt", "w")) == NULL)
      {
      printf("Could not open rpt file.\n");
      exit(0);
      }
    }
  else
    {
    if ((out = fopen(argv[2], "w")) == NULL)
      {
      printf("Could not open lst file.\n");
      exit(0);
      }
    }
  parse_beg();
  fprintf(out, "File %s contains the following information:\n\n", argv[1]);
  fprintf(out, "\tSource Type: %s\n", type_des);
  fprintf(out, "\tSource ID:   %s\n\n", id_des);
  fprintf(out, "There are %d attributes defined as follows:\n", tot_attrs-1);
  for (i = 1; i < tot_attrs; i++)
    fprintf(out, "\t%d) %s\n", i, nattrs[i]);
  fprintf(out, "\nThere are %d classes defined as follows with their associated attributes:\n", tot_classes-1);
  for (i = 1; i < tot_classes; i++)
    {
    fprintf(out, "\n\tClass \'%s\' with the following %d attributes:\n", Class[i].name, Class[i].num_attr);
    for (j = 0; j < Class[i].num_attr; j++)
      fprintf(out, "\t  %d) %s\n", Class[i].nattrs[j], nattrs[Class[i].nattrs[j]]);
    }
  fclose(out);
  return (0);
}


int parse_beg(void)
{
  unsigned char b[100],tb,tb2,tb3;
  USHORT ts;
  char line[255];

  fread(b, 2, 1, in);
  if (b[0] == 0x60)
  {
//    printf("Data Stream\n");
  }
  else
    {
    printf("Error, no data stream tag.\n");
    return (-1);
    }
  fread(b, 4, 1, in);
  if ((b[0] == 0x80) && (b[1] == 0x02) && (b[2] == 0x01) && (b[3] == 0x01))
  {
//    printf("--Level 0x01 0x01.\n");
  }
  else
    {
    printf("Error, Incorrect Level.\n");
    return (-2);
    }
  fread(b, 2, 1, in);
  if ((b[0] == 0x42) && (b[1] == 0x01))
  {
    fread(b,1,1,in);
    // printf("--Code Page is %X.\n", b[0]);
  }
  else if((b[0] == 0x42) && (b[1] == 0x02))
  {
    fread(b,2,1,in);
    // printf("--Code Page is 500.\n");
  }
  else
    {
    printf("Error, Code Page Expected.\n");
    return (-3);
    }
  fread(b, 2, 1, in);
  if (b[0] == 0xA1)
  {
//    printf("--Source.\n");
  }
  else
    {
    printf("Error, Not Source.\n");
    return (-4);
    }
  tb = do_line(line);
  if (tb == 0x4C)
    {
//    printf("----Type.\n");
    strcpy(type_des, line);
    }
  else
    {
    printf("Error, Not Type.\n");
    return (-5);
    }
  tb = do_line(line);
  if (tb == 0x4C)
    {
//    printf("----ID.\n");
    strcpy(id_des, line);
    }
  else
    {
    printf("Error, Not ID.\n");
    return (-5);
    }
  fread(b, 2, 1, in);
  if ((b[0] == 0x00) && (b[1] == 0x00))
    {
//    printf("--End of Source.\n");
    fread(b, 2, 1, in);
    }
  if (b[0] == 0xA4)
    {
    fread(b, 2, 1, in);
    tb = b[0];
    while (tb == 0x30)
      {
      fread(b, 2, 1, in);
      tb = b[1];
      b[0] = 0;
      b[1] = 0;
      b[2] = 0;
      fread(b, tb, 1, in);
      if (tb == 1)
        {
        ts = b[0];
        }
      else
        {
        b[2] = b[0];
        b[0] = b[1];
        b[1] = b[2];
        memcpy(&ts, b, 2);
        }
      fread(b, 2, 1, in);
      if (b[0] == 0x81)
        fread(b, 1, 1, in);
      else
        return (-11);
      do_line(line);
      nattrs[tot_attrs] = calloc(strlen(line)+1, 1);
      strcpy(nattrs[tot_attrs], line);
      tot_attrs++;
      fread(b, 2, 1, in);
      if (b[0] == 0x00)
        fread(b, 2, 1, in);
      tb = b[0];
      }
    fread(b, 2, 1, in);
    }
  if (b[0] == 0xA5)
    {
    fread(b, 2, 1, in);
    tb = b[0];
    while (tb == 0x30)
      {
      fread(b, 2, 1, in);
      tb = b[1];
      b[0] = 0;
      b[1] = 0;
      b[2] = 0;
      fread(b, tb, 1, in);
      if (tb == 1)
        {
        ts = b[0];
        }
      else
        {
        b[2] = b[0];
        b[0] = b[1];
        b[1] = b[2];
        memcpy(&ts, b, 2);
        }
      do_line(line);
      Class[tot_classes].name = calloc(strlen(line)+1, 1);
      strcpy(Class[tot_classes].name, line);
      Class[tot_classes].num_attr = 0;
      fread(b, 2, 1, in);
      if (b[0] == 0x00)
        fread(b, 2, 1, in);
      else
        if (b[0] == 0xA5)
          {
          fread(b, 2, 1, in);
          tb2 = b[0];
          while (tb2 != 0x00)
            {
            tb3 = b[1];
            fread(b, tb3, 1, in);
            if (tb3 == 1)
              {
              ts = b[0];
              }
            else
              {
              b[2] = b[0];
              b[0] = b[1];
              b[1] = b[2];
              memcpy(&ts, b, 2);
              }
            Class[tot_classes].nattrs[Class[tot_classes].num_attr] = ts;
            Class[tot_classes].num_attr++;
            fread(b, 2, 1, in);
            tb2 = b[0];
            }
          fread(b, 2, 1, in);
          fread(b, 2, 1, in);
          }
      tb = b[0];
      tot_classes++;
      }
    fread(b, 2, 1, in);
    }
  if (b[0] == 0x31)
  {
//    printf("--Set of CIU's.\n");
  }
  else
    {
    printf("Error, not set of CIU's tag.\n");
    return (-6);
    }
  return (0);
}
unsigned char do_line(char line[255])
{
  int rc;
  unsigned char b1,b2;

  strnset(line, 0, 255);
  fread(&b1, 1, 1, in);
  fread(&b2, 1, 1, in);
  fread(line, b2, 1, in);
  ebcdic2ascii(line, 255);
  line[b2] = 0;
  return (b1);
}

unsigned char do_line_un(char line[255])
{
  int rc;
  unsigned char b1,b2;

  strnset(line, 0, 255);
  fread(&b1, 1, 1, in);
  fread(&b2, 1, 1, in);
  fread(line, b2, 1, in);
  return (b1);
}

void strip_blank(char *line)
{
  int i = 0;

  i = strlen(line);
  while (i > 0)
    {
    if ((line[i] == 32) || (line[i] == 0))
      {
      line[i] = 0;
      i--;
      }
    else
      {
      i = -1;
      }
    }
}
