/* PARSEcif.H */
/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/* Include Files */

#include <stdio.h>              /* Standard C include files */
#include <stdlib.h>

#include <string.h>             /* String manipulation functions */

#define  INCL_WINCOUNTRY        /* Include Code Page information */
#include <os2.h>                /* Include OS/2 functions */

#include "cif_defs.h"           /* Include cif structures and defines */
#include "cif_util.h"           /* Include common cif functions */

/* Global variable declarations */

FILE *in,*out,*trc;             /* File handles */

int doc = 1,                    /* Keeps track of the number of docs parsed */
    folders = 0;                /* Keeps track of the number of fols parsed */

short in_folder = 0;            /* State variable: IN or OUT of a folder */

char type_des[100];             /* Source system type */
char id_des[100];               /* Source system ID */

                           /* Following variables used in note processing */
char *CP1 = NULL;               /* USERID of note creator */
char *CP2 = NULL;               /* Time & Date stamp of creation */

DATA d;                         /* Global data element for filling */
LINK head = NULL,tail;          /* Linked list pointers */

USHORT tot_classes = 1,         /* Total number of classes */
       tot_attrs = 1;           /* Total number of attributes */

char EBCDIC;

CLASS Class[MAXCLAS];           /* Class definitions */
char *nattrs[MAXATTR];          /* An array of attributes sent by source */

/* Function Prototypes */
                           /* High level parsing functions */
int parse_fol(void);            /* Parses a folder in the data stream(DS) */
int parse_doc(void);            /* Parses a document in the DS */

                           /* Lower level parsing functions */
int pull_image(void);           /* Pulls and writes an image from the DS */
int do_attrib(void);            /* Parses the attribute section of the DS */
int do_note(void);              /* Parses the note section from the DS */
int do_attribs(void);           /* Parses an attribute from the attr section */
int do_cp(void);                /* Parses a Code Point from the DS */

                           /* Low level parsing functions */
void strip_blank(char *line);   /* Strips blank chars a string (end only) */
unsigned char do_line(char line[255]);
                                /* Read a line and change code page */
unsigned char do_line_un(char line[255]);
                                /* Read a line and do not change code page */

                           /* INX creation functions */
int write_inxd(LINK head);      /* Writes all doc INX files in list */
int write_inxf(LINK head,USHORT level);
                                /* Writes all fol INX files at spcfd level */
int write_list(LINK head);      /* Write LST file with correct files */

USHORT count_lev(LINK head);    /* Determine number of nested folders */

/* This function will traverse the linked list and return the number of   */
/* nested folders in the list, if any.  For example if the list contained */
/* one folder it would return one.  This function also assigns a unique   */
/* name to each of folder INX files .file variable, while keeping a count */
/* of the number of folders in the list.                                  */

USHORT count_lev(LINK head)
{
  FILE *inx;
  int i;
  char inx_file[13];
  USHORT levels = 0;
  USHORT tfolders = 0;
  UCHAR in_folder = 0;

  i = 0;
  for (i = 0; head != NULL; head = head->next)
    {
    if (head == NULL)
      printf("NULL\n");
    else
      {
      if (head->data.flag == 'F')
        {
        if (in_folder == 1)
          levels++;
        folders++;
        sprintf(inx_file, "F%7.7d.INX", folders);
        while (access(inx_file, 00) == 0)
          {
          folders++;
          sprintf(inx_file, "F%7.7d.INX", folders);
          }
        strcpy(head->data.file, inx_file);
        in_folder = 1;
        }
      else
        if (head->data.flag == 'E')
          {
          in_folder = 0;
          }
      }
    }
  printf("There are %d levels of nested folders in this cif.\n", levels);
  return (levels);
}

/* This function traverses the linked list and writes a document INX file */
/* for each document contained in the linked list.  The file name used    */
/* is the same as the MDI file already created, except the extension is   */
/* changed to '.INX'.                                                     */

int write_inxd(LINK head)
{
  FILE *inx;
  int i;
  char inx_file[13];
  UCHAR infolder = 0;
  USHORT folder = 0;

  i = 0;
  for (i = 0; head != NULL; head = head->next)
    {
    if (head == NULL)
      printf("NULL\n");
    else
      {
      if (head->data.flag == '$')
        {
        printf("End flagged.\n");
        }
      else
        if (head->data.flag == '*')
          {
          printf("Beginning flagged.\n");
          }
        else
          if (head->data.flag == 'E')
            {
            printf("End of Folder flagged.\n");
            }
          else
            {
            strcpy(inx_file, head->data.file);
            i = strlen(inx_file);
            inx_file[i-1] = 'X';
            inx_file[i-2] = 'N';
            inx_file[i-3] = 'I';
            printf("%s\n", inx_file);
            if ((inx = fopen(inx_file, "w")) == NULL)
              {
              printf("Error Creating File.\n");
              return (-100);
              }
            if (head->data.flag == 'D')
              fprintf(inx, ":document.\n");
            else
              fprintf(inx, ":folder.\n");
            if (head->data.class == NULL)
              fprintf(inx, ":class.%s\n", Class[head->data.num_class].name);
            else
              fprintf(inx, ":class.%s\n", head->data.class);
            if (head->data.note_present == 1)
              {
              fprintf(inx, ":note.\n");
              fprintf(inx, ":line.");
              for (i = 0; i < strlen(head->data.note)-2; i++)
                {
                if (head->data.note[i] == '\n')
                  {
                  fprintf(inx, "\n:line.");
                  }
                else
                  {
                  fprintf(inx, "%c", head->data.note[i]);
                  }
                }
              fprintf(inx, "\n:enote.\n");
              }
            if (head->data.count > 0)
              {
              fprintf(inx, ":attrcnt.%d\n", head->data.count);
              if ((strcmpi(type_des, "IP/2 1.1") == 0)||(strcmpi(type_des, "WAF 2.3") == 0))
                {
                for (i = 0; i < head->data.count; i++)
                  fprintf(inx, ":attr.%s.%s\n", nattrs[head->data.attrs[i].num_attr], head->data.attrs[i].val);
                }
              else
                {
                for (i = 0; i < head->data.count; i++)
                  fprintf(inx, ":attr.%s.%s\n", head->data.attrs[i].name, head->data.attrs[i].val);
                }
              }
            if (head->data.flag == 'D')
              {
              fprintf(inx, ":image.%s\n", head->data.file);
              fprintf(inx, ":edoc.\n");
              }
            fclose(inx);
            }
      }
    }
}

/* This function will write the folder INX files that reside at the */
/* specified level in the linked list.  This function will also     */
/* specify all items in the linked list that are referenced by that */
/* folder, by a :folderitem. tag.                                   */

int write_inxf(LINK head,USHORT target_level)
{
  FILE *inx;
  int i;
  char inx_file[13];
  UCHAR infolder = 0;
  USHORT folder = 1;
  USHORT level = 0;

  i = 0;
  printf("In write_inxf, working on level %d\n", target_level);
  for (i = 0; head != NULL; head = head->next)
    {
    if (head == NULL)
      printf("NULL\n");
    else
      {
      if (head->data.flag == '$')
        {
        printf("End flagged.\n");
        }
      else
        if (head->data.flag == '*')
          {
          printf("Beginning flagged.\n");
          }
        else
          if (head->data.flag == 'E')
            {
            level--;
            if (level < target_level)
              {
              printf("Done with folder.\n");
              fprintf(inx, ":efolder.\n");
              fclose(inx);
              }
            }
          else
            if (head->data.flag == 'D')
              {
              if (level == target_level)
                {
                printf("File should be included: %s\n", head->data.file);
                strcpy(inx_file, head->data.file);
                i = strlen(inx_file);
                inx_file[i-1] = 'X';
                inx_file[i-2] = 'N';
                inx_file[i-3] = 'I';
                fprintf(inx, ":folderitem.%s\n", inx_file);
                }
              }
            else
              if (head->data.flag == 'F')
                {
                level++;
                if (level == target_level)
                  {
                  printf("Working on folder %s\n", head->data.file);
                  inx = fopen(head->data.file, "a+t");
                  }
                if ((level-1) == target_level)
                  {
                  printf("Folder should be included: %s\n", head->data.file);
                  fprintf(inx, ":folderitem.%s\n", head->data.file);
                  }
                }
      }
    }
  printf("Out of write_inxf\n");
}

/* This function creates a LST file that contains all high level references */
/* to elements in the linked list.                                          */

int write_list(LINK head)
{
  int i;
  char inx_file[13];
  UCHAR level = 0;
  USHORT folder = 0;

  i = 0;
  for (i = 0; head != NULL; head = head->next)
    {
    if (head == NULL)
      printf("NULL\n");
    else
      {
      if (head->data.flag == '$')
        {
        printf("End flagged.\n");
        }
      else
        if (head->data.flag == '*')
          {
          printf("Beginning flagged.\n");
          }
        else
          if (head->data.flag == 'E')
            {
            level--;
            }
          else
            if (head->data.flag == 'D')
              {
              if (level == 0)
                {
                strcpy(inx_file, head->data.file);
                i = strlen(inx_file);
                inx_file[i-1] = 'X';
                inx_file[i-2] = 'N';
                inx_file[i-3] = 'I';
                printf("%s-DOCUMENT\n", inx_file);
                fprintf(out, "%s-DOCUMENT\n", inx_file);
                }
              }
            else
              if (head->data.flag == 'F')
                {
                if (level == 0)
                  {
                  fprintf(out, "%s-FOLDER\n", head->data.file);
                  printf("%s-FOLDER\n", head->data.file);
                  }
                level++;
                }
      }
    }
}

/* This function is provided as a place holder for someone to do their own */
/* customization to the data before it is written to an INX file.  This is */
/* provided because some systems do not convey the names of their          */
/* attributes/indexing values in the header of the data stream.  Also, a   */
/* need may arise for some special case processing of information and this */
/* is most likely the best place to do specialized or transformation       */
/* processing.                                                             */
/*                                                                         */
/* The function provided does a limited form of attribute naming, which is */
/* based off of a external text file that is tagged with certain           */
/* characters to define System ID, System Type and Folder Type.  Based on  */
/* this information the function will substitute the next n common lines   */
/* for the next un-named or qualified attributes/index values on the       */
/* folder level.  This processing takes place only on the folder level     */
/* because IBM ImagePlus MVS/ESA does indexing on the folder level, but not*/
/* the document level and IBM ImagePlus/400 does contain items that do and */
/* do not do indexing on the folder level.                                 */
/*                                                                         */
/* this function will read the external file CIF.TFM located in the        */
/* directory specified in the IP2IMPEX environment variable.               */

int transform_exit(LINK head)
{
  int i,j,k,act = 0,cct = -1,found_type = 0,found_id = 0;
  char inx_file[13],line[132],tfm_file[256],*ip2impex;
  UCHAR level = 0;
  USHORT folder = 0;
  FILE *map;
  CLASS2 tfm[20];

  ip2impex = getenv("IP2IMPEX");
  if (ip2impex == NULL)
    {
    strcpy(tfm_file, "cif.tfm");
    }
  else
    {
    sprintf(tfm_file, "%s\\cif.tfm", ip2impex);
    }
  if ((map = fopen(tfm_file, "r")) == NULL)
    {
    printf("Cannot open cif transformation file in transform_exit.\n");
    return (-1);
    }
  while (fgets(line, 132, map) != NULL)
    {
    line[strlen(line)-1] = 0;
    if (line[0] != '#')
      {
      if (line[0] == ':')
        {
        printf("Type: %s %s\n", &line[1], type_des);
        if (strcmpi(&line[1], type_des) == 0)
          found_type = 1;
        else
          {
          found_type = 0;
          found_id = 0;
          }
        }
      else
        if (line[0] == '@')
          {
          printf("ID: %s %s\n", &line[1], id_des);
          if ((strcmpi(&line[1], id_des) == 0) && (found_type = 1))
            found_id = 1;
          else
            found_id = 0;
          }
        else
          if (found_id == 1)
            {
            if (line[0] == '.')
              {
              cct++;
              act = 0;
              tfm[cct].name = calloc(strlen(line), 1);
              strcpy(tfm[cct].name, &line[1]);
              printf("Class is :%s\n", tfm[cct].name);
              }
            else
              {
              tfm[cct].attrs[act] = calloc(strlen(line)+1, 1);
              strcpy(tfm[cct].attrs[act], line);
              printf(" w/Attr : %s\n", tfm[cct].attrs[act]);
              tfm[cct].num_attr++;
              act++;
              }
            }
      }
    }
  fclose(map);
  i = 0;
  for (i = 0; head != NULL; head = head->next)
    {
    if (head == NULL)
      printf("NULL\n");
    else
      {
      if (head->data.flag == '$')
        {
        printf("End flagged.\n");
        }
      else
        if (head->data.flag == '*')
          {
          printf("Beginning flagged.\n");
          }
        else
          if (head->data.flag == 'E')
            {
            printf("End of folder.\n");
            }
          else
            if (head->data.flag == 'D')
              {
              printf("Document.\n");
              }
            else
              if (head->data.flag == 'F')
                {
                for (j = 0; j < cct+1; j++)
                  {
                  printf("Comparing: %s & %s\n", tfm[j].name, head->data.class);
                  if (strcmpi(tfm[j].name, head->data.class) == 0)
                    {
                    printf("Transforming: %s\n", tfm[j].name);
                    for (k = 0; k < tfm[j].num_attr; k++)
                      {
                      head->data.attrs[k].name = calloc(strlen(tfm[j].attrs[k])+1, 1);
                      strcpy(head->data.attrs[k].name, tfm[j].attrs[k]);
                      }
                    }
                  }
                }
      }
    }
}

/* This function append the currently filled data element to the linked */
/* list and then resets some of the state variable associated with the  */
/* data element.                                                        */

void dump_data(DATA item)
{
  USHORT i;

  tail->next = malloc(sizeof(ELEMENT));
  tail = tail->next;
  memcpy(&tail->data, &d, sizeof(ELEMENT));
  if (item.flag == '$')
    {
    printf("End flagged.\n");
    }
  else
    if (item.flag == '*')
      {
      printf("Beginning flagged.\n");
      }
    else
      if (item.flag == 'E')
        {
        printf("End of Folder flagged.\n");
        }
      else
        if (item.flag == 'F')
          {
          printf("Folder flagged.\n");
          }
        else
          if (item.flag == 'D')
            {
            printf("Document flagged.\n");
            }
  d.note_present = 0;
  d.count = 0;
  d.class = NULL;
}

/* This function will parse the central core of the data stream.  It reads  */
/* a little and depending on the data calls parse_doc, parse_fol or another */
/* appropriate function.                                                    */

int parse_mid(void)
{
  unsigned char b[10],tb;
  int rc;

  fread(b, 2, 1, in);
  if (b[0] == 0x61)
    printf("----CIU.\n");
  else
    {
    printf("Error, no CIU tag.\n");
    return (-7);
    }
  fread(b, 4, 1, in);
  if ((b[0] == 0xA1) && (b[2] == 0x82))
    {
    printf("------Set of CIU.\n");
    printf("--------New Object.\n");
    }
  else
    {
    printf("Error, no CIU tag.\n");
    return (-7);
    }
  printf("------End Set of CIU.\n");
  if (b[1] == 0x80)
    {
    fread(b, 2, 1, in);
    if (!((b[0] == 0x00) && (b[1] == 0x00)))
      {
      printf("Error in parse.\n");
      return (-8);
      }
    }
  fread(b, 2, 1, in);
  tb = b[0];
  while (tb != 0x00)
    {
    if (tb == 0x65)
      {
      printf("------Folder.\n");
      rc = 0x65;
      while (rc == 0x65)
        {
        d.flag = 'F';
        rc = parse_fol();
        d.flag = 'E';
        dump_data(d);
        printf("------End of Folder.\n");
        fread(b, 2, 1, in);
        }
      if (rc != 0)
        return (rc);
      }
    else
      if (tb == 0x67)
        {
        printf("------Document.\n");
        d.flag = 'D';
        rc = parse_doc();
        printf("------End of Document.\n");
        if (rc != 0)
          return (rc);
        fread(b, 4, 1, in);
        }
      else
        {
        printf("Error, not a doc or folder.\n");
        printf("%X\n", tb);
        return (-13);
        }
    fread(b, 2, 1, in);
    if (b[0] == 0x61)
      printf("----CIU.\n");
    else
      if ((b[0] == 0x00) && (b[1] == 0x00))
        {
        return (0);
        }
      else
        {
        printf("Error, no CIU tag.\n");
        return (-7);
        }
    fread(b, 4, 1, in);
    if ((b[0] == 0xA1) && (b[2] == 0x82))
      {
      printf("------Set of CIU.\n");
      printf("--------New Object.\n");
      }
    else
      {
      printf("Error, no CIU tag.\n");
      return (-7);
      }
    printf("------End Set of CIU.\n");
    if (b[1] == 0x80)
      {
      fread(b, 2, 1, in);
      if (!((b[0] == 0x00) && (b[1] == 0x00)))
        {
        printf("Error in parse.\n");
        return (-8);
        }
      }
    fread(b, 2, 1, in);
    tb = b[0];
    }
  return (0);
}

/* This function will parse a folder and can call document and folder   */
/* parsing functions.  In some case this function does call itself.  It */
/* will also call the several lower level parsing calls.                */

int parse_fol(void)
{
  unsigned char b[100],tb;
  char line[255];
  int rc;

  in_folder = 1;
  fread(b, 3, 1, in);
  if (b[0] == 0x44)
    printf("--------UID is %d.\n", b[2]);
  else
    {
    printf("Error, no UID present %X.\n", b[0]);
    return (-20);
    }
  fread(b, 2, 1, in);
  tb = b[0];
  while (tb != 0x00)
    {
    if (tb == 0x69)
      {
      printf("--------Note Set.\n");
      rc = do_note();
      if (rc != 0)
        return (rc);
      if (b[1] == 0x80)
        {
        printf("--------End of Note.\n");
        fread(b, 2, 1, in);
        }
      }
    else
      if (tb == 0x6A)
        {
        printf("------Attribute Set.\n");
        rc = do_attrib();
        if (rc != 0)
          return (rc);
        if (b[1] == 0x80)
          {
          printf("--------End of Attribute Set.\n");
          }
        }
      else
        {
        printf("Error, not a attribute or note set(folder).\n");
        printf("%X\n", tb);
        return (-30);
        }
    fread(b, 2, 1, in);
    tb = b[0];
    }
  return (0);
}

/* This function will parse a document form the data stream and pull the */
/* image from the data stream.                                           */

int parse_doc(void)
{
  unsigned char b[100],tb;
  char line[255];
  int rc;

  d.flag = 'D';
  fread(b, 3, 1, in);
  if (b[0] == 0x44)
    printf("--------UID is %d.\n", b[2]);
  else
    {
    printf("Error, no UID present.\n");
    return (-20);
    }
  fread(b, 2, 1, in);
  tb = b[0];
  while (tb != 0x00)
    {
    if (tb == 0x69)
      {
      printf("--------Note Set.\n");
      rc = do_note();
      if (rc != 0)
        return (rc);
      if (b[1] == 0x80)
        {
        printf("--------End of Note Set.\n");
        fread(b, 2, 1, in);
        }
      }
    else
      if (tb == 0x6A)
        {
        printf("------Attribute Set.\n");
        rc = do_attrib();
        if (rc != 0)
          return (rc);
        printf("--------End of Attribute Set.\n");
        }
      else
        if (tb == 0xA0)
          {
          printf("------Document Content.\n");
          rc = pull_image();
          if (rc < 0)
            return (rc);
          }
        else
          {
          printf("Error, not a attribute or note set(document).\n");
          printf("%X\n", tb);
          return (-30);
          }
    fread(b, 2, 1, in);
    tb = b[0];
    }
  dump_data(d);
  return (0);
}

/* This function will pull an image object from the data stream and put */
/* it into a unique file in the same directory.  Thisfunction will copy */
/* chunks of image up to the value stored in FILECHK (default is 32K)   */
/* at a time.                                                           */

int pull_image(void)
{
  unsigned char b[200],tb,tb2;
  unsigned long tl,k;
  unsigned short ts,j,to_read;
  char line[255],line2[255],*buf;
  int rc,i;

  sprintf(line, "D%7.7d.MDI", doc);
  sprintf(line2, "D%7.7d.INX", doc);
  while ((access(line, 0) == 00) || (access(line2, 0) == 00))
    {
    doc++;
    sprintf(line, "D%7.7d.MDI", doc);
    sprintf(line2, "D%7.7d.INX", doc);
    }
  strcpy(d.file, line);
  trc = fopen(line, "wb");
  fread(b, 2, 1, in);
  tb = b[1];
  if (tb < 0x80)
    {
    printf("Image is 0x%X bytes long.\n", tb);
    fread(b, 1, tb, in);
    fwrite(b, 1, tb, trc);
    fclose(trc);
    }
  else
    if (tb == 0x81)
      {
      fread(&tb2, 1, 1, in);
      printf("Image is 0x%X bytes long.\n", tb2);
      for (i = 0; i < tb2; i++)
        {
        fread(b, 1, 1, in);
        fwrite(b, 1, 1, trc);
        }
      fclose(trc);
      }
    else
      if (tb == 0x82)
        {
        printf("Image size is 2 bytes long.\n");
        fread(b, 2, 1, in);
        printf("  Size before being swapped is 0x%2.2X%2.2X bytes.\n", b[0], b[1]);
        swab(b, b, 2);
        printf("  Size after being swapped is 0x%2.2X%2.2X bytes.\n", b[0], b[1]);
        memcpy(&ts, b, 2);
        j = 0;
        buf = malloc(FILECHK);
        while (j < ts)
          {
          j += FILECHK;
          if (j > ts)
            to_read = FILECHK-(j-ts);
          else
            to_read = FILECHK;
          rc = fread(buf, to_read, 1, in);
          printf("There were %u chunk of %u bytes read out of %u::%u.\n", rc, to_read, j, ts);
          rc = fwrite(buf, to_read, 1, trc);
          }
        free(buf);
        fclose(trc);
        }
      else
        if (tb = 0x84)
          {
          printf("Image size is 4 bytes long.\n");
          fread(b, 4, 1, in);
          printf("  Size before being swapped is 0x%2.2X %2.2X %2.2X %2.2X bytes.\n", b[0], b[1], b[2], b[3]);
          b[4] = b[0];
          b[5] = b[1];
          b[0] = b[3];
          b[1] = b[2];
          b[2] = b[5];
          b[3] = b[4];
          printf("  Size after being swapped is 0x%2.2X %2.2X %2.2X %2.2X bytes.\n", b[0], b[1], b[2], b[3]);
          memcpy(&tl, b, 4);
          printf("%x %lu\n", tl, tl);
          k = 0;
          buf = malloc(FILECHK);
          while (k < tl)
            {
            k += FILECHK;
            if (k > tl)
              to_read = FILECHK-(k-tl);
            else
              to_read = FILECHK;
            rc = fread(buf, to_read, 1, in);
            printf("There were %u chunk of %u bytes read out of %lu::%lu.\n", rc, to_read, k, tl);
            fwrite(buf, to_read, 1, trc);
            }
          free(buf);
          fclose(trc);
          }
        else
          {
          printf("Unsupported right now.\n");
          return (-1);
          }
  return (0);
}

/* This function will take a note from the data stream and attach it to the */
/* data element data.note and change the code page.  This function will     */
/* format a note if the note is seperated by lines with userid and time     */
/* stamps.                                                                  */

int do_note(void)
{
  unsigned char b[200],tb,clnp = 0,tb2;
  unsigned short ts,j;
  unsigned long tl,note_flag = 0;
  char *line,*note,*stars = "*****************************\n";
  int rc,i;

  fread(b, 3, 1, in);
  note = calloc(FILECHK, 1);
  if (b[0] == 0x44)
    printf("----------UID is %d\n", b[2]);
  else
    return (-49);
  fread(b, 2, 1, in);
  if (b[0] == 0x30)
    {
    printf("----------Seq of Notes.\n");
    }
  else
    {
    printf("Error, note defintion wrong.\n");
    return (-40);
    }
  fread(b, 2, 1, in);
  if (b[0] == 0x30)
    {
    printf("------------Note.\n");
    }
  else
    {
    printf("Error, note defintion wrong.\n");
    return (-40);
    }
  if (b[1] == 0x80)
    clnp = 2;
  if (b[3] == 0x80)
    clnp += 2;
  tb2 = b[0];
  while (tb2 != 0x00)
    {
    fread(b, 2, 1, in);
    if (b[0] == 0xA0)
      {
      fread(b, 2, 1, in);
      do_cp();
      fread(b, 2, 1, in);
      if (b[0] == 0xA1)
        {
        do_cp();
        }
      fread(b, 2, 1, in);
      fread(b, 2, 1, in);
      }
    if (b[0] == 0x81)
      {
      printf("--------------Note Text.\n");
      }
    else
      {
      printf("Error, bad note text.\n");
      return (-41);
      }
    tb = b[1];
    if (tb < 0x80)
      {
      line = calloc(tb+1, 1);
      fread(line, 1, tb, in);
      ebcdic2ascii(line, tb);
      }
    else
      if (tb == 0x81)
        {
        fread(&tb2, 1, 1, in);
        line = calloc(tb2+1, 1);
        fread(line, tb2, 1, in);
        ebcdic2ascii(line, tb2);
        }
      else
        if (tb == 0x82)
          {
          fread(b, 2, 1, in);
          swab(b, b, 2);
          memcpy(&ts, b, 2);
          line = calloc(ts+1, 1);
          fread(line, ts, 1, in);
          ebcdic2ascii(line, ts);
          }
        else
          if (tb == 0x84)
            {
            fread(b, 4, 1, in);
            printf("  Size before being swapped is 0x%2.2X %2.2X %2.2X %2.2X bytes.\n", b[0], b[1], b[2], b[3]);
            b[4] = b[0];
            b[5] = b[1];
            b[0] = b[3];
            b[1] = b[2];
            b[2] = b[5];
            b[3] = b[4];
            printf("  Size after being swapped is 0x%2.2X %2.2X %2.2X %2.2X bytes.\n", b[0], b[1], b[2], b[3]);
            memcpy(&tl, b, 4);
            printf("%x %lu\n", tl, tl);
            if (tl > FILECHK)
              {
              printf("Note too large.\n");
              exit(2);
              }
            line = calloc(tl+1, 1);
            fread(line, tl, 1, in);
            ebcdic2ascii(line, tl);
            }
          else
            {
            printf("Unsupported length %d.\n", tb);
            return (-42);
            }
    if (!((CP1 == NULL) || (CP2 == NULL)))
      {
      if (note_flag == 0)
        {
        note_flag = strlen(CP1)+strlen(CP2)+2*strlen(stars)+3;
        strcpy(note, stars);
        strcat(note, " ");
        strcat(note, CP1);
        strcat(note, " ");
        strcat(note, CP2);
        strcat(note, "\n");
        strcat(note, stars);
        }
      else
        if ((note_flag+strlen(line)) > FILECHK)
          {
          note_flag = FILECHK;
          printf("Note too large. Truncated to 32K\n");
          }
        else
          {
          note_flag += strlen(CP1)+strlen(CP2)+2*strlen(stars)+4;
          strcat(note, "\n");
          strcat(note, stars);
          strcat(note, " ");
          strcat(note, CP1);
          strcat(note, " ");
          strcat(note, CP2);
          strcat(note, "\n");
          strcat(note, stars);
          }
      free(CP1);
      free(CP2);
      CP1 = NULL;
      CP2 = NULL;
      }
    if (note_flag == 0)
      {
      note_flag = strlen(line);
      strcpy(note, line);
      }
    else
      if ((note_flag+strlen(line)) > FILECHK)
        {
        note_flag = FILECHK;
        printf("Note too large. Truncated to 32K\n");
        }
      else
        {
        note_flag += strlen(line);
        strcat(note, line);
        }
    free(line);
    fread(b, 2, 1, in);
    fread(b, 2, 1, in);
    tb2 = b[0];
    }
  d.note_present = 1;
  d.note = calloc(strlen(note)+1, 1);
  strcpy(d.note, note);
  free(note);
  printf("------------End Note.\n");
  printf("----------End Seq of Notes.\n");
  return (0);
}

/* This function will process a code point from the data stream and copy */
/* the information gathered from the code point to the global data       */
/* structure, if the information needs to be retained.                   */

int do_cp(void)
{
  unsigned char b[100],tb;
  char line[255];
  USHORT ts;

  do_line_un(line);
  tb = line[0];
  printf("Code point is %2.2X\n", tb);
  if (tb == 0x14)
    {
    do_line(line);
    strip_blank(line);
    d.class = calloc(strlen(line)+1, 1);
    strcpy(d.class, line);
    printf("Class is: %s\n", line);
    }
  else
    if (tb == 0x08)
      {
      do_line(line);
//      strip_blank(line);
        printf("String is: %s\n", line);
//      strcpy(index, line);
//      printf("Copying index info.\n");
      }
    else
      if (tb == 0x0B)
        {
        do_line(line);
        strip_blank(line);
        d.class = calloc(strlen(line)+1, 1);
        strcpy(d.class, line);
        printf("Class is: %s\n", line);
        }
      else
        if (tb == 0x01)
          {
          do_line(line);
          strip_blank(line);
          CP1 = calloc(strlen(line)+1, 1);
          strcpy(CP1, line);
          printf("Creation time is: %s\n", line);
          }
        else
          if (tb == 0x02)
            {
            do_line(line);
            strip_blank(line);
            CP2 = calloc(strlen(line)+1, 1);
            strcpy(CP2, line);
            printf("Creation user id is: %s\n", line);
            }
          else
            if (tb == 0x0E)
              {
              fread(b, 2, 1, in);
              tb = b[1];
              fread(b, tb, 1, in);
              if (tb == 1)
                {
                printf("Will be using class %d.\n", b[0]);
                d.num_class = b[0];
                d.count = 0;
                }
              else
                {
                b[2] = b[0];
                b[0] = b[1];
                b[1] = b[2];
                memcpy(&ts, b, 2);
                printf("Will be using class %d.\n", ts);
                d.num_class = ts;
                d.count = 0;
                }
              }
            else
              if (tb == 0xC8)
                {
                fread(b, 2, 1, in);
                fread(b, 2, 1, in);
                tb = b[0];
                while (tb != 0x00)
                  {
                  fread(b, 2, 1, in);
                  tb = b[1];
                  fread(b, tb, 1, in);
                  if (tb == 1)
                    {
                    printf("Will be using attribute %d.\n", b[0]);
                    d.attrs[d.count].num_attr = b[0];
                    }
                  else
                    {
                    b[2] = b[0];
                    b[0] = b[1];
                    b[1] = b[2];
                    memcpy(&ts, b, 2);
                    printf("Will be using attribute %d.\n", ts);
                    d.attrs[d.count].num_attr = ts;
                    }
                  do_line(line);
                  strip_blank(line);
                  printf("With the following assignment: %s.\n", line);
                  d.attrs[d.count].val = calloc(strlen(line)+1, 1);
                  strcpy(d.attrs[d.count].val, line);
                  d.count++;
                  fread(b, 2, 1, in);
                  fread(b, 2, 1, in);
                  tb = b[0];
                  }
                }
              else
                {
                do_line(line);
                printf("String is: %s\n", line);
                }
  fread(b, 2, 1, in);
  return (0);
}

/* This function will process Single or Multi-valued attributes from the */
/* data stream.                                                          */

int do_attribs(void)
{
  unsigned char b[100],tb;
  char line[255];

  fread(b, 2, 1, in);
  tb = b[0];
  while (tb != 0x00)
    {
    if (tb == 0xA1)
      {
      printf("----------I+ Single Attrib.\n");
      do_cp();
      }
    else
      if (tb == 0xA2)
        {
        printf("----------I+ Multi-valued Attrib.\n");
        do_cp();
        }
      else
        {
        printf("Error, not valid attrib sub-ID. %d\n", tb);
        return (1);
        }
    fread(b, 2, 1, in);
    tb = b[0];
    }
  return (0);
}

/* This function will process the Attribute section of the data stream. */

int do_attrib(void)
{
  unsigned char b[100],tb;
  char line[255];
  int rc;

  fread(b, 3, 1, in);
  if (b[0] == 0x44)
    printf("--------UID is %d.\n", b[2]);
  else
    {
    printf("Error, no UID present.\n");
    return (-20);
    }
  fread(b, 2, 1, in);
  tb = b[0];
  while (tb != 0x00)
    {
    if (tb == 0x31)
      {
      printf("--------Set of Attrib.\n");
      rc = do_attribs();
      printf("--------End of Set of Attrib.\n");
      if (rc != 0)
        return (rc);
      if (in_folder == 1)
        {
        in_folder = 0;
        fread(b, 2, 1, in);
        if (b[0] == 0x00)
          fread(b, 2, 1, in);
        if (b[0] == 0x69)
          {
          printf("--------Set of Attributes.\n");
          do_note();
          fread(b, 2, 1, in);
          fread(b, 2, 1, in);
          }
        if (b[0] == 0x31)
          {
          printf("--------Set of Contents.\n");
          dump_data(d);
          }
        else
          {
          printf("Error, Not Set of Contents.%X\n", b[0]);
          return (-32);
          }
        }
      }
    else
      if (tb == 0x67)
        {
        printf("--------Document.\n");
        rc = parse_doc();
        if (rc != 0)
          return (rc);
        if (b[1] == 0x80)
          {
          fread(b, 2, 1, in);
          printf("--------End of Document.\n");
          }
        }
      else
        if (tb == 0x65)
          {
          printf("--------Folder.\n");
          d.flag = 'F';
          rc = parse_fol();
          d.flag = 'E';
          dump_data(d);
          if (rc != 0)
            return (rc);
          if (b[1] == 0x80)
            {
            fread(b, 2, 1, in);
            printf("--------End of Folder.\n");
            }
          }
        else
          {
          printf("Error, not a attribute or document.\n");
          return (-30);
          }
    fread(b, 2, 1, in);
    tb = b[0];
    }
  return (0);
}
/* This function will process the beginning segment (or header) of the data */
/* stream.  This function finds the level, source, id f the source system   */
/* along with the attributes and classes passed in the data stream.         */

int parse_beg(void)
{
  unsigned char b[100],tb,tb2,tb3;
  USHORT ts;
  char line[255];

  fread(b, 2, 1, in);
  if (b[0] == 0x60)
    printf("Data Stream\n");
  else
    {
    printf("Error, no data stream tag.\n");
    return (-1);
    }
  fread(b, 4, 1, in);
  if ((b[0] == 0x80) && (b[1] == 0x02) && (b[2] == 0x01) && (b[3] == 0x01))
    printf("--Level 0x01 0x01.\n");
  else
    {
    printf("Error, Incorrect Level.\n");
    return (-2);
    }
  fread(b, 2, 1, in);
  if ((b[0] == 0x42) && (b[1] == 0x01))
  {
    fread(b,1,1,in);
    printf("--Code Page is %X.\n", b[0]);
  }
  else if((b[0] == 0x42) && (b[1] == 0x02))
  {
    fread(b,2,1,in);
    printf("--Code Page is 500.\n");
  }
  else
    {
    printf("Error, Code Page Expected.\n");
    return (-3);
    }
  fread(b, 2, 1, in);
  if (b[0] == 0xA1)
    printf("--Source.\n");
  else
    {
    printf("Error, Not Source.\n");
    return (-4);
    }
  tb = do_line(line);
  if (tb == 0x4C)
    {
    printf("----Type.\n");
    strcpy(type_des, line);
    }
  else
    {
    printf("Error, Not Type.\n");
    return (-5);
    }
  tb = do_line(line);
  if (tb == 0x4C)
    {
    printf("----ID.\n");
    strcpy(id_des, line);
    }
  else
    {
    printf("Error, Not ID.\n");
    return (-5);
    }
  fread(b, 2, 1, in);
  if ((b[0] == 0x00) && (b[1] == 0x00))
    {
    printf("--End of Source.\n");
    fread(b, 2, 1, in);
    }
  if (b[0] == 0xA4)
    {
    fread(b, 2, 1, in);
    tb = b[0];
    while (tb == 0x30)
      {
      fread(b, 2, 1, in);
      tb = b[1];
      b[0] = 0;
      b[1] = 0;
      b[2] = 0;
      fread(b, tb, 1, in);
      if (tb == 1)
        {
        ts = b[0];
        }
      else
        {
        b[2] = b[0];
        b[0] = b[1];
        b[1] = b[2];
        memcpy(&ts, b, 2);
        }
      fread(b, 2, 1, in);
      if (b[0] == 0x81)
        fread(b, 1, 1, in);
      else
        return (-11);
      do_line(line);
      printf("--> Attribute %d is %s\n", ts, line);
      nattrs[tot_attrs] = calloc(strlen(line)+1, 1);
      strcpy(nattrs[tot_attrs], line);
      tot_attrs++;
      fread(b, 2, 1, in);
      if (b[0] == 0x00)
        fread(b, 2, 1, in);
      tb = b[0];
      }
    fread(b, 2, 1, in);
    }
  if (b[0] == 0xA5)
    {
    fread(b, 2, 1, in);
    tb = b[0];
    while (tb == 0x30)
      {
      fread(b, 2, 1, in);
      tb = b[1];
      b[0] = 0;
      b[1] = 0;
      b[2] = 0;
      fread(b, tb, 1, in);
      if (tb == 1)
        {
        ts = b[0];
        }
      else
        {
        b[2] = b[0];
        b[0] = b[1];
        b[1] = b[2];
        memcpy(&ts, b, 2);
        }
      do_line(line);
      printf("--> Class %d is %s\n", ts, line);
      Class[tot_classes].name = calloc(strlen(line)+1, 1);
      strcpy(Class[tot_classes].name, line);
      Class[tot_classes].num_attr = 0;
      fread(b, 2, 1, in);
      if (b[0] == 0x00)
        fread(b, 2, 1, in);
      else
        if (b[0] == 0xA5)
          {
          fread(b, 2, 1, in);
          tb2 = b[0];
          while (tb2 != 0x00)
            {
            tb3 = b[1];
            fread(b, tb3, 1, in);
            if (tb3 == 1)
              {
              ts = b[0];
              }
            else
              {
              b[2] = b[0];
              b[0] = b[1];
              b[1] = b[2];
              memcpy(&ts, b, 2);
              }
            printf("  --> Has atttribute %d assigned to it.\n", ts);
            Class[tot_classes].nattrs[Class[tot_classes].num_attr] = ts;
            Class[tot_classes].num_attr++;
            fread(b, 2, 1, in);
            tb2 = b[0];
            }
          fread(b, 2, 1, in);
          fread(b, 2, 1, in);
          }
      tb = b[0];
      tot_classes++;
      }
    fread(b, 2, 1, in);
    }
  if (b[0] == 0x31)
    printf("--Set of CIU's.\n");
  else
    {
    printf("Error, not set of CIU's tag.\n");
    return (-6);
    }
  return (0);
}

/* This function will read one line of information from the data stream and */
/* then change the code page of the text obtained.                          */

unsigned char do_line(char line[255])
{
  int rc;
  unsigned char b1,b2;

  strnset(line, 0, 255);
  fread(&b1, 1, 1, in);
  fread(&b2, 1, 1, in);
  fread(line, b2, 1, in);
  ebcdic2ascii(line, 255);
  line[b2] = 0;
  return (b1);
}

/* THis function will read one line of information from the data stream, but */
/* will not change the code page of the data.  This function is used when    */
/* reading binary information(i.e. integers) from the data stream.           */

unsigned char do_line_un(char line[255])
{
  int rc;
  unsigned char b1,b2;

  strnset(line, 0, 255);
  fread(&b1, 1, 1, in);
  fread(&b2, 1, 1, in);
  fread(line, b2, 1, in);
  return (b1);
}

/* This function will strip blank characters from the end of a string. This */
/* function is required for use when processing strings obtained from the   */
/* ImagePlus/MVS system, because the ImagePlus/MVS system puts out strings  */
/* out fully( i.e. uses 40 characters when sending a 10 character string).  */

void strip_blank(char *line)
{
  int i = 0;

  i = strlen(line);
  while (i > 0)
    {
    if ((line[i] == 32) || (line[i] == 0))
      {
      line[i] = 0;
      i--;
      }
    else
      {
      i = -1;
      }
    }
}
