/* PARSEcif.C */
/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

#include "parsecif.h"

/*************************************************************************/
/*                                                                       */
/* This main module to the excutable parser will parse the cif file      */
/* specified as the first parameter to the program and then generate     */
/* the LST file specified as the second parameter in the command line    */
/* arguments passed to the executable.  The main module will check the   */
/* arguments, initialize the linked list and then parse the cif file.    */
/* The parsing of the data stream is accomplished by two main functions  */
/* parse_beg and parse_mid.  Parse_beg, reads the header of the data     */
/* stream and parse_mid parses the remaining components of the data      */
/* stream.  The generation of the MDI (image files) takes place when a   */
/* image is encountered in the data stream.  All INX files and the LST   */
/* file are generated after parsing is completed.  Before the            */
/* creation of the INX files, transform_exit is called.  This function   */
/* is provided as a placeholder for someone to write their own custom    */
/* customization of the conveyed information.  A sample is provided and  */
/* it's use will explained in the file parsecif.h in front of the fx.    */
/*                                                                       */
/*************************************************************************/

int main(argc,argv,envp)
  int argc;
  char *argv[];
  char *envp[];
{
  USHORT levels,level;          /* Variables to keep track of level(s) */
  char temp[80];

  /* Check for proper number of arguments and file existence */

  if (argc <= 2)
    {
    printf("Usage: parsecif file.cif file.lst A|E\n\a");
    printf("       specify E for output in EBCDIC\n");
    exit(1);
    }
  if ((in = fopen(argv[1], "rb")) == NULL)
    {
    printf("Could not open cif.\n");
    exit(0);
    }

  if(argc==4)
  {
    if((argv[3][0]=='E')||(argv[3][0]=='e'))
    {
      EBCDIC='T';
    }
    else
    {
      EBCDIC='F';
    }
  }
  else
  {
     EBCDIC='F';
  }


  /* Initialize default TYPE and ID variables */

  strcpy(type_des, "DEFAULT TYPE");
  strcpy(id_des, "DEFAULT ID");

  /* Allocate head of linked list and initialize */

  head = malloc(sizeof(ELEMENT));
  head->data.flag = '*';
  tail = head;

  /* Parse the header of the data stream */

  parse_beg();

  /* Parse the remaining element in the data stream */

  d.note_present = 0;
  parse_mid();

  /* Close the cif file */

  fclose(in);

  /* Add the tail to the list and fill with end of list tag '$' */

  tail->next = malloc(sizeof(ELEMENT));
  tail = tail->next;
  tail->next = NULL;
  tail->data.flag = '$';

  /* Call the transform_exit to perform customization on the data */

  transform_exit(head);

  /* Find the number of levels of nested folders in the linked list */

  levels = count_lev(head);

  /* Write out ALL document INX files */

  write_inxd(head);

  /* Loop through any and all levels of folders, writing one level at a time */

  for (level = 1; level <= levels+1; level++)
    write_inxf(head, level);

  /* Open the output LST file and write out it's contents, the highest level */
  /* documents and/or folder INX files                                       */

  if ((out = fopen(argv[2], "w")) == NULL)
    {
    printf("Could not open lst file.\n");
    exit(0);
    }
  write_list(head);
  fclose(out);

  printf("End of cif data structure!!!!\n");            /* trace */


  if(EBCDIC=='T')
  {
     sprintf(temp,"chngtext %s A",argv[2]);
     system(temp);
  }

  return (0);
}
