/*************************************************************************/
/*                                                                       */
/* These programs are provided "AS IS."  There are no warranties, either */
/* express or implied (including, but not limited to, the implied        */
/* warranties of merchantability and fitness for a particular purpose)   */
/* provided with these programs.                                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************/
/*                                                                       */
/*                  (c) Copyright IBM Corp. 1992                         */
/*                                                                       */
/*************************************************************************/

/*BEGINPROLOGUE**************************************************************/
/*                                                                          */
/*   Module Name:              IPMISC.C                                     */
/*                                                                          */
/*   Descriptive Name:         This module contains miscellaneous functions */
/*                             used throughout the application.             */
/*                                                                          */
/*   Status:                   Release 1, Level 0                           */
/*                                                                          */
/*   Dependencies:             IBM OS/2 Extended Edition 1.30.1             */
/*                                                                          */
/*   Functions:                                                             */
/*                                                                          */
/*ENDPROLOGUE****************************************************************/

#define INCL_DOS
#define INCL_DOSMEMMGR
#define INCL_GPIBITMAPS
#define INCL_DOSERRORS
#define INCL_WIN
#define INCL_PM
#include <os2.h>

#include <stdio.h>                     // Standard C standard input/output
#include <stdlib.h>                    // Standard C library header
#include <string.h>                    // Standard C string header
#include <ctype.h>                     // Contains standard macros and symbols
#include <time.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>

#define IPS_SDS_INCL                   // To include Spool Device Services
#define IPS_IMG_INCL                   // To include Image Services
#define IPS_PAG_INCL                   // To include Page Services
#define IPS_DSP_INCL                   // To include Display Services
#define IPS_OMS_INCL                   // To include Object Management System
#define IPS_OAS_INCL                   // To include Object Access Services
#include <ips.h>

#include "ip2impex.rch"                // Contains menu symbol definitions
#include "ip2impex.h"                  // Includes prototypes and Masthead
#include "dialog.h"                    // Contains defines used in dialog boxes
#include "globals.h"                   // Contains our global variables
#include "error.h"                     // Contains error definitions

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void CenterWindow(HWND hWndTarget,HWND hWndCanvas)
{
   SWP swpc, swpt;
   SHORT twidth, theight, x, y;
   SHORT cwidth, cheight;
   long Width, Height;

   Width = (ULONG) WinQuerySysValue(HWND_DESKTOP,SV_CXSCREEN);
   Height = (ULONG) WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN);

   WinQueryWindowPos(hWndCanvas,&swpc);
   WinQueryWindowPos(hWndTarget,&swpt);

   twidth = (SHORT) swpt.cx;
   theight = (SHORT) swpt.cy;

   cwidth = (SHORT) swpc.cx;
   cheight = (SHORT) swpc.cy;

   if (cwidth >= twidth)
      x = ((cwidth - twidth) / 2) + (SHORT) swpc.x;
   else
      x = (SHORT) swpc.x - ((twidth - cwidth) / 2);

   if (cheight >= theight)
      y = ((cheight - theight) / 2) + (SHORT) swpc.y;
   else
      y = (SHORT) swpc.y - ((theight - cheight) / 2);

   if (y > 0 && (y + theight) > (SHORT) Height)
      y = (SHORT) Height - theight;

   if (x > 0 && x +  twidth > (SHORT) Width)
      x = (SHORT) Width - twidth;

   if (x < 0)
      x = 0;

   if (y < 0)
      y = 0;

   WinSetWindowPos(hWndTarget,HWND_TOP,x,y,twidth,theight,SWP_MOVE | SWP_SHOW);
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

char *getline(char *buffer,int bufsize,FILE *fp)
{
   char *p;

   if (fgets(buffer,bufsize,fp) == NULL)
      {
      return(NULL);
      }
   else
      {
      p = strchr(buffer,'\n');
      if (p != NULL)
         *p = '\0';
      }
   return(buffer);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int exists(char *szFName)
{
   register int fh, rc = 0;

   fh = open(szFName,O_BINARY | O_RDONLY);
   if (fh != -1)
      {
      close(fh);
      rc = 1;
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitDrives(void)
{
   register int rc = SUCCESS;
   register int i;
   ULONG lDriveMap;
   USHORT usDrive;

   rc = DosQCurDisk(&usDrive,&lDriveMap);
   memset(szDriveLetters,0,sizeof(szDriveLetters));
   for (i = 0; i < 26; i++)
      {
      if (lDriveMap & 0x000000001)
         {
         szDriveLetters[i] = (char) ('A' + i);
         }
      lDriveMap = lDriveMap >> 1;
      }
   return(SUCCESS);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void InitList(HWND hDList,BOOL bDir)
{
   HDIR FindHandle;
   FILEFINDBUF FindBuffer;
   USHORT FindCount;
   register int rc;
   char szPattern[10];
   USHORT attrFile;

   FindHandle = 0x0001;
   FindCount = 1;
   strcpy(szPattern,"*.*");
   attrFile = bDir ? FILE_DIRECTORY : FILE_NORMAL;

   rc = DosFindFirst(                  // Find first file occurrence
            szPattern,                 // Search pattern
            &FindHandle,               // Directory search handle
            attrFile,                  // Search attribute
            &FindBuffer,               // Result buffer
            sizeof(FindBuffer),        // Result buffer length
            &FindCount,                // # of entries to find
            0L);                       // Reserved long value

   if (rc == SUCCESS)
      {
      do
         {
         if (bDir)
            {
            if (FindBuffer.attrFile & FILE_DIRECTORY)
               {
               if (!(FindBuffer.achName[0] == '.' && FindBuffer.achName[1] == '\0'))
                  {
                  WinSendMsg(hDList,LM_INSERTITEM,
                     MPFROMSHORT(LIT_SORTASCENDING),MPFROMP(FindBuffer.achName));
                  }
               }
            }
         else
            {
            if ((ImportFiles.bLST && strstr(FindBuffer.achName,".LST")) ||
                (ImportFiles.bINX && strstr(FindBuffer.achName,".INX")) ||
                (ImportFiles.bMDI && strstr(FindBuffer.achName,".MDI")) ||
                (ImportFiles.bTIF && strstr(FindBuffer.achName,".TIF")) ||
                (ImportFiles.bCIF && strstr(FindBuffer.achName,".CIF")))
               {
               WinSendMsg(hDList,LM_INSERTITEM,
                  MPFROMSHORT(LIT_SORTASCENDING),MPFROMP(FindBuffer.achName));
               }
            }

         rc = DosFindNext(                // Find next file occurrence
                  FindHandle,             // Directory handle
                  &FindBuffer,            // Result buffer
                  sizeof(FindBuffer),     // Result buffer length
                  &FindCount);            // # of entries to find
         }
      while (rc == SUCCESS);
      }
   DosFindClose(FindHandle);

   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void AddDrivesToList(HWND hDList)
{
   char szDrive[10];
   register int i;

   szDrive[0] = '[';
   szDrive[1] = ' ';
   szDrive[2] = ']';
   szDrive[3] = '\0';
   for (i = 0; i < 26; i++)
      {
      if (szDriveLetters[i] != '\0')
         {
         szDrive[1] = szDriveLetters[i];
         WinSendMsg(hDList,LM_INSERTITEM,
            MPFROMSHORT(LIT_SORTASCENDING),MPFROMP(szDrive));
         }
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void GetSelectedItems(HWND hList,PIPLIST *pList)
{
   register int index, done = FALSE;
   char buffer[256];

   if (*pList != NULL)
      {
      DestroyList(*pList);
      }
   *pList = CreateList(LT_VARLEN,0);
   if (*pList != NULL)
      {
      index = LIT_FIRST;
      while (!done)
         {
         index = (SHORT) (LONG) WinSendMsg(hList,
            LM_QUERYSELECTION,MPFROMSHORT(index),MPFROMSHORT(0));

         if (index != LIT_NONE)
            {
            WinSendMsg(hList,LM_QUERYITEMTEXT,
               MPFROM2SHORT(index,sizeof(buffer)),MPFROMP(buffer));

            AppendListItem(*pList,buffer);
            }
         else
            {
            done = TRUE;
            }
         }
      }
   return;
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

char *strcpyc(char *pDest,int dest_len,char *pSrc,char ch)
{
   char *p = pDest;
   register int i = 1, n = dest_len;

   while (*pSrc != '\0' && *pSrc != ch && i++ < n)
      {
      *pDest++ = *pSrc++;
      }
   *pDest = '\0';

   return(p);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void FindRoomyVolume(char *szVolName,PULONG pulSerial)
{
   register int i, rc;
   FSALLOCATE fs;
   ULONG ulLargestSpace = 0L;
   ULONG ulTempSpace;
   USHORT LargestDrive = 0;
   FSVOLINFO volinfo;

   for (i = 2; i < 26; i++)
      {
      if (szDriveLetters[i] != '\0')
         {
         rc = DosQFSInfo((szDriveLetters[i]-'A')+1,1,(PBYTE) &fs,sizeof(fs));
         if (rc == SUCCESS)
            {
            ulTempSpace = fs.cSectorUnit * fs.cUnitAvail * fs.cbSector;
            if (ulTempSpace > ulLargestSpace)
               {
               ulLargestSpace = ulTempSpace;
               LargestDrive = (USHORT) (szDriveLetters[i]-'A') + 1;
               }
            }
         }
      }

   rc = DosQFSInfo(LargestDrive,2,(PBYTE) &volinfo,sizeof(volinfo));
   if (rc == SUCCESS)
      {
      *pulSerial = volinfo.ulSerial;
      strcpy(szVolName,volinfo.szVolLabel);
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int InitVolumeSpace(void)
{
   register int sRC = SUCCESS;
   FSALLOCATE fs;
   ULONG ulSpace;

   sRC = DosQFSInfo(3,1,(PBYTE) &fs,sizeof(fs));
   if (sRC != SUCCESS)
      {
      sRC = ERR_VOLCBAD;
      }
   else
      {
      ulSpace = fs.cSectorUnit * fs.cUnitAvail * fs.cbSector;
      if (ulSpace < 2000000L)
         {
         sRC = ERR_SMALLVOLC;
         }

      if (sRC == SUCCESS)
         {
         sRC = DosMkDir("C:\\IP2TEMP",0L);
         if (sRC != SUCCESS)
            {
            if (sRC == ERROR_ACCESS_DENIED)
               {
               sRC = SUCCESS;
               }
            else
               {
               sRC = ERR_CREATDIR;
               }
            }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void CombinePathAndName(char *szPath,char *szFName,char *szResult)
{
   register int len;

   strcpy(szResult,szPath);
   len = strlen(szResult);
   if (len > 0)
      {
      if (szResult[len-1] != '\\')
         {
         szResult[len] = '\\';
         szResult[len+1] = '\0';
         }
      }
   strcat(szResult,szFName);
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void EnforceExtension(char *szPath,char *szExt)
{
   char *p;

   p = strchr(szPath,'.');
   if (p != NULL)
      *p = '\0';

   if (szExt[0] != '.')
      strcat(szPath,".");

   strcat(szPath,szExt);
   return;
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int GetExportName(char *szExpName,PUID uidItem)
{
   register int sRC = SUCCESS;
   register int done = FALSE;
   char szFName[13], *p;

   memset(szFName,0,sizeof(szFName));
   memcpy(szFName,uidItem,8);
   EnforceExtension(szFName,".INX");

   CombinePathAndName(szExportPath,szFName,szExpName);
   while (!done)
      {
      if (exists(szExpName))
         {
         p = strrchr(szExpName,'.');
         p--;
         (*p)++;
         }
      else
         {
         done = TRUE;
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int FindDriveLetter(char *szVolName,PULONG pulVolSer,char *chDrive)
{
   register int sRC = SUCCESS, i;
   FSVOLINFO volinfo;

   *chDrive = '\0';
   for (i = 0; i < 26; i++)
      {
      if (szDriveLetters[i] >= 'C')
         {
         sRC = DosQFSInfo((szDriveLetters[i]-'A')+1,2,
                  (PBYTE) &volinfo,sizeof(volinfo));
         if (sRC == SUCCESS)
            {
            if (strcmpi(szVolName,volinfo.szVolLabel) == 0)
               {
               *pulVolSer = volinfo.ulSerial;
               *chDrive = szDriveLetters[i];
               break;
               }
            }
         }
      }
   if (*chDrive == '\0')
      {
      sRC = ERR_NODRIVE;
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int FindPathDrive(char *szFullSrc,char *chDrive)
{
   register int i, sRC = ERR_PATHNF;
   char szPath[128];

   for (i = 0; i < 26; i++)
      {
      if (szDriveLetters[i] >= 'C')
         {
         szPath[0] = szDriveLetters[i];
         szPath[1] = ':';
         if (szFullSrc[0] == '\\')
            {
            szPath[2] = '\0';
            }
         else
            {
            szPath[2] = '\\';
            szPath[3] = '\0';
            }
         strcat(szPath,szFullSrc);
         if (exists(szPath))
            {
            *chDrive = szDriveLetters[i];
            sRC = SUCCESS;
            break;
            }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int GetDASDId(char *chDASD)
{
   register int count, i, sRC;
   RCSTRUCT RC;
   PSTGCLASSNAMESTRUCT pClasses;

   *chDASD = '\0';
   memset(&RC,0,sizeof(RC));
   sRC = IpsQueryObjectStgClassNames(IPS_OPT_SYNC,NULL,0,&RC);
   if (sRC != SUCCESS)
      {
      sRC = LogError(ERR_QRYSC,NULL);
      }
   else
      {
      count = RC.usParam;
      pClasses = (PSTGCLASSNAMESTRUCT) RC.ulParam;
      for (i = 0; i < count; i++)
         {
         if (strstr(pClasses[i].szClassName,"DASD") != NULL)
            {
            *chDASD = pClasses[i].idStgClass;
            break;
            }
         }
      if (*chDASD == '\0')
         {
         sRC = LogError(ERR_NODASD,NULL);
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int GetDASDVolumeOnDEFAULT(char *szVolName,PULONG ulVolSer)
{
   register int i, count, sRC;
   RCSTRUCT RC;
   PSTGGROUPSTRUCT pStgGroup;
   PVOLENTRYSTRUCT pVols;
   unsigned char chDASD;

   sRC = StgGroupToId("DEFAULT",&usDASDStgGroup);
   if (sRC != SUCCESS)
      {
      sRC = LogError(ERR_NODEFSG,NULL);
      }
   else
      {
      sRC = GetDASDId(&chDASD);
      if (sRC != SUCCESS)
         {
         sRC = LogError(sRC,NULL);
         }
      else
         {
         memset(&RC,0,sizeof(RC));
         sRC = IpsQueryObjectStgGroup(usDASDStgGroup,IPS_OPT_SYNC,NULL,0,&RC);
         if (sRC != SUCCESS)
            {
            sRC = LogError(ERR_NODEFSG,NULL);
            }
         else
            {
            pStgGroup = (PSTGGROUPSTRUCT) RC.ulParam;
            pVols = pStgGroup->pVolEntry;
            count = pStgGroup->usVolEntries;
            szVolName[0] = '\0';
            *ulVolSer = 0L;
            for (i = 0; i < count; i++)
               {
               if (pVols[i].idStgClass == chDASD) // COMEBACK && pVols[i].ucLocation == OM_GLOBAL)
                  {
                  strcpy(szVolName,pVols[i].szVolName);
                  *ulVolSer = pVols[i].ulVolSer;
                  break;
                  }
               }
            if (szVolName[0] == '\0')
               {
               sRC = LogError(ERR_NODEFVOL,NULL);
               }
            }
         }
      }
   return(sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int match(char *pStr,char *pTarget)
{
   while (*pTarget)
      {
      if (tolower(*pStr) != tolower(*pTarget))
         return(0);

      pTarget++;

      if (*pStr++ == '\0')
         return(0);
      }
   return(1);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int ExtensionToCC(char *szExt,unsigned char *pCC)
{
   register int rc = SUCCESS;

   if (szExt == NULL)
      {
      rc = ERR_INVCC;
      }
   else if (strcmpi(szExt,".mdi") == 0)
      {
      CCToId("MO:DCA-P",pCC);
      }
   else if (strcmpi(szExt,".tif") == 0)
      {
      CCToId("TIFF",pCC);
      }
   else
      {
      rc = ERR_INVCC;
      }
   return(rc);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void CCToExtension(unsigned char CC,char *szExt)
{
   char szCC[33];

   IdToCC(CC,szCC);
   if (strstr(szCC,"TIFF") != 0)
      {
      strcpy(szExt,".TIF");
      }
   else if (strstr(szCC,"MO:DCA") != 0)
      {
      strcpy(szExt,".MDI");
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void ActivityLogOutput(char *szMsg)
{
   char buffer[256];
   DATETIME DateTime;
   BOOL bAM;

   if (hWndList != NULL)
      {
      DosGetDateTime(&DateTime);

      bAM = TRUE;
      if (DateTime.hours > 12)
         {
         DateTime.hours -= 12;
         bAM = FALSE;
         }
      else if (DateTime.hours == 0)
         {
         DateTime.hours = 12;
         }

      sprintf(
         buffer,
         "%02d:%02d:%02d %s - %s",
         DateTime.hours,
         DateTime.minutes,
         DateTime.seconds,
         bAM ? "am" : "pm",
         szMsg);

      WinSendMsg(hWndList,LM_INSERTITEM,MPFROM2SHORT(LIT_END,0),MPFROMP(buffer));
      WinSendMsg(hWndList,WM_CHAR,(MPARAM) 0x4F011006,(MPARAM) 0x00134F00);
      }
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void IPYield()
{
   QMSG qmsgPeek;

   while (WinPeekMsg(hAB,(PQMSG) &qmsgPeek,0,0,0,PM_REMOVE))
      {
      WinDispatchMsg(hAB,(PQMSG) &qmsgPeek);
      }
   return;
}


/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void StartHourGlass()
{
   WinSetPointer(HWND_DESKTOP,
      WinQuerySysPointer(HWND_DESKTOP,SPTR_WAIT,FALSE));

   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void StopHourGlass()
{
   WinSetPointer(HWND_DESKTOP,
      WinQuerySysPointer(HWND_DESKTOP,SPTR_ARROW,FALSE));

   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

int WaitAndYield(PRCSTRUCT pRC)
{
   while (pRC->sRC == ASYNCH_STARTED)
      {
      IPYield();
      DosSleep(300);
      }
   return(pRC->sRC);
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void SoundGoodAlarm()
{
   DosBeep(392,400);
   DosBeep(392,100);
   DosBeep(523,1500);
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void SoundBadAlarm()
{
   DosBeep(250,400);
   DosBeep(200,600);
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void ComposeDateAndTime(char *buffer)
{
   register int bAM = TRUE;
   char szDate[12];
   char szTime[12];
   DATETIME DT;

   DosGetDateTime(&DT);

   if (DT.hours > 12)
      {
      DT.hours -= 12;
      bAM = FALSE;
      }

   if (DT.hours == 0)
      {
      DT.hours = 12;
      bAM = TRUE;
      }
   sprintf(szTime,"%02d:%02d:%02d",DT.hours,DT.minutes,DT.seconds);
   sprintf(szDate,"%02d-%02d-%02d",DT.month,DT.day,DT.year);
   sprintf(buffer,"%s %s %s",szDate,szTime,bAM ? "AM" : "PM");
   return;
}

/*BEGINFUNCTION**************************************************************/
/*                                                                          */
/*  Name:                                                                   */
/*                                                                          */
/*  Description:                                                            */
/*                                                                          */
/*                                                                          */
/*ENDFUNCTION****************************************************************/

void LoadEditor(char *szFile)
{
   char szPath[128];
   CHAR ObjFail[50];
   RESULTCODES ReturnCodes;
   register int rc;

   memset(szPath,0,sizeof(szPath));
   sprintf(szPath,"e.exe %s",szFile);
   szPath[5] = '\0';

   rc = DosExecPgm(
            ObjFail,            // Object name buffer
            sizeof(ObjFail),    // Length of obj. name buffer
            EXEC_ASYNC,         // Execution flag - asynchronous
            szPath,             // Arguments to pass to VIEW process
            NULL,               // Inherits our environment
            &ReturnCodes,       // Ptr. to resultcodes struct
            "E.EXE");        // Name of program file
   return;
}
